/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.eKasaSK.lib.communication.jssc;

import gnu.io.CommPortIdentifier;
import java.util.ArrayList;
import java.util.List;
import jssc.SerialPort;
import jssc.SerialPortException;
import sk.singularisdev.eKasaSK.lib.LowLevelFMInterface;
import sk.singularisdev.eKasaSK.lib.Pegas06FMException;
import sk.singularisdev.eKasaSK.lib.communication.CommunicationDriver;
import sk.singularisdev.eKasaSK.lib.communication.SerialCommunicationMirror;
import sk.singularisdev.eKasaSK.lib.logger.Logger;

public class SerialDriver
implements CommunicationDriver {
    public static final int STOPBITS_1 = 1;
    public static final int STOPBITS_2 = 2;
    public static final int STOPBITS_1_5 = 3;
    protected static final int RECV_TIMEOUT = 4000;
    protected static final int SEND_TIMEOUT = 4000;
    protected SerialPort serialPort;
    protected boolean init = false;
    protected static Logger logger;
    protected boolean bufferEmpty = true;
    protected List<SerialCommunicationMirror> mirrors = new ArrayList<SerialCommunicationMirror>();
    protected int recvTimeout = 4000;
    protected int sendTimeout = 4000;
    protected int stopBits = 1;
    protected String portName;
    protected int baudRate = 0;

    public SerialDriver(String port, int baud, int stopBits) {
        this(port, baud);
        this.stopBits = stopBits;
    }

    public SerialDriver(String port, int baud) {
        if (System.getProperty("gnu.io.log.mode") == null) {
            System.setProperty("gnu.io.log.mode", "FILE_MODE");
        }
        if (System.getProperty("gnu.io.log.filename") == null) {
            System.setProperty("gnu.io.log.filename", "rxtx_log.txt");
        }
        logger = Logger.createLogger(this.getClass().getName());
        this.init = false;
        this.portName = port;
        this.baudRate = baud;
    }

    public SerialDriver(SerialPort serialPort) {
        logger = Logger.createLogger(this.getClass().getName());
        this.serialPort = serialPort;
        try {
            this.portName = serialPort.getPortName();
            this.baudRate = 0;
            serialPort.setDTR(true);
            this.init = true;
        }
        catch (SerialPortException e) {
            this.init = false;
            logger.error(e.getMessage(), e);
        }
        catch (Exception e) {
            this.init = false;
            logger.error(e.getMessage(), e);
        }
    }

    @Override
    public void clearInputBuffer() throws Exception {
        this.serialPort.readBytes(this.serialPort.getInputBufferBytesCount());
    }

    @Override
    public void send(byte[] data, LowLevelFMInterface signalInterface) throws Pegas06FMException {
        if (!this.init) {
            throw new Pegas06FMException(-10103);
        }
        try {
            int i = 0;
            while (i < data.length) {
                logger.debug(" **** SerialSendData [bytes]:Waiting for empty buffer/ DSR");
                long time = System.currentTimeMillis();
                while (!this.bufferEmpty) {
                    logger.debug(" **** SerialSendData [bytes]:EmptyBuffer - " + this.bufferEmpty + "/ DSR:" + this.serialPort.isDSR());
                    if (System.currentTimeMillis() - time > (long)this.sendTimeout) {
                        throw new Pegas06FMException(-10006);
                    }
                    try {
                        Thread.sleep(5L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.serialPort.writeByte(data[i]);
                logger.debug(" **** SerialSendData [bytes]: writing byte [" + data[i]);
                for (SerialCommunicationMirror mirror : this.mirrors) {
                    mirror.byteWritten(data[i]);
                }
                ++i;
            }
            logger.debug(" **** SerialSendData [bytes]: flush buffer *");
            logger.debug(" **** SerialSendData [bytes]: buffer flushed");
        }
        catch (SerialPortException e) {
            logger.debug("Error", e);
            throw new Pegas06FMException(-10003, (Exception)((Object)e));
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.debug("Error", e);
            throw new Pegas06FMException(-10003, e);
        }
    }

    @Override
    public void send(byte data, LowLevelFMInterface signalInterface) throws Pegas06FMException {
        if (!this.init) {
            throw new Pegas06FMException(-10103);
        }
        try {
            logger.debug(" **** SerialSendData [byte]:Waiting for empty buffer/ DSR");
            long time = System.currentTimeMillis();
            while (!this.bufferEmpty || !this.serialPort.isDSR()) {
                logger.debug(" **** SerialSendData [byte]:EmptyBuffer - " + this.bufferEmpty + "/ DSR:" + this.serialPort.isDSR());
                if (System.currentTimeMillis() - time > (long)this.sendTimeout) {
                    throw new Pegas06FMException(-10006);
                }
                try {
                    Thread.sleep(5L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.serialPort.writeByte(data);
            logger.debug(" **** SerialSendData [byte]: writing byte [" + data);
            for (SerialCommunicationMirror mirror : this.mirrors) {
                mirror.byteWritten(data);
            }
            logger.debug(" **** SerialSendData [byte]: flush buffer");
        }
        catch (SerialPortException e) {
            throw new Pegas06FMException(-10003, (Exception)((Object)e));
        }
    }

    @Override
    public byte read(LowLevelFMInterface signalInterface) throws Pegas06FMException {
        if (!this.init) {
            throw new Pegas06FMException(-10103);
        }
        try {
            long time = System.currentTimeMillis();
            logger.debug(" **** SerialRead: waiting for available data ");
            while (this.serialPort.getInputBufferBytesCount() == 0) {
                Thread.sleep(5L);
                logger.debug(" **** SerialRead: waiting for CTS ");
                boolean longJob = false;
                signalInterface.invokeFMSignalListener(longJob);
                if (!this.serialPort.isCTS()) {
                    if (!longJob) {
                        longJob = !longJob;
                        signalInterface.invokeFMSignalListener(longJob);
                    }
                    time = System.currentTimeMillis();
                    continue;
                }
                if (longJob) {
                    longJob = !longJob;
                    signalInterface.invokeFMSignalListener(longJob);
                }
                logger.debug(" **** SerialRead: CTS ON ");
                if (time + (long)this.recvTimeout >= System.currentTimeMillis()) continue;
                throw new Pegas06FMException(64);
            }
            logger.debug(" **** SerialRead: read byte ");
            byte returnByte = this.serialPort.readBytes(1)[0];
            for (SerialCommunicationMirror mirror : this.mirrors) {
                mirror.byteRead(returnByte);
            }
            logger.debug(" **** SerialRead: byte readed [" + returnByte);
            return returnByte;
        }
        catch (SerialPortException e) {
            throw new Pegas06FMException(-10003, (Exception)((Object)e));
        }
        catch (InterruptedException e) {
            throw new Pegas06FMException(-10004, e);
        }
    }

    @Override
    public boolean isInitialized() {
        return this.init;
    }

    @Override
    public void openPort() throws Pegas06FMException {
        logger.debug(String.valueOf(this.getPort()) + " - connecting ...");
        try {
            CommPortIdentifier portId = CommPortIdentifier.getPortIdentifier((String)this.getPort());
            this.serialPort = new SerialPort(this.getPort());
            if (!this.serialPort.openPort()) {
                this.init = false;
                throw new Pegas06FMException(-10003);
            }
            this.serialPort.setFlowControlMode(3);
            this.serialPort.setParams(this.getBaud(), 8, this.stopBits, 0);
            this.serialPort.setDTR(true);
            this.init = true;
        }
        catch (SerialPortException e) {
            this.init = false;
            logger.error(e.getMessage(), e);
            if (e.getExceptionType() == "Port already opened") {
                throw new Pegas06FMException(-10100, (Exception)((Object)e));
            }
            if (e.getExceptionType() == "Port not found") {
                throw new Pegas06FMException(-10101, (Exception)((Object)e));
            }
            if (e.getExceptionType() == "Parameter is not correct") {
                throw new Pegas06FMException(-10102, (Exception)((Object)e));
            }
            throw new Pegas06FMException(-10003, (Exception)((Object)e));
        }
        catch (Exception e) {
            this.init = false;
            logger.error(e.getMessage(), e);
            throw new Pegas06FMException(-10001, e);
        }
    }

    @Override
    public void closePort() {
        this.init = false;
        logger.debug(String.valueOf(this.getPort()) + " - disconnecting ...");
        try {
            logger.debug("Closing SerialPort ...");
            this.serialPort.closePort();
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
        }
    }

    @Override
    public String getPort() {
        return this.portName;
    }

    @Override
    public int getBaud() {
        return this.baudRate;
    }

    @Override
    public void addMirror(SerialCommunicationMirror mirror) {
        this.mirrors.add(mirror);
    }

    @Override
    public void removeMirror(SerialCommunicationMirror mirror) {
        this.mirrors.remove(mirror);
    }

    @Override
    public void removeAllMirrors() {
        this.mirrors.clear();
    }

    @Override
    public void setOldFMBehaviour(boolean old) {
    }
}

