/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.eKasaSK.lib.communication.jssc;

import jssc.SerialPort;
import jssc.SerialPortException;
import sk.singularisdev.eKasaSK.lib.LowLevelFMInterface;
import sk.singularisdev.eKasaSK.lib.Pegas06FMException;
import sk.singularisdev.eKasaSK.lib.communication.SerialCommunicationMirror;
import sk.singularisdev.eKasaSK.lib.communication.jssc.SerialDriver;

public class SerialDriverSwHandshake
extends SerialDriver {
    public SerialDriverSwHandshake(String port, int baud, int stopBits) {
        super(port, baud, stopBits);
    }

    public SerialDriverSwHandshake(String port, int baud) {
        super(port, baud);
    }

    public SerialDriverSwHandshake(SerialPort serialPort) {
        super(serialPort);
        try {
            serialPort.setDTR(false);
        }
        catch (SerialPortException e) {
            this.init = false;
            logger.error(e.getMessage(), e);
        }
        catch (Exception e) {
            this.init = false;
            logger.error(e.getMessage(), e);
        }
    }

    @Override
    public void openPort() throws Pegas06FMException {
        super.openPort();
        try {
            this.serialPort.setDTR(false);
        }
        catch (SerialPortException e) {
            this.init = false;
            logger.error(e.getMessage(), e);
        }
        catch (Exception e) {
            this.init = false;
            logger.error(e.getMessage(), e);
        }
    }

    @Override
    public void send(byte[] data, LowLevelFMInterface signalInterface) throws Pegas06FMException {
        if (!this.init) {
            throw new Pegas06FMException(-10103);
        }
        try {
            int i = 0;
            while (i < data.length) {
                logger.debug(" **** SerialSendData [bytes]:Waiting for empty buffer/ DSR");
                long time = System.currentTimeMillis();
                while (!this.bufferEmpty) {
                    logger.debug(" **** SerialSendData [bytes]:EmptyBuffer - " + this.bufferEmpty + "/ DSR:" + this.serialPort.isDSR());
                    if (System.currentTimeMillis() - time > (long)this.sendTimeout) {
                        throw new Pegas06FMException(-10006);
                    }
                    try {
                        Thread.sleep(5L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.serialPort.writeByte(data[i]);
                logger.debug(" **** SerialSendData [bytes]: writing byte [" + data[i]);
                for (SerialCommunicationMirror mirror : this.mirrors) {
                    mirror.byteWritten(data[i]);
                }
                ++i;
            }
            logger.debug(" **** SerialSendData [bytes]: flush buffer *");
            logger.debug(" **** SerialSendData [bytes]: buffer flushed");
        }
        catch (SerialPortException e) {
            logger.debug("Error", e);
            throw new Pegas06FMException(-10003, (Exception)((Object)e));
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.debug("Error", e);
            throw new Pegas06FMException(-10003, e);
        }
    }

    @Override
    public void send(byte data, LowLevelFMInterface signalInterface) throws Pegas06FMException {
        if (!this.init) {
            throw new Pegas06FMException(-10103);
        }
        try {
            logger.debug(" **** SerialSendData [byte]:Waiting for empty buffer/ DSR");
            long time = System.currentTimeMillis();
            while (!this.bufferEmpty) {
                logger.debug(" **** SerialSendData [byte]:EmptyBuffer - " + this.bufferEmpty + "/ DSR:" + this.serialPort.isDSR());
                if (System.currentTimeMillis() - time > (long)this.sendTimeout) {
                    throw new Pegas06FMException(-10006);
                }
                try {
                    Thread.sleep(5L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.serialPort.writeByte(data);
            logger.debug(" **** SerialSendData [byte]: writing byte [" + data);
            for (SerialCommunicationMirror mirror : this.mirrors) {
                mirror.byteWritten(data);
            }
            logger.debug(" **** SerialSendData [byte]: flush buffer");
        }
        catch (SerialPortException e) {
            throw new Pegas06FMException(-10003, (Exception)((Object)e));
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public byte read(LowLevelFMInterface signalInterface) throws Pegas06FMException {
        if (!this.init) {
            throw new Pegas06FMException(-10103);
        }
        try {
            time = System.currentTimeMillis();
            SerialDriverSwHandshake.logger.debug(" **** SerialRead: waiting for available data ");
            handshake = -1;
            longJob = false;
            while (this.serialPort.getInputBufferBytesCount() == 0) {
                Thread.sleep(5L);
                SerialDriverSwHandshake.logger.debug(" **** SerialRead: CTS ON ");
                if (time + (long)this.recvTimeout >= System.currentTimeMillis()) ** GOTO lbl-1000
                handshake = this.swHandshake(signalInterface);
                switch (handshake) {
                    case 19: {
                        handshake = -1;
                        time = System.currentTimeMillis();
                        longJob = true;
                        signalInterface.invokeFMSignalListener(longJob);
                        break;
                    }
                    case -1: 
                    case 17: {
                        throw new Pegas06FMException(64);
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        try {
                            Thread.sleep(100L);
                            break;
                        }
                        catch (Exception var6_7) {
                            // empty catch block
                        }
                    }
                }
            }
            if (longJob) {
                longJob = longJob == false;
                signalInterface.invokeFMSignalListener(longJob);
            }
            if (handshake == -1) {
                SerialDriverSwHandshake.logger.debug(" **** SerialRead: read byte ");
                returnByte = this.serialPort.readBytes(1)[0];
                for (SerialCommunicationMirror mirror : this.mirrors) {
                    mirror.byteRead(returnByte);
                }
                SerialDriverSwHandshake.logger.debug(" **** SerialRead: byte readed [" + returnByte);
            } else {
                returnByte = (byte)handshake;
            }
            return returnByte;
        }
        catch (SerialPortException e) {
            throw new Pegas06FMException(-10003, (Exception)e);
        }
        catch (InterruptedException e) {
            throw new Pegas06FMException(-10004, e);
        }
    }

    private int swHandshake(LowLevelFMInterface signalInterface) throws Pegas06FMException {
        try {
            logger.debug(" **** SerialHandshake");
            this.serialPort.writeInt(17);
            logger.debug(" **** SerialHandshake: writing byte [17");
            for (SerialCommunicationMirror mirror : this.mirrors) {
                mirror.byteWritten((byte)17);
            }
            byte returnValue = this.serialPort.readBytes(1)[0];
            if (returnValue != -1) {
                for (SerialCommunicationMirror mirror : this.mirrors) {
                    mirror.byteRead(returnValue);
                }
            }
            return returnValue;
        }
        catch (SerialPortException e) {
            throw new Pegas06FMException(-10003, (Exception)((Object)e));
        }
    }
}

