/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.eKasaSK.lib.utility;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.io.FileInputStream;
import java.io.IOException;

public class BMPLoader {
    public static int constructInt(byte[] in, int offset) {
        int ret = in[offset + 3] & 0xFF;
        ret = ret << 8 | in[offset + 2] & 0xFF;
        ret = ret << 8 | in[offset + 1] & 0xFF;
        ret = ret << 8 | in[offset + 0] & 0xFF;
        return ret;
    }

    public static int constructInt3(byte[] in, int offset) {
        int ret = 255;
        ret = ret << 8 | in[offset + 2] & 0xFF;
        ret = ret << 8 | in[offset + 1] & 0xFF;
        ret = ret << 8 | in[offset + 0] & 0xFF;
        return ret;
    }

    public static long constructLong(byte[] in, int offset) {
        long ret = (long)in[offset + 7] & 0xFFL;
        ret |= ret << 8 | (long)in[offset + 6] & 0xFFL;
        ret |= ret << 8 | (long)in[offset + 5] & 0xFFL;
        ret |= ret << 8 | (long)in[offset + 4] & 0xFFL;
        ret |= ret << 8 | (long)in[offset + 3] & 0xFFL;
        ret |= ret << 8 | (long)in[offset + 2] & 0xFFL;
        ret |= ret << 8 | (long)in[offset + 1] & 0xFFL;
        ret |= ret << 8 | (long)in[offset + 0] & 0xFFL;
        return ret;
    }

    public static double constructDouble(byte[] in, int offset) {
        long ret = BMPLoader.constructLong(in, offset);
        return Double.longBitsToDouble(ret);
    }

    public static short constructShort(byte[] in, int offset) {
        short ret = (short)((short)in[offset + 1] & 0xFF);
        ret = (short)(ret << 8 | (short)((short)in[offset + 0] & 0xFF));
        return ret;
    }

    public static byte[][] read(byte[] fs) {
        BitmapHeader bh = new BitmapHeader();
        bh.read(fs);
        return null;
    }

    protected static Image readMap32(FileInputStream fs, BitmapHeader bh) throws IOException {
        int xwidth = bh.nsizeimage / bh.nheight;
        int[] ndata = new int[bh.nheight * bh.nwidth];
        byte[] brgb = new byte[bh.nwidth * 4 * bh.nheight];
        fs.read(brgb, 0, bh.nwidth * 4 * bh.nheight);
        int nindex = 0;
        int j = 0;
        while (j < bh.nheight) {
            int i = 0;
            while (i < bh.nwidth) {
                ndata[bh.nwidth * (bh.nheight - j - 1) + i] = BMPLoader.constructInt3(brgb, nindex);
                nindex += 4;
                ++i;
            }
            ++j;
        }
        Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(bh.nwidth, bh.nheight, ndata, 0, bh.nwidth));
        fs.close();
        return image;
    }

    protected static Image readMap24(FileInputStream fs, BitmapHeader bh) throws IOException {
        int npad = bh.nsizeimage / bh.nheight - bh.nwidth * 3;
        int[] ndata = new int[bh.nheight * bh.nwidth];
        byte[] brgb = new byte[(bh.nwidth + npad) * 3 * bh.nheight];
        fs.read(brgb, 0, (bh.nwidth + npad) * 3 * bh.nheight);
        int nindex = 0;
        int j = 0;
        while (j < bh.nheight) {
            int i = 0;
            while (i < bh.nwidth) {
                ndata[bh.nwidth * (bh.nheight - j - 1) + i] = BMPLoader.constructInt3(brgb, nindex);
                nindex += 3;
                ++i;
            }
            nindex += npad;
            ++j;
        }
        Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(bh.nwidth, bh.nheight, ndata, 0, bh.nwidth));
        fs.close();
        return image;
    }

    protected static Image readMap8(FileInputStream fs, BitmapHeader bh) throws IOException {
        int nNumColors = 0;
        nNumColors = bh.nclrused > 0 ? bh.nclrused : 1 << bh.nbitcount;
        if (bh.nsizeimage == 0) {
            bh.nsizeimage = (bh.nwidth * bh.nbitcount + 31 & 0xFFFFFFE0) >> 3;
            bh.nsizeimage *= bh.nheight;
        }
        int[] npalette = new int[nNumColors];
        byte[] bpalette = new byte[nNumColors * 4];
        fs.read(bpalette, 0, nNumColors * 4);
        int nindex8 = 0;
        int n = 0;
        while (n < nNumColors) {
            npalette[n] = BMPLoader.constructInt3(bpalette, nindex8);
            nindex8 += 4;
            ++n;
        }
        int npad8 = bh.nsizeimage / bh.nheight - bh.nwidth;
        int[] ndata8 = new int[bh.nwidth * bh.nheight];
        byte[] bdata = new byte[(bh.nwidth + npad8) * bh.nheight];
        fs.read(bdata, 0, (bh.nwidth + npad8) * bh.nheight);
        nindex8 = 0;
        int j8 = 0;
        while (j8 < bh.nheight) {
            int i8 = 0;
            while (i8 < bh.nwidth) {
                ndata8[bh.nwidth * (bh.nheight - j8 - 1) + i8] = npalette[bdata[nindex8] & 0xFF];
                ++nindex8;
                ++i8;
            }
            nindex8 += npad8;
            ++j8;
        }
        Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(bh.nwidth, bh.nheight, ndata8, 0, bh.nwidth));
        return image;
    }

    public static byte[][] readMap1(byte[] fs, BitmapHeader bh, int pos) {
        int nNumColors = 0;
        nNumColors = bh.nclrused > 0 ? bh.nclrused : 1 << bh.nbitcount;
        if (bh.nsizeimage == 0) {
            bh.nsizeimage = (bh.nwidth * bh.nbitcount + 31 & 0xFFFFFFE0) >> 3;
            bh.nsizeimage *= bh.nheight;
        }
        int[] npalette = new int[nNumColors];
        byte[] bpalette = new byte[nNumColors * 4];
        int i = 0;
        while (i < nNumColors * 4) {
            bpalette[i] = fs[pos];
            ++pos;
            ++i;
        }
        int nindex8 = 0;
        int n = 0;
        while (n < nNumColors) {
            npalette[n] = BMPLoader.constructInt3(bpalette, nindex8);
            nindex8 += 4;
            ++n;
        }
        int npad8 = bh.nsizeimage / bh.nheight - bh.nwidth;
        byte[] bdata = new byte[(bh.nwidth + npad8) * bh.nheight];
        int i2 = 0;
        while (i2 < (bh.nwidth + npad8) * bh.nheight) {
            bdata[i2] = fs[pos];
            ++pos;
            ++i2;
        }
        nindex8 = 0;
        byte[][] imageData = new byte[bh.nheight][(bh.nwidth + npad8) * 8];
        int j8 = 0;
        while (j8 < bh.nheight) {
            int i8 = 0;
            while (i8 < bh.nwidth + npad8) {
                int a = bdata[nindex8] & 0xFF;
                imageData[bh.nheight - j8 - 1][i8 * 8 + 0] = (a & 0x80) == 128 ? (byte)1 : 0;
                imageData[bh.nheight - j8 - 1][i8 * 8 + 1] = (a & 0x40) == 64 ? (byte)1 : 0;
                imageData[bh.nheight - j8 - 1][i8 * 8 + 2] = (a & 0x20) == 32 ? (byte)1 : 0;
                imageData[bh.nheight - j8 - 1][i8 * 8 + 3] = (a & 0x10) == 16 ? (byte)1 : 0;
                imageData[bh.nheight - j8 - 1][i8 * 8 + 4] = (a & 8) == 8 ? (byte)1 : 0;
                imageData[bh.nheight - j8 - 1][i8 * 8 + 5] = (a & 4) == 4 ? (byte)1 : 0;
                imageData[bh.nheight - j8 - 1][i8 * 8 + 6] = (a & 2) == 2 ? (byte)1 : 0;
                imageData[bh.nheight - j8 - 1][i8 * 8 + 7] = (a & 1) == 1 ? (byte)1 : 0;
                ++nindex8;
                ++i8;
            }
            ++j8;
        }
        return imageData;
    }

    public static void main(String[] args) throws IOException {
    }

    public static class BitmapHeader {
        public int nsize;
        public int nbisize;
        public int nwidth;
        public int nheight;
        public int nplanes;
        public int nbitcount;
        public int ncompression;
        public int nsizeimage;
        public int nxpm;
        public int nypm;
        public int nclrused;
        public int nclrimp;

        public int read(byte[] fs) {
            int pos = 0;
            int bflen = 14;
            byte[] bf = new byte[14];
            int i = 0;
            while (i < 14) {
                bf[i] = fs[pos];
                ++pos;
                ++i;
            }
            int bilen = 40;
            byte[] bi = new byte[40];
            int i2 = 0;
            while (i2 < 40) {
                bi[i2] = fs[pos];
                ++pos;
                ++i2;
            }
            this.nsize = BMPLoader.constructInt(bf, 2);
            this.nbisize = BMPLoader.constructInt(bi, 2);
            this.nwidth = BMPLoader.constructInt(bi, 4);
            this.nheight = BMPLoader.constructInt(bi, 8);
            this.nplanes = BMPLoader.constructShort(bi, 12);
            this.nbitcount = BMPLoader.constructShort(bi, 14);
            this.ncompression = BMPLoader.constructInt(bi, 16);
            this.nsizeimage = BMPLoader.constructInt(bi, 20);
            this.nxpm = BMPLoader.constructInt(bi, 24);
            this.nypm = BMPLoader.constructInt(bi, 28);
            this.nclrused = BMPLoader.constructInt(bi, 32);
            this.nclrimp = BMPLoader.constructInt(bi, 36);
            return pos;
        }
    }
}

