/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.printer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.enumeration.PRINT_ALIGNMENT;
import sk.singularisdev.ekasask.enumeration.PRINT_SEQUENCE_TYPE;
import sk.singularisdev.ekasask.printer.AbstractPrinter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Printer {
    private static final Pattern do;
    public static final byte[] NON_FISCAL_MARK;

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        NON_FISCAL_MARK = "#".getBytes();
        StringBuilder regex = new StringBuilder();
        regex.append(".*[");
        int ch = 0;
        while (ch < 32) {
            regex.append((char)ch);
            ++ch;
        }
        regex.append('\u007f');
        regex.append("]+.*");
        do = Pattern.compile(var0.toString());
    }

    /*
     * WARNING - void declaration
     */
    public static void validateString(AbstractPrinter printer, String text) throws EKasaException {
        void var1_1;
        Matcher matcher = do.matcher(text);
        if (matcher.matches()) {
            throw new EKasaException(16L);
        }
        if (var1_1.indexOf(126) == -1) {
            return;
        }
        throw new EKasaException(16L);
    }

    /*
     * WARNING - void declaration
     */
    public static String replaceEsc(AbstractPrinter printer, String text) throws EKasaException {
        void var1_1;
        return Printer.replaceEsc(printer, (String)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static String replaceEsc(AbstractPrinter printer, String text, boolean announcement) throws EKasaException {
        void var2_2;
        void var1_1;
        return Printer.replaceEsc(printer, (String)var1_1, true, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String replaceEsc(AbstractPrinter printer, String text, boolean validate, boolean announcement) throws EKasaException {
        void var1_1;
        void var2_2;
        void var3_3;
        AbstractPrinter abstractPrinter;
        Matcher matcher;
        if (validate && (matcher = do.matcher(text)).matches()) {
            throw new EKasaException(16L);
        }
        text = abstractPrinter.rewriteEscSequence(text, false, (boolean)var3_3);
        if (var2_2 != false) {
            if (text.indexOf(126) == -1) {
                return text;
            }
            throw new EKasaException(16L);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static int getPrintableLength(AbstractPrinter printer, String text, boolean announcement) {
        void var2_2;
        String string;
        string = printer.rewriteEscSequence(string, true, (boolean)var2_2);
        return string.length();
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] alignText(AbstractPrinter printer, String text, PRINT_ALIGNMENT alignment) throws EKasaException {
        AbstractPrinter abstractPrinter;
        void var2_2;
        void var1_1;
        return Printer.alignText(printer, (String)var1_1, (PRINT_ALIGNMENT)var2_2, abstractPrinter.getCharPerRow());
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] alignText(AbstractPrinter printer, String text, PRINT_ALIGNMENT alignment, int chars) throws EKasaException {
        void var3_3;
        void var2_2;
        void var1_1;
        return Printer.alignText(printer, (String)var1_1, (PRINT_ALIGNMENT)var2_2, (int)var3_3, false, false);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] alignText(AbstractPrinter printer, String text, PRINT_ALIGNMENT alignment, int chars, boolean addEmptyCharsAfter, boolean announcement) throws EKasaException {
        try {
            void var1_1;
            int emptyCharsAfter;
            int emptyCharsBefore;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            switch (alignment) {
                case CENTER: {
                    int textLen = Printer.getPrintableLength(printer, text, announcement);
                    emptyCharsBefore = (chars - textLen) / 2;
                    emptyCharsAfter = chars - emptyCharsBefore - textLen;
                    break;
                }
                case RIGHT: {
                    void var5_6;
                    emptyCharsBefore = emptyCharsAfter - Printer.getPrintableLength(printer, text, (boolean)var5_6);
                    emptyCharsAfter = 0;
                    break;
                }
                default: {
                    void var5_6;
                    emptyCharsBefore = 0;
                    emptyCharsAfter -= Printer.getPrintableLength(printer, text, (boolean)var5_6);
                    break;
                }
            }
            while (emptyCharsBefore > 0) {
                baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.SPACE));
                --emptyCharsBefore;
            }
            baos.write(Printer.replaceEsc(printer, (String)var1_1).getBytes(printer.getCharset()));
            if (addEmptyCharsAfter) {
                while (emptyCharsAfter > 0) {
                    baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.SPACE));
                    --emptyCharsAfter;
                }
            }
            return baos.toByteArray();
        }
        catch (IOException iOException) {
            throw new EKasaException(13L);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String formatNumber(long amount, int precision, int size) {
        void var3_2;
        StringBuilder sb = new StringBuilder();
        boolean negate = false;
        if (amount < 0L) {
            negate = true;
            amount = -amount;
        }
        if (precision > 0) {
            void var2_1;
            int div = (int)Math.pow(10.0, precision);
            String txt = String.valueOf(negate ? "-" : "") + (int)(amount / (long)div);
            int l = size - precision - 1;
            if (l <= 0) {
                l = 1;
            }
            sb.append(String.format("%" + (int)var3_2 + "s", txt));
            sb.append(".");
            sb.append(String.format("%0" + (int)var2_1 + "d", amount % (long)div));
        } else {
            long l;
            void var5_4;
            String txt = String.valueOf(var5_4 != false ? "-" : "") + (int)l;
            sb.append(String.format("%" + (int)var3_2 + "s", txt));
        }
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String formatNumber(BigDecimal amount, int size) {
        BigDecimal bigDecimal;
        void var1_1;
        return String.format("%" + (int)var1_1 + "s", bigDecimal.toString());
    }

    /*
     * WARNING - void declaration
     */
    public static String formatString(String text, int size, boolean left) {
        String string;
        void var1_1;
        void var2_2;
        return String.format("%" + (var2_2 != false ? "-" : "") + (int)var1_1 + "s", string);
    }

    /*
     * WARNING - void declaration
     */
    public static void splitText(List<String> list, String text, int width) {
        void var2_2;
        void var1_1;
        Printer.splitText(list, (String)var1_1, (int)var2_2, false);
    }

    public static void splitText(List<String> list, String text, int width, boolean splitByWord) {
        int l = text.length();
        int i = 0;
        while (i < l) {
            if (l - i <= width) {
                list.add(text.substring(i));
            } else {
                int n = i;
                String txt = text.substring(n, n + width);
                if (splitByWord && text.charAt(i + width) != ' ') {
                    int j = 0;
                    while (j < width) {
                        if (text.charAt(i + width - j - 1) == ' ') {
                            int n2 = i;
                            txt = text.substring(n2, n2 + width - j);
                            i -= j;
                            break;
                        }
                        ++j;
                    }
                }
                list.add(txt);
            }
            i += width;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String getParagonItemSaleFormat(AbstractPrinter printer, boolean platca) throws EKasaException {
        String string;
        void var1_1;
        String format = printer.getParagonItemSaleFormat(platca);
        if (!(format.contains("%1$") && format.contains("%2$") && format.contains("%3$") && format.contains("%5$") && (var1_1 == false || format.contains("%7$")))) {
            throw new EKasaException(13L);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static String getParagonItemVoucherFormat(AbstractPrinter printer, boolean platca) throws EKasaException {
        String string;
        void var1_1;
        String format = printer.getParagonItemVoucherFormat(platca);
        if (!format.contains("%3$") || !format.contains("%5$") || var1_1 != false && !format.contains("%7$")) {
            throw new EKasaException(13L);
        }
        return string;
    }

    public static String getVatTableFormat(AbstractPrinter printer) throws EKasaException {
        String string;
        String format = printer.getVatTableFormat();
        if (!(format.contains("%1$") && format.contains("%2$") && format.contains("%3$") && format.contains("%5$"))) {
            throw new EKasaException(13L);
        }
        return string;
    }
}

