/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.printer.driver;

import sk.singularisdev.ekasask.enumeration.PRINT_SEQUENCE_TYPE;
import sk.singularisdev.ekasask.printer.AbstractPrinter;
import sk.singularisdev.ekasask.printer.utility.Rewriter;

public class BMPRewriter {
    public static final Rewriter REWRITER_LF = new Rewriter("(~0A)", ""){
        {
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String replacement(AbstractPrinter printer) {
            void var1_1;
            return new String(printer.getEscSequence(PRINT_SEQUENCE_TYPE.LF), var1_1.getCharset());
        }
    };
    public static final Rewriter REWRITER_CR = new Rewriter("(~0D)", ""){
        {
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String replacement(AbstractPrinter printer) {
            void var1_1;
            return new String(printer.getEscSequence(PRINT_SEQUENCE_TYPE.CR), var1_1.getCharset());
        }
    };
    public static final Rewriter REWRITER_UNDERLINE = new Rewriter("(~1B~2D~0[0-2])", ""){
        {
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String replacement(AbstractPrinter printer) {
            void var1_2;
            String g = this.group(1);
            char ch = g.charAt(g.length() - 1);
            return "\u001b-".concat(String.valueOf((char)var1_2));
        }
    };
    public static final Rewriter REWRITER_EMPHASIZED = new Rewriter("(~1B~45~[0-9A-F]{2})", ""){
        {
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String replacement(AbstractPrinter printer) {
            void var1_1;
            String g = this.group(1);
            String ch = g.substring(g.length() - 2);
            String b = new String(new byte[]{(byte)Integer.parseInt(ch, 16)}, this.getCharset());
            return "\u001bE".concat(String.valueOf(var1_1));
        }
    };
    public static final Rewriter REWRITER_DOUBLE_STRIKE = new Rewriter("(~1B~47~[0-9A-F]{2})", ""){
        {
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String replacement(AbstractPrinter printer) {
            void var1_1;
            String g = this.group(1);
            String ch = g.substring(g.length() - 2);
            String b = new String(new byte[]{(byte)Integer.parseInt(ch, 16)}, this.getCharset());
            return "\u001bG".concat(String.valueOf(var1_1));
        }
    };
    public static final Rewriter REWRITER_ROTATE = new Rewriter("(~1B~56~0[0-1])", ""){
        {
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String replacement(AbstractPrinter printer) {
            void var1_2;
            String g = this.group(1);
            char ch = g.charAt(g.length() - 1);
            return "\u001bV".concat(String.valueOf((char)var1_2));
        }
    };
    public static final Rewriter REWRITER_ALLOW_PANEL_BUTTON = new Rewriter("(~1B~63~35~[0-9A-F]{2})", ""){
        {
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String replacement(AbstractPrinter printer) {
            void var1_1;
            String g = this.group(1);
            String ch = g.substring(g.length() - 2);
            String b = new String(new byte[]{(byte)Integer.parseInt(ch, 16)}, this.getCharset());
            return "\u001bc5".concat(String.valueOf(var1_1));
        }
    };
    public static final Rewriter REWRITER_SHUFFLE = new Rewriter("(~1B~70~0[0-1]~[0-9A-F]{2}~[0-9A-F]{2})", ""){
        {
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String replacement(AbstractPrinter printer) {
            void var1_1;
            void var3_3;
            void var2_2;
            String g = this.group(1);
            int l = g.length();
            char ch = g.charAt(l - 7);
            String ch1 = g.substring(l - 5, l - 3);
            String b1 = new String(new byte[]{(byte)Integer.parseInt(ch1, 16)}, this.getCharset());
            String ch2 = g.substring(l - 2, (int)var2_2);
            String b2 = new String(new byte[]{(byte)Integer.parseInt(ch2, 16)}, this.getCharset());
            return "\u001bp" + (char)var3_3 + b1 + (String)var1_1;
        }
    };
    public static final Rewriter REWRITER_LOGO = new Rewriter("(~1C~70~0[0-1]~0[0-1])", ""){
        {
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String replacement(AbstractPrinter printer) {
            void var1_1;
            void var3_3;
            void var2_2;
            String g = this.group(1);
            int l = g.length();
            String ch1 = g.substring(l - 5, l - 3);
            String b1 = new String(new byte[]{(byte)Integer.parseInt(ch1, 16)}, this.getCharset());
            String ch2 = g.substring(l - 2, (int)var2_2);
            String b2 = new String(new byte[]{(byte)Integer.parseInt(ch2, 16)}, this.getCharset());
            return "\u001cp" + (String)var3_3 + (String)var1_1;
        }
    };
    public static final Rewriter REWRITER_UPSIDE_DOWN = new Rewriter("(~1B~7B~[0-9A-F]{2})", ""){
        {
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String replacement(AbstractPrinter printer) {
            void var1_1;
            String g = this.group(1);
            String ch = g.substring(g.length() - 2);
            String b = new String(new byte[]{(byte)Integer.parseInt(ch, 16)}, this.getCharset());
            return "\u001b{".concat(String.valueOf(var1_1));
        }
    };
    public static final Rewriter REWRITER_CUTTER = new Rewriter("(~1D~56~42~(00|01|66))", ""){
        {
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String replacement(AbstractPrinter printer) {
            void var1_1;
            String g = this.group(1);
            String ch = g.substring(g.length() - 2);
            String b = new String(new byte[]{(byte)Integer.parseInt(ch, 16)}, this.getCharset());
            return "\u001dVB".concat(String.valueOf(var1_1));
        }
    };
    public static final Rewriter REWRITER_REVERSE = new Rewriter("(~1D~42~[0-9A-F]{2})", ""){
        {
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String replacement(AbstractPrinter printer) {
            void var1_1;
            String g = this.group(1);
            String ch = g.substring(g.length() - 2);
            String b = new String(new byte[]{(byte)Integer.parseInt(ch, 16)}, this.getCharset());
            return "\u001dB".concat(String.valueOf(var1_1));
        }
    };
    public static final Rewriter REWRITER_DOUBLE_WIDTH = new Rewriter("(~1F.)", "  "){
        {
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String replacement(AbstractPrinter printer) {
            void var1_1;
            void var2_3;
            void var3_4;
            String g = this.group(1);
            int l = g.length();
            char ch = g.charAt((int)(var3_4 - true));
            return String.valueOf(new String(printer.getEscSequence(PRINT_SEQUENCE_TYPE.DOUBLE_CHAR_ON), printer.getCharset())) + (char)var2_3 + new String(printer.getEscSequence(PRINT_SEQUENCE_TYPE.DOUBLE_CHAR_OFF), var1_1.getCharset());
        }
    };
    public static final Rewriter REWRITER_EURO = new Rewriter("(\u20ac)", " "){
        {
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String replacement(AbstractPrinter printer) {
            void var1_1;
            this.group(1);
            return new String(printer.getEscSequence(PRINT_SEQUENCE_TYPE.EURO), var1_1.getCharset());
        }
    };
}

