/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.chdu.DisplayData;
import sk.singularisdev.ekasask.command.AbstractCommand;
import sk.singularisdev.ekasask.command.Display;
import sk.singularisdev.ekasask.enumeration.DISPLAY_NUMBER;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.util.Hex;

public class ClearDisplay
extends FmCommand {
    private static final Logger logger = LoggerManager.getLogger((String)ClearDisplay.class.getName());
    private int displayType;

    public ClearDisplay(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    @Override
    protected byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        block9: {
            byte status;
            block10: {
                if (ppekk == null) {
                    return -3;
                }
                try {
                    if (!fm.isDbOk()) break block9;
                    status = this.parseParams();
                    if (status != 0) break block10;
                    try {
                        Display display = Display.getInstance((DISPLAY_NUMBER)(this.displayType == 0 ? DISPLAY_NUMBER.INTERNAL : DISPLAY_NUMBER.EXTERNAL));
                        DisplayData data = new DisplayData();
                        switch (fm.getDisplayType()) {
                            case 2: {
                                byte[] byArray = new byte[8];
                                byArray[0] = 85;
                                byArray[1] = 33;
                                byArray[2] = 118;
                                byArray[3] = 2;
                                byArray[6] = 1;
                                byArray[7] = 1;
                                data.setData(byArray);
                                break;
                            }
                            default: {
                                data.setData(new byte[]{12});
                            }
                        }
                        display.addDisplayData(data);
                        ppekk.process((AbstractCommand)display);
                    }
                    catch (EKasaException e) {
                        fm.setLastPPEKKError(e.getErrorCode());
                        return -3;
                    }
                }
                catch (FmStoreToDbException e) {
                    logger.fatal("Database error", (Throwable)e);
                    return -2;
                }
            }
            return status;
        }
        return -2;
    }

    @Override
    protected byte parseParams() {
        FmFiscalMemory fm = this.eKasa.getFm();
        switch (fm.getFmState()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 20: 
            case 32: 
            case 33: 
            case 34: {
                break;
            }
            default: {
                return 52;
            }
        }
        if (this.params.length != 2) {
            return 32;
        }
        try {
            this.displayType = Integer.parseInt(this.params[0]);
            if (this.displayType < 0 || this.displayType > 9) {
                return 96;
            }
        }
        catch (NumberFormatException e) {
            return 96;
        }
        return 0;
    }
}

