/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import java.io.ByteArrayOutputStream;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.command.AbstractCommand;
import sk.singularisdev.ekasask.command.internal.LoadLogo;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.interfaces.BlockOutInterface;
import sk.singularisdev.ekasask.fm.util.Hex;

public class LoadGHNV
extends FmCommand
implements BlockOutInterface {
    private static final Logger logger = LoggerManager.getLogger((String)LoadGHNV.class.getName());
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private int logoCount = 0;

    public LoadGHNV(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    @Override
    protected byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        if (ppekk == null) {
            return -3;
        }
        if (fm.isDbOk()) {
            byte status = this.parseParams();
            return status;
        }
        return -2;
    }

    @Override
    protected byte parseParams() {
        FmFiscalMemory fm = this.eKasa.getFm();
        switch (fm.getFmState()) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                return 52;
            }
        }
        if (this.params.length != 2) {
            return 32;
        }
        try {
            this.logoCount = Integer.parseInt(this.params[0]);
            if (this.logoCount < 0 || this.logoCount > 6) {
                return 96;
            }
        }
        catch (NumberFormatException e) {
            return 96;
        }
        return 0;
    }

    @Override
    public byte block(byte[] blockData, boolean lastBlock) {
        block7: {
            int dataLength;
            FmFiscalMemory fm;
            PPEKK ppekk;
            block8: {
                ppekk = this.eKasa.getPPEKK();
                fm = this.eKasa.getFm();
                dataLength = this.baos.size();
                this.baos.write(blockData);
                if (!lastBlock) break block7;
                if (ppekk != null) break block8;
                return -3;
            }
            try {
                if (fm.isDbOk()) {
                    LoadLogo loadLogo = LoadLogo.getInstance((int)this.logoCount, (byte[])this.baos.toByteArray());
                    ppekk.process((AbstractCommand)loadLogo);
                    return 0;
                }
                return -2;
            }
            catch (EKasaException e) {
                byte[] data = this.baos.toByteArray();
                this.baos.reset();
                this.baos.write(data, 0, dataLength);
                try {
                    fm.setLastPPEKKError(e.getErrorCode());
                }
                catch (FmStoreToDbException e1) {
                    logger.fatal("Database error - error suppressed by outer error");
                }
                return -3;
            }
            catch (Exception e) {
                byte[] data = this.baos.toByteArray();
                this.baos.reset();
                this.baos.write(data, 0, dataLength);
                return 96;
            }
        }
        return 0;
    }
}

