/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import java.util.Date;
import java.util.Map;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.common.Function;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.data.ParagonModel;
import sk.singularisdev.ekasask.fm.data.Turnover;
import sk.singularisdev.ekasask.fm.enums.ParagonType;
import sk.singularisdev.ekasask.fm.util.Hex;
import sk.singularisdev.ekasask.printer.utility.AbstractPrinterInterface;

public class ParagonBegin
extends FmCommand {
    private static final Logger logger = LoggerManager.getLogger((String)ParagonBegin.class.getName());
    private int rowNumber;
    private int commType;
    private int paragonType;
    private int recapType;
    private int graphicHeader;
    private ParagonType saleType;

    public ParagonBegin(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    @Override
    public byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        if (ppekk == null) {
            return -3;
        }
        try {
            if (fm.isDbOk()) {
                byte status = this.parseParams();
                if (status == 0) {
                    fm.beginTransaction();
                    switch (this.saleType) {
                        case maloobchod: {
                            fm.setFmState(2);
                            break;
                        }
                        case velkoobchod: {
                            fm.setFmState(2);
                            break;
                        }
                        case interny2: {
                            fm.setFmState(10);
                            break;
                        }
                        case interny3: {
                            fm.setFmState(10);
                            break;
                        }
                        case neplatny: {
                            fm.setFmState(2);
                            break;
                        }
                        case vkladVyber: {
                            fm.setFmState(20);
                            break;
                        }
                        case interny6: {
                            fm.setFmState(10);
                            break;
                        }
                        case faktura: {
                            fm.setFmState(32);
                            break;
                        }
                        default: {
                            fm.setFmState(2);
                        }
                    }
                    for (Map.Entry<Character, Turnover> entry : fm.getVats().entrySet()) {
                        entry.getValue().resetLocals();
                    }
                    fm.setActualRow(this.rowNumber);
                    fm.initParagon(new ParagonModel.Builder().setRow(this.rowNumber).setSaleType(this.saleType).setCommType(this.commType).setGraphicHeader(this.graphicHeader).setRecapType(this.recapType).setParagonType(this.paragonType).build());
                    fm.getParagon().appendBinaryData(this.binary);
                    if (ppekk.getPrinter() instanceof AbstractPrinterInterface) {
                        AbstractPrinterInterface p = (AbstractPrinterInterface)ppekk.getPrinter();
                        if (this.saleType == ParagonType.interny6) {
                            p.setCharPerRow(p.getCharPerRowInternalReceipt());
                            fm.setCharCount(p.getCharPerRowInternalReceipt());
                        } else {
                            p.setCharPerRow(p.getCharPerRowReceipt());
                            fm.setCharCount(p.getCharPerRowReceipt());
                        }
                    }
                    fm.saveDbParagon();
                    fm.setTransactionSuccesfull();
                    fm.endTransaction();
                }
                return status;
            }
            return -2;
        }
        catch (FmStoreToDbException e) {
            if (ppekk.getPrinter() instanceof AbstractPrinterInterface) {
                AbstractPrinterInterface p = (AbstractPrinterInterface)ppekk.getPrinter();
                p.setCharPerRow(p.getCharPerRowReceipt());
            }
            fm.endTransaction();
            logger.fatal("Database error", (Throwable)e);
            Function.initFMDB(fm);
            return -2;
        }
    }

    @Override
    protected byte parseParams() {
        block19: {
            block18: {
                block17: {
                    FmFiscalMemory fm;
                    block16: {
                        block15: {
                            block14: {
                                block13: {
                                    fm = this.eKasa.getFm();
                                    if (fm.getFmState() == 0) {
                                        fm.setLastShiftDate(new Date());
                                        fm.setFmState(1);
                                    }
                                    if (fm.getFmState() == 1) break block13;
                                    return 52;
                                }
                                if (this.params.length >= 6 && this.params.length <= 7) break block14;
                                return 32;
                            }
                            this.rowNumber = Integer.parseInt(this.params[0]);
                            if (this.rowNumber >= 0 && this.rowNumber <= 9) break block15;
                            return 96;
                        }
                        this.saleType = ParagonType.fromId(Integer.parseInt(this.params[1]));
                        if (this.saleType != null) break block16;
                        return 96;
                    }
                    if (!fm.isVatPayer() && this.saleType == ParagonType.velkoobchod) {
                        this.saleType = ParagonType.maloobchod;
                    }
                    this.commType = Integer.parseInt(this.params[2]);
                    if (this.commType >= 0 && this.commType <= 1) break block17;
                    return 96;
                }
                this.paragonType = Integer.parseInt(this.params[3]);
                if (this.paragonType >= 0 && this.paragonType <= 0) break block18;
                return 96;
            }
            this.recapType = Integer.parseInt(this.params[4]);
            if (this.recapType >= 0 && this.recapType <= 9) break block19;
            return 96;
        }
        try {
            this.graphicHeader = Integer.parseInt(this.params[5]);
            if (this.graphicHeader < 0 || this.graphicHeader > 6) {
                return 96;
            }
        }
        catch (NumberFormatException e) {
            return 96;
        }
        catch (FmStoreToDbException e) {
            logger.fatal("Database error", (Throwable)e);
            return -2;
        }
        return 0;
    }
}

