/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.fm.Checkers;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.Payment;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.common.Function;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.data.FiscalRounding;
import sk.singularisdev.ekasask.fm.data.PaymentMethod;
import sk.singularisdev.ekasask.fm.data.PaymentModel;
import sk.singularisdev.ekasask.fm.data.Turnover;
import sk.singularisdev.ekasask.fm.enums.ParagonType;
import sk.singularisdev.ekasask.fm.util.Hex;
import sk.singularisdev.ekasask.printer.AbstractPrinter;
import sk.singularisdev.ekasask.printer.Printer;
import sk.singularisdev.ekasask.printer.utility.AbstractPrinterInterface;

public class Payment2
extends FmCommand {
    private static final Logger logger = LoggerManager.getLogger((String)Payment.class.getName());
    private int row;
    private int paymentID;
    private BigDecimal total;
    private BigDecimal payedValue;
    private BigDecimal payedValueZ;
    private BigDecimal exchangeRate;
    private BigDecimal realPayedValue = BigDecimal.ZERO;
    private BigDecimal returnValue = BigDecimal.ZERO;
    private BigDecimal roundValue = BigDecimal.ZERO;
    private String description;
    private String print = "";
    private PaymentMethod paymentMethod;
    private int baseFont = 0;

    public Payment2(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        BigDecimal actualTotal;
        byte status;
        String formatRound;
        String formatNotReturn;
        String formatReturn;
        String formatExchangeRate;
        String formatStandard;
        String formatTotal;
        block57: {
            if (ppekk == null) {
                return -3;
            }
            if (ppekk.getPrinter() instanceof AbstractPrinterInterface) {
                this.baseFont = ((AbstractPrinterInterface)ppekk.getPrinter()).isBaseFont() ? 0 : 1;
            }
            formatTotal = "";
            formatTotal = fm.getCharCount() < 26 ? "~1B~21~1" + (0 + this.baseFont) + "CELKOM: %" + (fm.getCharCount() - 12) + "s EUR~1B~21~0" + (0 + this.baseFont) + "\n" : "~1B~21~3" + (0 + this.baseFont) + "CELKOM:~1B~21~1" + (0 + this.baseFont) + " %" + (fm.getCharCount() - 19) + "s EUR~1B~21~0" + (0 + this.baseFont) + "\n";
            formatStandard = "%-10s %" + (fm.getCharCount() - 15) + "s EUR\n";
            formatExchangeRate = "%-21sKURZ%11s    \n%-11sx%8s = %" + (fm.getCharCount() - 27) + "s EUR\n";
            formatReturn = "VR\u00c1TEN\u00c9%" + (fm.getCharCount() - 11) + "s EUR\n";
            formatNotReturn = "NEVR\u00c1TEN\u00c9%" + (fm.getCharCount() - 13) + "s EUR\n";
            formatRound = "ZAOKR\u00daHLENIE:%" + (fm.getCharCount() - 17) + "s   \n";
            if (!fm.isDbOk()) return -2;
            status = this.parseParams();
            if (status != 0) return status;
            fm.beginTransaction();
            switch (fm.getParagon().getSaleType()) {
                case faktura: {
                    fm.setReceiptTotal(fm.getLocalInvoiceTurnover().add(fm.getParagon().getReceiptTotal().negate()));
                    break;
                }
                default: {
                    if (fm.getFmState() != 2 || !fm.isVatPayer()) break;
                    fm.setReceiptTotal(fm.getReceiptTotalWithVat());
                }
            }
            actualTotal = fm.getReceiptTotal().setScale(2, RoundingMode.UNNECESSARY);
            if (actualTotal.abs().compareTo(this.payedValue.abs()) >= 0 || this.paymentMethod.isOverpay() || fm.getParagon().getRecapType() == 3) break block57;
            return 42;
        }
        try {
            this.realPayedValue = this.payedValueZ;
            BigDecimal balance = actualTotal.subtract(this.realPayedValue);
            FiscalRounding rounding = new FiscalRounding();
            block5 : switch (balance.compareTo(BigDecimal.ZERO)) {
                case -1: {
                    switch (balance.compareTo(fm.getPaymentMethod(16).getMinCurrency())) {
                        case -1: {
                            rounding = fm.getFiscalLocalization().adaptRevenueToMinCurrency(actualTotal, this.paymentMethod.getMinCurrency());
                            actualTotal = rounding.roundedObrat;
                            this.roundValue = rounding.roundedFragment;
                            this.returnValue = actualTotal.subtract(this.realPayedValue);
                            fm.setReceiptTotal(BigDecimal.ZERO);
                            break;
                        }
                        case 0: 
                        case 1: {
                            rounding = fm.getFiscalLocalization().adaptRevenueToMinCurrency(balance.abs(), fm.getPaymentMethod(16).getMinCurrency());
                            actualTotal = this.realPayedValue.subtract(rounding.roundedObrat);
                            this.roundValue = rounding.roundedFragment;
                            this.returnValue = rounding.roundedObrat;
                            fm.setReceiptTotal(BigDecimal.ZERO);
                        }
                    }
                    break;
                }
                case 0: {
                    fm.setReceiptTotal(BigDecimal.ZERO);
                    break;
                }
                case 1: {
                    rounding = fm.getFiscalLocalization().adaptRevenueToMinCurrency(actualTotal, this.paymentMethod.getMinCurrency());
                    switch (rounding.roundedObrat.subtract(this.realPayedValue).compareTo(BigDecimal.ZERO)) {
                        case -1: {
                            break block5;
                        }
                        case 0: {
                            actualTotal = rounding.roundedObrat;
                            this.roundValue = rounding.roundedFragment;
                            fm.setReceiptTotal(BigDecimal.ZERO);
                            break block5;
                        }
                        case 1: {
                            fm.appendReceiptTotal(this.realPayedValue.negate());
                        }
                    }
                }
            }
            if (this.roundValue.compareTo(BigDecimal.ZERO) != 0) {
                fm.getFiscalLocalization().divideRevenues(fm, this.roundValue);
            }
            this.print = this.exchangeRate.compareTo(BigDecimal.ZERO) == 0 ? String.valueOf(this.print) + String.format(formatStandard, this.description, this.realPayedValue) : String.valueOf(this.print) + String.format(formatExchangeRate, this.description, this.exchangeRate, this.payedValue, this.exchangeRate, this.realPayedValue);
            switch (fm.getFmState()) {
                case 2: {
                    fm.setFmState(3);
                    if (fm.getReceiptTotal().compareTo(BigDecimal.ZERO) > 0) break;
                    fm.setFmState(4);
                    for (Map.Entry<Character, Turnover> vat : fm.getVats().entrySet()) {
                        if (vat.getValue().getLocalTotal().compareTo(BigDecimal.ZERO) == 0) continue;
                        if (fm.getParagon().getSaleType() != ParagonType.velkoobchod) {
                            fm.getFiscalLocalization().getMaloobchod(vat.getValue());
                            continue;
                        }
                        fm.getFiscalLocalization().getVelkoobchod(vat.getValue());
                    }
                    if (fm.getParagon().getRecapType() != 3) {
                        BigDecimal totalValue;
                        if (this.returnValue.compareTo(BigDecimal.ZERO) != 0) {
                            this.print = String.valueOf(this.print) + String.format(formatReturn, this.returnValue);
                        }
                        if (this.roundValue.compareTo(BigDecimal.ZERO) != 0) {
                            this.print = String.valueOf(this.print) + String.format(formatRound, this.roundValue);
                        }
                        this.print = String.valueOf(this.print) + Formatter.get().repeat('-', fm.getCharCount()) + "\n";
                        switch (fm.getParagon().getSaleType()) {
                            case velkoobchod: {
                                totalValue = fm.getReceiptTotalNoVat().setScale(2, RoundingMode.UNNECESSARY);
                                break;
                            }
                            default: {
                                totalValue = fm.getReceiptTotalWithVat().setScale(2, RoundingMode.UNNECESSARY);
                            }
                        }
                        this.print = String.valueOf(this.print) + String.format(formatTotal, totalValue);
                        break;
                    }
                    if (this.returnValue.compareTo(BigDecimal.ZERO) != 0) {
                        this.print = String.valueOf(this.print) + String.format(this.paymentMethod.isOverpay() ? formatReturn : formatNotReturn, this.returnValue);
                    }
                    if (this.roundValue.compareTo(BigDecimal.ZERO) == 0) break;
                    this.print = String.valueOf(this.print) + String.format(formatRound, this.roundValue);
                    break;
                }
                case 32: {
                    fm.setFmState(33);
                    if (fm.getReceiptTotal().compareTo(BigDecimal.ZERO) > 0) break;
                    fm.setFmState(34);
                    if (fm.getParagon().getRecapType() != 3) {
                        if (this.returnValue.compareTo(BigDecimal.ZERO) != 0) {
                            this.print = String.valueOf(this.print) + String.format(formatReturn, this.returnValue);
                        }
                        if (this.roundValue.compareTo(BigDecimal.ZERO) != 0) {
                            this.print = String.valueOf(this.print) + String.format(formatRound, this.roundValue);
                        }
                        this.print = String.valueOf(this.print) + Formatter.get().repeat('-', fm.getCharCount()) + "\n";
                        BigDecimal totalValue = fm.getLocalInvoiceTurnover().setScale(2, RoundingMode.UNNECESSARY);
                        this.print = String.valueOf(this.print) + String.format(formatTotal, totalValue);
                        break;
                    }
                    if (this.returnValue.compareTo(BigDecimal.ZERO) != 0) {
                        this.print = String.valueOf(this.print) + String.format(this.paymentMethod.isOverpay() ? formatReturn : formatNotReturn, this.returnValue);
                    }
                    if (this.roundValue.compareTo(BigDecimal.ZERO) == 0) break;
                    this.print = String.valueOf(this.print) + String.format(formatRound, this.roundValue);
                    break;
                }
                case 3: {
                    if (fm.getReceiptTotal().compareTo(BigDecimal.ZERO) > 0) break;
                    fm.setFmState(4);
                    for (Map.Entry<Character, Turnover> vat : fm.getVats().entrySet()) {
                        if (vat.getValue().getLocalTotal().compareTo(BigDecimal.ZERO) == 0) continue;
                        if (fm.getParagon().getSaleType() != ParagonType.velkoobchod) {
                            fm.getFiscalLocalization().getMaloobchod(vat.getValue());
                            continue;
                        }
                        fm.getFiscalLocalization().getVelkoobchod(vat.getValue());
                    }
                    if (fm.getParagon().getRecapType() != 3) {
                        BigDecimal totalValue;
                        if (this.returnValue.compareTo(BigDecimal.ZERO) != 0) {
                            this.print = String.valueOf(this.print) + String.format(formatReturn, this.returnValue);
                        }
                        if (this.roundValue.compareTo(BigDecimal.ZERO) != 0) {
                            this.print = String.valueOf(this.print) + String.format(formatRound, this.roundValue);
                        }
                        this.print = String.valueOf(this.print) + Formatter.get().repeat('-', fm.getCharCount()) + "\n";
                        switch (fm.getParagon().getSaleType()) {
                            case velkoobchod: {
                                totalValue = fm.getReceiptTotalNoVat().setScale(2, RoundingMode.UNNECESSARY);
                                break;
                            }
                            default: {
                                totalValue = fm.getReceiptTotalWithVat().setScale(2, RoundingMode.UNNECESSARY);
                            }
                        }
                        this.print = String.valueOf(this.print) + String.format(formatTotal, totalValue);
                        break;
                    }
                    if (this.returnValue.compareTo(BigDecimal.ZERO) != 0) {
                        this.print = String.valueOf(this.print) + String.format(this.paymentMethod.isOverpay() ? formatReturn : formatNotReturn, this.returnValue);
                    }
                    if (this.roundValue.compareTo(BigDecimal.ZERO) == 0) break;
                    this.print = String.valueOf(this.print) + String.format(formatRound, this.roundValue);
                    break;
                }
                case 33: {
                    if (fm.getReceiptTotal().compareTo(BigDecimal.ZERO) > 0) break;
                    fm.setFmState(34);
                    if (fm.getParagon().getRecapType() != 3) {
                        if (this.returnValue.compareTo(BigDecimal.ZERO) != 0) {
                            this.print = String.valueOf(this.print) + String.format(formatReturn, this.returnValue);
                        }
                        if (this.roundValue.compareTo(BigDecimal.ZERO) != 0) {
                            this.print = String.valueOf(this.print) + String.format(formatRound, this.roundValue);
                        }
                        this.print = String.valueOf(this.print) + Formatter.get().repeat('-', fm.getCharCount()) + "\n";
                        BigDecimal totalValue = fm.getLocalInvoiceTurnover().setScale(2, RoundingMode.UNNECESSARY);
                        this.print = String.valueOf(this.print) + String.format(formatTotal, totalValue);
                        break;
                    }
                    if (this.returnValue.compareTo(BigDecimal.ZERO) != 0) {
                        this.print = String.valueOf(this.print) + String.format(this.paymentMethod.isOverpay() ? formatReturn : formatNotReturn, this.returnValue);
                    }
                    if (this.roundValue.compareTo(BigDecimal.ZERO) == 0) break;
                    this.print = String.valueOf(this.print) + String.format(formatRound, this.roundValue);
                }
            }
            if (this.exchangeRate.compareTo(BigDecimal.ZERO) != 0) {
                fm.getPaymentMethod(this.paymentID).appendExchangeLocalTurnover(this.payedValue);
            }
            fm.getPaymentMethod(16).appendLocalTurnover(this.returnValue.negate());
            fm.getPaymentMethod(this.paymentID).appendLocalTurnover(this.realPayedValue);
            fm.getPaymentMethod(this.paymentID).incLocalPaymentCounter();
            if (this.roundValue.compareTo(BigDecimal.ZERO) > 0) {
                fm.getNegativeLocalCounter().appendRoundValue(this.roundValue);
            }
            fm.getParagon().appendReceiptTotal(this.realPayedValue);
            fm.getParagon().appendReceiptTotal(this.returnValue.negate());
            fm.getParagon().addPayment(new PaymentModel.Builder().setRow(this.row).setPaymentId(this.paymentID).setTotal(this.total.toString()).setPayedAmount(this.realPayedValue.toString()).setExchangeRate(this.exchangeRate.toString()).setDescription(this.description).setPreline(fm.getPreline()).setPostline(fm.getPostline()).setPrintRepresentation(this.print).build());
            fm.getParagon().appendBinaryData(this.binary);
            fm.setPreline(null);
            fm.setPostline(null);
            fm.saveDbParagon();
            fm.setTransactionSuccesfull();
            fm.endTransaction();
            return status;
        }
        catch (FmStoreToDbException e) {
            fm.endTransaction();
            logger.fatal("Database error", (Throwable)e);
            Function.initFMDB(fm);
            return -2;
        }
    }

    private boolean isWhole(BigDecimal bigDecimal) {
        return bigDecimal.setScale(0, RoundingMode.HALF_UP).compareTo(bigDecimal) == 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected byte parseParams() {
        FmFiscalMemory fm = this.eKasa.getFm();
        PPEKK ppekk = this.eKasa.getPPEKK();
        switch (fm.getFmState()) {
            case 2: 
            case 3: 
            case 32: 
            case 33: 
            case 43: {
                break;
            }
            default: {
                return 52;
            }
        }
        if (this.params.length != 7) {
            return 32;
        }
        try {
            this.row = Integer.parseInt(this.params[0]);
            if (this.row < 0) return 96;
            if (this.row > 9) {
                return 96;
            }
            if (fm.isSafeMode() && fm.getActualRow() != this.row - 1) {
                return 67;
            }
            this.paymentID = Integer.parseInt(this.params[1]);
            if (this.paymentID < 1) return 96;
            if (this.paymentID > 8 && this.paymentID != 16) {
                return 96;
            }
            this.paymentMethod = fm.getPaymentMethod(this.paymentID);
            if (!Checkers.get().checkValueFormat(this.params[2], 7, 2)) {
                return 33;
            }
            this.total = new BigDecimal(this.params[2]);
            if (!Checkers.get().checkValueFormat(this.params[3], 7, 2)) {
                return 33;
            }
            this.payedValue = new BigDecimal(this.params[3]);
            try {
                if (!this.isWhole(this.payedValue.divide(fm.getPaymentMethod(this.paymentID).getMinCurrency()))) {
                    return -127;
                }
            }
            catch (Exception e) {
                return 38;
            }
            if (!Checkers.get().checkValueFormat(this.params[4], 2, 4)) {
                return 33;
            }
            try {
                this.exchangeRate = new BigDecimal(this.params[4]);
            }
            catch (NumberFormatException e) {
                return 39;
            }
            this.description = this.params[5];
            if (Printer.getPrintableLength((AbstractPrinter)ppekk.getPrinter(), (String)this.description, (boolean)false) > 10) {
                return 33;
            }
            if (Function.matches(this.description, ".*[\\x00-\\x19].*")) {
                return 40;
            }
            if (!Checkers.get().checkValueFormat(this.params[6], 7, 2)) {
                return 33;
            }
            this.payedValueZ = new BigDecimal(this.params[6]);
            return 0;
        }
        catch (NumberFormatException e) {
            return 96;
        }
    }
}

