/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.common.Function;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.data.ItemModel;
import sk.singularisdev.ekasask.fm.data.PaymentModel;
import sk.singularisdev.ekasask.fm.util.Hex;
import sk.singularisdev.ekasask.printer.AbstractPrinter;
import sk.singularisdev.ekasask.printer.Printer;

public class PrintAnnouncementNF
extends FmCommand {
    private static final Logger logger = LoggerManager.getLogger((String)PrintAnnouncementNF.class.getName());
    private int row;
    private String description;

    public PrintAnnouncementNF(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    @Override
    public byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        if (ppekk == null) {
            return -3;
        }
        try {
            if (fm.isDbOk()) {
                byte status = this.parseParams();
                if (status == 0) {
                    switch (fm.getFmState()) {
                        case 3: 
                        case 33: {
                            fm.getParagon().addPayment(new PaymentModel.Builder().setRow(this.row).setDescription(this.description).build());
                            break;
                        }
                        case 4: 
                        case 34: {
                            fm.getParagon().addItem(new ItemModel.Builder().setRow(this.row).setDescription(this.description).setItemType(ItemModel.ItemType.printAnnouncement).build());
                            break;
                        }
                        default: {
                            fm.getParagon().addItem(new ItemModel.Builder().setRow(this.row).setDescription(this.description).setItemType(ItemModel.ItemType.printAnnouncement).build());
                        }
                    }
                    fm.getParagon().appendBinaryData(this.binary);
                    fm.saveDbParagon();
                }
                return status;
            }
            return -2;
        }
        catch (FmStoreToDbException e) {
            logger.fatal("Database error", (Throwable)e);
            return -2;
        }
    }

    @Override
    protected byte parseParams() {
        block12: {
            PPEKK ppekk;
            FmFiscalMemory fm;
            block11: {
                block10: {
                    fm = this.eKasa.getFm();
                    ppekk = this.eKasa.getPPEKK();
                    switch (fm.getFmState()) {
                        case 2: 
                        case 3: 
                        case 4: 
                        case 10: 
                        case 20: 
                        case 32: 
                        case 33: 
                        case 34: {
                            break;
                        }
                        default: {
                            return 52;
                        }
                    }
                    if (this.params.length != 2) {
                        return 32;
                    }
                    try {
                        this.row = Integer.parseInt(this.params[0]);
                        if (this.row >= 0 && this.row <= 9) break block10;
                        return 96;
                    }
                    catch (NumberFormatException e) {
                        return 96;
                    }
                }
                if (!fm.isSafeMode() || fm.getActualRow() == this.row - 1) break block11;
                return 67;
            }
            this.description = this.params[1];
            if (Printer.getPrintableLength((AbstractPrinter)ppekk.getPrinter(), (String)this.description, (boolean)true) <= fm.getCharCount()) break block12;
            return 33;
        }
        if (Function.matches(this.description, ".*[\\x00-\\x19].*")) {
            return 96;
        }
        return 0;
    }
}

