/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import java.math.BigInteger;
import java.text.SimpleDateFormat;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.util.Hex;

public class PrintIssuedParagon
extends FmCommand {
    private static final Logger logger = LoggerManager.getLogger((String)PrintIssuedParagon.class.getName());
    private BigInteger issuedParagonNumber;
    private String issuedParagonDate;

    public PrintIssuedParagon(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    @Override
    protected byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        if (ppekk == null) {
            return -3;
        }
        try {
            if (fm.isDbOk()) {
                byte status = this.parseParams();
                if (status == 0) {
                    fm.getParagon().setIssuedParagonDate(this.issuedParagonDate);
                    fm.getParagon().setIssuedParagonNumber(this.issuedParagonNumber);
                    fm.getParagon().appendBinaryData(this.binary);
                    fm.saveDbParagon();
                }
                return status;
            }
            return -2;
        }
        catch (FmStoreToDbException e) {
            logger.fatal("Database error", (Throwable)e);
            return -2;
        }
    }

    @Override
    protected byte parseParams() {
        block12: {
            block11: {
                block10: {
                    FmFiscalMemory fm = this.eKasa.getFm();
                    switch (fm.getFmState()) {
                        case 2: 
                        case 3: 
                        case 4: 
                        case 32: 
                        case 33: 
                        case 34: {
                            break;
                        }
                        default: {
                            return 52;
                        }
                    }
                    try {
                        if (this.params.length == 2) break block10;
                        return 32;
                    }
                    catch (NumberFormatException e) {
                        return 96;
                    }
                }
                this.issuedParagonNumber = new BigInteger(this.params[0]);
                if (this.issuedParagonNumber.compareTo(new BigInteger("1")) >= 0 && this.issuedParagonNumber.compareTo(new BigInteger("4294967295")) <= 0) break block11;
                return 96;
            }
            this.issuedParagonDate = this.params[1];
            if (this.issuedParagonDate.length() == 14) break block12;
            return 33;
        }
        try {
            new SimpleDateFormat("ddMMyyyykkmmss").parse(this.issuedParagonDate);
        }
        catch (Exception e) {
            return 96;
        }
        return 0;
    }
}

