/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.command.AbstractCommand;
import sk.singularisdev.ekasask.command.InternalDocument;
import sk.singularisdev.ekasask.command.ItemPrintBinary;
import sk.singularisdev.ekasask.command.MessageItemInterfaceParagon;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.db.enums.DB;
import sk.singularisdev.ekasask.fm.util.Hex;

public class PrintJournalStructU
extends FmCommand {
    private static final Logger logger = LoggerManager.getLogger((String)PrintJournalStructU.class.getName());
    private String receiptId;
    private DB type;

    public PrintJournalStructU(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        if (ppekk == null) {
            return -3;
        }
        try {
            if (!fm.isDbOk()) return -2;
            byte status = this.parseParams();
            try {
                byte[] print = fm.getJournalParagon(this.type, this.receiptId, null, null);
                if (print == null) return 4;
                if (print.length == 0) {
                    return 4;
                }
                InternalDocument document = InternalDocument.getInstance();
                document.addItem((MessageItemInterfaceParagon)ItemPrintBinary.getInstance((byte[])print));
                ppekk.process((AbstractCommand)document);
                return status;
            }
            catch (EKasaException e) {
                fm.setLastPPEKKError(e.getErrorCode());
                return -3;
            }
            catch (NumberFormatException e) {
                return 96;
            }
        }
        catch (FmStoreToDbException e) {
            if (e.getMessage().equals("java.sql.SQLException: No data")) {
                return 4;
            }
            logger.fatal("Database error", (Throwable)e);
            return -2;
        }
    }

    @Override
    protected byte parseParams() {
        FmFiscalMemory fm = this.eKasa.getFm();
        switch (fm.getFmState()) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                return 52;
            }
        }
        if (this.params.length != 1) {
            return 32;
        }
        this.receiptId = this.params[0];
        switch (this.receiptId.length()) {
            case 44: {
                this.type = DB.okp;
                break;
            }
            case 34: {
                this.type = DB.uid;
                break;
            }
            case 11: {
                this.type = DB.pcd;
                break;
            }
            case 10: {
                this.type = DB.oldPcd;
            }
        }
        return 0;
    }
}

