/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.command.AbstractCommand;
import sk.singularisdev.ekasask.command.setup.Setup;
import sk.singularisdev.ekasask.command.setup.SetupItemInterface;
import sk.singularisdev.ekasask.command.setup.SetupItemVat;
import sk.singularisdev.ekasask.enumeration.VAT_LEVEL;
import sk.singularisdev.ekasask.enumeration.VAT_TYPE;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.util.Hex;

public class SetAllVATs
extends FmCommand {
    private static final Logger logger = LoggerManager.getLogger((String)SetAllVATs.class.getName());
    private int vatA;
    private int vatB;
    private int vatC;
    private int vatD;
    private int vatE;
    private VAT_TYPE vatLevelIdA;
    private VAT_TYPE vatLevelIdB;
    private VAT_TYPE vatLevelIdC;
    private VAT_TYPE vatLevelIdD;
    private VAT_TYPE vatLevelIdE;
    private String password;
    private boolean canceledA = false;
    private boolean canceledB = false;
    private boolean canceledC = false;
    private boolean canceledD = false;
    private boolean canceledE = false;

    public SetAllVATs(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    @Override
    protected byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        block16: {
            byte status;
            block17: {
                if (ppekk == null) {
                    return -3;
                }
                try {
                    if (!fm.isDbOk()) break block16;
                    status = this.parseParams();
                    if (status != 0) break block17;
                    try {
                        SetupItemVat setupItemVat;
                        Setup setup = Setup.getInstance();
                        if (this.canceledA) {
                            fm.getVat('A').setVat(null);
                            fm.getVat('A').setVatType(null);
                            setupItemVat = SetupItemVat.getInstance((VAT_LEVEL)VAT_LEVEL.A);
                            setupItemVat.setVatType(VAT_TYPE.FREE);
                            setupItemVat.setVat(null);
                            setup.addItem((SetupItemInterface)setupItemVat);
                        } else {
                            fm.getVat('A').setVat(this.vatA);
                            fm.getVat('A').setVatType(this.vatLevelIdA);
                            setupItemVat = SetupItemVat.getInstance((VAT_LEVEL)VAT_LEVEL.A);
                            setupItemVat.setVatType(this.vatLevelIdA);
                            setupItemVat.setVat(Integer.valueOf(this.vatA));
                            setup.addItem((SetupItemInterface)setupItemVat);
                        }
                        if (this.canceledB) {
                            fm.getVat('B').setVat(null);
                            fm.getVat('B').setVatType(null);
                            setupItemVat = SetupItemVat.getInstance((VAT_LEVEL)VAT_LEVEL.B);
                            setupItemVat.setVatType(VAT_TYPE.FREE);
                            setupItemVat.setVat(null);
                            setup.addItem((SetupItemInterface)setupItemVat);
                        } else {
                            fm.getVat('B').setVat(this.vatB);
                            fm.getVat('B').setVatType(this.vatLevelIdB);
                            setupItemVat = SetupItemVat.getInstance((VAT_LEVEL)VAT_LEVEL.B);
                            setupItemVat.setVatType(this.vatLevelIdB);
                            setupItemVat.setVat(Integer.valueOf(this.vatB));
                            setup.addItem((SetupItemInterface)setupItemVat);
                        }
                        if (this.canceledC) {
                            fm.getVat('C').setVat(null);
                            fm.getVat('C').setVatType(null);
                            setupItemVat = SetupItemVat.getInstance((VAT_LEVEL)VAT_LEVEL.C);
                            setupItemVat.setVatType(VAT_TYPE.FREE);
                            setupItemVat.setVat(null);
                            setup.addItem((SetupItemInterface)setupItemVat);
                        } else {
                            fm.getVat('C').setVat(this.vatC);
                            fm.getVat('C').setVatType(this.vatLevelIdC);
                            setupItemVat = SetupItemVat.getInstance((VAT_LEVEL)VAT_LEVEL.C);
                            setupItemVat.setVatType(this.vatLevelIdC);
                            setupItemVat.setVat(Integer.valueOf(this.vatC));
                            setup.addItem((SetupItemInterface)setupItemVat);
                        }
                        if (this.canceledD) {
                            fm.getVat('D').setVat(null);
                            fm.getVat('D').setVatType(null);
                            setupItemVat = SetupItemVat.getInstance((VAT_LEVEL)VAT_LEVEL.D);
                            setupItemVat.setVatType(VAT_TYPE.FREE);
                            setupItemVat.setVat(null);
                            setup.addItem((SetupItemInterface)setupItemVat);
                        } else {
                            fm.getVat('D').setVat(this.vatD);
                            fm.getVat('D').setVatType(this.vatLevelIdD);
                            setupItemVat = SetupItemVat.getInstance((VAT_LEVEL)VAT_LEVEL.D);
                            setupItemVat.setVatType(this.vatLevelIdD);
                            setupItemVat.setVat(Integer.valueOf(this.vatD));
                            setup.addItem((SetupItemInterface)setupItemVat);
                        }
                        if (this.canceledE) {
                            fm.getVat('E').setVat(null);
                            fm.getVat('E').setVatType(null);
                            setupItemVat = SetupItemVat.getInstance((VAT_LEVEL)VAT_LEVEL.E);
                            setupItemVat.setVatType(VAT_TYPE.FREE);
                            setupItemVat.setVat(null);
                            setup.addItem((SetupItemInterface)setupItemVat);
                        } else {
                            fm.getVat('E').setVat(this.vatE);
                            fm.getVat('E').setVatType(this.vatLevelIdE);
                            setupItemVat = SetupItemVat.getInstance((VAT_LEVEL)VAT_LEVEL.E);
                            setupItemVat.setVatType(this.vatLevelIdE);
                            setupItemVat.setVat(Integer.valueOf(this.vatE));
                            setup.addItem((SetupItemInterface)setupItemVat);
                        }
                        ppekk.process((AbstractCommand)setup);
                    }
                    catch (EKasaException e) {
                        fm.setLastPPEKKError(e.getErrorCode());
                        return -3;
                    }
                }
                catch (FmStoreToDbException e) {
                    logger.fatal("Database error", (Throwable)e);
                    return -2;
                }
            }
            return status;
        }
        return -2;
    }

    private VAT_TYPE getVatType(int levelid) throws Exception {
        switch (levelid) {
            case 1: {
                return VAT_TYPE.BASED;
            }
            case 2: {
                return VAT_TYPE.REDUCED;
            }
            case 3: {
                return VAT_TYPE.FREE;
            }
        }
        throw new Exception();
    }

    @Override
    protected byte parseParams() {
        int levelid;
        block39: {
            block38: {
                block37: {
                    block36: {
                        block35: {
                            block34: {
                                block33: {
                                    block32: {
                                        block31: {
                                            block30: {
                                                block29: {
                                                    FmFiscalMemory fm;
                                                    block28: {
                                                        fm = this.eKasa.getFm();
                                                        switch (fm.getFmState()) {
                                                            case 0: 
                                                            case 1: {
                                                                break;
                                                            }
                                                            default: {
                                                                return 52;
                                                            }
                                                        }
                                                        if (this.params.length != 11) {
                                                            return 32;
                                                        }
                                                        try {
                                                            this.password = this.params[0];
                                                            if (this.password.length() >= 6 && this.password.length() <= 8) break block28;
                                                            return 96;
                                                        }
                                                        catch (NumberFormatException e) {
                                                            return 96;
                                                        }
                                                    }
                                                    if (Formatter.get().getMD5Format(this.password).equals(fm.getPassword())) break block29;
                                                    return 96;
                                                }
                                                this.vatA = Integer.parseInt(this.params[1]);
                                                if (this.vatA >= 0 && this.vatA <= 99) break block30;
                                                return 96;
                                            }
                                            this.vatB = Integer.parseInt(this.params[3]);
                                            if (this.vatB >= 0 && this.vatB <= 99) break block31;
                                            return 96;
                                        }
                                        this.vatC = Integer.parseInt(this.params[5]);
                                        if (this.vatC >= 0 && this.vatC <= 99) break block32;
                                        return 96;
                                    }
                                    this.vatD = Integer.parseInt(this.params[7]);
                                    if (this.vatD >= 0 && this.vatD <= 99) break block33;
                                    return 96;
                                }
                                this.vatE = Integer.parseInt(this.params[9]);
                                if (this.vatE >= 0 && this.vatE <= 99) break block34;
                                return 96;
                            }
                            levelid = Integer.parseInt(this.params[2]);
                            if (levelid >= 0 && levelid <= 3) break block35;
                            return 96;
                        }
                        try {
                            this.vatLevelIdA = this.getVatType(levelid);
                        }
                        catch (Exception e) {
                            this.canceledA = true;
                        }
                        levelid = Integer.parseInt(this.params[4]);
                        if (levelid >= 0 && levelid <= 3) break block36;
                        return 96;
                    }
                    try {
                        this.vatLevelIdB = this.getVatType(levelid);
                    }
                    catch (Exception e) {
                        this.canceledB = true;
                    }
                    levelid = Integer.parseInt(this.params[6]);
                    if (levelid >= 0 && levelid <= 3) break block37;
                    return 96;
                }
                try {
                    this.vatLevelIdC = this.getVatType(levelid);
                }
                catch (Exception e) {
                    this.canceledC = true;
                }
                levelid = Integer.parseInt(this.params[8]);
                if (levelid >= 0 && levelid <= 3) break block38;
                return 96;
            }
            try {
                this.vatLevelIdD = this.getVatType(levelid);
            }
            catch (Exception e) {
                this.canceledD = true;
            }
            levelid = Integer.parseInt(this.params[10]);
            if (levelid >= 0 && levelid <= 3) break block39;
            return 96;
        }
        try {
            this.vatLevelIdE = this.getVatType(levelid);
        }
        catch (Exception e) {
            this.canceledE = true;
        }
        return 0;
    }
}

