/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.enumeration.BARCODE_FONT_SIZE;
import sk.singularisdev.ekasask.enumeration.BARCODE_TEXT_POSITION;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.util.Hex;

public class SetBCParm
extends FmCommand {
    private static final Logger logger = LoggerManager.getLogger((String)SetBCParm.class.getName());
    private int textPosition;
    private int textFont;
    private int barcodeH;
    private int barcodeW;

    public SetBCParm(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    @Override
    public byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        try {
            if (fm.isDbOk()) {
                byte status = this.parseParams();
                if (status == 0) {
                    switch (this.textPosition) {
                        case 0: {
                            fm.setTextPos(BARCODE_TEXT_POSITION.NONE);
                            break;
                        }
                        case 1: {
                            fm.setTextPos(BARCODE_TEXT_POSITION.ABOVE);
                            break;
                        }
                        case 2: {
                            fm.setTextPos(BARCODE_TEXT_POSITION.BELOW);
                            break;
                        }
                        case 3: {
                            fm.setTextPos(BARCODE_TEXT_POSITION.BOTH);
                        }
                    }
                    switch (this.textFont) {
                        case 0: {
                            fm.setTextFont(BARCODE_FONT_SIZE.LARGE);
                            break;
                        }
                        case 1: {
                            fm.setTextFont(BARCODE_FONT_SIZE.SMALL);
                        }
                    }
                    fm.setBarcodeW(this.barcodeW);
                    fm.setBarcodeH(this.barcodeH);
                }
                return status;
            }
            return -2;
        }
        catch (FmStoreToDbException e) {
            logger.fatal("Database error", (Throwable)e);
            return -2;
        }
    }

    @Override
    protected byte parseParams() {
        block12: {
            block11: {
                block10: {
                    FmFiscalMemory fm = this.eKasa.getFm();
                    switch (fm.getFmState()) {
                        case 0: 
                        case 1: {
                            break;
                        }
                        default: {
                            return 52;
                        }
                    }
                    if (this.params.length != 4) {
                        return 32;
                    }
                    try {
                        this.textPosition = Integer.parseInt(this.params[0]);
                        if (this.textPosition >= 0 && this.textPosition <= 3) break block10;
                        return 96;
                    }
                    catch (NumberFormatException e) {
                        return 96;
                    }
                }
                this.textFont = Integer.parseInt(this.params[1]);
                if (this.textFont >= 0 && this.textFont <= 1) break block11;
                return 96;
            }
            this.barcodeH = Integer.parseInt(this.params[2]);
            if (this.barcodeH >= 1 && this.barcodeH <= 255) break block12;
            return 96;
        }
        this.barcodeW = Integer.parseInt(this.params[3]);
        if (this.barcodeW < 2 || this.barcodeW > 6) {
            return 96;
        }
        return 0;
    }
}

