/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import java.math.BigDecimal;
import java.util.Date;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.command.AbstractCommand;
import sk.singularisdev.ekasask.command.Location;
import sk.singularisdev.ekasask.fm.Checkers;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.common.Function;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.enums.SFSError;
import sk.singularisdev.ekasask.fm.util.Hex;
import sk.singularisdev.ekasask.sfs.EKasaResponseException;

public class SetLocation
extends FmCommand {
    private static final Logger logger = LoggerManager.getLogger((String)SetLocation.class.getName());
    private BigDecimal gpsX;
    private BigDecimal gpsY;
    private int type;
    private String city;
    private String street;
    private String orientationNumber;
    private String description;
    private String registerNumber;
    private String zipCode;

    public SetLocation(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    @Override
    protected byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        block12: {
            byte status;
            block13: {
                if (ppekk == null) {
                    return -3;
                }
                try {
                    if (!fm.isDbOk()) break block12;
                    status = this.parseParams();
                    Location location = Location.getInstance();
                    location.setCreateDate(new Date());
                    if (status != 0) break block13;
                    switch (this.type) {
                        case 0: {
                            location.setGps(this.gpsX.toString(), this.gpsY.toString());
                            break;
                        }
                        case 1: {
                            location.setAddress(this.street, this.orientationNumber, this.registerNumber, this.city, this.zipCode);
                            break;
                        }
                        case 2: {
                            location.setOther(this.description);
                        }
                    }
                    try {
                        ppekk.process((AbstractCommand)location);
                    }
                    catch (EKasaResponseException e) {
                        fm.setLastSFSError(e.getResponseCode());
                        fm.setLastPPEKKError(e.getErrorCode());
                        e.printStackTrace();
                        return SFSError.fromSFSCode(e.getResponseCode()).getInternalFmInternalCode();
                    }
                    catch (EKasaException e) {
                        fm.setLastPPEKKError(e.getErrorCode());
                        e.printStackTrace();
                        return -3;
                    }
                }
                catch (FmStoreToDbException e) {
                    logger.fatal("Database error", (Throwable)e);
                    return -2;
                }
            }
            return status;
        }
        return -2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected byte parseParams() {
        FmFiscalMemory fm = this.eKasa.getFm();
        switch (fm.getFmState()) {
            case 0: 
            case 1: 
            case 105: {
                break;
            }
            default: {
                return 52;
            }
        }
        try {
            this.type = Integer.parseInt(this.params[0]);
            switch (this.type) {
                case 0: {
                    if (this.params.length > 6) {
                        return 32;
                    }
                    this.gpsX = new BigDecimal(this.params[1]);
                    if (this.params[1].length() > 20) {
                        return 33;
                    }
                    if (!Checkers.get().checkValueFormat(this.params[1], 10, 10)) {
                        return 33;
                    }
                    this.gpsY = new BigDecimal(this.params[2]);
                    if (this.params[2].length() > 20) {
                        return 33;
                    }
                    if (Checkers.get().checkValueFormat(this.params[2], 10, 10)) break;
                    return 33;
                }
                case 1: {
                    if (this.params.length > 6) {
                        return 32;
                    }
                    this.city = this.params[1];
                    if (this.city.length() < 1) return 33;
                    if (this.city.length() > 100) {
                        return 33;
                    }
                    if (Function.matches(this.city, ".*[\\x00-\\x19].*")) {
                        return 96;
                    }
                    this.street = this.params[2];
                    if (this.street.length() < 1) return 33;
                    if (this.street.length() > 100) {
                        return 33;
                    }
                    if (Function.matches(this.street, ".*[\\x00-\\x19].*")) {
                        return 96;
                    }
                    if (Integer.parseInt(this.params[3]) < 1) {
                        return 33;
                    }
                    this.registerNumber = this.params[3];
                    if (this.params[3].length() < 1) return 33;
                    if (this.params[3].length() > 10) {
                        return 33;
                    }
                    this.orientationNumber = this.params[4];
                    if (this.orientationNumber.length() < 1) return 33;
                    if (this.orientationNumber.length() > 20) {
                        return 33;
                    }
                    if (Function.matches(this.orientationNumber, ".*[\\x00-\\x19].*")) {
                        return 96;
                    }
                    Integer.parseInt(this.params[5]);
                    this.zipCode = this.params[5];
                    if (this.params[5].length() == 5) break;
                    return 33;
                }
                case 2: {
                    if (this.params.length > 6) {
                        return 32;
                    }
                    this.description = this.params[1];
                    if (this.description.length() < 1) return 33;
                    if (this.description.length() > 255) {
                        return 33;
                    }
                    if (!Function.matches(this.description, ".*[\\x00-\\x19].*")) break;
                    return 96;
                }
            }
            if (Formatter.get().isOSTimeZoneCorrect()) return 0;
            return SFSError.SFS_ERROR_TIME_ZONE.getInternalFmInternalCode();
        }
        catch (NumberFormatException e) {
            return 96;
        }
    }
}

