/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import java.math.BigDecimal;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.fm.Checkers;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.data.PaymentMethod;
import sk.singularisdev.ekasask.fm.util.Hex;

public class SetPaymentType
extends FmCommand {
    private static final Logger logger = LoggerManager.getLogger((String)SetPaymentType.class.getName());
    private boolean overpay;
    private int paymentId;
    private BigDecimal minCoin;

    public SetPaymentType(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    @Override
    protected byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        if (ppekk == null) {
            return -3;
        }
        try {
            if (fm.isDbOk()) {
                byte status = this.parseParams();
                if (status == 0) {
                    PaymentMethod paymentMethod = fm.getPaymentMethod(this.paymentId);
                    paymentMethod.setMinCurrency(this.minCoin);
                    paymentMethod.setOverpay(this.overpay);
                }
                return status;
            }
            return -2;
        }
        catch (FmStoreToDbException e) {
            logger.fatal("Database error", (Throwable)e);
            return -2;
        }
    }

    @Override
    protected byte parseParams() {
        int overpay;
        block11: {
            block10: {
                block9: {
                    FmFiscalMemory fm = this.eKasa.getFm();
                    switch (fm.getFmState()) {
                        case 0: 
                        case 1: {
                            break;
                        }
                        default: {
                            return 52;
                        }
                    }
                    if (this.params.length != 3) {
                        return 32;
                    }
                    try {
                        this.paymentId = Integer.parseInt(this.params[0]);
                        if (this.paymentId >= 1 && this.paymentId <= 8 || this.paymentId == 16) break block9;
                        return 96;
                    }
                    catch (NumberFormatException e) {
                        return 96;
                    }
                }
                if (Checkers.get().checkValueFormat(this.params[1], 4, 2)) break block10;
                return 33;
            }
            this.minCoin = new BigDecimal(this.params[1]);
            overpay = Integer.parseInt(this.params[2]);
            if (overpay >= 0 && overpay <= 1) break block11;
            return 33;
        }
        this.overpay = overpay == 0;
        return 0;
    }
}

