/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.util.Hex;

public class SetQRParm
extends FmCommand {
    private static final Logger logger = LoggerManager.getLogger((String)SetQRParm.class.getName());
    private int model;
    private int moduleWidth;
    private int errorCorrectionLevel;
    private int leftMargin;
    private int viewMode;

    public SetQRParm(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    @Override
    public byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        try {
            if (fm.isDbOk()) {
                byte status = this.parseParams();
                if (status == 0) {
                    fm.setModel(this.model);
                    fm.setModuleWidth(this.moduleWidth);
                    fm.setErrorCorrectionLevel(this.errorCorrectionLevel);
                    fm.setLeftMargin(this.leftMargin);
                    fm.setViewMode(this.viewMode);
                }
                return status;
            }
            return -2;
        }
        catch (FmStoreToDbException e) {
            logger.fatal("Database error", (Throwable)e);
            return -2;
        }
    }

    @Override
    protected byte parseParams() {
        block14: {
            block13: {
                block12: {
                    block11: {
                        FmFiscalMemory fm = this.eKasa.getFm();
                        switch (fm.getFmState()) {
                            case 0: 
                            case 1: {
                                break;
                            }
                            default: {
                                return 52;
                            }
                        }
                        if (this.params.length != 5) {
                            return 32;
                        }
                        try {
                            this.model = Integer.parseInt(this.params[0]);
                            if (this.model >= 49 && this.model <= 50) break block11;
                            return 96;
                        }
                        catch (NumberFormatException e) {
                            return 96;
                        }
                    }
                    this.moduleWidth = Integer.parseInt(this.params[1]);
                    if (this.moduleWidth >= 0 && this.moduleWidth <= 16) break block12;
                    return 96;
                }
                this.errorCorrectionLevel = Integer.parseInt(this.params[2]);
                if (this.errorCorrectionLevel >= 48 && this.errorCorrectionLevel <= 51) break block13;
                return 96;
            }
            this.leftMargin = Integer.parseInt(this.params[3]);
            if (this.leftMargin >= 0 && this.leftMargin <= 999) break block14;
            return 96;
        }
        this.viewMode = Integer.parseInt(this.params[4]);
        if (this.viewMode < 0 || this.viewMode > 3) {
            return 96;
        }
        return 0;
    }
}

