/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.command.AbstractCommand;
import sk.singularisdev.ekasask.command.setup.Setup;
import sk.singularisdev.ekasask.command.setup.SetupItemException48;
import sk.singularisdev.ekasask.command.setup.SetupItemInterface;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.enums.SFSError;
import sk.singularisdev.ekasask.fm.util.Hex;
import sk.singularisdev.ekasask.sfs.EKasaResponseException;

public class SetV48
extends FmCommand {
    private static final Logger logger = LoggerManager.getLogger((String)SetV48.class.getName());
    private String password;
    private int exception48;

    public SetV48(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    @Override
    protected byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        block7: {
            byte status;
            block8: {
                if (ppekk == null) {
                    return -3;
                }
                try {
                    if (!fm.isDbOk()) break block7;
                    status = this.parseParams();
                    if (status != 0) break block8;
                    try {
                        fm.setVynimka48hodin(this.exception48 == 1);
                        Setup setup = Setup.getInstance();
                        SetupItemException48 exc48 = SetupItemException48.getInstance();
                        exc48.setException48(this.exception48 == 1);
                        setup.addItem((SetupItemInterface)exc48);
                        ppekk.process((AbstractCommand)setup);
                    }
                    catch (EKasaResponseException e) {
                        fm.setLastSFSError(e.getResponseCode());
                        fm.setLastPPEKKError(e.getErrorCode());
                        return SFSError.fromSFSCode(e.getResponseCode()).getInternalFmInternalCode();
                    }
                    catch (EKasaException e) {
                        fm.setLastPPEKKError(e.getErrorCode());
                        return -3;
                    }
                }
                catch (FmStoreToDbException e) {
                    logger.fatal("Database error", (Throwable)e);
                    return -2;
                }
            }
            return status;
        }
        return -2;
    }

    @Override
    protected byte parseParams() {
        block10: {
            block9: {
                FmFiscalMemory fm = this.eKasa.getFm();
                switch (fm.getFmState()) {
                    case 0: 
                    case 1: {
                        break;
                    }
                    default: {
                        return 52;
                    }
                }
                if (this.params.length != 2) {
                    return 32;
                }
                try {
                    this.password = this.params[0];
                    if (Formatter.get().getMD5Format(this.password).equals(fm.getPassword())) break block9;
                    return 49;
                }
                catch (NumberFormatException e) {
                    return 96;
                }
            }
            if (this.password.length() >= 6 && this.password.length() <= 8) break block10;
            return 96;
        }
        this.exception48 = Integer.parseInt(this.params[1]);
        if (this.exception48 < 0 || this.exception48 > 1) {
            return 96;
        }
        return 0;
    }
}

