/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import java.util.Map;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.command.AbstractCommand;
import sk.singularisdev.ekasask.command.setup.Setup;
import sk.singularisdev.ekasask.command.setup.SetupItemInterface;
import sk.singularisdev.ekasask.command.setup.SetupItemVat;
import sk.singularisdev.ekasask.enumeration.VAT_LEVEL;
import sk.singularisdev.ekasask.enumeration.VAT_TYPE;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.data.Turnover;
import sk.singularisdev.ekasask.fm.util.Hex;

public class SetVAT
extends FmCommand {
    private static final Logger logger = LoggerManager.getLogger((String)SetVAT.class.getName());
    private int vat;
    private VAT_TYPE vatLevelId;
    private char vatLevel;
    private String password;
    private boolean canceled = false;

    public SetVAT(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        if (ppekk == null) {
            return -3;
        }
        try {
            if (!fm.isDbOk()) return -2;
            byte status = this.parseParams();
            if (status != 0) return status;
            try {
                if (!this.canceled && !this.canSetVat(fm)) {
                    return 96;
                }
                Setup setup = Setup.getInstance();
                if (this.canceled) {
                    fm.getVat(this.vatLevel).setVat(null);
                    fm.getVat(this.vatLevel).setVatType(null);
                    SetupItemVat setupItemVat = SetupItemVat.getInstance((VAT_LEVEL)this.transformVATLevel(this.vatLevel));
                    setupItemVat.setVatType(VAT_TYPE.FREE);
                    setupItemVat.setVat(null);
                    setup.addItem((SetupItemInterface)setupItemVat);
                } else {
                    fm.getVat(this.vatLevel).setVat(this.vat);
                    fm.getVat(this.vatLevel).setVatType(this.vatLevelId);
                    SetupItemVat setupItemVat = SetupItemVat.getInstance((VAT_LEVEL)this.transformVATLevel(this.vatLevel));
                    setupItemVat.setVatType(this.vatLevelId);
                    setupItemVat.setVat(Integer.valueOf(this.vat));
                    setup.addItem((SetupItemInterface)setupItemVat);
                }
                ppekk.process((AbstractCommand)setup);
                return status;
            }
            catch (EKasaException e) {
                fm.setLastPPEKKError(e.getErrorCode());
                return -3;
            }
        }
        catch (FmStoreToDbException e) {
            logger.fatal("Database error", (Throwable)e);
            return -2;
        }
    }

    private boolean canSetVat(FmFiscalMemory fm) {
        switch (this.vatLevelId) {
            case BASED: {
                for (Map.Entry<Character, Turnover> vat : fm.getVats().entrySet()) {
                    Integer basedValue;
                    if (vat.getValue().getVatType() != VAT_TYPE.BASED || (basedValue = vat.getValue().getVat()) == null || basedValue == this.vat) continue;
                    return false;
                }
                break;
            }
            case REDUCED: {
                for (Map.Entry<Character, Turnover> vat : fm.getVats().entrySet()) {
                    Integer reducedValue;
                    if (vat.getValue().getVatType() != VAT_TYPE.REDUCED || (reducedValue = vat.getValue().getVat()) == null || reducedValue == this.vat) continue;
                    return false;
                }
                break;
            }
            case FREE: {
                if (this.vat == 0) break;
                return false;
            }
        }
        return true;
    }

    private VAT_LEVEL transformVATLevel(char vatLevel) {
        switch (vatLevel) {
            case 'A': {
                return VAT_LEVEL.A;
            }
            case 'B': {
                return VAT_LEVEL.B;
            }
            case 'C': {
                return VAT_LEVEL.C;
            }
            case 'D': {
                return VAT_LEVEL.D;
            }
            case 'E': {
                return VAT_LEVEL.E;
            }
        }
        return VAT_LEVEL.A;
    }

    @Override
    protected byte parseParams() {
        int levelid;
        block23: {
            block22: {
                block21: {
                    block20: {
                        block19: {
                            FmFiscalMemory fm;
                            block18: {
                                fm = this.eKasa.getFm();
                                switch (fm.getFmState()) {
                                    case 0: 
                                    case 1: {
                                        break;
                                    }
                                    default: {
                                        return 52;
                                    }
                                }
                                if (this.params.length != 4) {
                                    return 32;
                                }
                                try {
                                    this.password = this.params[0];
                                    if (this.password.length() >= 6 && this.password.length() <= 8) break block18;
                                    return 96;
                                }
                                catch (NumberFormatException e) {
                                    return 96;
                                }
                            }
                            if (Formatter.get().getMD5Format(this.password).equals(fm.getPassword())) break block19;
                            return 96;
                        }
                        if (this.params[1].length() == 1) break block20;
                        return 96;
                    }
                    this.vatLevel = this.params[1].charAt(0);
                    if (this.vatLevel >= 'A' && this.vatLevel <= 'E') break block21;
                    return 96;
                }
                this.vat = Integer.parseInt(this.params[2]);
                if (this.vat >= 0 && this.vat <= 99) break block22;
                return 96;
            }
            levelid = Integer.parseInt(this.params[3]);
            if (levelid >= 0 && levelid <= 3) break block23;
            return 96;
        }
        switch (levelid) {
            case 0: {
                this.canceled = true;
                break;
            }
            case 1: {
                this.canceled = false;
                this.vatLevelId = VAT_TYPE.BASED;
                break;
            }
            case 2: {
                this.canceled = false;
                this.vatLevelId = VAT_TYPE.REDUCED;
                break;
            }
            case 3: {
                this.canceled = false;
                this.vatLevelId = VAT_TYPE.FREE;
            }
        }
        return 0;
    }
}

