/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import java.math.BigDecimal;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.fm.Checkers;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.common.Function;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.data.ItemModel;
import sk.singularisdev.ekasask.fm.util.Hex;
import sk.singularisdev.ekasask.printer.AbstractPrinter;
import sk.singularisdev.ekasask.printer.Printer;

public class SubTotalDiscount2
extends FmCommand {
    private static final Logger logger = LoggerManager.getLogger((String)SubTotalDiscount2.class.getName());
    private int row;
    private String description;
    private BigDecimal discountValue;
    private BigDecimal referencedValue;
    private BigDecimal discountValueZ;
    private int operationType;
    private Character vat;

    public SubTotalDiscount2(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        if (ppekk == null) {
            return -3;
        }
        try {
            if (!fm.isDbOk()) {
                return -2;
            }
            byte status = this.parseParams();
            if (status == 0) {
                fm.beginTransaction();
                this.referencedValue = fm.isVatPayer() ? fm.getVat(this.vat.charValue()).getLocalTotal() : fm.getReceiptTotalWithVat();
                switch (this.operationType) {
                    case 0: {
                        if (this.referencedValue.compareTo(this.discountValueZ) < 0) {
                            return 96;
                        }
                        fm.getVat(this.vat.charValue()).appendLocalTotal(this.discountValueZ.negate());
                        fm.appendReceiptTotal(this.discountValueZ.negate());
                        fm.getDcsrLocalValueCounter().appendDiscountSubtotal(this.discountValueZ);
                        break;
                    }
                    case 1: {
                        fm.getVat(this.vat.charValue()).appendLocalTotal(this.discountValueZ);
                        fm.appendReceiptTotal(this.discountValueZ);
                        fm.getDcsrLocalValueCounter().appendSurchargeSubtotal(this.discountValueZ);
                        break;
                    }
                    case 2: {
                        if (this.referencedValue.compareTo(this.discountValueZ) < 0) {
                            return 96;
                        }
                        fm.getVat(this.vat.charValue()).appendLocalTotal(this.discountValueZ.negate());
                        fm.appendReceiptTotal(this.discountValueZ.negate());
                        fm.getDcsrLocalPercentageCounter().appendDiscountSubtotal(this.discountValueZ);
                        break;
                    }
                    case 3: {
                        fm.getVat(this.vat.charValue()).appendLocalTotal(this.discountValueZ);
                        fm.appendReceiptTotal(this.discountValueZ);
                        fm.getDcsrLocalPercentageCounter().appendSurchargeSubtotal(this.discountValueZ);
                        break;
                    }
                }
                fm.getParagon().addItem(new ItemModel.Builder().setRow(this.row).setDescription(this.description).setDiscountType(this.operationType).setDiscountValue(this.discountValue.toString()).setDiscountRealValue(this.discountValueZ.toString()).setVat(this.vat.charValue()).setItemType(ItemModel.ItemType.subTotalDiscount2).build());
                fm.getParagon().appendBinaryData(this.binary);
                fm.saveDbParagon();
                fm.setTransactionSuccesfull();
                fm.endTransaction();
            }
            return status;
        }
        catch (FmStoreToDbException e) {
            fm.endTransaction();
            logger.fatal("Database error", (Throwable)e);
            Function.initFMDB(fm);
            return -2;
        }
    }

    @Override
    protected byte parseParams() {
        block30: {
            block29: {
                block28: {
                    FmFiscalMemory fm;
                    block27: {
                        block26: {
                            block25: {
                                block24: {
                                    block23: {
                                        PPEKK ppekk;
                                        block22: {
                                            block21: {
                                                block20: {
                                                    fm = this.eKasa.getFm();
                                                    ppekk = this.eKasa.getPPEKK();
                                                    if (fm.getFmState() != 2) {
                                                        return 52;
                                                    }
                                                    if (this.params.length != 6) {
                                                        return 32;
                                                    }
                                                    this.row = Integer.parseInt(this.params[0]);
                                                    if (this.row >= 0 && this.row <= 9) break block20;
                                                    return 96;
                                                }
                                                if (!fm.isSafeMode() || fm.getActualRow() == this.row - 1) break block21;
                                                return 67;
                                            }
                                            this.description = this.params[1];
                                            if (Printer.getPrintableLength((AbstractPrinter)ppekk.getPrinter(), (String)this.description, (boolean)false) <= 18) break block22;
                                            return 33;
                                        }
                                        if (Printer.getPrintableLength((AbstractPrinter)ppekk.getPrinter(), (String)this.description, (boolean)false) != 0) break block23;
                                        return 33;
                                    }
                                    if (!Function.matches(this.description, ".*[\\x00-\\x19].*")) break block24;
                                    return 96;
                                }
                                this.description.replaceAll("\\*", " ");
                                this.operationType = Integer.parseInt(this.params[2]);
                                if (this.operationType >= 0 && this.operationType <= 1) break block25;
                                return 96;
                            }
                            switch (this.operationType) {
                                case 0: 
                                case 1: {
                                    if (Checkers.get().checkValueFormat(this.params[3], 7, 2)) break;
                                    return 33;
                                }
                            }
                            if (!this.params[3].contains("-")) break block26;
                            return 96;
                        }
                        this.discountValue = new BigDecimal(this.params[3]);
                        if (this.params[4].length() <= 1) break block27;
                        return 33;
                    }
                    this.vat = Character.valueOf(this.params[4].charAt(0));
                    if (fm.validateVat(this.vat.charValue())) break block28;
                    return 96;
                }
                if (Checkers.get().checkValueFormat(this.params[5], 7, 2)) break block29;
                return 33;
            }
            if (!this.params[5].contains("-")) break block30;
            return 96;
        }
        try {
            this.discountValueZ = new BigDecimal(this.params[5]);
        }
        catch (NumberFormatException e) {
            return 96;
        }
        catch (Exception e) {
            return 96;
        }
        return 0;
    }
}

