/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm.common;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.Configuration;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.data.InitConfiguration;
import sk.singularisdev.ekasask.fm.enums.ConfigurationIdent;

public class Function {
    private static final Logger logger = LoggerManager.getLogger((String)Function.class.getName());

    public static List<String> getFilesList(String path, String fileContainFilter) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Stream<Path> walk = Files.walk(Paths.get(path, new String[0]), new FileVisitOption[0]);){
                List<String> result = walk.map(x -> x.toString()).filter(f -> f.contains(fileContainFilter)).collect(Collectors.toList());
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return new ArrayList<String>();
        }
    }

    public static boolean checkLength(String input) throws UnsupportedEncodingException {
        int lngthByte;
        int lngth = input.length();
        return lngth == (lngthByte = input.getBytes("UTF-8").length);
    }

    public static void initFMDB(FmFiscalMemory fm) {
        try {
            fm.reloadData();
        }
        catch (FmStoreToDbException e) {
            logger.info("fatala DB error");
        }
    }

    public static String loadTemplateFile(long fmId) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("Templates/Template_" + fmId + ".template"), "UTF8"));
        String line = null;
        StringBuilder template = new StringBuilder();
        try {
            while ((line = reader.readLine()) != null) {
                line = line.replace("\ufeff", "");
                template.append(line).append("\n");
            }
            String string = template.toString();
            return string;
        }
        finally {
            reader.close();
        }
    }

    public static void loadPPEKKConfiguration() throws Exception {
        String line = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("PPEKKConfiguration.config"), "UTF8"));){
            while ((line = reader.readLine()) != null) {
                String[] dataIdent = line.split("=");
                if (dataIdent.length != 2) continue;
                switch (ConfigurationIdent.fromName(dataIdent[0])) {
                    case url: {
                        Configuration.setSfsUrl((String)dataIdent[1]);
                        break;
                    }
                    case sfs_send_timeout: {
                        Configuration.setSendTimeout((int)Integer.parseInt(dataIdent[1]));
                        break;
                    }
                    case sfs_resend_timeout: {
                        Configuration.setResendTimeout((int)Integer.parseInt(dataIdent[1]));
                        break;
                    }
                    case chdu_connection_timeout: {
                        Configuration.setChduCommunicationTimeout((int)Integer.parseInt(dataIdent[1]));
                        break;
                    }
                    case chdu_autoconnection: {
                        Configuration.setChduAutoconnectionEnabled((dataIdent[1].equals("true") ? 1 : 0) != 0);
                        break;
                    }
                    case chdu_autoconnection_repeat_time: {
                        Configuration.setCchduAutoConnectionRepeatTime((int)Integer.parseInt(dataIdent[1]));
                        break;
                    }
                    case chdu_autoconnection_repeat_count: {
                        Configuration.setChduAutoConnectionCount((int)Integer.parseInt(dataIdent[1]));
                        break;
                    }
                    case chdu_keep_alive_enabled: {
                        Configuration.setChduKeepaliveEnabled((dataIdent[1].equals("true") ? 1 : 0) != 0);
                        break;
                    }
                    case proxy: {
                        String[] ipPort = dataIdent[1].split(":");
                        Configuration.setProxyHost((String)ipPort[0]);
                        Configuration.setProxyPort((int)Integer.parseInt(ipPort[1]));
                        break;
                    }
                }
            }
        }
    }

    public static boolean matches(String input, String regex) {
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(input);
        return m.find();
    }

    /*
     * Exception decompiling
     */
    public static InitConfiguration loadConfigurationFile() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [28[UNCONDITIONALDOLOOP]], but top level block is 29[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

