/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm.data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.command.AbstractCommand;
import sk.singularisdev.ekasask.command.CashIn;
import sk.singularisdev.ekasask.command.CashOut;
import sk.singularisdev.ekasask.command.InternalDocument;
import sk.singularisdev.ekasask.command.InvalidReceipt;
import sk.singularisdev.ekasask.command.ItemPrint;
import sk.singularisdev.ekasask.command.MessageItemInterfaceParagon;
import sk.singularisdev.ekasask.command.PaymentOfClaim;
import sk.singularisdev.ekasask.command.Receipt;
import sk.singularisdev.ekasask.enumeration.CUSTOMER_TYPE;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.data.Customer;
import sk.singularisdev.ekasask.fm.data.ItemModel;
import sk.singularisdev.ekasask.fm.data.PaymentModel;
import sk.singularisdev.ekasask.fm.data.Turnover;
import sk.singularisdev.ekasask.fm.enums.ParagonType;
import sk.singularisdev.ekasask.fm.enums.SFSError;
import sk.singularisdev.ekasask.sfs.EKasaResponseException;

public class ParagonModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int row;
    private int commType;
    private int paragonType;
    private int recapType;
    private int graphicHeader;
    private int graphicFooter;
    private ParagonType saleType;
    private BigDecimal receiptTotal;
    private String invoiceNumber;
    private String transactionID;
    private String email;
    private Customer customer;
    private BigInteger issuedParagonNumber;
    private String issuedParagonDate;
    private boolean correction;
    private byte[] binaryData;
    private ArrayList<ItemModel> items;
    private ArrayList<PaymentModel> payments;
    private ArrayList<ItemModel> additionalItems;

    public ParagonModel(Builder builder) {
        this.row = builder.row;
        this.saleType = builder.saleType;
        this.commType = builder.commType;
        this.paragonType = builder.paragonType;
        this.recapType = builder.recapType;
        this.graphicHeader = builder.graphicHeader;
        this.graphicFooter = builder.graphicFooter;
        this.items = builder.items;
        this.payments = builder.payments;
        this.additionalItems = builder.finalItems;
        this.receiptTotal = builder.receiptTotal;
        this.invoiceNumber = builder.invoiceNumber;
        this.customer = builder.customer;
        this.issuedParagonNumber = builder.issuedParagonNumber;
        this.issuedParagonDate = builder.issuedParagonDate;
        this.transactionID = builder.transactionID;
        this.email = builder.email;
        this.correction = builder.correction;
        this.binaryData = builder.binaryData;
    }

    public int getRow() {
        return this.row;
    }

    public ParagonType getSaleType() {
        return this.saleType;
    }

    public int getCommType() {
        return this.commType;
    }

    public int getParagonType() {
        return this.paragonType;
    }

    public int getRecapType() {
        return this.recapType;
    }

    public int getGraphicHeader() {
        return this.graphicHeader;
    }

    public int getGraphicFooter() {
        return this.graphicFooter;
    }

    public BigDecimal getReceiptTotal() {
        return this.receiptTotal;
    }

    public String getInvoiceNumber() {
        return this.invoiceNumber;
    }

    public String getTransactionID() {
        return this.transactionID;
    }

    public String getEmail() {
        return this.email;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public BigInteger getIssuedParagonNumber() {
        return this.issuedParagonNumber;
    }

    public String getIssuedParagonDate() {
        return this.issuedParagonDate;
    }

    public boolean isCorrection() {
        return this.correction;
    }

    public AbstractCommand getPPEKKFormat(FmFiscalMemory fm, Date createdDate) throws EKasaException {
        switch (this.saleType) {
            case maloobchod: {
                return this.getPPEKKReceipt(fm, createdDate);
            }
            case velkoobchod: {
                return this.getPPEKKReceipt(fm, createdDate);
            }
            case neplatny: {
                return this.getPPEKKInvalidReceipt(fm, createdDate);
            }
            case interny3: {
                return this.getPPEKKInternalDocument(fm, createdDate, false);
            }
            case interny2: 
            case interny6: {
                return this.getPPEKKInternalDocument(fm, createdDate, true);
            }
            case faktura: {
                return this.getPPEKKPaymentOfClain(fm, createdDate);
            }
            case vkladVyber: {
                switch (fm.getReceiptTotal().compareTo(BigDecimal.ZERO)) {
                    case -1: {
                        return this.getPPEKKCashOut(fm, createdDate);
                    }
                }
                return this.getPPEKKCashIn(fm, createdDate);
            }
        }
        return null;
    }

    public void setTransactionID(String transactionID) throws FmStoreToDbException {
        this.transactionID = transactionID;
    }

    public void setEmail(String email) throws FmStoreToDbException {
        this.email = email;
    }

    public void setInvoiceNumber(String invoiceNumber) throws FmStoreToDbException {
        this.invoiceNumber = invoiceNumber;
    }

    public void setCorrection(boolean correction) throws FmStoreToDbException {
        this.correction = correction;
    }

    public void setCustomer(Customer customer) throws FmStoreToDbException {
        this.customer = customer;
    }

    public void setCustomer(CUSTOMER_TYPE type, String customerId) throws FmStoreToDbException {
        if (this.customer == null) {
            this.customer = new Customer(type, customerId);
        } else {
            this.customer.setCustomerType(type);
            this.customer.setCustomerId(customerId);
        }
    }

    public void setGraphicHeader(int graphicHeader) throws FmStoreToDbException {
        this.graphicHeader = graphicHeader;
    }

    public void setGraphicFooter(int graphicFooter) throws FmStoreToDbException {
        this.graphicFooter = graphicFooter;
    }

    public void setIssuedParagonNumber(BigInteger issuedParagonNumber) throws FmStoreToDbException {
        this.issuedParagonNumber = issuedParagonNumber;
    }

    public void setIssuedParagonDate(String issuedParagonDate) throws FmStoreToDbException {
        this.issuedParagonDate = issuedParagonDate;
    }

    public void appendReceiptTotal(BigDecimal value) throws FmStoreToDbException {
        this.receiptTotal = this.receiptTotal.add(value);
    }

    public void appendBinaryData(byte[] binaryData) throws FmStoreToDbException {
        int l1 = this.binaryData.length;
        int l2 = binaryData.length;
        byte[] b = new byte[l1 + l2];
        System.arraycopy(this.binaryData, 0, b, 0, l1);
        System.arraycopy(binaryData, 0, b, l1, l2);
        this.binaryData = b;
    }

    public byte[] getBinaryData() {
        return this.binaryData;
    }

    private PaymentOfClaim getPPEKKPaymentOfClain(FmFiscalMemory fm, Date createdDate) throws EKasaException {
        PaymentOfClaim invoice = PaymentOfClaim.getInstance();
        invoice.setCreateDate(createdDate);
        if (this.issuedParagonDate != null) {
            try {
                invoice.setIssueDate(new SimpleDateFormat("ddMMyyyykkmmss").parse(this.issuedParagonDate));
            }
            catch (Exception exception) {}
        } else {
            invoice.setIssueDate(createdDate);
        }
        if (this.customer != null) {
            invoice.setCustomer(this.customer.getCustomer());
        }
        if (this.issuedParagonNumber != null) {
            invoice.setParagonNumber(Long.valueOf(Long.parseLong(this.issuedParagonNumber.toString())));
        }
        if (this.invoiceNumber != null) {
            invoice.setInvoiceNumber(this.invoiceNumber);
        }
        if (this.email != null) {
            invoice.setEmail(this.email);
        }
        invoice.setLogoHeader(this.graphicHeader);
        invoice.setLogoFooter(this.graphicFooter);
        invoice.setAdditionalHeader(fm.getAdditionalHeader());
        invoice.setAdditionalFooter(fm.getAdditionalFooter());
        block8: for (ItemModel item : this.items) {
            switch (item.getItemType()) {
                case itemSale: {
                    break;
                }
                case itemVoid: {
                    break;
                }
                case itemReturn: {
                    break;
                }
                case odpocitanaZaloha: {
                    break;
                }
                default: {
                    for (MessageItemInterfaceParagon messageItemInterfaceParagon : item.getPPEKKFormat(this.email != null, fm.getCharCount())) {
                        invoice.addItem(messageItemInterfaceParagon);
                    }
                    continue block8;
                }
            }
        }
        for (PaymentModel payment : this.payments) {
            for (ItemPrint itemPrint : payment.getPPEKKFormat(this.email != null)) {
                invoice.addPayment((MessageItemInterfaceParagon)itemPrint);
            }
        }
        if (this.additionalItems.size() > 0) {
            invoice.addPayment((MessageItemInterfaceParagon)ItemPrint.getInstance((String)Formatter.get().repeat('=', fm.getCharCount())));
            for (ItemModel item : this.additionalItems) {
                for (MessageItemInterfaceParagon messageItemInterfaceParagon : item.getPPEKKFormat(this.email != null, fm.getCharCount())) {
                    invoice.addPayment(messageItemInterfaceParagon);
                }
            }
        }
        invoice.setAmount(this.getValueInCents(this.receiptTotal.toString()));
        return invoice;
    }

    private CashIn getPPEKKCashIn(FmFiscalMemory fm, Date createdDate) throws EKasaException {
        CashIn cash = CashIn.getInstance();
        cash.setCreateDate(createdDate);
        cash.setIssueDate(createdDate);
        cash.setLogoHeader(this.graphicHeader);
        cash.setLogoFooter(this.graphicFooter);
        cash.setAdditionalHeader(fm.getAdditionalHeader());
        cash.setAdditionalFooter(fm.getAdditionalFooter());
        for (ItemModel item : this.items) {
            for (MessageItemInterfaceParagon row : item.getPPEKKFormat(this.email != null, fm.getCharCount())) {
                cash.addItem(row);
            }
        }
        cash.setAmount(this.getValueInCents(fm.getReceiptTotal().toString()));
        return cash;
    }

    private CashOut getPPEKKCashOut(FmFiscalMemory fm, Date createdDate) throws EKasaException {
        CashOut cash = CashOut.getInstance();
        cash.setCreateDate(createdDate);
        cash.setIssueDate(createdDate);
        cash.setLogoHeader(this.graphicHeader);
        cash.setLogoFooter(this.graphicFooter);
        cash.setAdditionalHeader(fm.getAdditionalHeader());
        cash.setAdditionalFooter(fm.getAdditionalFooter());
        for (ItemModel item : this.items) {
            for (MessageItemInterfaceParagon row : item.getPPEKKFormat(this.email != null, fm.getCharCount())) {
                cash.addItem(row);
            }
        }
        cash.setAmount(this.getValueInCents(fm.getReceiptTotal().toString()));
        return cash;
    }

    private InternalDocument getPPEKKInternalDocument(FmFiscalMemory fm, Date createdDate, boolean cutter) throws EKasaException {
        InternalDocument document = InternalDocument.getInstance();
        document.setLogoHeader(this.graphicHeader);
        document.setLogoFooter(this.graphicFooter);
        document.setAutoCutter(cutter);
        for (ItemModel item : this.items) {
            for (MessageItemInterfaceParagon row : item.getPPEKKFormat(this.email != null, fm.getCharCount())) {
                document.addItem(row);
            }
        }
        return document;
    }

    private InvalidReceipt getPPEKKInvalidReceipt(FmFiscalMemory fm, Date createdDate) throws EKasaException {
        InvalidReceipt paragon = InvalidReceipt.getInstance((boolean)true);
        paragon.setCreateDate(createdDate);
        paragon.setIssueDate(createdDate);
        paragon.setReceiptNumber(1L);
        paragon.setLogoHeader(this.graphicHeader);
        paragon.setLogoFooter(this.graphicFooter);
        paragon.setAdditionalHeader(fm.getAdditionalHeader());
        paragon.setAdditionalFooter(fm.getAdditionalFooter());
        if (fm.isVatPayer()) {
            BigDecimal[] obraty = this.getVAT_VALUES(fm);
            paragon.setBasicVatAmount(this.getValueInCents(obraty[1].toString()));
            paragon.setReducedVatAmount(this.getValueInCents(obraty[3].toString()));
            paragon.setTaxFreeAmount(this.getValueInCents(obraty[4].toString()));
            paragon.setTaxBaseBasic(this.getValueInCents(obraty[0].toString()));
            paragon.setTaxBaseReduced(this.getValueInCents(obraty[2].toString()));
        } else {
            paragon.setTaxFreeAmount(this.getValueInCents(this.receiptTotal.toString()));
        }
        boolean hasItems = false;
        for (ItemModel item : this.items) {
            switch (item.getItemType()) {
                case itemSale: 
                case itemReturn: 
                case itemNegative: 
                case itemVoid: 
                case itemDiscount: 
                case itemDiscount2: {
                    hasItems = true;
                }
            }
            for (MessageItemInterfaceParagon messageItemInterfaceParagon : item.getPPEKKFormat(this.email != null, fm.getCharCount())) {
                paragon.addItem(messageItemInterfaceParagon);
            }
        }
        if (!hasItems) {
            throw new EKasaResponseException(SFSError.SFS_ERROR_VALID_INVALID_RECEIPT_ITEMS_MANDATORY.getSFSCode(), "");
        }
        for (PaymentModel payment : this.payments) {
            for (ItemPrint itemPrint : payment.getPPEKKFormat(this.email != null)) {
                paragon.addPayment((MessageItemInterfaceParagon)itemPrint);
            }
        }
        if (this.additionalItems.size() > 0) {
            for (ItemModel item : this.additionalItems) {
                for (MessageItemInterfaceParagon messageItemInterfaceParagon : item.getPPEKKFormat(this.email != null, fm.getCharCount())) {
                    paragon.addFinalText(messageItemInterfaceParagon);
                }
            }
        }
        return paragon;
    }

    private Receipt getPPEKKReceipt(FmFiscalMemory fm, Date createdDate) throws EKasaException {
        Receipt paragon = this.saleType == ParagonType.maloobchod ? Receipt.getInstance((boolean)true) : Receipt.getInstance((boolean)false);
        paragon.setCreateDate(createdDate);
        if (this.issuedParagonDate != null) {
            try {
                paragon.setIssueDate(new SimpleDateFormat("ddMMyyyykkmmss").parse(this.issuedParagonDate));
            }
            catch (Exception exception) {}
        } else {
            paragon.setIssueDate(createdDate);
        }
        if (this.customer != null) {
            paragon.setCustomer(this.customer.getCustomer());
        }
        if (this.issuedParagonNumber != null) {
            paragon.setParagonNumber(Long.valueOf(Long.parseLong(this.issuedParagonNumber.toString())));
        }
        if (this.email != null) {
            paragon.setEmail(this.email);
        }
        paragon.setLogoHeader(this.graphicHeader);
        paragon.setLogoFooter(this.graphicFooter);
        paragon.setAdditionalHeader(fm.getAdditionalHeader());
        paragon.setAdditionalFooter(fm.getAdditionalFooter());
        if (fm.isVatPayer()) {
            BigDecimal[] obraty = this.getVAT_VALUES(fm);
            paragon.setBasicVatAmount(this.getValueInCents(obraty[1].toString()));
            paragon.setReducedVatAmount(this.getValueInCents(obraty[3].toString()));
            paragon.setTaxFreeAmount(this.getValueInCents(obraty[4].toString()));
            paragon.setTaxBaseBasic(this.getValueInCents(obraty[0].toString()));
            paragon.setTaxBaseReduced(this.getValueInCents(obraty[2].toString()));
        } else {
            paragon.setTaxFreeAmount(this.getValueInCents(this.receiptTotal.toString()));
        }
        boolean hasItems = false;
        for (ItemModel item : this.items) {
            switch (item.getItemType()) {
                case itemSale: 
                case itemReturn: 
                case itemNegative: 
                case itemVoid: 
                case itemDiscount: 
                case itemDiscount2: {
                    hasItems = true;
                }
            }
            for (MessageItemInterfaceParagon messageItemInterfaceParagon : item.getPPEKKFormat(this.email != null, fm.getCharCount())) {
                paragon.addItem(messageItemInterfaceParagon);
            }
        }
        if (!hasItems) {
            throw new EKasaResponseException(SFSError.SFS_ERROR_VALID_INVALID_RECEIPT_ITEMS_MANDATORY.getSFSCode(), "");
        }
        for (PaymentModel payment : this.payments) {
            for (ItemPrint itemPrint : payment.getPPEKKFormat(this.email != null)) {
                paragon.addPayment((MessageItemInterfaceParagon)itemPrint);
            }
        }
        if (this.additionalItems.size() > 0) {
            for (ItemModel item : this.additionalItems) {
                for (MessageItemInterfaceParagon messageItemInterfaceParagon : item.getPPEKKFormat(this.email != null, fm.getCharCount())) {
                    paragon.addFinalText(messageItemInterfaceParagon);
                }
            }
        }
        return paragon;
    }

    private BigDecimal[] getVAT_VALUES(FmFiscalMemory fm) {
        BigDecimal basedBase = BigDecimal.ZERO;
        BigDecimal basedVat = BigDecimal.ZERO;
        BigDecimal reducedBase = BigDecimal.ZERO;
        BigDecimal reducedVat = BigDecimal.ZERO;
        BigDecimal free = BigDecimal.ZERO;
        for (Map.Entry<Character, Turnover> turnover : fm.getVats().entrySet()) {
            if (turnover.getValue().getVatType() == null) continue;
            switch (turnover.getValue().getVatType()) {
                case BASED: {
                    basedBase = basedBase.add(turnover.getValue().getLocalBase());
                    basedVat = basedVat.add(turnover.getValue().getLocalVat());
                    break;
                }
                case REDUCED: {
                    reducedBase = reducedBase.add(turnover.getValue().getLocalBase());
                    reducedVat = reducedVat.add(turnover.getValue().getLocalVat());
                    break;
                }
                case FREE: {
                    free = free.add(turnover.getValue().getLocalTotal());
                }
            }
        }
        return new BigDecimal[]{basedBase, basedVat, reducedBase, reducedVat, free};
    }

    private long getValueInCents(String value) {
        boolean negative = false;
        if (value.contains("-")) {
            negative = true;
            value = value.replace("-", "");
        }
        String[] parcials = value.split("\\.");
        switch (parcials.length) {
            case 1: {
                return Long.parseLong(negative ? "-" + parcials[0] : parcials[0]) * 100L;
            }
            case 2: {
                if (Long.parseLong(parcials[0]) == 0L) {
                    if (parcials[1].length() == 1) {
                        return Long.parseLong(negative ? "-" + parcials[1] : parcials[1]) * 10L;
                    }
                    return Long.parseLong(negative ? "-" + parcials[1] : parcials[1]);
                }
                if (parcials[1].length() == 1) {
                    return Long.parseLong(negative ? "-" + value.replace(".", "") : value.replace(".", "")) * 10L;
                }
                return Long.parseLong(negative ? "-" + value.replace(".", "") : value.replace(".", ""));
            }
        }
        return Long.parseLong(negative ? "-" + value.replace(".", "") : value.replace(".", ""));
    }

    public void addItem(ItemModel item) throws FmStoreToDbException {
        this.items.add(item);
    }

    public ArrayList<ItemModel> getItems() {
        return this.items;
    }

    public void addPayment(PaymentModel payment) throws FmStoreToDbException {
        this.payments.add(payment);
    }

    public ArrayList<PaymentModel> getPayments() {
        return this.payments;
    }

    public void addFinalItem(ItemModel item) throws FmStoreToDbException {
        this.additionalItems.add(item);
    }

    public ArrayList<ItemModel> getFinalItems() {
        return this.additionalItems;
    }

    public ItemModel getLastValidItem() {
        int validIndex = -1;
        int i = this.items.size() - 1;
        while (i >= 0) {
            if (validIndex != -1) break;
            switch (this.items.get(i).getItemType()) {
                case itemSale: 
                case itemReturn: 
                case itemNegative: 
                case itemVoid: {
                    validIndex = i;
                    break;
                }
            }
            --i;
        }
        if (validIndex != -1) {
            return this.items.get(validIndex);
        }
        return null;
    }

    public ItemModel getLastValidPopis0Item() {
        ItemModel item = this.items.get(this.items.size() - 1);
        switch (item.getItemType()) {
            case itemSale: 
            case itemReturn: 
            case itemVoid: {
                return item;
            }
        }
        return null;
    }

    public static class Builder {
        int row = 0;
        int commType = 0;
        int paragonType = 0;
        int recapType = 0;
        int graphicHeader = 0;
        int graphicFooter = 0;
        ParagonType saleType = ParagonType.maloobchod;
        BigDecimal receiptTotal = BigDecimal.ZERO;
        String invoiceNumber = null;
        String transactionID = null;
        String email = null;
        Customer customer;
        BigInteger issuedParagonNumber = null;
        String issuedParagonDate = null;
        boolean correction = false;
        byte[] binaryData = new byte[0];
        ArrayList<ItemModel> items = new ArrayList();
        ArrayList<PaymentModel> payments = new ArrayList();
        ArrayList<ItemModel> finalItems = new ArrayList();

        public Builder setBinaryData(byte[] binaryData) {
            this.binaryData = binaryData;
            return this;
        }

        public Builder setCorrection(boolean correction) {
            this.correction = correction;
            return this;
        }

        public Builder setEmail(String email) {
            this.email = email;
            return this;
        }

        public Builder setTransactionID(String transactionID) {
            this.transactionID = transactionID;
            return this;
        }

        public Builder setIssuedParagonNumber(BigInteger issuedParagonNumber) {
            this.issuedParagonNumber = issuedParagonNumber;
            return this;
        }

        public Builder setIssuedParagonDate(String issuedParagonDate) {
            this.issuedParagonDate = issuedParagonDate;
            return this;
        }

        public Builder setCustomer(Customer customer) {
            this.customer = customer;
            return this;
        }

        public Builder setRow(int row) {
            this.row = row;
            return this;
        }

        public Builder setInvoiceNumber(String invoiceNumber) {
            this.invoiceNumber = invoiceNumber;
            return this;
        }

        public Builder setSaleType(ParagonType saleType) {
            this.saleType = saleType;
            return this;
        }

        public Builder setCommType(int commType) {
            this.commType = commType;
            return this;
        }

        public Builder setParagonType(int paragonType) {
            this.paragonType = paragonType;
            return this;
        }

        public Builder setRecapType(int recapType) {
            this.recapType = recapType;
            return this;
        }

        public Builder setGraphicHeader(int graphicHeader) {
            this.graphicHeader = graphicHeader;
            return this;
        }

        public Builder setGraphicFooter(int graphicFooter) {
            this.graphicFooter = graphicFooter;
            return this;
        }

        public Builder setItems(ArrayList<ItemModel> items) {
            this.items = items;
            return this;
        }

        public Builder setPayments(ArrayList<PaymentModel> payments) {
            this.payments = payments;
            return this;
        }

        public Builder setFinalItems(ArrayList<ItemModel> items) {
            this.finalItems = items;
            return this;
        }

        public ParagonModel build() {
            return new ParagonModel(this);
        }
    }
}

