/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm.data;

import java.math.BigDecimal;
import java.sql.SQLException;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.db.enums.RowPrefix;
import sk.singularisdev.ekasask.fm.db.enums.Rows;
import sk.singularisdev.ekasask.fm.db.enums.Tables;
import sk.singularisdev.ekasask.fm.db.helpers.ContentValues;

public class PaymentMethod {
    private FmFiscalMemory fm;
    private int fmId;
    private String name;
    private BigDecimal minCurrency;
    private boolean overpay;
    private BigDecimal exchangeLocalTurnover;
    private BigDecimal localTurnover;
    private BigDecimal localDeposite;
    private BigDecimal localWithdraw;
    private BigDecimal exchangeGlobalTurnover;
    private BigDecimal globalTurnover;
    private BigDecimal globalDeposite;
    private BigDecimal globalWithdraw;
    private int depositeCount;
    private int withdrawCount;
    private int paymentCount;
    private int localDepositeCount;
    private int localWithdrawCount;
    private int localPaymentCount;

    public PaymentMethod(Builder builder) {
        this.fm = builder.fm;
        this.fmId = builder.fmId;
        this.name = builder.name;
        this.minCurrency = builder.minCurrency;
        this.overpay = builder.overpay;
        this.localTurnover = builder.localTurnover;
        this.exchangeLocalTurnover = builder.exchangeLocalTurnover;
        this.localDeposite = builder.localDeposite;
        this.localWithdraw = builder.localWithdraw;
        this.globalTurnover = builder.globalTurnover;
        this.exchangeGlobalTurnover = builder.exchangeGlobalTurnover;
        this.globalDeposite = builder.globalDeposite;
        this.globalWithdraw = builder.globalWithdraw;
        this.depositeCount = builder.depositeCount;
        this.withdrawCount = builder.withdrawCount;
        this.paymentCount = builder.paymentCount;
        this.localDepositeCount = builder.localDepositeCount;
        this.localWithdrawCount = builder.localWithdrawCount;
        this.localPaymentCount = builder.localPaymentCount;
    }

    public void tiltLocalToGlobal() throws FmStoreToDbException {
        this.globalTurnover = this.globalTurnover.add(this.localTurnover);
        this.exchangeGlobalTurnover = this.exchangeGlobalTurnover.add(this.exchangeLocalTurnover);
        this.globalDeposite = this.globalDeposite.add(this.localDeposite);
        this.globalWithdraw = this.globalWithdraw.add(this.localWithdraw);
        this.depositeCount += this.localDepositeCount;
        this.withdrawCount += this.localWithdrawCount;
        this.paymentCount += this.localPaymentCount;
        this.saveRegisterToDb();
    }

    public void resetLocals() throws FmStoreToDbException {
        this.localTurnover = BigDecimal.ZERO;
        this.exchangeLocalTurnover = BigDecimal.ZERO;
        this.localDeposite = BigDecimal.ZERO;
        this.localWithdraw = BigDecimal.ZERO;
        this.localDepositeCount = 0;
        this.localWithdrawCount = 0;
        this.localPaymentCount = 0;
        this.saveRegisterToDb();
    }

    public void resetGlobals(boolean depositeOverhaul) throws FmStoreToDbException {
        this.globalTurnover = BigDecimal.ZERO;
        this.exchangeGlobalTurnover = BigDecimal.ZERO;
        this.paymentCount = 0;
        if (depositeOverhaul) {
            BigDecimal midleValue = this.globalDeposite.subtract(this.globalWithdraw);
            if (midleValue.compareTo(BigDecimal.ZERO) < 0) {
                this.globalWithdraw = midleValue.abs();
                this.withdrawCount = 1;
                this.globalDeposite = BigDecimal.ZERO;
                this.depositeCount = 0;
            } else if (midleValue.compareTo(BigDecimal.ZERO) > 0) {
                this.globalDeposite = midleValue.abs();
                this.depositeCount = 1;
                this.globalWithdraw = BigDecimal.ZERO;
                this.withdrawCount = 0;
            } else {
                this.globalDeposite = BigDecimal.ZERO;
                this.globalWithdraw = BigDecimal.ZERO;
                this.depositeCount = 0;
                this.withdrawCount = 0;
            }
        } else {
            this.globalDeposite = BigDecimal.ZERO;
            this.globalWithdraw = BigDecimal.ZERO;
            this.depositeCount = 0;
            this.withdrawCount = 0;
        }
        this.saveRegisterToDb();
    }

    public void appendExchangeLocalTurnover(BigDecimal appendValue) throws FmStoreToDbException {
        this.exchangeLocalTurnover = this.exchangeLocalTurnover.add(appendValue);
        this.saveRegisterToDb();
    }

    public void appendLocalTurnover(BigDecimal appendValue) throws FmStoreToDbException {
        this.localTurnover = this.localTurnover.add(appendValue);
        this.saveRegisterToDb();
    }

    public void appendExchangeGlobalTurnover(BigDecimal appendValue) throws FmStoreToDbException {
        this.exchangeGlobalTurnover = this.exchangeGlobalTurnover.add(appendValue);
        this.saveRegisterToDb();
    }

    public void appendGlobalTurnover(BigDecimal appendValue) throws FmStoreToDbException {
        this.globalTurnover = this.globalTurnover.add(appendValue);
        this.saveRegisterToDb();
    }

    public void appendLocalDeposite(BigDecimal appendValue) throws FmStoreToDbException {
        this.localDeposite = this.localDeposite.add(appendValue);
        this.saveRegisterToDb();
    }

    public void appendGlobalDeposite(BigDecimal appendValue) throws FmStoreToDbException {
        this.globalDeposite = this.globalDeposite.add(appendValue);
        this.saveRegisterToDb();
    }

    public void appendLocalWithdraw(BigDecimal appendValue) throws FmStoreToDbException {
        this.localWithdraw = this.localWithdraw.add(appendValue);
        this.saveRegisterToDb();
    }

    public void appendGlobalWithdraw(BigDecimal appendValue) throws FmStoreToDbException {
        this.globalWithdraw = this.globalWithdraw.add(appendValue);
        this.saveRegisterToDb();
    }

    public void incDepositeCounter(int count) throws FmStoreToDbException {
        this.depositeCount += count;
        this.saveRegisterToDb();
    }

    public void incLocalDepositeCounter() throws FmStoreToDbException {
        ++this.localDepositeCount;
        this.saveRegisterToDb();
    }

    public void incWithdrawCounter(int count) throws FmStoreToDbException {
        this.withdrawCount += count;
        this.saveRegisterToDb();
    }

    public void incLocalWithdrawCounter() throws FmStoreToDbException {
        ++this.localWithdrawCount;
        this.saveRegisterToDb();
    }

    private void saveRegisterToDb() throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.Total.fullPrefixRow(RowPrefix.local), this.localTurnover.toString());
            values.put(Rows.Total.fullPrefixRow(RowPrefix.exchange, RowPrefix.local), this.exchangeLocalTurnover.toString());
            values.put(Rows.Total.fullPrefixRow(RowPrefix.deposite, RowPrefix.local), this.localDeposite.toString());
            values.put(Rows.Total.fullPrefixRow(RowPrefix.withdraw, RowPrefix.local), this.localWithdraw.toString());
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.deposite, RowPrefix.local), this.localDepositeCount);
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.withdraw, RowPrefix.local), this.localWithdrawCount);
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.local), this.localPaymentCount);
            values.put(Rows.Total.fullPrefixRow(RowPrefix.global), this.globalTurnover.toString());
            values.put(Rows.Total.fullPrefixRow(RowPrefix.exchange, RowPrefix.global), this.exchangeGlobalTurnover.toString());
            values.put(Rows.Total.fullPrefixRow(RowPrefix.deposite, RowPrefix.global), this.globalDeposite.toString());
            values.put(Rows.Total.fullPrefixRow(RowPrefix.withdraw, RowPrefix.global), this.globalWithdraw.toString());
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.deposite, RowPrefix.global), this.depositeCount);
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.withdraw, RowPrefix.global), this.withdrawCount);
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.global), this.paymentCount);
            this.fm.getDbSource().saveData(Tables.fmPayments.table(), values, String.valueOf(Rows.FmId.row()) + "=" + this.fmId);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    private void saveSettingsToDb() throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.PaymentName.row(), this.name);
            values.put(Rows.PaymentMinCurrency.row(), this.minCurrency.toString());
            values.put(Rows.PaymentOverpay.row(), this.overpay ? 1 : 0);
            this.fm.getDbSource().saveData(Tables.fmPayments.table(), values, String.valueOf(Rows.FmId.row()) + "=" + this.fmId);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public void incPaymentCounter(int count) throws FmStoreToDbException {
        this.paymentCount += count;
        this.saveRegisterToDb();
    }

    public void incLocalPaymentCounter() throws FmStoreToDbException {
        ++this.localPaymentCount;
        this.saveRegisterToDb();
    }

    public BigDecimal getLocalTurnover() {
        return this.localTurnover;
    }

    public BigDecimal getLocalDeposite() {
        return this.localDeposite;
    }

    public BigDecimal getLocalWithdraw() {
        return this.localWithdraw;
    }

    public BigDecimal getGlobalTurnover() {
        return this.globalTurnover;
    }

    public BigDecimal getGlobalDeposite() {
        return this.globalDeposite;
    }

    public BigDecimal getGlobalWithdraw() {
        return this.globalWithdraw;
    }

    public int getDepositeCount() {
        return this.depositeCount;
    }

    public int getWithdrawCount() {
        return this.withdrawCount;
    }

    public int getPaymentCount() {
        return this.paymentCount;
    }

    public int getLocalDepositeCount() {
        return this.localDepositeCount;
    }

    public int getLocalWithdrawCount() {
        return this.localWithdrawCount;
    }

    public int getLocalPaymentCount() {
        return this.localPaymentCount;
    }

    public BigDecimal getExchangeLocalTurnover() {
        return this.exchangeLocalTurnover;
    }

    public BigDecimal getExchangeGlobalTurnover() {
        return this.exchangeGlobalTurnover;
    }

    public int getFmId() {
        return this.fmId;
    }

    public String getName() {
        return this.name;
    }

    public BigDecimal getMinCurrency() {
        return this.minCurrency;
    }

    public boolean isOverpay() {
        return this.overpay;
    }

    public void setName(String name) throws FmStoreToDbException {
        this.name = name;
        this.saveSettingsToDb();
    }

    public void setMinCurrency(BigDecimal minCurrency) throws FmStoreToDbException {
        this.minCurrency = minCurrency;
        this.saveSettingsToDb();
    }

    public void setOverpay(boolean overpay) throws FmStoreToDbException {
        this.overpay = overpay;
        this.saveSettingsToDb();
    }

    public static class Builder {
        FmFiscalMemory fm;
        int fmId = 16;
        String name = "PLATIDLO";
        BigDecimal minCurrency = new BigDecimal("0.01");
        BigDecimal localTurnover = BigDecimal.ZERO;
        BigDecimal globalTurnover = BigDecimal.ZERO;
        BigDecimal localDeposite = BigDecimal.ZERO;
        BigDecimal localWithdraw = BigDecimal.ZERO;
        BigDecimal globalDeposite = BigDecimal.ZERO;
        BigDecimal globalWithdraw = BigDecimal.ZERO;
        BigDecimal exchangeLocalTurnover = BigDecimal.ZERO;
        BigDecimal exchangeGlobalTurnover = BigDecimal.ZERO;
        int depositeCount = 0;
        int withdrawCount = 0;
        int paymentCount = 0;
        int localDepositeCount = 0;
        int localWithdrawCount = 0;
        int localPaymentCount = 0;
        boolean overpay = true;

        public Builder(FmFiscalMemory fm) {
            this.fm = fm;
        }

        public Builder setFmId(int fmId) {
            this.fmId = fmId;
            return this;
        }

        public Builder setExchangeLocalTurnover(BigDecimal exchangeLocalTurnover) {
            this.exchangeLocalTurnover = exchangeLocalTurnover;
            return this;
        }

        public Builder setExchangeGlobalTurnover(BigDecimal exchangeGlobalTurnover) {
            this.exchangeGlobalTurnover = exchangeGlobalTurnover;
            return this;
        }

        public Builder setLocalDepositeCounter(int depositeCounter) {
            this.localDepositeCount = depositeCounter;
            return this;
        }

        public Builder setLocalWithdrawCounter(int withdrawCounter) {
            this.localWithdrawCount = withdrawCounter;
            return this;
        }

        public Builder setLocalPaymentCounter(int paymentCounter) {
            this.localPaymentCount = paymentCounter;
            return this;
        }

        public Builder setDepositeCounter(int depositeCounter) {
            this.depositeCount = depositeCounter;
            return this;
        }

        public Builder setWithdrawCounter(int withdrawCounter) {
            this.withdrawCount = withdrawCounter;
            return this;
        }

        public Builder setPaymentCounter(int paymentCounter) {
            this.paymentCount = paymentCounter;
            return this;
        }

        public Builder setLocalDeposite(BigDecimal localDeposite) {
            this.localDeposite = localDeposite;
            return this;
        }

        public Builder setGlobalDeposite(BigDecimal globalDeposite) {
            this.globalDeposite = globalDeposite;
            return this;
        }

        public Builder setLocalWithdraw(BigDecimal localWithdraw) {
            this.localWithdraw = localWithdraw;
            return this;
        }

        public Builder setGlobalWithdraw(BigDecimal globalWithdraw) {
            this.globalWithdraw = globalWithdraw;
            return this;
        }

        public Builder setLocalTurnover(BigDecimal localTurnover) {
            this.localTurnover = localTurnover;
            return this;
        }

        public Builder setGlobalTurnover(BigDecimal globalTurnover) {
            this.globalTurnover = globalTurnover;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setMinCurrency(String minCurrency) {
            this.minCurrency = new BigDecimal(minCurrency);
            return this;
        }

        public Builder setOverpay(boolean overpay) {
            this.overpay = overpay;
            return this;
        }

        public PaymentMethod build() {
            return new PaymentMethod(this);
        }
    }
}

