/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm.test.ui;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Container;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import sk.singularisdev.ekasask.fm.test.ui.OverlapLayout;
import sk.singularisdev.ekasask.fm.test.ui.SwingUtils;

public class DisabledPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static DisabledEventQueue queue = new DisabledEventQueue();
    private static Map<Container, List<JComponent>> containers = new HashMap<Container, List<JComponent>>();
    int state = 0;
    Thread timer;
    private JComponent glassPane;
    private String message = "";

    public DisabledPanel(Container container) {
        this(container, null);
    }

    public DisabledPanel(Container container, Color disabledColor) {
        this.setLayout(new OverlapLayout());
        this.add(container);
        this.glassPane = new GlassPane();
        this.add(this.glassPane);
        if (disabledColor != null) {
            this.glassPane.setBackground(disabledColor);
        }
        this.setFocusTraversalPolicy(new DefaultFocusTraversalPolicy());
    }

    public void setSpinningMessage(String message) {
        this.message = message;
    }

    public Color getDisabledColor() {
        return this.glassPane.getBackground();
    }

    public void setDisabledColor(Color disabledColor) {
        this.glassPane.setBackground(disabledColor);
    }

    public JComponent getGlassPane() {
        return this.glassPane;
    }

    public void setGlassPane(JComponent glassPane) {
        this.glassPane = glassPane;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            if (this.timer != null) {
                this.timer.interrupt();
            }
            this.glassPane.setVisible(false);
            this.setFocusCycleRoot(false);
            queue.removePanel(this);
        } else {
            this.timer = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (!DisabledPanel.super.isEnabled()) {
                        try {
                            Thread.sleep(500L);
                            DisabledPanel.this.state = (DisabledPanel.this.state + 1) % 4;
                            DisabledPanel.this.repaint();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
            this.timer.start();
            this.glassPane.setVisible(true);
            this.setFocusCycleRoot(true);
            queue.addPanel(this);
        }
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    public static void disable(Container container) {
        List<JComponent> components = SwingUtils.getDescendantsOfType(JComponent.class, container, true);
        ArrayList<JComponent> enabledComponents = new ArrayList<JComponent>();
        containers.put(container, enabledComponents);
        for (JComponent component : components) {
            if (!component.isEnabled()) continue;
            enabledComponents.add(component);
            component.setEnabled(false);
        }
    }

    public static void enable(Container container) {
        List<JComponent> enabledComponents = containers.get(container);
        if (enabledComponents != null) {
            for (JComponent component : enabledComponents) {
                component.setEnabled(true);
            }
            containers.remove(container);
        }
    }

    static class DisabledEventQueue
    extends EventQueue
    implements WindowListener {
        private Map<DisabledPanel, Set<KeyStroke>> panels = new HashMap<DisabledPanel, Set<KeyStroke>>();

        DisabledEventQueue() {
        }

        public void addPanel(DisabledPanel panel) {
            Set<KeyStroke> keyStrokes = this.getKeyStrokes(panel);
            if (keyStrokes.size() == 0) {
                return;
            }
            this.panels.put(panel, keyStrokes);
            EventQueue current = Toolkit.getDefaultToolkit().getSystemEventQueue();
            if (current != this) {
                current.push(queue);
            }
            Window window = SwingUtilities.windowForComponent(panel);
            window.removeWindowListener(this);
            window.addWindowListener(this);
        }

        private Set<KeyStroke> getKeyStrokes(DisabledPanel panel) {
            HashSet<KeyStroke> keyStrokes = new HashSet<KeyStroke>();
            Container container = (Container)panel.getComponent(1);
            List<JComponent> components = SwingUtils.getDescendantsOfType(JComponent.class, container);
            for (JComponent component : components) {
                InputMap im = component.getInputMap(2);
                if (im == null || im.allKeys() == null) continue;
                KeyStroke[] keyStrokeArray = im.allKeys();
                int n = keyStrokeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    KeyStroke keyStroke = keyStrokeArray[n2];
                    keyStrokes.add(keyStroke);
                    ++n2;
                }
            }
            return keyStrokes;
        }

        public void removePanel(DisabledPanel panel) {
            if (this.panels.remove(panel) != null && this.panels.size() == 0) {
                this.pop();
            }
        }

        @Override
        protected void dispatchEvent(AWTEvent event) {
            if (event.getID() == 400 || event.getID() == 401 || event.getID() == 402) {
                KeyEvent keyEvent = (KeyEvent)event;
                KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
                for (DisabledPanel panel : this.panels.keySet()) {
                    Window panelWindow = SwingUtilities.windowForComponent(panel);
                    if (panelWindow != keyEvent.getComponent() || !this.searchForKeyBinding(panel, keyStroke)) continue;
                    return;
                }
            }
            super.dispatchEvent(event);
        }

        private boolean searchForKeyBinding(DisabledPanel panel, KeyStroke keyStroke) {
            Set<KeyStroke> keyStrokes = this.panels.get(panel);
            return keyStrokes.contains(keyStroke);
        }

        @Override
        public void windowClosed(WindowEvent e) {
            ArrayList<DisabledPanel> panelsToRemove = new ArrayList<DisabledPanel>();
            Window window = e.getWindow();
            for (DisabledPanel panel : this.panels.keySet()) {
                Window panelWindow = SwingUtilities.windowForComponent(panel);
                if (panelWindow != window) continue;
                panelsToRemove.add(panel);
            }
            for (DisabledPanel panel : panelsToRemove) {
                this.removePanel(panel);
            }
            window.removeWindowListener(this);
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }
    }

    class GlassPane
    extends JComponent {
        private static final long serialVersionUID = 1L;

        public GlassPane() {
            this.setOpaque(false);
            this.setVisible(false);
            Color base = UIManager.getColor("inactiveCaptionBorder");
            base = base == null ? Color.LIGHT_GRAY : base;
            Color background = new Color(base.getRed(), base.getGreen(), base.getBlue(), 128);
            this.setBackground(background);
            this.addMouseListener(new MouseAdapter(){});
            this.addMouseMotionListener(new MouseMotionAdapter(){});
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getSize().width, this.getSize().height);
            g.setColor(Color.BLACK);
            g.setFont(g.getFont().deriveFont(25.0f));
            FontMetrics metrics = g.getFontMetrics(g.getFont());
            g.drawString(String.valueOf(DisabledPanel.this.message) + " ...".substring(0, DisabledPanel.this.state + 1), this.getSize().width / 2 - metrics.stringWidth(DisabledPanel.this.message) / 2, this.getSize().height / 2 - metrics.getHeight() / 2);
        }
    }
}

