/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm.test.ui;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import sk.singularisdev.eKasaSK.lib.Charset;
import sk.singularisdev.eKasaSK.lib.LowLevelFMInterfaceNoControl;
import sk.singularisdev.eKasaSK.lib.Pegas06FMException;
import sk.singularisdev.eKasaSK.lib.communication.CommunicationDriver;
import sk.singularisdev.eKasaSK.lib.communication.TcpDriverSwHandshake;
import sk.singularisdev.ekasask.fm.config.Config;
import sk.singularisdev.ekasask.fm.enums.Commands;
import sk.singularisdev.ekasask.fm.interfaces.GUIThreadListener;

public class GUIParserRunnable
implements Runnable {
    private File file;
    private Config config;
    private LowLevelFMInterfaceNoControl fmInterface;
    private GUIThreadListener listener;

    public GUIParserRunnable(Config config, File file, GUIThreadListener listener) {
        this.config = config.clone();
        this.file = file;
        this.listener = listener;
    }

    private synchronized void processCommands(ArrayList<String> commands, String fileName) {
        StringBuilder resultInfo = new StringBuilder();
        try {
            boolean error = false;
            for (String command : commands) {
                String data = null;
                String[] parsedCommands = command.split(":", 2);
                Commands eCommand = Commands.fromString(parsedCommands[0]);
                if (eCommand != null) {
                    if (!error) {
                        String[] params = parsedCommands[1].split(";");
                        try {
                            block3 : switch (eCommand) {
                                case sellingDayBegin: {
                                    this.fmInterface.sellingDayBegin(1, params[0]);
                                    break;
                                }
                                case printReport: {
                                    this.fmInterface.printReport(1, params[0], params[1]);
                                    break;
                                }
                                case paragonBegin: {
                                    if (params.length == 6) {
                                        this.fmInterface.paragonBegin(1, params[0], params[1], params[2], params[3], params[4], params[5], null);
                                        break;
                                    }
                                    this.fmInterface.paragonBegin(1, params[0], params[1], params[2], params[3], params[4], params[5], params[6]);
                                    break;
                                }
                                case paragonEnd: {
                                    this.fmInterface.paragonEnd(1, params[0], params[1]);
                                    break;
                                }
                                case itemSale: {
                                    this.fmInterface.itemSale(1, params[0], params[1], params[2], params[3], params[4], params[5], params[6]);
                                    break;
                                }
                                case itemVoid: {
                                    this.fmInterface.itemVoid(1, params[0], params[1], params[2], params[3], params[4], params[5], params[6], params[7]);
                                    break;
                                }
                                case itemReturn: {
                                    this.fmInterface.itemReturn(1, params[0], params[1], params[2], params[3], params[4], params[5], params[6], params[7]);
                                    break;
                                }
                                case itemNegative: {
                                    this.fmInterface.itemNegative(1, params[0], params[1], params[2], params[3], params[4], params[5], params[6]);
                                    break;
                                }
                                case depositeInDrawer: {
                                    this.fmInterface.depositeInDrawer(1, params[0], params[1], params[2], params[3], params[4]);
                                    break;
                                }
                                case destroyParagon: {
                                    this.fmInterface.destroyParagon(1, params[0], params[1]);
                                    break;
                                }
                                case freeId: {
                                    this.fmInterface.freeID(1, params[0], params[1]);
                                    break;
                                }
                                case getVariable: {
                                    data = this.fmInterface.getVariable(1, params[0]);
                                    break;
                                }
                                case itemDiscount: {
                                    this.fmInterface.itemDiscount(1, params[0], params[1], params[2], params[3], params[4]);
                                    break;
                                }
                                case itemDiscount2: {
                                    this.fmInterface.itemDiscount2(1, params[0], params[1], params[2], params[3], params[4], params[5]);
                                    break;
                                }
                                case payment: {
                                    this.fmInterface.payment(1, params[0], params[1], params[2], params[3], params[4], params[5]);
                                    break;
                                }
                                case payment2: {
                                    this.fmInterface.payment2(1, params[0], params[1], params[2], params[3], params[4], params[5], params[6]);
                                    break;
                                }
                                case printAnnouncement: {
                                    this.fmInterface.printAnnouncement(1, params[0], params[1]);
                                    break;
                                }
                                case printAnnouncementNF: {
                                    this.fmInterface.printAnnouncementNF(1, params[0], params[1]);
                                    break;
                                }
                                case printBC: {
                                    this.fmInterface.printBC(1, params[0], params[1]);
                                    break;
                                }
                                case printIssuedParagon: {
                                    this.fmInterface.printIssuedParagon(1, params[0], params[1]);
                                    break;
                                }
                                case printQRCode: {
                                    this.fmInterface.printQrCode(1, params[0]);
                                    break;
                                }
                                case setBCParm: {
                                    this.fmInterface.setBCparm(1, params[0], params[1], params[2], params[3]);
                                    break;
                                }
                                case setClientID: {
                                    this.fmInterface.setClientID(1, params[0], params[1]);
                                    break;
                                }
                                case setHeader: {
                                    this.fmInterface.setHeader(1, params[0], params[1], params[2]);
                                    break;
                                }
                                case setLocation: {
                                    switch (Integer.parseInt(params[0])) {
                                        case 0: {
                                            this.fmInterface.setLocation(1, params[0], new String[]{params[1], params[2]});
                                            break block3;
                                        }
                                        case 1: {
                                            this.fmInterface.setLocation(1, params[0], new String[]{params[1], params[2], params[3], params[4], params[5]});
                                            break block3;
                                        }
                                        case 2: {
                                            this.fmInterface.setLocation(1, params[0], new String[]{params[1]});
                                            break block3;
                                        }
                                    }
                                    throw new Pegas06FMException(96);
                                }
                                case setPostline: {
                                    this.fmInterface.setPreline(1, params[0]);
                                    break;
                                }
                                case setPreline: {
                                    this.fmInterface.setPostline(1, params[0]);
                                    break;
                                }
                                case setQRParm: {
                                    this.fmInterface.setQrParm(1, params[0], params[1], params[2], params[3], params[4]);
                                    break;
                                }
                                case subTotal: {
                                    this.fmInterface.subTotal(1, params[0], params[1], params[2]);
                                    break;
                                }
                                case subTotalDiscount: {
                                    this.fmInterface.subTotalDiscount(1, params[0], params[1], params[2], params[3], params[4]);
                                    break;
                                }
                                case subTotalDiscount2: {
                                    this.fmInterface.subTotalDiscount2(1, params[0], params[1], params[2], params[3], params[4], params[5]);
                                    break;
                                }
                                case odpocitanaZaloha: {
                                    this.fmInterface.odpocitanaZaloha(1, params[0], params[1], params[2], params[3]);
                                    break;
                                }
                                case popis0DPH: {
                                    this.fmInterface.popis0DPH(1, Integer.parseInt(params[0]));
                                    break;
                                }
                                case printUnsentSFSPackets: {
                                    this.fmInterface.printUnsentSFSpackets(1);
                                    break;
                                }
                                case sendUnsentSFSPackets: {
                                    this.fmInterface.sendUnsentSFSpackets(1);
                                    break;
                                }
                                case setAdditionalFooter: {
                                    this.fmInterface.setAdditionalFooter(1, params[0]);
                                    break;
                                }
                                case setAdditionalHeader: {
                                    this.fmInterface.setAdditionalHeader(1, params[0]);
                                    break;
                                }
                                case setAutKey: {
                                    this.fmInterface.setAutKey(1, params[0], params[1]);
                                    break;
                                }
                                case setSubjectIDData: {
                                    this.fmInterface.setSubjectIDData(1, params[0]);
                                    break;
                                }
                                case setEmail: {
                                    this.fmInterface.setEmail(1, params[0]);
                                    break;
                                }
                                case setInvoiceNumber: {
                                    this.fmInterface.setInvoiceNumber(1, params[0]);
                                    break;
                                }
                                case setParameter: {
                                    this.fmInterface.setParameter(1, params[0], params[1], params[2]);
                                    break;
                                }
                                case setPParameter: {
                                    this.fmInterface.setPParameter(1, params[0], params[1], params[2]);
                                    break;
                                }
                                case setPCHDU: {
                                    this.fmInterface.setPCHDU(1, params[0], params[1]);
                                    break;
                                }
                                case setPrinterType: {
                                    this.fmInterface.setPrinterType(1, params[0], params[1], params[2]);
                                    break;
                                }
                                case setPRNBd: {
                                    this.fmInterface.setPRNBd(1, params[0]);
                                    break;
                                }
                                case setSellerID: {
                                    this.fmInterface.setSellerID(1, params[0], Integer.parseInt(params[0]));
                                    break;
                                }
                                case setSMTP: {
                                    this.fmInterface.setSMTP(1, Integer.parseInt(params[0]), params[1], Integer.parseInt(params[2]), params[3]);
                                    break;
                                }
                                case setTransactionID: {
                                    this.fmInterface.setTransactionID(1, params[0]);
                                    break;
                                }
                                case setVAT48: {
                                    this.fmInterface.setV48(1, params[0], params[1]);
                                    break;
                                }
                                case setVAT: {
                                    this.fmInterface.setVAT(1, params[0], params[1], params[2], params[3]);
                                    break;
                                }
                                case getParagonIDs: {
                                    data = this.fmInterface.getParagonIDs(1, params[0], params[1]);
                                    break;
                                }
                                case vymenaPoukazu: {
                                    this.fmInterface.vymenaPoukazu(1, params[0], params[1], params[2], params[3], params[4]);
                                    break;
                                }
                                case opravaDokladu: {
                                    this.fmInterface.opravaDokladu(1, params[0]);
                                    break;
                                }
                                case resetState: {
                                    this.fmInterface.executionCommand(1, -3, params);
                                    break;
                                }
                                case stopParser: {
                                    break;
                                }
                                case repeatParagon: {
                                    this.fmInterface.repeatParagon(1);
                                    break;
                                }
                                case setDispF: {
                                    if (params.length == 3) {
                                        this.fmInterface.setDispF(1, params[0], params[1], params[2], "");
                                        break;
                                    }
                                    this.fmInterface.setDispF(1, params[0], params[1], params[2], params[3]);
                                    break;
                                }
                                case clearDisplay: {
                                    this.fmInterface.clearDisplay(1, params[0], "");
                                    break;
                                }
                                case printDisplay: {
                                    this.fmInterface.printDisplay(1, params[0], params[1], params[2]);
                                    break;
                                }
                            }
                            resultInfo.append("0/").append(command).append("\r\n");
                            if (data == null) continue;
                            resultInfo.append(">").append(data).append("\r\n");
                        }
                        catch (Pegas06FMException e) {
                            error = true;
                            resultInfo.append(e.getErrorCode()).append("/").append(command).append("\r\n");
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            error = true;
                            resultInfo.append(32).append("/").append(command).append("\r\n");
                        }
                        continue;
                    }
                    resultInfo.append("-9999/").append(command).append("\r\n");
                    continue;
                }
                error = true;
                resultInfo.append(52).append("/").append(command).append("\r\n");
            }
            if (error) {
                resultInfo.append("99/");
            } else {
                resultInfo.append("00/");
            }
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(String.valueOf(this.config.getPath()) + "/" + fileName + ".result")));
            writer.write(resultInfo.toString());
            writer.close();
        }
        catch (Exception e) {
            try {
                this.fmInterface.closePort();
            }
            catch (Pegas06FMException e1) {
                e1.printStackTrace();
            }
            resultInfo.append("99/");
        }
    }

    @Override
    public void run() {
        try {
            String line;
            ArrayList<String> rows = new ArrayList<String>();
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(String.valueOf(this.config.getPath()) + "/" + this.file.getName())));
            while ((line = reader.readLine()) != null) {
                rows.add(line);
            }
            reader.close();
            if (this.fmInterface == null) {
                this.fmInterface = new LowLevelFMInterfaceNoControl((CommunicationDriver)new TcpDriverSwHandshake("127.0.0.1", this.config.getSuperserverPort()));
            }
            if (!this.fmInterface.isPortInitialized()) {
                this.fmInterface.openPort();
            }
            this.fmInterface.setCharset(Charset.CP1250);
            this.processCommands(rows, this.file.getName());
            this.fmInterface.closePort();
            this.listener.processFinished(true);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Pegas06FMException e) {
            e.printStackTrace();
        }
    }
}

