/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.client.application;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Date;
import sk.singularisdev.ekasask.client.application.Configuration;
import sk.singularisdev.ekasask.client.application.Controller;
import sk.singularisdev.ekasask.client.packet.AbstractPacketRequest;
import sk.singularisdev.ekasask.client.packet.AbstractPacketResponse;
import sk.singularisdev.ekasask.client.packet.CfgQuorionBridgeResponse;
import sk.singularisdev.ekasask.client.packet.ChduConnectRequest;
import sk.singularisdev.ekasask.client.packet.ChduConnectResponse;
import sk.singularisdev.ekasask.client.packet.ChduDisconnectRequest;
import sk.singularisdev.ekasask.client.packet.ChduDisconnectResponse;
import sk.singularisdev.ekasask.client.packet.GetCertificateValidResponse;
import sk.singularisdev.ekasask.client.packet.GetChduInfoResponse;
import sk.singularisdev.ekasask.client.packet.GetChduStateResponse;
import sk.singularisdev.ekasask.client.packet.GetPpekkInfoResponse;
import sk.singularisdev.ekasask.client.packet.GetPpekkRs232PortResponse;
import sk.singularisdev.ekasask.client.packet.GetUnsendedMessageResponse;
import sk.singularisdev.ekasask.client.packet.LoadPacketFromChduResponse;
import sk.singularisdev.ekasask.client.packet.PrintLastReceiptCopyMessageResponse;
import sk.singularisdev.ekasask.client.packet.PrintUnsendedMessageResponse;
import sk.singularisdev.ekasask.client.packet.SendUnsendedMessageResponse;
import sk.singularisdev.ekasask.client.packet.SendUpgradeResponse;
import sk.singularisdev.ekasask.client.packet.SetAuthenticationResponse;
import sk.singularisdev.ekasask.client.packet.SetChduPortResponse;
import sk.singularisdev.ekasask.client.packet.SetIdentityResponse;
import sk.singularisdev.ekasask.client.packet.SetProxyResponse;
import sk.singularisdev.ekasask.client.packet.SynchronizeResponse;
import sk.singularisdev.ekasask.client.packet.TestReceiptResponse;
import sk.singularisdev.ekasask.client.server.Server;

public class CommunicationClient {
    private Socket socket = null;
    private String serverAddress;
    private int serverPort;
    private InputStream inputStream;
    private OutputStream outputStream;
    private Controller controller;

    public CommunicationClient(Controller controller) {
        this.controller = controller;
    }

    public void connect() {
        try {
            this.socket = new Socket(this.serverAddress, this.serverPort);
            this.outputStream = this.socket.getOutputStream();
            this.inputStream = this.socket.getInputStream();
            this.outputStream.write(Server.INIT_SEQUENCE);
            this.outputStream.flush();
            if (this.inputStream.read() == 6) {
                this.controller.serverConnected(true);
            } else {
                this.controller.serverConnected(false);
            }
            this.controller.serverConnected(true);
        }
        catch (Exception ignore) {
            this.socket = null;
            this.controller.serverConnected(false);
        }
    }

    public void setConfiguration(Configuration configuration) {
        if (this.isConnected()) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.socket = null;
        }
        this.serverAddress = configuration.getServerAddress();
        this.serverPort = configuration.getServerPort();
    }

    public boolean isConnected() {
        if (this.socket == null) {
            this.controller.serverConnected(false);
            return false;
        }
        if (this.socket.isClosed()) {
            this.controller.serverConnected(false);
            return false;
        }
        this.controller.serverConnected(true);
        return true;
    }

    public synchronized AbstractPacketResponse send(AbstractPacketRequest request) throws Exception {
        System.out.println(new Date() + request.getClass().getName());
        try {
            ByteBuffer bBuff = ByteBuffer.allocate(4);
            bBuff.order(ByteOrder.LITTLE_ENDIAN);
            byte[] command = request.getCommand();
            this.outputStream.write(command);
            this.outputStream.write((int)request.getPpekkId());
            byte[] d = request.serializeParam();
            byte[] bLength = bBuff.putInt(d.length).array();
            this.outputStream.write(bLength);
            this.outputStream.write(d);
            this.outputStream.flush();
            byte ack = (byte)this.inputStream.read();
            if (ack == 6) {
                int l = this.read(command);
                if (l != 2) {
                    throw new Exception();
                }
                int ppekkId = this.inputStream.read();
                l = this.read(bLength);
                if (l != 4) {
                    throw new Exception();
                }
                bBuff = ByteBuffer.wrap(bLength);
                bBuff.order(ByteOrder.LITTLE_ENDIAN);
                int dataLen = bBuff.getInt();
                byte[] data = new byte[dataLen];
                l = this.read(data);
                if (l != dataLen) {
                    throw new Exception();
                }
                AbstractPacketResponse packet = null;
                if (Arrays.equals(command, SetAuthenticationResponse.COMMAND)) {
                    packet = SetAuthenticationResponse.getInstance(ppekkId, data);
                } else if (Arrays.equals(command, SetIdentityResponse.COMMAND)) {
                    packet = SetIdentityResponse.getInstance(ppekkId, data);
                } else if (Arrays.equals(command, GetChduInfoResponse.COMMAND)) {
                    packet = GetChduInfoResponse.getInstance(ppekkId, data);
                } else if (Arrays.equals(command, GetPpekkInfoResponse.COMMAND)) {
                    packet = GetPpekkInfoResponse.getInstance(ppekkId, data);
                } else if (Arrays.equals(command, GetUnsendedMessageResponse.COMMAND)) {
                    packet = GetUnsendedMessageResponse.getInstance(ppekkId, data);
                } else if (Arrays.equals(command, GetCertificateValidResponse.COMMAND)) {
                    packet = GetCertificateValidResponse.getInstance(ppekkId, data);
                } else if (Arrays.equals(command, PrintUnsendedMessageResponse.COMMAND)) {
                    packet = PrintUnsendedMessageResponse.getInstance(ppekkId, data);
                } else if (Arrays.equals(command, SendUnsendedMessageResponse.COMMAND)) {
                    packet = SendUnsendedMessageResponse.getInstance(ppekkId, data);
                } else if (Arrays.equals(command, GetPpekkRs232PortResponse.COMMAND)) {
                    packet = GetPpekkRs232PortResponse.getInstance(ppekkId, data);
                } else if (Arrays.equals(command, SetChduPortResponse.COMMAND)) {
                    packet = SetChduPortResponse.getInstance(ppekkId, data);
                } else if (Arrays.equals(command, SynchronizeResponse.COMMAND)) {
                    packet = SynchronizeResponse.getInstance(ppekkId, data);
                } else if (Arrays.equals(command, GetChduStateResponse.COMMAND)) {
                    packet = GetChduStateResponse.getInstance(ppekkId, data);
                } else if (Arrays.equals(command, SendUpgradeResponse.COMMAND)) {
                    packet = SendUpgradeResponse.getInstance(ppekkId, data);
                } else if (Arrays.equals(command, PrintLastReceiptCopyMessageResponse.COMMAND)) {
                    packet = PrintLastReceiptCopyMessageResponse.getInstance(ppekkId, data);
                } else if (Arrays.equals(command, SetProxyResponse.COMMAND)) {
                    packet = SetProxyResponse.getInstance(ppekkId, data);
                } else if (Arrays.equals(command, LoadPacketFromChduResponse.COMMAND)) {
                    packet = LoadPacketFromChduResponse.getInstance(ppekkId, data);
                } else if (Arrays.equals(command, CfgQuorionBridgeResponse.COMMAND)) {
                    packet = CfgQuorionBridgeResponse.getInstance(ppekkId, data);
                } else if (Arrays.equals(command, TestReceiptResponse.COMMAND)) {
                    packet = TestReceiptResponse.getInstance(ppekkId, data);
                } else if (Arrays.equals(command, ChduConnectRequest.COMMAND)) {
                    packet = ChduConnectResponse.getInstance(ppekkId);
                } else if (Arrays.equals(command, ChduDisconnectRequest.COMMAND)) {
                    packet = ChduDisconnectResponse.getInstance(ppekkId);
                }
                if (packet == null) {
                    throw new Exception();
                }
                return packet;
            }
            throw new Exception();
        }
        catch (Exception e) {
            if (this.socket != null) {
                this.socket.close();
            }
            throw e;
        }
    }

    private int read(byte[] data) throws IOException {
        int pos = 0;
        int l = data.length;
        while (pos < l) {
            pos += this.inputStream.read(data, pos, data.length - pos);
        }
        return pos;
    }
}

