/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.client.application;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;
import sk.singularisdev.ekasask.client.application.Controller;
import sk.singularisdev.ekasask.client.localization.Localization;

public class ConfigWindow
extends JFrame {
    private JPanel contentPaneX;
    private JComboBox activeDeviceBox;
    private JTextField addressField;
    private JTextField portField;

    public ConfigWindow(final Controller controller) {
        this.setBounds(100, 100, 540, 362);
        this.contentPaneX = new JPanel();
        this.contentPaneX.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.contentPaneX.setBackground(new Color(228, 228, 230));
        this.contentPaneX.setLayout(new BoxLayout(this.contentPaneX, 0));
        this.setContentPane(this.contentPaneX);
        JPanel contentPaneY = new JPanel();
        contentPaneY.setBackground(this.contentPaneX.getBackground());
        contentPaneY.setLayout(new BoxLayout(contentPaneY, 1));
        this.contentPaneX.add(contentPaneY);
        JPanel addressPanel = new JPanel();
        contentPaneY.add(addressPanel);
        addressPanel.setPreferredSize(new Dimension(addressPanel.getSize().width, 24));
        addressPanel.setBackground(this.contentPaneX.getBackground());
        addressPanel.setLayout(new BoxLayout(addressPanel, 0));
        JLabel addressLabel = new JLabel(Localization.getString("client.config.address"));
        addressLabel.setPreferredSize(new Dimension(175, addressLabel.getSize().height));
        addressPanel.add(addressLabel);
        this.addressField = new JTextField();
        this.addressField.setColumns(10);
        addressPanel.add(this.addressField);
        JPanel portPanel = new JPanel();
        contentPaneY.add(portPanel);
        portPanel.setPreferredSize(new Dimension(portPanel.getSize().width, 24));
        portPanel.setBackground(this.contentPaneX.getBackground());
        portPanel.setLayout(new BoxLayout(portPanel, 0));
        JLabel portLabel = new JLabel(Localization.getString("client.config.port"));
        portLabel.setPreferredSize(new Dimension(175, portLabel.getSize().height));
        portPanel.add(portLabel);
        this.portField = new JTextField();
        this.portField.setColumns(10);
        portPanel.add(this.portField);
        JPanel devicesPanel = new JPanel();
        contentPaneY.add(devicesPanel);
        devicesPanel.setBackground(this.contentPaneX.getBackground());
        GridBagLayout gbl_devicesPanel = new GridBagLayout();
        gbl_devicesPanel.columnWidths = new int[]{(this.getWidth() - 92) / 2, 64, (this.getWidth() - 92) / 2};
        gbl_devicesPanel.rowHeights = new int[]{205};
        gbl_devicesPanel.columnWeights = new double[]{0.0, 0.0, 0.0};
        gbl_devicesPanel.rowWeights = new double[]{0.0};
        devicesPanel.setLayout(gbl_devicesPanel);
        JPanel fullListPanel = new JPanel();
        fullListPanel.setBackground(this.contentPaneX.getBackground());
        GridBagConstraints gbc_fullListPanel = new GridBagConstraints();
        gbc_fullListPanel.fill = 1;
        gbc_fullListPanel.gridx = 0;
        gbc_fullListPanel.gridy = 0;
        devicesPanel.add((Component)fullListPanel, gbc_fullListPanel);
        fullListPanel.setLayout(new BoxLayout(fullListPanel, 0));
        JScrollPane sp = new JScrollPane();
        fullListPanel.add(sp);
        DefaultListModel<Integer> deviceList = new DefaultListModel<Integer>();
        int i = 1;
        while (i < 256) {
            deviceList.addElement(i);
            ++i;
        }
        final JList fullList = new JList(deviceList);
        sp.setViewportView(fullList);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setBackground(this.contentPaneX.getBackground());
        GridBagConstraints gbc_buttonsPanel = new GridBagConstraints();
        gbc_buttonsPanel.fill = 1;
        gbc_buttonsPanel.gridx = 1;
        gbc_buttonsPanel.gridy = 0;
        devicesPanel.add((Component)buttonsPanel, gbc_buttonsPanel);
        buttonsPanel.setLayout(null);
        JButton removeAllButton = new JButton("<<");
        removeAllButton.setFont(new Font("Tahoma", 0, 10));
        removeAllButton.setBounds(16, 24, 32, 32);
        removeAllButton.setMargin(new Insets(0, 0, 0, 0));
        removeAllButton.setBackground(this.contentPaneX.getBackground());
        buttonsPanel.add(removeAllButton);
        JButton removeButton = new JButton("<");
        removeButton.setFont(new Font("Tahoma", 0, 10));
        removeButton.setBounds(16, 58, 32, 32);
        removeButton.setMargin(new Insets(0, 0, 0, 0));
        removeButton.setBackground(this.contentPaneX.getBackground());
        buttonsPanel.add(removeButton);
        JButton addButton = new JButton(">");
        addButton.setFont(new Font("Tahoma", 0, 10));
        addButton.setBounds(16, 123, 32, 32);
        addButton.setMargin(new Insets(0, 0, 0, 0));
        addButton.setBackground(this.contentPaneX.getBackground());
        buttonsPanel.add(addButton);
        JButton addAllButton = new JButton(">>");
        addAllButton.setFont(new Font("Tahoma", 0, 10));
        addAllButton.setBounds(16, 157, 32, 32);
        addAllButton.setMargin(new Insets(0, 0, 0, 0));
        addAllButton.setBackground(this.contentPaneX.getBackground());
        buttonsPanel.add(addAllButton);
        JPanel selectedListPanel = new JPanel();
        selectedListPanel.setBackground(this.contentPaneX.getBackground());
        GridBagConstraints gbc_selectedListPanel = new GridBagConstraints();
        gbc_selectedListPanel.fill = 1;
        gbc_selectedListPanel.gridx = 2;
        gbc_selectedListPanel.gridy = 0;
        devicesPanel.add((Component)selectedListPanel, gbc_selectedListPanel);
        selectedListPanel.setLayout(new BoxLayout(selectedListPanel, 0));
        JScrollPane sp2 = new JScrollPane();
        selectedListPanel.add(sp2);
        final JList selectedList = new JList();
        selectedList.setBounds(0, 0, 204, 205);
        sp2.setViewportView(selectedList);
        JPanel activeDevicePanel = new JPanel();
        activeDevicePanel.setPreferredSize(new Dimension(activeDevicePanel.getSize().width, 24));
        activeDevicePanel.setBackground(this.contentPaneX.getBackground());
        activeDevicePanel.setLayout(null);
        contentPaneY.add(activeDevicePanel);
        this.activeDeviceBox = new JComboBox();
        this.activeDeviceBox.setBounds(0, 0, 100, 24);
        this.activeDeviceBox.removeAllItems();
        activeDevicePanel.add(this.activeDeviceBox);
        Component verticalStrut = Box.createVerticalStrut(2);
        contentPaneY.add(verticalStrut);
        JPanel controlPanel = new JPanel();
        controlPanel.setPreferredSize(new Dimension(controlPanel.getSize().width, 24));
        controlPanel.setBackground(this.contentPaneX.getBackground());
        controlPanel.setLayout(null);
        contentPaneY.add(controlPanel);
        JButton applyChanges = new JButton(Localization.getString("client.config.apply"));
        applyChanges.setBounds(0, 0, 100, 24);
        applyChanges.setBackground(this.contentPaneX.getBackground());
        controlPanel.add(applyChanges);
        removeAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectedList.setModel(new DefaultListModel());
                ConfigWindow.this.syncDeviceBox(selectedList.getModel());
            }
        });
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (selectedList.isSelectionEmpty()) {
                    return;
                }
                DefaultListModel model = (DefaultListModel)selectedList.getModel();
                model.removeElementAt(selectedList.getSelectedIndex());
                selectedList.setModel(model);
                ConfigWindow.this.syncDeviceBox(model);
            }
        });
        addAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultListModel<Integer> model = new DefaultListModel<Integer>();
                int i = 1;
                while (i < 256) {
                    model.addElement(i);
                    ++i;
                }
                selectedList.setModel(model);
                ConfigWindow.this.syncDeviceBox(model);
            }
        });
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (fullList.isSelectionEmpty() || ConfigWindow.this.modelContainsElement(selectedList.getModel(), (Integer)fullList.getSelectedValue())) {
                    return;
                }
                DefaultListModel model = (DefaultListModel)selectedList.getModel();
                model.addElement(fullList.getSelectedValue());
                selectedList.setModel(model);
                ConfigWindow.this.syncDeviceBox(model);
            }
        });
        applyChanges.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ListModel model = selectedList.getModel();
                    int[] devices = new int[model.getSize()];
                    int i = 0;
                    while (i < model.getSize()) {
                        devices[i] = (Integer)model.getElementAt(i);
                        ++i;
                    }
                    controller.setConfiguration(ConfigWindow.this.addressField.getText(), Integer.parseInt(ConfigWindow.this.portField.getText()), devices, (Integer)ConfigWindow.this.activeDeviceBox.getSelectedItem() == null ? 0 : (Integer)ConfigWindow.this.activeDeviceBox.getSelectedItem());
                    ConfigWindow.this.setVisible(false);
                    ConfigWindow.this.dispose();
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(null, Localization.getString("client.config.invalid_port_message"), Localization.getString("client.config.invalid_port_title"), 2);
                    return;
                }
            }
        });
        this.syncWindowData(selectedList, controller);
        this.setVisible(true);
    }

    private void syncWindowData(JList list, Controller controller) {
        this.addressField.setText(controller.getConfiguration().getServerAddress());
        this.portField.setText("" + controller.getConfiguration().getServerPort());
        list.removeAll();
        Integer[] devices = new Integer[controller.getConfiguration().getDevices().length];
        int i = 0;
        while (i < controller.getConfiguration().getDevices().length) {
            devices[i] = controller.getConfiguration().getDevices()[i];
            ++i;
        }
        Arrays.sort(devices, new Comparator<Integer>(){

            @Override
            public int compare(Integer x, Integer y) {
                return x - y;
            }
        });
        DefaultListModel<Integer> model = new DefaultListModel<Integer>();
        Integer[] integerArray = devices;
        int n = devices.length;
        int n2 = 0;
        while (n2 < n) {
            int device = integerArray[n2];
            model.addElement(device);
            ++n2;
        }
        list.setModel(model);
        this.syncDeviceBox(list.getModel());
        this.activeDeviceBox.setSelectedItem(controller.getConfiguration().getActiveDevice());
    }

    private void syncDeviceBox(ListModel model) {
        this.activeDeviceBox.removeAllItems();
        int[] devices = new int[model.getSize()];
        int i = 0;
        while (i < model.getSize()) {
            devices[i] = (Integer)model.getElementAt(i);
            ++i;
        }
        int[] nArray = devices;
        int n = devices.length;
        int n2 = 0;
        while (n2 < n) {
            int device = nArray[n2];
            this.activeDeviceBox.addItem(device);
            ++n2;
        }
    }

    private <T> boolean modelContainsElement(ListModel model, T element) {
        int i = 0;
        while (i < model.getSize()) {
            if (element.equals(model.getElementAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

