/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.client.application;

import java.io.File;
import sk.singularisdev.eKasaSK.lib.Charset;
import sk.singularisdev.eKasaSK.lib.LowLevelFMInterface;
import sk.singularisdev.eKasaSK.lib.Pegas06FMException;
import sk.singularisdev.eKasaSK.lib.communication.CommunicationDriver;
import sk.singularisdev.eKasaSK.lib.communication.TcpDriverSwHandshake;
import sk.singularisdev.ekasask.client.utils.FileUtil;

public class FiscalModule {
    private static final String PASSWORD = "Pegas006";
    private int deviceId;
    private CommunicationDriver communicationDriver;
    private LowLevelFMInterface fmInterface;

    public FiscalModule(String ip, int port, int deviceId) {
        this.deviceId = deviceId;
        this.communicationDriver = new TcpDriverSwHandshake(ip, port);
        this.fmInterface = new LowLevelFMInterface(this.communicationDriver);
        this.fmInterface.setCharset(Charset.CP1250);
    }

    public void setPrinterType(int printerType, int connectionType) throws Pegas06FMException {
        this.fmInterface.openPort();
        this.fmInterface.setPrinterType(this.deviceId, PASSWORD, printerType, connectionType);
        this.fmInterface.closePort();
    }

    public void setDisplay(int displayType, int displayConnection, int displayBaudrate) throws Pegas06FMException {
        this.fmInterface.openPort();
        this.fmInterface.setDispF(this.deviceId, PASSWORD, displayType, displayConnection, "" + displayBaudrate);
        this.fmInterface.closePort();
    }

    public void setParams(boolean vatPayer) throws Pegas06FMException {
        this.fmInterface.openPort();
        this.fmInterface.setParameter(this.deviceId, PASSWORD, 0, vatPayer ? 0 : 1);
        this.fmInterface.closePort();
    }

    public void printReport(char reportType, int reportNumber) throws Pegas06FMException {
        this.fmInterface.openPort();
        this.fmInterface.printReport(this.deviceId, reportType, reportNumber);
        this.fmInterface.closePort();
    }

    public void setVat(char vat, int vatValue, int type) throws Pegas06FMException {
        this.fmInterface.openPort();
        this.fmInterface.setVAT(this.deviceId, PASSWORD, vat, (long)vatValue, (long)type);
        this.fmInterface.closePort();
    }

    public void setPayment(int index, String name, double minCoin, boolean overpay) throws Pegas06FMException {
        this.fmInterface.openPort();
        this.fmInterface.setPaymentType2(this.deviceId, name, index, minCoin, overpay);
        this.fmInterface.closePort();
    }

    public void setHeader(String header1, String header2, String header3, String header4, String header5, String header6) throws Pegas06FMException {
        this.fmInterface.openPort();
        this.fmInterface.setHeader(this.deviceId, PASSWORD, 1, header1);
        this.fmInterface.setHeader(this.deviceId, PASSWORD, 2, header2);
        this.fmInterface.setHeader(this.deviceId, PASSWORD, 3, header3);
        this.fmInterface.setHeader(this.deviceId, PASSWORD, 4, header4);
        this.fmInterface.setHeader(this.deviceId, PASSWORD, 5, header5);
        this.fmInterface.setHeader(this.deviceId, PASSWORD, 6, header6);
        this.fmInterface.closePort();
    }

    public String getVariable(String variableCode) throws Pegas06FMException {
        this.fmInterface.openPort();
        String rVal = this.fmInterface.getVariable(this.deviceId, variableCode);
        this.fmInterface.closePort();
        return rVal;
    }

    public void printTestParagon() throws Pegas06FMException {
        this.fmInterface.openPort();
        this.fmInterface.paragonBegin(this.deviceId, 0, 4, 0, 0, 0, 0);
        this.fmInterface.itemSale(this.deviceId, 1, "Nanuk", 136L, 'A', 1000L, 136L, "Ks");
        this.fmInterface.payment(this.deviceId, 2, 16, 0L, 0L, 0L, "Hotovos\u0165");
        this.fmInterface.paragonEnd(this.deviceId, 3, 0);
        this.fmInterface.closePort();
    }

    public void destroyParagon() throws Pegas06FMException {
        this.fmInterface.openPort();
        String[] var = this.fmInterface.getVariable(this.deviceId, "F11").split(";");
        if (Integer.parseInt(var[5]) == 10) {
            this.fmInterface.destroyParagon(this.deviceId, Integer.parseInt(var[4]), "");
        } else {
            this.fmInterface.destroyParagon(this.deviceId, Integer.parseInt(var[4]), "");
        }
        this.fmInterface.closePort();
    }

    public void loadGHNV(int i, int leftSpacing1, String txtLogo1, int leftSpacing2, String txtLogo2, int leftSpacing3, String txtLogo3, int leftSpacing4, String txtLogo4, int leftSpacing5, String txtLogo5, int leftSpacing6, String txtLogo6) throws Exception {
        this.fmInterface.openPort();
        int count = this.loadLogosToMemory(txtLogo1, txtLogo2, txtLogo3, txtLogo4, txtLogo5, txtLogo6, false);
        this.fmInterface.loadGHNV(this.deviceId, count, leftSpacing1, leftSpacing2, leftSpacing3, leftSpacing4, leftSpacing5, leftSpacing6);
        this.fmInterface.closePort();
    }

    private int loadLogosToMemory(String txtLogo1, String txtLogo2, String txtLogo3, String txtLogo4, String txtLogo5, String txtLogo6, boolean inverse) throws Exception {
        int logoCount = 0;
        if (!txtLogo1.equals("")) {
            File file = new File(txtLogo1);
            byte[] data = FileUtil.getBytesFromFile(file);
            this.fmInterface.prepareGraphicHeader(1, data, inverse);
            ++logoCount;
            if (!txtLogo2.equals("")) {
                file = new File(txtLogo2);
                data = FileUtil.getBytesFromFile(file);
                this.fmInterface.prepareGraphicHeader(2, data, inverse);
                ++logoCount;
                if (!txtLogo3.equals("")) {
                    file = new File(txtLogo3);
                    data = FileUtil.getBytesFromFile(file);
                    this.fmInterface.prepareGraphicHeader(3, data, inverse);
                    ++logoCount;
                    if (!txtLogo4.equals("")) {
                        file = new File(txtLogo4);
                        data = FileUtil.getBytesFromFile(file);
                        this.fmInterface.prepareGraphicHeader(4, data, inverse);
                        ++logoCount;
                        if (!txtLogo5.equals("")) {
                            file = new File(txtLogo5);
                            data = FileUtil.getBytesFromFile(file);
                            this.fmInterface.prepareGraphicHeader(5, data, inverse);
                            ++logoCount;
                            if (!txtLogo6.equals("")) {
                                file = new File(txtLogo6);
                                data = FileUtil.getBytesFromFile(file);
                                this.fmInterface.prepareGraphicHeader(6, data, inverse);
                                ++logoCount;
                            }
                        }
                    }
                }
            }
        }
        return logoCount;
    }
}

