/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.client.application;

import java.awt.Image;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.net.URL;
import javax.swing.ImageIcon;
import sk.singularisdev.ekasask.client.application.AbstractTrayIcon;
import sk.singularisdev.ekasask.client.application.Controller;
import sk.singularisdev.ekasask.client.application.TrayPopupMenuAWT;
import sk.singularisdev.ekasask.client.application.TrayPopupMenuInterface;

public class TrayIconAWT
extends AbstractTrayIcon {
    private static final String SERVER_ICON_FILE_NAME_CONNECTED = "/sk/singularisdev/ekasask/client/application/systray_connected.png";
    private static final String SERVER_ICON_FILE_NAME_DISCONNECTED = "/sk/singularisdev/ekasask/client/application/systray_disconnected.png";
    private Image serverTrayIconConnected = null;
    private Image serverTrayIconDisconnected = null;
    private static final String SERVER_CAPTION = "BOWA EKasa v1.1";
    private TrayIcon trayIcon = null;

    public TrayIconAWT() {
        this.init();
    }

    private void init() {
        URL url;
        try {
            url = this.getClass().getResource(SERVER_ICON_FILE_NAME_CONNECTED);
            this.serverTrayIconConnected = new ImageIcon(url).getImage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            url = this.getClass().getResource(SERVER_ICON_FILE_NAME_DISCONNECTED);
            this.serverTrayIconDisconnected = new ImageIcon(url).getImage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.trayIcon = new TrayIcon(this.serverTrayIconDisconnected);
        this.trayIcon.setImageAutoSize(true);
        this.trayIcon.setToolTip(SERVER_CAPTION);
    }

    @Override
    public void displayMessage(String string, String string2, int infoMessageType) {
        if (this.trayIcon != null) {
            TrayIcon.MessageType type;
            switch (infoMessageType) {
                case 0: {
                    type = TrayIcon.MessageType.INFO;
                    break;
                }
                case 1: {
                    type = TrayIcon.MessageType.ERROR;
                    break;
                }
                case 2: {
                    type = TrayIcon.MessageType.WARNING;
                    break;
                }
                default: {
                    type = TrayIcon.MessageType.NONE;
                }
            }
            this.trayIcon.displayMessage(string, string2, type);
        }
    }

    @Override
    public void dispose() {
        SystemTray tray = SystemTray.getSystemTray();
        tray.remove(this.trayIcon);
    }

    @Override
    public TrayPopupMenuInterface getPopupMenu(Controller controller) {
        return new TrayPopupMenuAWT(this, controller);
    }

    @Override
    public void register() {
        try {
            SystemTray tray = SystemTray.getSystemTray();
            tray.add(this.trayIcon);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setPopupMenu(TrayPopupMenuAWT popupMenu) {
        if (this.trayIcon != null) {
            this.trayIcon.setPopupMenu(popupMenu);
        }
    }

    @Override
    public void setConnectionState(Controller.CONNECTION_STATE state) {
        switch (state) {
            case CONNECTED: {
                this.trayIcon.setImage(this.serverTrayIconConnected);
                ((TrayPopupMenuAWT)this.trayIcon.getPopupMenu()).setProxyEnabled(true);
                break;
            }
            case DISCONNECTED: {
                this.trayIcon.setImage(this.serverTrayIconDisconnected);
                ((TrayPopupMenuAWT)this.trayIcon.getPopupMenu()).setProxyEnabled(false);
            }
        }
    }

    @Override
    public void setProxy(boolean isProxy) {
        ((TrayPopupMenuAWT)this.trayIcon.getPopupMenu()).setProxy(isProxy);
    }
}

