/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.client.application;

import java.awt.CheckboxMenuItem;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import sk.singularisdev.ekasask.client.application.ConfigWindow;
import sk.singularisdev.ekasask.client.application.Controller;
import sk.singularisdev.ekasask.client.application.TrayIconAWT;
import sk.singularisdev.ekasask.client.application.TrayPopupMenuInterface;
import sk.singularisdev.ekasask.client.localization.Localization;
import sk.singularisdev.ekasask.client.ui.PPEKKWindow;

public class TrayPopupMenuAWT
extends PopupMenu
implements TrayPopupMenuInterface {
    private MenuItem send = new MenuItem(Localization.getString("client.systray.send"));
    private MenuItem settings = new MenuItem(Localization.getString("client.systray.settings"));
    private CheckboxMenuItem proxy = new CheckboxMenuItem(Localization.getString("client.systray.proxy"));
    private MenuItem exit = new MenuItem(Localization.getString("client.systray.exit"));
    private TrayIconAWT trayIcon;
    private Controller controller;

    public TrayPopupMenuAWT(TrayIconAWT tIcon, Controller controller) {
        this.controller = controller;
        this.trayIcon = tIcon;
        tIcon.setPopupMenu(this);
        this.initComponent();
    }

    private void initComponent() {
        this.send.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PPEKKWindow sfw = new PPEKKWindow(TrayPopupMenuAWT.this.controller);
            }
        });
        this.add(this.send);
        this.proxy.setEnabled(false);
        this.proxy.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    boolean state = TrayPopupMenuAWT.this.proxy.getState();
                    TrayPopupMenuAWT.this.controller.setProxy(state);
                    TrayPopupMenuAWT.this.proxy.setState(!state);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    TrayPopupMenuAWT.this.proxy.setEnabled(false);
                }
            }
        });
        if (this.controller.getProxyAddress() != null) {
            this.add(this.proxy);
        }
        this.addSeparator();
        this.settings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigWindow cw = new ConfigWindow(TrayPopupMenuAWT.this.controller);
            }
        });
        this.add(this.settings);
        this.addSeparator();
        this.exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrayPopupMenuAWT.this.doExit();
            }
        });
        this.add(this.exit);
    }

    private Controller getController() {
        return this.controller;
    }

    private void doExit() {
        this.controller.exit();
    }

    public void setProxy(boolean isProxy) {
        this.proxy.setState(isProxy);
    }

    public void setProxyEnabled(boolean enabled) {
        this.proxy.setEnabled(enabled);
    }
}

