/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.client.packet;

import sk.singularisdev.ekasask.Configuration;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.chdu.CHDUState;
import sk.singularisdev.ekasask.client.packet.AbstractPacketRequest;
import sk.singularisdev.ekasask.client.packet.AbstractPacketResponse;
import sk.singularisdev.ekasask.client.packet.GetChduStateResponse;

public class GetChduStateRequest
extends AbstractPacketRequest {
    public static final byte[] COMMAND = new byte[]{1, 12};

    private GetChduStateRequest(long ppekkId) {
        super(ppekkId);
    }

    public static GetChduStateRequest getInstance(long ppekkId) {
        GetChduStateRequest r = new GetChduStateRequest(ppekkId);
        return r;
    }

    public static GetChduStateRequest getInstance(long ppekkId, byte[] data) {
        GetChduStateRequest r = new GetChduStateRequest(ppekkId);
        r.deserializeParam(data);
        return r;
    }

    @Override
    public AbstractPacketResponse process() {
        GetChduStateResponse response = new GetChduStateResponse(this.ppekkId);
        try {
            PPEKK ppekk = PPEKK.getPpekk((long)this.ppekkId);
            if (ppekk == null) {
                response.setErrorCode(2L);
            } else {
                CHDUState state = ppekk.getChduState();
                response.setConnected(state.isConnected());
                response.setReceived(state.isReceived());
                response.setTransmitted(state.isTransmitted());
                response.setTransactionId(state.getTransactionId());
                response.setProxy(Configuration.getProxyHost() != null);
                response.setErrorCode(0L);
            }
        }
        catch (EKasaException e) {
            response.setErrorCode(3L);
            response.setErrorCodeEkasa(e.getErrorCode());
        }
        return response;
    }

    @Override
    public byte[] getCommand() {
        return COMMAND;
    }
}

