/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.client.packet;

import sk.singularisdev.ekasask.Configuration;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.client.packet.AbstractPacketRequest;
import sk.singularisdev.ekasask.client.packet.AbstractPacketResponse;
import sk.singularisdev.ekasask.client.packet.GetPpekkRs232PortResponse;

public class GetPpekkRs232PortRequest
extends AbstractPacketRequest {
    public static final byte[] COMMAND = new byte[]{1, 9};
    public static final String PARAMETER_TYPE = "type";

    private GetPpekkRs232PortRequest(long ppekkId) {
        super(ppekkId);
        this.data.put(PARAMETER_TYPE, "RS232");
    }

    public static GetPpekkRs232PortRequest getInstance(long ppekkId) {
        GetPpekkRs232PortRequest r = new GetPpekkRs232PortRequest(ppekkId);
        return r;
    }

    public static GetPpekkRs232PortRequest getInstance(long ppekkId, byte[] data) {
        GetPpekkRs232PortRequest r = new GetPpekkRs232PortRequest(ppekkId);
        r.deserializeParam(data);
        return r;
    }

    public String getType() {
        return (String)this.data.get(PARAMETER_TYPE);
    }

    public void setType(String type) {
        this.data.put(PARAMETER_TYPE, type);
    }

    @Override
    public AbstractPacketResponse process() {
        GetPpekkRs232PortResponse response = new GetPpekkRs232PortResponse(this.ppekkId);
        try {
            PPEKK ppekk = PPEKK.getPpekk((long)this.ppekkId);
            if (ppekk == null) {
                response.setErrorCode(2L);
            } else {
                String[] p = Configuration.getAvailableConnectionPorts((String)this.getType());
                response.setPorts(p);
                response.setErrorCode(0L);
            }
        }
        catch (EKasaException e) {
            response.setErrorCode(3L);
            response.setErrorCodeEkasa(e.getErrorCode());
        }
        return response;
    }

    @Override
    public byte[] getCommand() {
        return COMMAND;
    }
}

