/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.client.packet;

import sk.singularisdev.ekasask.Configuration;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.client.packet.AbstractPacketRequest;
import sk.singularisdev.ekasask.client.packet.AbstractPacketResponse;
import sk.singularisdev.ekasask.client.packet.SetProxyResponse;

public class SetProxyRequest
extends AbstractPacketRequest {
    public static final byte[] COMMAND = new byte[]{1, 15};
    public static final String PARAMETER_PROXY_ENABLED = "Enabled";
    public static final String PARAMETER_PROXY_HOST = "ProxyHost";
    public static final String PARAMETER_PROXY_PORT = "ProxyPort";

    private SetProxyRequest(long ppekkId) {
        super(ppekkId);
        this.data.put(PARAMETER_PROXY_ENABLED, "false");
        this.data.put(PARAMETER_PROXY_HOST, "");
        this.data.put(PARAMETER_PROXY_PORT, "0");
    }

    public static SetProxyRequest getInstance(long ppekkId, boolean proxyEnabled, String proxyHost, int proxyPort) {
        SetProxyRequest r = new SetProxyRequest(ppekkId);
        r.setProxyEnabled(proxyEnabled);
        r.setProxyHost(proxyHost);
        r.setProxyPort(proxyPort);
        return r;
    }

    public static SetProxyRequest getInstance(long ppekkId, byte[] data) {
        SetProxyRequest r = new SetProxyRequest(ppekkId);
        r.deserializeParam(data);
        return r;
    }

    public String getProxyHost() {
        return (String)this.data.get(PARAMETER_PROXY_HOST);
    }

    public void setProxyHost(String proxyHost) {
        this.data.put(PARAMETER_PROXY_HOST, proxyHost);
    }

    public int getProxyPort() {
        return Integer.parseInt((String)this.data.get(PARAMETER_PROXY_PORT));
    }

    public void setProxyPort(int proxyPort) {
        this.data.put(PARAMETER_PROXY_PORT, "" + proxyPort);
    }

    public boolean isProxyEnabled() {
        System.out.println((String)this.data.get(PARAMETER_PROXY_ENABLED));
        return Boolean.parseBoolean((String)this.data.get(PARAMETER_PROXY_ENABLED));
    }

    public void setProxyEnabled(boolean proxyEnabled) {
        this.data.put(PARAMETER_PROXY_ENABLED, "" + proxyEnabled);
    }

    @Override
    public AbstractPacketResponse process() {
        SetProxyResponse response = new SetProxyResponse(this.ppekkId);
        try {
            PPEKK ppekk = PPEKK.getPpekk((long)this.ppekkId);
            if (ppekk == null) {
                response.setErrorCode(2L);
            } else {
                System.out.println("Enabled:" + this.isProxyEnabled());
                System.out.println("Host:" + this.getProxyHost());
                System.out.println("Port:" + this.getProxyPort());
                if (this.isProxyEnabled()) {
                    Configuration.setProxyHost((String)this.getProxyHost());
                    Configuration.setProxyPort((int)this.getProxyPort());
                } else {
                    Configuration.setProxyHost(null);
                }
                response.setErrorCode(0L);
            }
        }
        catch (Exception e) {
            response.setErrorCode(3L);
            response.setErrorCodeEkasa(-1111111L);
        }
        return response;
    }

    @Override
    public byte[] getCommand() {
        return COMMAND;
    }
}

