/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.client.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.client.packet.AbstractPacketRequest;
import sk.singularisdev.ekasask.client.packet.AbstractPacketResponse;
import sk.singularisdev.ekasask.client.packet.GetCertificateValidRequest;
import sk.singularisdev.ekasask.client.packet.GetChduInfoRequest;
import sk.singularisdev.ekasask.client.packet.GetChduStateRequest;
import sk.singularisdev.ekasask.client.packet.GetPpekkInfoRequest;
import sk.singularisdev.ekasask.client.packet.GetPpekkRs232PortRequest;
import sk.singularisdev.ekasask.client.packet.GetUnsendedMessageRequest;
import sk.singularisdev.ekasask.client.packet.PrintLastReceiptCopyMessageRequest;
import sk.singularisdev.ekasask.client.packet.PrintUnsendedMessageRequest;
import sk.singularisdev.ekasask.client.packet.SendUnsendedMessageRequest;
import sk.singularisdev.ekasask.client.packet.SendUpgradeRequest;
import sk.singularisdev.ekasask.client.packet.SetAuthenticationRequest;
import sk.singularisdev.ekasask.client.packet.SetChduPortRequest;
import sk.singularisdev.ekasask.client.packet.SetIdentityRequest;
import sk.singularisdev.ekasask.client.packet.SetProxyRequest;
import sk.singularisdev.ekasask.client.packet.SynchronizeRequest;

public class Client
implements Runnable {
    private static final Logger logger = LoggerManager.getLogger((String)Client.class.getName());
    public static final byte ACK = 6;
    public static final byte NAK = 21;
    private boolean running = false;
    private boolean stopSignal = false;
    private Socket socket;
    private InputStream inputStream;
    private OutputStream outputStream;

    public Client(Socket socket) throws IOException {
        this.socket = socket;
        this.inputStream = socket.getInputStream();
        this.outputStream = socket.getOutputStream();
    }

    @Override
    public void run() {
        this.running = true;
        this.stopSignal = false;
        ByteBuffer bBuffOut = ByteBuffer.allocate(4);
        bBuffOut.order(ByteOrder.LITTLE_ENDIAN);
        byte[] command = new byte[2];
        byte[] bLength = new byte[4];
        try {
            while (!this.stopSignal) {
                int l = this.read(command);
                if (l == 0) continue;
                if (l < 2) {
                    this.outputStream.write(21);
                    this.outputStream.flush();
                    continue;
                }
                int ppekkId = this.inputStream.read();
                l = this.read(bLength);
                if (l != 4) {
                    this.outputStream.write(21);
                    this.outputStream.flush();
                    continue;
                }
                ByteBuffer bBuff = ByteBuffer.wrap(bLength);
                bBuff.order(ByteOrder.LITTLE_ENDIAN);
                int dataLen = bBuff.getInt();
                byte[] data = new byte[dataLen];
                l = this.read(data);
                if (l != dataLen) {
                    this.outputStream.write(21);
                    this.outputStream.flush();
                    continue;
                }
                AbstractPacketRequest packet = null;
                if (Arrays.equals(command, SetAuthenticationRequest.COMMAND)) {
                    packet = SetAuthenticationRequest.getInstance(ppekkId, data);
                } else if (Arrays.equals(command, SetIdentityRequest.COMMAND)) {
                    packet = SetIdentityRequest.getInstance(ppekkId, data);
                } else if (Arrays.equals(command, GetChduInfoRequest.COMMAND)) {
                    packet = GetChduInfoRequest.getInstance(ppekkId, data);
                } else if (Arrays.equals(command, GetPpekkInfoRequest.COMMAND)) {
                    packet = GetPpekkInfoRequest.getInstance(ppekkId, data);
                } else if (Arrays.equals(command, GetUnsendedMessageRequest.COMMAND)) {
                    packet = GetUnsendedMessageRequest.getInstance(ppekkId, data);
                } else if (Arrays.equals(command, GetCertificateValidRequest.COMMAND)) {
                    packet = GetCertificateValidRequest.getInstance(ppekkId, data);
                } else if (Arrays.equals(command, PrintUnsendedMessageRequest.COMMAND)) {
                    packet = PrintUnsendedMessageRequest.getInstance(ppekkId, data);
                } else if (Arrays.equals(command, SendUnsendedMessageRequest.COMMAND)) {
                    packet = SendUnsendedMessageRequest.getInstance(ppekkId, data);
                } else if (Arrays.equals(command, GetPpekkRs232PortRequest.COMMAND)) {
                    packet = GetPpekkRs232PortRequest.getInstance(ppekkId, data);
                } else if (Arrays.equals(command, SetChduPortRequest.COMMAND)) {
                    packet = SetChduPortRequest.getInstance(ppekkId, data);
                } else if (Arrays.equals(command, SynchronizeRequest.COMMAND)) {
                    packet = SynchronizeRequest.getInstance(ppekkId, data);
                } else if (Arrays.equals(command, GetChduStateRequest.COMMAND)) {
                    packet = GetChduStateRequest.getInstance(ppekkId, data);
                } else if (Arrays.equals(command, SendUpgradeRequest.COMMAND)) {
                    packet = SendUpgradeRequest.getInstance(ppekkId, data);
                } else if (Arrays.equals(command, PrintLastReceiptCopyMessageRequest.COMMAND)) {
                    packet = PrintLastReceiptCopyMessageRequest.getInstance(ppekkId, data);
                } else if (Arrays.equals(command, SetProxyRequest.COMMAND)) {
                    packet = SetProxyRequest.getInstance(ppekkId, data);
                }
                if (packet == null) {
                    this.outputStream.write(21);
                    this.outputStream.flush();
                    continue;
                }
                AbstractPacketResponse response = ((AbstractPacketRequest)packet).process();
                this.outputStream.write(6);
                this.outputStream.write(response.getCommand());
                this.outputStream.write((int)response.getPpekkId());
                byte[] d = response.serializeParam();
                bBuff = ByteBuffer.allocate(4);
                bBuff.order(ByteOrder.LITTLE_ENDIAN);
                this.outputStream.write(bBuff.putInt(d.length).array());
                this.outputStream.write(d);
                this.outputStream.flush();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        this.running = false;
    }

    private int read(byte[] data) throws IOException {
        int pos = 0;
        int l = data.length;
        while (pos < l) {
            pos += this.inputStream.read(data, pos, data.length - pos);
        }
        return pos;
    }

    public synchronized void startDriver() {
        Thread t = new Thread(this);
        t.start();
    }

    public synchronized void stopDriver() {
        this.stopSignal = true;
        while (this.running) {
            try {
                Thread.sleep(5L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

