/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.client.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import sk.singularisdev.ekasask.client.localization.Localization;
import sk.singularisdev.ekasask.client.server.Client;

public class Server
implements Runnable {
    public static final byte[] INIT_SEQUENCE;
    private int port;
    private ServerSocket listenSocket;
    private boolean running = false;
    private boolean stopSignal = false;
    private static List<Client> clients;
    Thread thread;

    static {
        byte[] byArray = new byte[13];
        byArray[0] = 28;
        byArray[1] = 1;
        byArray[2] = -108;
        byArray[3] = 83;
        byArray[4] = 89;
        byArray[5] = 83;
        byArray[6] = 84;
        byArray[7] = 82;
        byArray[8] = 65;
        byArray[9] = 89;
        byArray[11] = 4;
        byArray[12] = -54;
        INIT_SEQUENCE = byArray;
        clients = new ArrayList<Client>();
    }

    public Server() throws Exception {
        this(0);
    }

    public Server(int port) throws Exception {
        this.setPort(port);
        Locale currentLocale = new Locale("sk");
        Localization.setBundle(ResourceBundle.getBundle("sk.singularisdev.ekasask.client.localization.ekasask", currentLocale));
    }

    public void setPort(int port) throws Exception {
        this.port = port;
        this.listenSocket = new ServerSocket(this.port);
        this.listenSocket.setSoTimeout(2000);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.running = true;
        this.stopSignal = false;
        try {
            while (!this.stopSignal) {
                Socket socket;
                try {
                    socket = this.listenSocket.accept();
                }
                catch (SocketTimeoutException e) {
                    continue;
                }
                InputStream inputStream = socket.getInputStream();
                OutputStream outputStream = socket.getOutputStream();
                byte[] initSequence = new byte[INIT_SEQUENCE.length];
                if (inputStream.read(initSequence) != INIT_SEQUENCE.length) {
                    try {
                        socket.close();
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (Arrays.equals(initSequence, INIT_SEQUENCE)) {
                    outputStream.write(6);
                    outputStream.flush();
                    this.addClient(socket);
                    continue;
                }
                outputStream.write(21);
                outputStream.flush();
                try {
                    socket.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.running = false;
    }

    public void addClient(Socket socket) throws IOException {
        Client client = new Client(socket);
        clients.add(client);
        client.startDriver();
    }

    public synchronized void startDriver() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public synchronized void stopDriver() {
        for (Client client : clients) {
            client.stopDriver();
        }
        this.stopSignal = true;
        this.thread.interrupt();
        while (this.running) {
            try {
                Thread.sleep(5L);
            }
            catch (Exception client) {
                // empty catch block
            }
        }
        try {
            this.listenSocket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void forwardClientSocket(Socket socket) throws IOException {
        socket.setSoTimeout(0);
        Client client = new Client(socket);
        clients.add(client);
        client.startDriver();
    }
}

