/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.client.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class OverlapLayout
implements LayoutManager2,
Serializable {
    public static Boolean POP_UP = Boolean.TRUE;
    public static Boolean POP_DOWN = Boolean.FALSE;
    private static final int PREFERRED = 0;
    private static final int MINIMUM = 1;
    private boolean overlapAbove;
    private Point overlapPosition;
    private boolean includeInvisible = true;
    private Insets popupInsets = new Insets(0, 0, 0, 0);
    private List<Component> components = new ArrayList<Component>();
    private HashMap<Component, Boolean> constraints = new HashMap();

    public OverlapLayout() {
        this(new Point(0, 0));
    }

    public OverlapLayout(Point overlapPosition) {
        this(overlapPosition, true);
    }

    public OverlapLayout(Point overlapPosition, boolean overlapAbove) {
        this.setOverlapPosition(overlapPosition);
        this.overlapAbove = overlapAbove;
    }

    public int convertIndex(int index) {
        if (this.overlapAbove) {
            return this.components.size() - index - 1;
        }
        return index;
    }

    public boolean isIncludeInvisible() {
        return this.includeInvisible;
    }

    public void setIncludeInvisible(boolean includeInvisible) {
        this.includeInvisible = includeInvisible;
    }

    public Point getOverlapPosition() {
        return this.overlapPosition;
    }

    public void setOverlapPosition(Point overlapPosition) {
        this.overlapPosition = overlapPosition;
    }

    public Insets getPopupInsets() {
        return this.popupInsets;
    }

    public void setPopupInsets(Insets popupInsets) {
        this.popupInsets = popupInsets;
    }

    public Boolean getConstraints(Component component) {
        return this.constraints.get(component);
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void addLayoutComponent(Component component, Object constraint) {
        if (constraint == null) {
            this.constraints.remove(component);
        } else if (constraint instanceof Boolean) {
            this.constraints.put(component, (Boolean)constraint);
        } else {
            String message = "Constraint parameter must be of type Boolean";
            throw new IllegalArgumentException(message);
        }
        if (!this.components.contains(component)) {
            Container parent = component.getParent();
            int size = parent.getComponentCount();
            int i = 0;
            while (i < size) {
                Component c = parent.getComponent(i);
                if (c == component) {
                    this.components.add(i, component);
                    if (!this.overlapAbove) break;
                    parent.setComponentZOrder(component, size - i - 1);
                    break;
                }
                ++i;
            }
        }
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.components.remove(component);
        this.constraints.remove(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            return this.getLayoutSize(parent, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            return this.getLayoutSize(parent, 0);
        }
    }

    private Dimension getLayoutSize(Container parent, int type) {
        int visibleComponents = 0;
        int width = 0;
        int height = 0;
        for (Component component : this.components) {
            if (!component.isVisible() && !this.includeInvisible) continue;
            Dimension size = this.getDimension(component, type);
            width = Math.max(size.width, width);
            height = Math.max(size.height, height);
            ++visibleComponents;
        }
        if (visibleComponents == 0) {
            return new Dimension(0, 0);
        }
        width += --visibleComponents * Math.abs(this.overlapPosition.x);
        height += visibleComponents * Math.abs(this.overlapPosition.y);
        Insets parentInsets = parent.getInsets();
        width += parentInsets.left + parentInsets.right;
        height += parentInsets.top + parentInsets.bottom;
        return new Dimension(width += this.popupInsets.left + this.popupInsets.right, height += this.popupInsets.top + this.popupInsets.bottom);
    }

    private Dimension getDimension(Component component, int type) {
        switch (type) {
            case 0: {
                return component.getPreferredSize();
            }
            case 1: {
                return component.getMinimumSize();
            }
        }
        return new Dimension(0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int size = this.components.size();
            if (size == 0) {
                return;
            }
            Dimension maximumSize = new Dimension();
            for (Component component : this.components) {
                if (!component.isVisible() && !this.includeInvisible) continue;
                Dimension preferred = component.getPreferredSize();
                maximumSize.width = Math.max(preferred.width, maximumSize.width);
                maximumSize.height = Math.max(preferred.height, maximumSize.height);
            }
            Point location = new Point(0, 0);
            Insets parentInsets = parent.getInsets();
            location.x = this.overlapPosition.x < 0 ? parent.getWidth() - maximumSize.width - parentInsets.right - this.popupInsets.right : parentInsets.left + this.popupInsets.left;
            location.y = this.overlapPosition.y < 0 ? parent.getHeight() - maximumSize.height - parentInsets.bottom - this.popupInsets.bottom : parentInsets.top + this.popupInsets.top;
            int i = 0;
            while (i < size) {
                Component component = this.components.get(i);
                if (component.isVisible() || this.includeInvisible) {
                    if (this.overlapPosition.x == 0 && this.overlapPosition.y == 0) {
                        int width = parent.getWidth() - parentInsets.left - parentInsets.right;
                        int height = parent.getHeight() - parentInsets.top - parentInsets.bottom;
                        component.setSize(width, height);
                    } else {
                        component.setSize(maximumSize);
                    }
                    int x = location.x;
                    int y = location.y;
                    Boolean constraint = this.constraints.get(component);
                    if (constraint != null && constraint == Boolean.TRUE) {
                        x += this.popupInsets.right - this.popupInsets.left;
                        y += this.popupInsets.bottom - this.popupInsets.top;
                    }
                    component.setLocation(x, y);
                    location.x += this.overlapPosition.x;
                    location.y += this.overlapPosition.y;
                }
                ++i;
            }
        }
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[overlapAbove=" + this.overlapAbove + ",overlapPosition=" + this.overlapPosition + "]";
    }
}

