/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.client.ui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import sk.singularisdev.ekasask.client.application.Controller;
import sk.singularisdev.ekasask.client.localization.Localization;
import sk.singularisdev.ekasask.client.ui.PPEKKWindow;
import sk.singularisdev.ekasask.utils.Utility;
import sk.singularisdev.ekasask.xmlparser.AuthenticationData;

public class PPEKKWindowAuthPanel
extends JPanel {
    private Controller controller;
    private PPEKKWindow ppekkWindow;
    private JPanel authBorderPanel;
    private JLabel authDataLabel;
    private JButton authBrowseButton;
    private JLabel authPassLabel;
    private JPasswordField authPassField;
    private JTextField authFilePathField;
    private JButton authUploadButton;
    private JLabel authUploadStatusIcon;

    public PPEKKWindowAuthPanel(Controller controller, PPEKKWindow ppekkWindow) {
        this.controller = controller;
        this.ppekkWindow = ppekkWindow;
        this.init();
    }

    private void init() {
        this.setLayout(null);
        this.authBorderPanel = new JPanel();
        this.authBorderPanel.setBorder(new LineBorder(Color.LIGHT_GRAY));
        this.authBorderPanel.setBounds(5, 5, 360, 137);
        this.authBorderPanel.setLayout(null);
        this.add(this.authBorderPanel);
        this.authDataLabel = new JLabel(Localization.getString("client.send.authdata"));
        this.authDataLabel.setBounds(10, 11, 200, 14);
        this.authBorderPanel.add(this.authDataLabel);
        this.authPassLabel = new JLabel(Localization.getString("client.send.authpass"));
        this.authPassLabel.setBounds(10, 40, 140, 14);
        this.authBorderPanel.add(this.authPassLabel);
        this.authPassField = new JPasswordField();
        this.authPassField.setBounds(160, 37, 190, 20);
        this.authBorderPanel.add(this.authPassField);
        this.authPassField.setColumns(10);
        this.authFilePathField = new JTextField();
        this.authFilePathField.setBounds(10, 70, 270, 20);
        this.authBorderPanel.add(this.authFilePathField);
        this.authFilePathField.setColumns(10);
        this.authBrowseButton = new JButton("...");
        this.authBrowseButton.setBounds(290, 67, 60, 26);
        this.authBorderPanel.add(this.authBrowseButton);
        this.authUploadButton = new JButton(Localization.getString("client.send.authsend"));
        this.authUploadButton.setBounds(230, 100, 90, 26);
        this.authBorderPanel.add(this.authUploadButton);
        this.authUploadStatusIcon = new JLabel();
        this.authUploadStatusIcon.setBounds(332, 100, 26, 26);
        this.ppekkWindow.showSuccessIcon(this.authUploadStatusIcon, false, true, null);
        this.authBorderPanel.add(this.authUploadStatusIcon);
        this.authBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser browser = new JFileChooser();
                browser.setCurrentDirectory(Controller.LAST_DIR);
                browser.setVisible(true);
                if (browser.showOpenDialog(null) != 0) {
                    return;
                }
                PPEKKWindowAuthPanel.this.authFilePathField.setText(browser.getSelectedFile().getPath());
                Controller.LAST_DIR = browser.getCurrentDirectory();
            }
        });
        this.authUploadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Utility.arrayContains((int[])PPEKKWindowAuthPanel.this.controller.getConfiguration().getDevices(), (int)PPEKKWindowAuthPanel.this.controller.getConfiguration().getActiveDevice())) {
                    return;
                }
                File file = new File(PPEKKWindowAuthPanel.this.authFilePathField.getText());
                if (!file.exists()) {
                    return;
                }
                PPEKKWindowAuthPanel.this.ppekkWindow.processing(true);
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(PPEKKWindowAuthPanel.this.authFilePathField.getText()), "UTF8"));
                            String line = null;
                            StringBuilder stringBuilder = new StringBuilder();
                            String ls = System.getProperty("line.separator");
                            try {
                                boolean fl = true;
                                while ((line = reader.readLine()) != null) {
                                    if (fl) {
                                        byte[] b = line.getBytes("UTF8");
                                        if (b.length > 3 && b[0] == -17 && b[1] == -69 && b[2] == -65) {
                                            line = new String(b, 3, b.length - 3, "UTF8");
                                        }
                                        fl = false;
                                    }
                                    stringBuilder.append(line);
                                    stringBuilder.append(ls);
                                }
                            }
                            finally {
                                reader.close();
                            }
                            AuthenticationData data = new AuthenticationData(stringBuilder.toString());
                            if (!data.parse()) {
                                JOptionPane.showMessageDialog(null, Localization.getString("client.send.invalid_auth_file_message"), Localization.getString("client.send.invalid_auth_file_title"), 2);
                                return;
                            }
                            try {
                                PPEKKWindowAuthPanel.this.controller.sendAuthentication(stringBuilder.toString(), new String(PPEKKWindowAuthPanel.this.authPassField.getPassword()), PPEKKWindowAuthPanel.this.controller.getConfiguration().getActiveDevice());
                                PPEKKWindowAuthPanel.this.ppekkWindow.showSuccessIcon(PPEKKWindowAuthPanel.this.authUploadStatusIcon, true, true, null);
                            }
                            catch (Exception ex) {
                                PPEKKWindowAuthPanel.this.ppekkWindow.showSuccessIcon(PPEKKWindowAuthPanel.this.authUploadStatusIcon, true, false, ex.getMessage());
                                return;
                            }
                        }
                        finally {
                            PPEKKWindowAuthPanel.this.ppekkWindow.processing(false);
                        }
                    }
                });
                t.start();
            }
        });
    }
}

