/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.client.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import sk.singularisdev.ekasask.client.application.Controller;
import sk.singularisdev.ekasask.client.localization.Localization;
import sk.singularisdev.ekasask.client.packet.GetPpekkInfoResponse;
import sk.singularisdev.ekasask.client.packet.GetPpekkRs232PortResponse;
import sk.singularisdev.ekasask.client.ui.PPEKKWindow;
import sk.singularisdev.ekasask.utils.Utility;

public class PPEKKWindowChduConnectionPanel
extends JPanel {
    private String[] ports = new String[0];
    private Controller controller;
    private PPEKKWindow ppekkWindow;
    private JTextField ppekkCompanyNameField;
    private JTextField ppekkNameField;
    private JTextField ppekkVersionField;
    private JLabel lblStatusRs232;
    private JLabel lblStatusSetChduPort;
    private JButton btnSetChduPort;
    private JRadioButton radioRs232;
    private JRadioButton radioTcp;
    private JTextField txtIpPort;
    private JTextField txtIpAddress;
    private JComboBox comboRs232;
    private JComboBox comboRs232PortSpeed;

    public PPEKKWindowChduConnectionPanel(Controller controller, PPEKKWindow ppekkWindow) {
        this.controller = controller;
        this.ppekkWindow = ppekkWindow;
        this.init();
    }

    private void init() {
        this.setLayout(null);
        JPanel ppekkConnectionPanel = new JPanel();
        ppekkConnectionPanel.setBorder(new LineBorder(Color.LIGHT_GRAY));
        ppekkConnectionPanel.setBounds(5, 5, 393, 195);
        ppekkConnectionPanel.setLayout(null);
        this.add(ppekkConnectionPanel);
        JLabel ppekkConnectionChduLabel = new JLabel(Localization.getString("client.send.connection.chdu"));
        ppekkConnectionChduLabel.setBounds(10, 10, 373, 14);
        ppekkConnectionPanel.add(ppekkConnectionChduLabel);
        this.radioRs232 = new JRadioButton(Localization.getString("client.connnection_chdu.rs232"));
        this.radioTcp = new JRadioButton(Localization.getString("client.connnection_chdu.tcp"));
        ButtonGroup group = new ButtonGroup();
        group.add(this.radioRs232);
        group.add(this.radioTcp);
        this.radioRs232.setSelected(true);
        this.radioRs232.setBounds(10, 35, 373, 20);
        ppekkConnectionPanel.add(this.radioRs232);
        JLabel lblRs232 = new JLabel(Localization.getString("client.connnection_chdu.rs232.port_number"));
        lblRs232.setBounds(10, 60, 70, 20);
        ppekkConnectionPanel.add(lblRs232);
        this.comboRs232 = new JComboBox();
        this.comboRs232.setBounds(85, 60, 150, 20);
        ppekkConnectionPanel.add(this.comboRs232);
        JButton btnSearchPort = new JButton(Localization.getString("client.connnection_chdu.rs232.search_port"));
        btnSearchPort.setBounds(240, 57, 100, 26);
        ppekkConnectionPanel.add(btnSearchPort);
        btnSearchPort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Utility.arrayContains((int[])PPEKKWindowChduConnectionPanel.this.controller.getConfiguration().getDevices(), (int)PPEKKWindowChduConnectionPanel.this.controller.getConfiguration().getActiveDevice())) {
                    return;
                }
                PPEKKWindowChduConnectionPanel.this.ppekkWindow.processing(true);
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            try {
                                GetPpekkRs232PortResponse portsResponse = PPEKKWindowChduConnectionPanel.this.controller.getPpekkRs232Port(PPEKKWindowChduConnectionPanel.this.controller.getConfiguration().getActiveDevice());
                                String[] ports = portsResponse.getPorts();
                                if (ports != null) {
                                    Object item = PPEKKWindowChduConnectionPanel.this.comboRs232.getSelectedItem();
                                    PPEKKWindowChduConnectionPanel.this.comboRs232.removeAllItems();
                                    String[] stringArray = ports;
                                    int n = ports.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        String port = stringArray[n2];
                                        PPEKKWindowChduConnectionPanel.this.comboRs232.addItem(port);
                                        if (item != null && port.equals(item)) {
                                            PPEKKWindowChduConnectionPanel.this.comboRs232.setSelectedItem(port);
                                        }
                                        ++n2;
                                    }
                                }
                                PPEKKWindowChduConnectionPanel.this.ppekkWindow.showSuccessIcon(PPEKKWindowChduConnectionPanel.this.lblStatusRs232, true, true, null);
                            }
                            catch (Exception ex) {
                                PPEKKWindowChduConnectionPanel.this.ppekkWindow.showSuccessIcon(PPEKKWindowChduConnectionPanel.this.lblStatusRs232, true, false, ex.getMessage());
                                PPEKKWindowChduConnectionPanel.this.ppekkWindow.processing(false);
                            }
                        }
                        finally {
                            PPEKKWindowChduConnectionPanel.this.ppekkWindow.processing(false);
                        }
                    }
                });
                t.start();
            }
        });
        this.lblStatusRs232 = new JLabel();
        this.lblStatusRs232.setBounds(345, 57, 26, 26);
        this.ppekkWindow.showSuccessIcon(this.lblStatusRs232, false, true, null);
        ppekkConnectionPanel.add(this.lblStatusRs232);
        JLabel lblRs232PortSpeed = new JLabel(Localization.getString("client.connnection_chdu.rs232.port_speed"));
        lblRs232PortSpeed.setBounds(10, 85, 70, 20);
        ppekkConnectionPanel.add(lblRs232PortSpeed);
        this.comboRs232PortSpeed = new JComboBox();
        this.comboRs232PortSpeed.addItem("115200");
        this.comboRs232PortSpeed.addItem("230400");
        this.comboRs232PortSpeed.addItem("460800");
        this.comboRs232PortSpeed.setBounds(85, 85, 150, 20);
        ppekkConnectionPanel.add(this.comboRs232PortSpeed);
        this.radioTcp.setBounds(10, 110, 373, 20);
        this.radioTcp.setEnabled(false);
        ppekkConnectionPanel.add(this.radioTcp);
        JLabel lblTcp = new JLabel(Localization.getString("client.connnection_chdu.tcp.address"));
        lblTcp.setBounds(10, 135, 70, 20);
        ppekkConnectionPanel.add(lblTcp);
        this.txtIpAddress = new JTextField();
        this.txtIpAddress.setEnabled(false);
        this.txtIpAddress.setBounds(85, 135, 100, 20);
        ppekkConnectionPanel.add(this.txtIpAddress);
        JLabel lblTcpPort = new JLabel(Localization.getString("client.connnection_chdu.tcp.port"));
        lblTcpPort.setBounds(190, 135, 70, 20);
        ppekkConnectionPanel.add(lblTcpPort);
        this.txtIpPort = new JTextField();
        this.txtIpPort.setEnabled(false);
        this.txtIpPort.setBounds(265, 135, 60, 20);
        ppekkConnectionPanel.add(this.txtIpPort);
        this.btnSetChduPort = new JButton(Localization.getString("client.send.set_chdu_port"));
        this.btnSetChduPort.setBounds(250, 160, 90, 26);
        ppekkConnectionPanel.add(this.btnSetChduPort);
        this.btnSetChduPort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Utility.arrayContains((int[])PPEKKWindowChduConnectionPanel.this.controller.getConfiguration().getDevices(), (int)PPEKKWindowChduConnectionPanel.this.controller.getConfiguration().getActiveDevice())) {
                    return;
                }
                PPEKKWindowChduConnectionPanel.this.ppekkWindow.processing(true);
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            try {
                                StringBuilder connectionString = new StringBuilder();
                                if (PPEKKWindowChduConnectionPanel.this.radioRs232.isSelected()) {
                                    connectionString.append(PPEKKWindowChduConnectionPanel.this.comboRs232.getSelectedItem());
                                    connectionString.append(":");
                                    connectionString.append(PPEKKWindowChduConnectionPanel.this.comboRs232PortSpeed.getSelectedItem());
                                } else {
                                    connectionString.append("TCP:");
                                    connectionString.append(PPEKKWindowChduConnectionPanel.this.txtIpAddress.getText());
                                    connectionString.append(":");
                                    connectionString.append(PPEKKWindowChduConnectionPanel.this.txtIpPort.getText());
                                }
                                PPEKKWindowChduConnectionPanel.this.controller.setChduPort(connectionString.toString(), PPEKKWindowChduConnectionPanel.this.controller.getConfiguration().getActiveDevice());
                                PPEKKWindowChduConnectionPanel.this.ppekkWindow.showSuccessIcon(PPEKKWindowChduConnectionPanel.this.lblStatusSetChduPort, true, true, null);
                            }
                            catch (Exception ex) {
                                PPEKKWindowChduConnectionPanel.this.ppekkWindow.showSuccessIcon(PPEKKWindowChduConnectionPanel.this.lblStatusSetChduPort, true, false, ex.getMessage());
                                PPEKKWindowChduConnectionPanel.this.ppekkWindow.processing(false);
                            }
                        }
                        finally {
                            PPEKKWindowChduConnectionPanel.this.ppekkWindow.processing(false);
                        }
                    }
                });
                t.start();
            }
        });
        this.lblStatusSetChduPort = new JLabel();
        this.lblStatusSetChduPort.setBounds(352, 160, 26, 26);
        this.ppekkWindow.showSuccessIcon(this.lblStatusSetChduPort, false, true, null);
        ppekkConnectionPanel.add(this.lblStatusSetChduPort);
        JPanel ppekkStatePanel = new JPanel();
        ppekkStatePanel.setBorder(new LineBorder(Color.LIGHT_GRAY));
        ppekkStatePanel.setBounds(5, 205, 393, 130);
        ppekkStatePanel.setLayout(null);
        this.add(ppekkStatePanel);
        JLabel ppekkStateLabel = new JLabel(Localization.getString("client.send.statedata.ppekk"));
        ppekkStateLabel.setBounds(10, 10, 373, 14);
        ppekkStatePanel.add(ppekkStateLabel);
        JPanel ppekkCompanyNamePanel = new JPanel();
        ppekkCompanyNamePanel.setSize(373, 19);
        ppekkCompanyNamePanel.setLocation(10, 35);
        ppekkStatePanel.add(ppekkCompanyNamePanel);
        Dimension labelSize = new Dimension(140, 20);
        ppekkCompanyNamePanel.setLayout(null);
        JLabel ppekkCompanyNameLabel = new JLabel(Localization.getString("client.send.statedata.ppekk.company_name"));
        ppekkCompanyNameLabel.setBounds(0, 0, 183, 19);
        ppekkCompanyNameLabel.setPreferredSize(labelSize);
        ppekkCompanyNameLabel.setMaximumSize(labelSize);
        ppekkCompanyNamePanel.add(ppekkCompanyNameLabel);
        this.ppekkCompanyNameField = new JTextField();
        this.ppekkCompanyNameField.setBounds(193, 0, 180, 19);
        this.ppekkCompanyNameField.setEditable(false);
        this.ppekkCompanyNameField.setColumns(22);
        ppekkCompanyNamePanel.add(this.ppekkCompanyNameField);
        JPanel ppekkNamePanel = new JPanel();
        ppekkNamePanel.setSize(373, 19);
        ppekkNamePanel.setLocation(10, 60);
        ppekkStatePanel.add(ppekkNamePanel);
        ppekkNamePanel.setLayout(null);
        JLabel ppekkNameLabel = new JLabel(Localization.getString("client.send.statedata.ppekk.name"));
        ppekkNameLabel.setBounds(0, 0, 183, 19);
        ppekkNameLabel.setPreferredSize(labelSize);
        ppekkNameLabel.setMaximumSize(labelSize);
        ppekkNamePanel.add(ppekkNameLabel);
        this.ppekkNameField = new JTextField();
        this.ppekkNameField.setBounds(193, 0, 180, 19);
        this.ppekkNameField.setEditable(false);
        this.ppekkNameField.setColumns(22);
        ppekkNamePanel.add(this.ppekkNameField);
        JPanel ppekkVersionPanel = new JPanel();
        ppekkVersionPanel.setSize(373, 19);
        ppekkVersionPanel.setLocation(10, 85);
        ppekkStatePanel.add(ppekkVersionPanel);
        ppekkVersionPanel.setLayout(null);
        JLabel ppekkVersionLabel = new JLabel(Localization.getString("client.send.statedata.ppekk.version"));
        ppekkVersionLabel.setBounds(0, 0, 183, 19);
        ppekkVersionLabel.setPreferredSize(labelSize);
        ppekkVersionLabel.setMaximumSize(labelSize);
        ppekkVersionPanel.add(ppekkVersionLabel);
        this.ppekkVersionField = new JTextField();
        this.ppekkVersionField.setBounds(193, 0, 180, 19);
        this.ppekkVersionField.setEditable(false);
        this.ppekkVersionField.setColumns(22);
        ppekkVersionPanel.add(this.ppekkVersionField);
        this.ppekkInfoChanged();
    }

    public void ppekkInfoChanged() {
        if (!Utility.arrayContains((int[])this.controller.getConfiguration().getDevices(), (int)this.controller.getConfiguration().getActiveDevice())) {
            return;
        }
        GetPpekkInfoResponse ppekkInfo = this.controller.restorePpekkInfo(this.controller.getConfiguration().getActiveDevice());
        if (ppekkInfo != null) {
            this.ppekkCompanyNameField.setText(ppekkInfo.getCompanyName());
            this.ppekkNameField.setText(ppekkInfo.getName());
            this.ppekkVersionField.setText(ppekkInfo.getVersion());
        }
    }
}

