/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.eKasaSK.lib;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sk.singularisdev.eKasaSK.lib.Charset;
import sk.singularisdev.eKasaSK.lib.FMDataFileListener;
import sk.singularisdev.eKasaSK.lib.FMDataListener;
import sk.singularisdev.eKasaSK.lib.FMDataStringListener;
import sk.singularisdev.eKasaSK.lib.FMStateListener;
import sk.singularisdev.eKasaSK.lib.LowLevelCommunicationListener;
import sk.singularisdev.eKasaSK.lib.Pegas06FMException;
import sk.singularisdev.eKasaSK.lib.communication.CommunicationDriver;
import sk.singularisdev.eKasaSK.lib.holder.FMSignalEvent;
import sk.singularisdev.eKasaSK.lib.holder.FMStateEvent;
import sk.singularisdev.eKasaSK.lib.languages.Cp852Charset;
import sk.singularisdev.eKasaSK.lib.logger.Logger;
import sk.singularisdev.eKasaSK.lib.utility.BMPLoader;

public class LowLevelFMInterface {
    protected static final BigDecimal HUNDRED = new BigDecimal(100);
    protected static final BigDecimal THOUSAND = new BigDecimal(1000);
    protected static final BigDecimal TEN_THOUSAND = new BigDecimal(10000);
    protected static final BigDecimal MILLION = new BigDecimal(1000000);
    private static final byte[] NULL_BYTE = new byte[0];
    protected static Logger logger;
    protected CommunicationDriver serial;
    protected ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
    protected Map<Integer, byte[]> graphicHeadersMMC = new HashMap<Integer, byte[]>();
    protected Map<Integer, byte[]> graphicHeadersMMC1 = new HashMap<Integer, byte[]>();
    protected Map<Integer, byte[]> graphicHeadersNV = new HashMap<Integer, byte[]>();
    protected java.nio.charset.Charset charset = null;
    protected List<LowLevelCommunicationListener> lowLevelCommunicationListeners = new ArrayList<LowLevelCommunicationListener>();
    protected List<FMStateListener> fmStateListeners = new ArrayList<FMStateListener>();
    private boolean fmSignal = false;
    private int fmState = 0;
    private short maxReinitPortCounter = 0;
    private int versionNumber = 100;
    private int revisionNumber = 1;
    private boolean autoTwoLineItem = false;
    protected boolean testingMode = false;

    public LowLevelFMInterface() {
        logger = Logger.createLogger(this.getClass().getName());
        try {
            this.charset = java.nio.charset.Charset.forName("CP852");
        }
        catch (Exception e) {
            this.charset = new Cp852Charset();
        }
    }

    public LowLevelFMInterface(boolean testingMode) {
        this();
        this.testingMode = testingMode;
    }

    public LowLevelFMInterface(CommunicationDriver serial) {
        this(serial, false);
    }

    public LowLevelFMInterface(CommunicationDriver serial, boolean testingMode) {
        this();
        this.serial = serial;
        this.testingMode = testingMode;
    }

    public void setReinitPortCounter(short counter) {
        this.maxReinitPortCounter = counter;
    }

    public void addCommunicationListener(LowLevelCommunicationListener listener) {
        this.lowLevelCommunicationListeners.add(listener);
    }

    public void removeCommunicationListener(LowLevelCommunicationListener listener) {
        this.lowLevelCommunicationListeners.remove(listener);
    }

    public void setAutoTwoLineItem(boolean autoTwoLineItem) {
        this.autoTwoLineItem = autoTwoLineItem;
    }

    public boolean isAutoTwoLineItem() {
        return this.autoTwoLineItem;
    }

    public int getVersion() {
        return 103;
    }

    public int getVersionNumber() {
        return this.versionNumber;
    }

    public int getRevisionNumber() {
        return this.revisionNumber;
    }

    public void openPort() throws Pegas06FMException {
        this.serial.openPort();
        this.init();
    }

    public void closePort() throws Pegas06FMException {
        this.serial.closePort();
    }

    public void reinitPort() throws Pegas06FMException {
        logger.debug("*** Reinitializing port started ***");
        this.closePort();
        this.serial.openPort();
        logger.debug("*** Reinitializing port finished ***");
    }

    public void init() throws Pegas06FMException {
        this.serial.setOldFMBehaviour(false);
    }

    public boolean isPortInitialized() {
        return this.serial.isInitialized();
    }

    public CommunicationDriver getSerialDriver() {
        return this.getCommunicationDriver();
    }

    public CommunicationDriver getCommunicationDriver() {
        return this.serial;
    }

    public void setCommunicationDriver(CommunicationDriver driver) {
        this.serial = driver;
    }

    public void paragonBegin(int deviceNumber, int rowNumber, int saleType, int communicationType, int paragonType, int recapitulationType, int graphicHeader, int correctionTransactionID) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 32, "" + rowNumber, "" + saleType, "" + communicationType, "" + paragonType, "" + recapitulationType, "" + graphicHeader, "" + correctionTransactionID);
    }

    public void paragonBegin(int deviceNumber, int rowNumber, int saleType, int communicationType, int paragonType, int recapitulationType, int graphicHeader) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 32, "" + rowNumber, "" + saleType, "" + communicationType, "" + paragonType, "" + recapitulationType, "" + graphicHeader, null);
    }

    public void paragonEnd(int deviceNumber, int rowNumber, int graphicHeader) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 34, "" + rowNumber, "" + graphicHeader);
    }

    public void sellingDayBegin(int deviceNumber, int saleMode) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 41, "" + saleMode);
    }

    public void itemSale(int deviceNumber, int rowNumber, String commodityName, double totalPrice, char vat, double amount, double unitPrice, String unit) throws Pegas06FMException {
        BigDecimal dUnitPrice;
        BigDecimal dTotalPrice = new BigDecimal("" + totalPrice);
        dTotalPrice = dTotalPrice.setScale(2, 4);
        BigDecimal dAmount = new BigDecimal("" + amount);
        if (dAmount.scale() < 3) {
            dAmount = dAmount.setScale(3, 4);
        }
        if ((dUnitPrice = new BigDecimal("" + unitPrice)).scale() < 2) {
            dUnitPrice = dUnitPrice.setScale(2, 4);
        }
        this.itemSale(deviceNumber, rowNumber, commodityName, dTotalPrice.toString(), vat, dAmount.toString(), dUnitPrice.toString(), unit);
    }

    public void itemSale_str(int deviceNumber, int rowNumber, String commodityName, String totalPrice, char vat, String amount, String unitPrice, String unit) throws Pegas06FMException {
        this.itemSale(deviceNumber, rowNumber, commodityName, totalPrice, vat, amount, unitPrice, unit);
    }

    public void itemSale(int deviceNumber, int rowNumber, String commodityName, String totalPrice, char vat, String amount, String unitPrice, String unit) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 36, "" + rowNumber, this.autoTwoLineItem ? String.format("%1$-40s", commodityName) : commodityName, totalPrice, "" + vat, amount, unitPrice, (String.valueOf(unit) + "   ").substring(0, 3));
    }

    public void itemSale(int deviceNumber, int rowNumber, String commodityName, long totalPrice, char vat, long amount, long unitPrice, String unit) throws Pegas06FMException {
        BigDecimal dTotalPrice = new BigDecimal("" + totalPrice);
        dTotalPrice = dTotalPrice.divide(HUNDRED);
        dTotalPrice = dTotalPrice.setScale(2, 4);
        BigDecimal dAmount = new BigDecimal("" + amount);
        if ((dAmount = dAmount.divide(THOUSAND)).scale() < 3) {
            dAmount = dAmount.setScale(3, 4);
        }
        BigDecimal dUnitPrice = new BigDecimal("" + unitPrice);
        if ((dUnitPrice = dUnitPrice.divide(HUNDRED)).scale() < 2) {
            dUnitPrice = dUnitPrice.setScale(2, 4);
        }
        this.executionCommand(deviceNumber, 36, "" + rowNumber, this.autoTwoLineItem ? String.format("%1$-40s", commodityName) : commodityName, dTotalPrice.toString(), "" + vat, dAmount.toString(), dUnitPrice.toString(), (String.valueOf(unit) + "   ").substring(0, 3));
    }

    public void itemVoid(int deviceNumber, int rowNumber, String commodityName, double totalPrice, char vat, double amount, double unitPrice, String unit, String referenceDocumentNumber) throws Pegas06FMException {
        BigDecimal dUnitPrice;
        BigDecimal dTotalPrice = new BigDecimal("" + totalPrice);
        dTotalPrice = dTotalPrice.setScale(2, 4);
        BigDecimal dAmount = new BigDecimal("" + amount);
        if (dAmount.scale() < 3) {
            dAmount = dAmount.setScale(3, 4);
        }
        if ((dUnitPrice = new BigDecimal("" + unitPrice)).scale() < 2) {
            dUnitPrice = dUnitPrice.setScale(2, 4);
        }
        this.itemVoid(deviceNumber, rowNumber, commodityName, dTotalPrice.toString(), vat, dAmount.toString(), dUnitPrice.toString(), unit, referenceDocumentNumber);
    }

    public void itemVoid_str(int deviceNumber, int rowNumber, String commodityName, String totalPrice, char vat, String amount, String unitPrice, String unit, String referenceDocumentNumber) throws Pegas06FMException {
        this.itemVoid(deviceNumber, rowNumber, commodityName, totalPrice, vat, amount, unitPrice, unit, referenceDocumentNumber);
    }

    public void itemVoid(int deviceNumber, int rowNumber, String commodityName, String totalPrice, char vat, String amount, String unitPrice, String unit, String referenceDocumentNumber) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 37, "" + rowNumber, this.autoTwoLineItem ? String.format("%1$-40s", commodityName) : commodityName, totalPrice, "" + vat, amount, unitPrice, (String.valueOf(unit) + "   ").substring(0, 3), referenceDocumentNumber);
    }

    public void itemVoid(int deviceNumber, int rowNumber, String commodityName, long totalPrice, char vat, long amount, long unitPrice, String unit, String referenceDocumentNumber) throws Pegas06FMException {
        BigDecimal dTotalPrice = new BigDecimal("" + totalPrice);
        dTotalPrice = dTotalPrice.divide(HUNDRED);
        dTotalPrice = dTotalPrice.setScale(2, 4);
        BigDecimal dAmount = new BigDecimal("" + amount);
        if ((dAmount = dAmount.divide(THOUSAND)).scale() < 3) {
            dAmount = dAmount.setScale(3, 4);
        }
        BigDecimal dUnitPrice = new BigDecimal("" + unitPrice);
        if ((dUnitPrice = dUnitPrice.divide(HUNDRED)).scale() < 2) {
            dUnitPrice = dUnitPrice.setScale(2, 4);
        }
        this.executionCommand(deviceNumber, 37, "" + rowNumber, this.autoTwoLineItem ? String.format("%1$-40s", commodityName) : commodityName, dTotalPrice.toString(), "" + vat, dAmount.toString(), dUnitPrice.toString(), (String.valueOf(unit) + "   ").substring(0, 3), referenceDocumentNumber);
    }

    public void itemReturn(int deviceNumber, int rowNumber, String commodityName, double totalPrice, char vat, double amount, double unitPrice, String unit, String referenceDocumentNumber) throws Pegas06FMException {
        BigDecimal dUnitPrice;
        BigDecimal dTotalPrice = new BigDecimal("" + totalPrice);
        dTotalPrice = dTotalPrice.setScale(2, 4);
        BigDecimal dAmount = new BigDecimal("" + amount);
        if (dAmount.scale() < 3) {
            dAmount = dAmount.setScale(3, 4);
        }
        if ((dUnitPrice = new BigDecimal("" + unitPrice)).scale() < 2) {
            dUnitPrice = dUnitPrice.setScale(2, 4);
        }
        this.itemReturn(deviceNumber, rowNumber, commodityName, dTotalPrice.toString(), vat, dAmount.toString(), dUnitPrice.toString(), unit, referenceDocumentNumber);
    }

    public void itemReturn_str(int deviceNumber, int rowNumber, String commodityName, String totalPrice, char vat, String amount, String unitPrice, String unit, String referenceDocumentNumber) throws Pegas06FMException {
        this.itemReturn(deviceNumber, rowNumber, commodityName, totalPrice, vat, amount, unitPrice, unit, referenceDocumentNumber);
    }

    public void itemReturn(int deviceNumber, int rowNumber, String commodityName, String totalPrice, char vat, String amount, String unitPrice, String unit, String referenceDocumentNumber) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 40, "" + rowNumber, this.autoTwoLineItem ? String.format("%1$-40s", commodityName) : commodityName, totalPrice, "" + vat, amount, unitPrice, (String.valueOf(unit) + "   ").substring(0, 3), referenceDocumentNumber);
    }

    public void itemReturn(int deviceNumber, int rowNumber, String commodityName, long totalPrice, char vat, long amount, long unitPrice, String unit, String referenceDocumentNumber) throws Pegas06FMException {
        BigDecimal dTotalPrice = new BigDecimal("" + totalPrice);
        dTotalPrice = dTotalPrice.divide(HUNDRED);
        dTotalPrice = dTotalPrice.setScale(2, 4);
        BigDecimal dAmount = new BigDecimal("" + amount);
        if ((dAmount = dAmount.divide(THOUSAND)).scale() < 3) {
            dAmount = dAmount.setScale(3, 4);
        }
        BigDecimal dUnitPrice = new BigDecimal("" + unitPrice);
        if ((dUnitPrice = dUnitPrice.divide(HUNDRED)).scale() < 2) {
            dUnitPrice = dUnitPrice.setScale(2, 4);
        }
        this.executionCommand(deviceNumber, 40, "" + rowNumber, this.autoTwoLineItem ? String.format("%1$-40s", commodityName) : commodityName, dTotalPrice.toString(), "" + vat, dAmount.toString(), dUnitPrice.toString(), (String.valueOf(unit) + "   ").substring(0, 3), referenceDocumentNumber);
    }

    public void itemNegative(int deviceNumber, int rowNumber, String commodityName, double totalPrice, char vat, double amount, double unitPrice, String unit) throws Pegas06FMException {
        BigDecimal dUnitPrice;
        BigDecimal dTotalPrice = new BigDecimal("" + totalPrice);
        dTotalPrice = dTotalPrice.setScale(2, 4);
        BigDecimal dAmount = new BigDecimal("" + amount);
        if (dAmount.scale() < 3) {
            dAmount = dAmount.setScale(3, 4);
        }
        if ((dUnitPrice = new BigDecimal("" + unitPrice)).scale() < 2) {
            dUnitPrice = dUnitPrice.setScale(2, 4);
        }
        this.itemNegative(deviceNumber, rowNumber, commodityName, dTotalPrice.toString(), vat, dAmount.toString(), dUnitPrice.toString(), unit);
    }

    public void itemNegative_str(int deviceNumber, int rowNumber, String commodityName, String totalPrice, char vat, String amount, String unitPrice, String unit) throws Pegas06FMException {
        this.itemNegative(deviceNumber, rowNumber, commodityName, totalPrice, vat, amount, unitPrice, unit);
    }

    public void itemNegative(int deviceNumber, int rowNumber, String commodityName, String totalPrice, char vat, String amount, String unitPrice, String unit) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 45, "" + rowNumber, this.autoTwoLineItem ? String.format("%1$-40s", commodityName) : commodityName, totalPrice, "" + vat, amount, unitPrice, (String.valueOf(unit) + "   ").substring(0, 3));
    }

    public void itemNegative(int deviceNumber, int rowNumber, String commodityName, long totalPrice, char vat, long amount, long unitPrice, String unit) throws Pegas06FMException {
        BigDecimal dTotalPrice = new BigDecimal("" + totalPrice);
        dTotalPrice = dTotalPrice.divide(HUNDRED);
        dTotalPrice = dTotalPrice.setScale(2, 4);
        BigDecimal dAmount = new BigDecimal("" + amount);
        if ((dAmount = dAmount.divide(THOUSAND)).scale() < 3) {
            dAmount = dAmount.setScale(3, 4);
        }
        BigDecimal dUnitPrice = new BigDecimal("" + unitPrice);
        if ((dUnitPrice = dUnitPrice.divide(HUNDRED)).scale() < 2) {
            dUnitPrice = dUnitPrice.setScale(2, 4);
        }
        this.executionCommand(deviceNumber, 45, "" + rowNumber, this.autoTwoLineItem ? String.format("%1$-40s", commodityName) : commodityName, dTotalPrice.toString(), "" + vat, dAmount.toString(), dUnitPrice.toString(), (String.valueOf(unit) + "   ").substring(0, 3));
    }

    public void itemDiscount(int deviceNumber, int rowNumber, String description, int operationType, double discountValue, char vat) throws Pegas06FMException {
        BigDecimal dDiscountValue = new BigDecimal("" + discountValue);
        dDiscountValue = dDiscountValue.setScale(2, 4);
        this.itemDiscount(deviceNumber, rowNumber, description, operationType, dDiscountValue.toString(), vat);
    }

    public void itemDiscount_str(int deviceNumber, int rowNumber, String description, int operationType, String discountValue, char vat) throws Pegas06FMException {
        this.itemDiscount(deviceNumber, rowNumber, description, operationType, discountValue, vat);
    }

    public void itemDiscount(int deviceNumber, int rowNumber, String description, int operationType, String discountValue, char vat) throws Pegas06FMException {
        if (vat == ' ') {
            this.executionCommand(deviceNumber, 38, "" + rowNumber, description, "" + operationType, discountValue);
        } else {
            this.executionCommand(deviceNumber, 38, "" + rowNumber, description, "" + operationType, discountValue, "" + vat);
        }
    }

    public void itemDiscount(int deviceNumber, int rowNumber, String description, int operationType, long discountValue, char vat) throws Pegas06FMException {
        BigDecimal dDiscountValue = new BigDecimal("" + discountValue);
        dDiscountValue = dDiscountValue.divide(HUNDRED);
        dDiscountValue = dDiscountValue.setScale(2, 4);
        if (vat == ' ') {
            this.executionCommand(deviceNumber, 38, "" + rowNumber, description, "" + operationType, dDiscountValue.toString());
        } else {
            this.executionCommand(deviceNumber, 38, "" + rowNumber, description, "" + operationType, dDiscountValue.toString(), "" + vat);
        }
    }

    public void itemDiscount2(int deviceNumber, int rowNumber, String description, int operationType, double discountValue, char vat, double discountTotalValue) throws Pegas06FMException {
        BigDecimal dDiscountValue = new BigDecimal("" + discountValue);
        dDiscountValue = dDiscountValue.setScale(2, 4);
        BigDecimal dDiscountTotalValue = new BigDecimal("" + discountTotalValue);
        dDiscountTotalValue = dDiscountTotalValue.setScale(2, 4);
        this.itemDiscount2(deviceNumber, rowNumber, description, operationType, dDiscountValue.toString(), vat, dDiscountTotalValue.toString());
    }

    public void itemDiscount2_str(int deviceNumber, int rowNumber, String description, int operationType, String discountValue, char vat, String discountTotalValue) throws Pegas06FMException {
        this.itemDiscount2(deviceNumber, rowNumber, description, operationType, discountValue, vat, discountTotalValue);
    }

    public void itemDiscount2(int deviceNumber, int rowNumber, String description, int operationType, String discountValue, char vat, String discountTotalValue) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 52, "" + rowNumber, description, "" + operationType, discountValue, vat != ' ' ? "" + vat : null, discountTotalValue);
    }

    public void itemDiscount2(int deviceNumber, int rowNumber, String description, int operationType, long discountValue, char vat, long discountTotalValue) throws Pegas06FMException {
        BigDecimal dDiscountValue = new BigDecimal("" + discountValue);
        dDiscountValue = dDiscountValue.divide(HUNDRED);
        dDiscountValue = dDiscountValue.setScale(2, 4);
        BigDecimal dDiscountTotalValue = new BigDecimal("" + discountTotalValue);
        dDiscountTotalValue = dDiscountTotalValue.divide(HUNDRED);
        dDiscountTotalValue = dDiscountTotalValue.setScale(2, 4);
        this.executionCommand(deviceNumber, 52, "" + rowNumber, description, "" + operationType, dDiscountValue.toString(), vat != ' ' ? "" + vat : null, dDiscountTotalValue.toString());
    }

    public void subTotal(int deviceNumber, int rowNumber, String description, int operationType) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 39, "" + rowNumber, description, "" + operationType);
    }

    public void payment(int deviceNumber, int rowNumber, int paymentNumber, double total, double payedAmount, double exchangeRate, String description) throws Pegas06FMException {
        String ExchangeRate;
        String PayedAmount;
        BigDecimal decimal = new BigDecimal("" + total);
        decimal = decimal.setScale(2, 4);
        String Total = decimal.toString();
        if (payedAmount == 0.0) {
            PayedAmount = "0";
        } else {
            decimal = new BigDecimal("" + payedAmount);
            decimal = decimal.setScale(2, 4);
            PayedAmount = decimal.toString();
        }
        if (exchangeRate == 0.0) {
            ExchangeRate = "0";
        } else {
            decimal = new BigDecimal("" + exchangeRate);
            decimal = decimal.setScale(4, 4);
            ExchangeRate = decimal.toString();
        }
        this.executionCommand(deviceNumber, 48, "" + rowNumber, "" + paymentNumber, Total, PayedAmount, ExchangeRate, description.equals("") ? "" : (String.valueOf(description) + "          ").substring(0, 10));
    }

    public void payment(int deviceNumber, int rowNumber, int paymentNumber, long total, long payedAmount, long exchangeRate, String description) throws Pegas06FMException {
        String ExchangeRate;
        String PayedAmount;
        BigDecimal decimal = new BigDecimal("" + total);
        decimal = decimal.divide(HUNDRED);
        decimal = decimal.setScale(2, 4);
        String Total = decimal.toString();
        if (payedAmount == 0L) {
            PayedAmount = "0";
        } else {
            decimal = new BigDecimal("" + payedAmount);
            decimal = decimal.divide(HUNDRED);
            decimal = decimal.setScale(2, 4);
            PayedAmount = decimal.toString();
        }
        if (exchangeRate == 0L) {
            ExchangeRate = "0";
        } else {
            decimal = new BigDecimal("" + exchangeRate);
            decimal = decimal.divide(TEN_THOUSAND);
            decimal = decimal.setScale(4, 4);
            ExchangeRate = decimal.toString();
        }
        this.executionCommand(deviceNumber, 48, "" + rowNumber, "" + paymentNumber, Total, PayedAmount, ExchangeRate, description.equals("") ? "" : (String.valueOf(description) + "          ").substring(0, 10));
    }

    public void payment2(int deviceNumber, int rowNumber, int paymentNumber, double total, double payedAmount, double exchangeRate, String description, double totalPayedAmount) throws Pegas06FMException {
        String TotalPayedAmount;
        String ExchangeRate;
        String PayedAmount;
        BigDecimal decimal = new BigDecimal("" + total);
        decimal = decimal.setScale(2, 4);
        String Total = decimal.toString();
        if (payedAmount == 0.0) {
            PayedAmount = "0";
        } else {
            decimal = new BigDecimal("" + payedAmount);
            decimal = decimal.setScale(2, 4);
            PayedAmount = decimal.toString();
        }
        if (exchangeRate == 0.0) {
            ExchangeRate = "0";
        } else {
            decimal = new BigDecimal("" + exchangeRate);
            decimal = decimal.setScale(4, 4);
            ExchangeRate = decimal.toString();
        }
        if (totalPayedAmount == 0.0) {
            TotalPayedAmount = "0";
        } else {
            decimal = new BigDecimal("" + totalPayedAmount);
            decimal = decimal.setScale(2, 4);
            TotalPayedAmount = decimal.toString();
        }
        this.executionCommand(deviceNumber, 54, "" + rowNumber, "" + paymentNumber, Total, PayedAmount, ExchangeRate, description.equals("") ? "" : (String.valueOf(description) + "          ").substring(0, 10), TotalPayedAmount);
    }

    public void payment2(int deviceNumber, int rowNumber, int paymentNumber, long total, long payedAmount, long exchangeRate, String description, long totalPayedAmount) throws Pegas06FMException {
        String TotalPayedAmount;
        String ExchangeRate;
        String PayedAmount;
        BigDecimal decimal = new BigDecimal("" + total);
        decimal = decimal.divide(HUNDRED);
        decimal = decimal.setScale(2, 4);
        String Total = decimal.toString();
        if (payedAmount == 0L) {
            PayedAmount = "0";
        } else {
            decimal = new BigDecimal("" + payedAmount);
            decimal = decimal.divide(HUNDRED);
            decimal = decimal.setScale(2, 4);
            PayedAmount = decimal.toString();
        }
        if (exchangeRate == 0L) {
            ExchangeRate = "0";
        } else {
            decimal = new BigDecimal("" + exchangeRate);
            decimal = decimal.divide(TEN_THOUSAND);
            decimal = decimal.setScale(4, 4);
            ExchangeRate = decimal.toString();
        }
        if (totalPayedAmount == 0L) {
            TotalPayedAmount = "0";
        } else {
            decimal = new BigDecimal("" + totalPayedAmount);
            decimal = decimal.divide(HUNDRED);
            decimal = decimal.setScale(2, 4);
            TotalPayedAmount = decimal.toString();
        }
        this.executionCommand(deviceNumber, 54, "" + rowNumber, "" + paymentNumber, Total, PayedAmount, ExchangeRate, description.equals("") ? "" : (String.valueOf(description) + "          ").substring(0, 10), TotalPayedAmount);
    }

    public void destroyParagon(int deviceNumber, int rowNumber, String description) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 43, "" + rowNumber, description);
    }

    public void repeatParagon(int deviceNumber) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 42, new String[0]);
    }

    public void subTotalDiscount(int deviceNumber, int rowNumber, String description, int operationType, double discountValue, char vat) throws Pegas06FMException {
        BigDecimal dDiscountValue = new BigDecimal("" + discountValue);
        dDiscountValue = dDiscountValue.setScale(2, 4);
        this.subTotalDiscount(deviceNumber, rowNumber, description, operationType, dDiscountValue.toString(), vat);
    }

    public void subTotalDiscount_str(int deviceNumber, int rowNumber, String description, int operationType, String discountValue, char vat) throws Pegas06FMException {
        this.subTotalDiscount(deviceNumber, rowNumber, description, operationType, discountValue, vat);
    }

    public void subTotalDiscount(int deviceNumber, int rowNumber, String description, int operationType, String discountValue, char vat) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 44, "" + rowNumber, description, "" + operationType, discountValue, vat != ' ' ? "" + vat : "");
    }

    public void subTotalDiscount(int deviceNumber, int rowNumber, String description, int operationType, long discountValue, char vat) throws Pegas06FMException {
        BigDecimal decimal = new BigDecimal("" + discountValue);
        decimal = decimal.divide(HUNDRED);
        decimal = decimal.setScale(2, 4);
        this.executionCommand(deviceNumber, 44, "" + rowNumber, description, "" + operationType, decimal.toString(), vat != ' ' ? "" + vat : "");
    }

    public void subTotalDiscount2(int deviceNumber, int rowNumber, String description, int operationType, double discountValue, double discountTotalValue, char vat) throws Pegas06FMException {
        BigDecimal dDiscountValue = new BigDecimal("" + discountValue);
        dDiscountValue = dDiscountValue.setScale(2, 4);
        BigDecimal dDiscountTotalValue = new BigDecimal("" + discountTotalValue);
        dDiscountTotalValue = dDiscountTotalValue.setScale(2, 4);
        this.subTotalDiscount2(deviceNumber, rowNumber, description, operationType, dDiscountValue.toString(), dDiscountTotalValue.toString(), vat);
    }

    public void subTotalDiscount2_str(int deviceNumber, int rowNumber, String description, int operationType, String discountValue, String discountTotalValue, char vat) throws Pegas06FMException {
        this.subTotalDiscount2(deviceNumber, rowNumber, description, operationType, discountValue, discountTotalValue, vat);
    }

    public void subTotalDiscount2(int deviceNumber, int rowNumber, String description, int operationType, String discountValue, String discountTotalValue, char vat) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 53, "" + rowNumber, description, "" + operationType, discountValue, discountTotalValue, vat != ' ' ? "" + vat : "");
    }

    public void subTotalDiscount2(int deviceNumber, int rowNumber, String description, int operationType, long discountValue, long discountTotalValue, char vat) throws Pegas06FMException {
        BigDecimal dDiscountValue = new BigDecimal("" + discountValue);
        dDiscountValue = dDiscountValue.divide(HUNDRED);
        dDiscountValue = dDiscountValue.setScale(2, 4);
        BigDecimal dDiscountTotalValue = new BigDecimal("" + discountTotalValue);
        dDiscountTotalValue = dDiscountTotalValue.divide(HUNDRED);
        dDiscountTotalValue = dDiscountTotalValue.setScale(2, 4);
        this.executionCommand(deviceNumber, 53, "" + rowNumber, description, "" + operationType, dDiscountValue.toString(), dDiscountTotalValue.toString(), vat != ' ' ? "" + vat : "");
    }

    public void printAnnouncement(int deviceNumber, int rowNumber, String text) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 49, "" + rowNumber, text);
    }

    public void printAnnouncementNF(int deviceNumber, int rowNumber, String text) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 50, "" + rowNumber, text);
    }

    public void printDisplay(int deviceNumber, int displayType, String escSequence, String text) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 197, "" + displayType, escSequence, text);
    }

    public void clearDisplay(int deviceNumber, int displayType, String escSequence) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 198, "" + displayType, escSequence);
    }

    public void setEscapeSequence(int deviceNumber, String sequence) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 199, sequence);
    }

    public String getEscapeSequence(int deviceNumber, String sequence) throws Pegas06FMException {
        FMDataStringListener dataListener = new FMDataStringListener(this.charset);
        this.getCommand(deviceNumber, 145, dataListener, sequence);
        return dataListener.getData();
    }

    public void setAllVats(int deviceNumber, String password, double vatValueA, double reverseConstantA, double vatValueB, double reverseConstantB, double vatValueC, double reverseConstantC, double vatValueD, double reverseConstantD, double vatValueE, double reverseConstantE) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 144, password, "" + (int)vatValueA, "" + (int)reverseConstantA, "" + (int)vatValueB, "" + (int)reverseConstantB, "" + (int)vatValueC, "" + (int)reverseConstantC, "" + (int)vatValueD, "" + (int)reverseConstantD, "" + (int)vatValueE, "" + (int)reverseConstantE);
    }

    public void depositeInDrawer(int deviceNumber, int rowNumber, String description, int operationType, double amount, int paymentNumber) throws Pegas06FMException {
        BigDecimal decimal = new BigDecimal("" + amount);
        decimal = decimal.setScale(2, 4);
        this.executionCommand(deviceNumber, 46, "" + rowNumber, description, "" + operationType, decimal.toString(), "" + paymentNumber);
    }

    public void depositeInDrawer(int deviceNumber, int rowNumber, String description, int operationType, long amount, int paymentNumber) throws Pegas06FMException {
        BigDecimal decimal = new BigDecimal("" + amount);
        decimal = decimal.divide(HUNDRED);
        decimal = decimal.setScale(2, 4);
        this.executionCommand(deviceNumber, 46, "" + rowNumber, description, "" + operationType, decimal.toString(), "" + paymentNumber);
    }

    public void printDisplay2(int deviceNumber, int displayType, String text) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 200, "" + displayType, text);
    }

    public void printBC(int deviceNumber, int codeType, String code) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 55, "" + codeType, code);
    }

    public void freeID(int deviceNumber, boolean print, String freeId) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 56, print ? "1" : "0", freeId);
    }

    public void setQrParm(int deviceNumber, int model, int moduleWidth, int correctionLevel, int leftMargin, int viewMode) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 236, "" + model, "" + moduleWidth, "" + correctionLevel, "" + leftMargin, "" + viewMode);
    }

    public void printQrCode(int deviceNumber, String code) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 237, code);
    }

    public void setHeader(int deviceNumber, String password, int rowNumber, String text) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 188, password, "" + rowNumber, text);
    }

    public void setAdditionalHeader(int deviceNumber, String text) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 193, text);
    }

    public void setAdditionalFooter(int deviceNumber, String text) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 194, text);
    }

    public void setPreline(int deviceNumber, String description) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 195, description);
    }

    public void setPostline(int deviceNumber, String description) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 196, description);
    }

    public void fiscalization(int deviceNumber, String password, String dkp) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 176, password, dkp);
    }

    public void fiscalization(int deviceNumber, String password) throws Pegas06FMException {
        this.fiscalization(deviceNumber, password, "");
    }

    public void setDateTime(int deviceNumber, String date) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 191, date);
    }

    public void setVAT(int deviceNumber, String password, char vat, double vatValue, double reverseConstant) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 190, password, "" + vat, "" + (int)vatValue, "" + (int)reverseConstant);
    }

    public void setVAT(int deviceNumber, String password, char vat, long vatValue, long reverseConstant) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 190, password, "" + vat, "" + vatValue, "" + reverseConstant);
    }

    public void setParameter(int deviceNumber, String password, int paramNumber, int paramValue) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 189, password, "" + paramNumber, "" + paramValue);
    }

    public void setV48(int deviceNumber, String password, int stateV48) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 164, password, "" + stateV48);
    }

    public void loadGHMMC(int deviceNumber, int imageNumber, int leftSpacing) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 208, "" + imageNumber, "" + leftSpacing);
        if (this.graphicHeadersMMC.get(imageNumber) == null) {
            this.blockOut(new byte[4], true);
        } else {
            this.blockOut(this.graphicHeadersMMC.get(imageNumber), true);
        }
    }

    public void loadGHMMC1(int deviceNumber, int imageNumber, int leftSpacing) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 210, "" + imageNumber, "" + leftSpacing);
        if (this.graphicHeadersMMC1.get(imageNumber) == null) {
            this.blockOut(new byte[4], true);
        } else {
            this.blockOut(this.graphicHeadersMMC1.get(imageNumber), true);
        }
    }

    public void loadGHNV(int deviceNumber, int imageCount, int leftSpacing1, int leftSpacing2, int leftSpacing3, int leftSpacing4, int leftSpacing5, int leftSpacing6) throws Pegas06FMException {
        byte[][] imageStreams = new byte[7][];
        int imageNumber = 1;
        while (imageNumber <= imageCount) {
            imageStreams[imageNumber] = this.graphicHeadersNV.get(imageNumber) == null ? new byte[4] : this.graphicHeadersNV.get(imageNumber);
            ++imageNumber;
        }
        this.executionCommand(deviceNumber, 209, "" + imageCount, String.valueOf(leftSpacing1 < 10 ? "0" + leftSpacing1 : "" + leftSpacing1) + (leftSpacing2 < 10 ? "0" + leftSpacing2 : "" + leftSpacing2) + (leftSpacing3 < 10 ? "0" + leftSpacing3 : "" + leftSpacing3) + (leftSpacing4 < 10 ? "0" + leftSpacing4 : "" + leftSpacing4) + (leftSpacing5 < 10 ? "0" + leftSpacing5 : "" + leftSpacing5) + (leftSpacing6 < 10 ? "0" + leftSpacing6 : "" + leftSpacing6));
        imageNumber = 1;
        while (imageNumber <= imageCount) {
            if (imageNumber == imageCount) {
                this.blockOut(imageStreams[imageNumber], true);
            } else {
                this.blockOut(imageStreams[imageNumber], false);
            }
            ++imageNumber;
        }
    }

    public void loadBitMap(int deviceNumber, int imageNumber, int leftSpacing) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 208, "" + imageNumber, "" + leftSpacing);
        if (this.graphicHeadersMMC.get(imageNumber) == null) {
            this.blockOut(new byte[4], true);
        } else {
            this.blockOut(this.graphicHeadersMMC.get(imageNumber), true);
        }
    }

    public void setEuroExchangeRate(int deviceNumber, double exchangeRate) throws Pegas06FMException {
        String rate;
        BigDecimal decimal = new BigDecimal("" + exchangeRate);
        if (decimal.equals(BigDecimal.ZERO)) {
            rate = "0";
        } else {
            decimal = decimal.setScale(4, 4);
            rate = decimal.toString();
        }
        this.executionCommand(deviceNumber, 178, rate);
    }

    public void setEuroExchangeRate(int deviceNumber, long exchangeRate) throws Pegas06FMException {
        String rate;
        BigDecimal decimal = new BigDecimal("" + exchangeRate);
        if (decimal.equals(BigDecimal.ZERO)) {
            rate = "0";
        } else {
            decimal = decimal.divide(TEN_THOUSAND);
            decimal = decimal.setScale(4, 4);
            rate = decimal.toString();
        }
        this.executionCommand(deviceNumber, 178, rate);
    }

    @Deprecated
    public void setPeymentType(int deviceNumber, int paymentTypeNumber, double minCurrency, boolean overPay) throws Pegas06FMException {
        this.setPaymentType(deviceNumber, paymentTypeNumber, minCurrency, overPay);
    }

    public void setPaymentType(int deviceNumber, int paymentTypeNumber, double minCurrency, boolean overPay) throws Pegas06FMException {
        BigDecimal decimal = new BigDecimal("" + minCurrency);
        decimal = decimal.setScale(2, 5);
        this.executionCommand(deviceNumber, 187, "" + paymentTypeNumber, decimal.toString(), overPay ? "0" : "1");
    }

    public void setPaymentType(int deviceNumber, int paymentTypeNumber, long minCurrency, boolean overPay) throws Pegas06FMException {
        BigDecimal decimal = new BigDecimal("" + minCurrency);
        decimal = decimal.divide(HUNDRED);
        decimal = decimal.setScale(2, 5);
        this.executionCommand(deviceNumber, 187, "" + paymentTypeNumber, decimal.toString(), overPay ? "0" : "1");
    }

    @Deprecated
    public void setPeymentType2(int deviceNumber, String paymentTypeName, int paymentTypeNumber, double minCurrency, boolean overPay) throws Pegas06FMException {
        this.setPaymentType2(deviceNumber, paymentTypeName, paymentTypeNumber, minCurrency, overPay);
    }

    public void setPaymentType2(int deviceNumber, String paymentTypeName, int paymentTypeNumber, double minCurrency, boolean overPay) throws Pegas06FMException {
        BigDecimal decimal = new BigDecimal("" + minCurrency);
        decimal = decimal.setScale(2, 5);
        this.executionCommand(deviceNumber, 184, paymentTypeName, "" + paymentTypeNumber, decimal.toString(), overPay ? "0" : "1");
    }

    public void setPaymentType2(int deviceNumber, String paymentTypeName, int paymentTypeNumber, long minCurrency, boolean overPay) throws Pegas06FMException {
        BigDecimal decimal = new BigDecimal("" + minCurrency);
        decimal = decimal.divide(HUNDRED);
        decimal = decimal.setScale(2, 5);
        this.executionCommand(deviceNumber, 184, paymentTypeName, "" + paymentTypeNumber, decimal.toString(), overPay ? "0" : "1");
    }

    public void setPassword(int deviceNumber, String oldPassword, String newPassword) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 183, oldPassword, newPassword);
    }

    public void setPrinterType(int deviceNumber, String servicePassword, int printerType, int speed) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 182, servicePassword, "" + printerType, "" + speed);
    }

    public void setPRNBd(int deviceNumber, int speed) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 180, "" + speed);
    }

    public void setBCparm(int deviceNumber, int textPosition, int textFont, int height, int width) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 213, "" + textPosition, "" + textFont, "" + height, "" + width);
    }

    public void setPParameter(int deviceNumber, String password, int paramType, int value) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 214, password, "" + paramType, "" + value);
    }

    public void setPRNcolumns(int deviceNumber, int width) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 216, "" + width);
    }

    public void setDeltaSI(int deviceNumber, String password, int days) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 218, password, "" + days);
    }

    public void setDispF(int deviceNumber, String password, int displayType, int displayProfile, String parameters) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 219, password, "" + displayType, "" + displayProfile, parameters);
    }

    public void setBluetooth(int deviceNumber, int bluetooth) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 250, "" + bluetooth);
    }

    public void setBTPin(int deviceNumber, String oldPin, String newPin) throws Pegas06FMException {
        this.setBluetoothPin(deviceNumber, oldPin, newPin);
    }

    public void setBluetoothPin(int deviceNumber, String oldPin, String newPin) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 234, oldPin, newPin);
    }

    public void setWifiParam(int deviceNumber, int profile, String p1, String p2, String p3, String p4, String p5, String p6, String p7, String p8, String p9, String p10) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 170, "" + profile, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10);
    }

    public void set3GParam(int deviceNumber, String profile, String pin) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 171, profile, pin);
    }

    public void setSleepMode(int deviceNumber, String sleepMode, String sleepTime, String autoOff, String displayOff) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 251, sleepMode, sleepTime, autoOff, displayOff);
    }

    public void setSleepMode(int deviceNumber, int sleepMode, int sleepTime, int autoOff, int displayOff) throws Pegas06FMException {
        this.setSleepMode(deviceNumber, "" + sleepMode, "" + sleepTime, "" + autoOff, "" + displayOff);
    }

    public void setTpg(int deviceNumber, String password, String tpg) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 252, password, tpg);
    }

    public void setUctFormat(int deviceNumber, String format) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 235, format);
    }

    public void setUctFormat(int deviceNumber, int format) throws Pegas06FMException {
        this.setUctFormat(deviceNumber, "" + format);
    }

    public void printReport(int deviceNumber, char reportType, int reportNumber) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 80, "" + reportType, "" + reportNumber);
    }

    public String getVariable(int deviceNumber, String variableCode) throws Pegas06FMException {
        FMDataStringListener dataListener = new FMDataStringListener(this.charset);
        this.getCommand(deviceNumber, 146, dataListener, variableCode);
        return dataListener.getData();
    }

    public void getJournal(int deviceNumber) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 159, new String[0]);
    }

    public String getLastParagon(int deviceNumber) throws Pegas06FMException {
        FMDataStringListener dataListener = new FMDataStringListener(this.charset);
        this.getCommand(deviceNumber, 147, dataListener, new String[0]);
        return dataListener.getData();
    }

    public String getStructJournalD(int deviceNumber, char journalType, String dateFrom, String dateTo) throws Pegas06FMException {
        FMDataStringListener dataListener = new FMDataStringListener(this.charset);
        this.getCommand(deviceNumber, 151, dataListener, "" + journalType, dateFrom, dateTo);
        return dataListener.getData();
    }

    public String getJournalStructD(int deviceNumber, char journalType, String dateFrom, String dateTo) throws Pegas06FMException {
        return this.getStructJournalD(deviceNumber, journalType, dateFrom, dateTo);
    }

    public String getStructJournalZ(int deviceNumber, int numberFrom, int numberTo) throws Pegas06FMException {
        FMDataStringListener dataListener = new FMDataStringListener(this.charset);
        this.getCommand(deviceNumber, 152, dataListener, String.format("%1$4d", numberFrom).replace(' ', '0'), String.format("%1$4d", numberTo).replace(' ', '0'));
        return dataListener.getData();
    }

    public String getJournalStructZ(int deviceNumber, int numberFrom, int numberTo) throws Pegas06FMException {
        return this.getStructJournalZ(deviceNumber, numberFrom, numberTo);
    }

    public String getStructJournalU(int deviceNumber, String paragonSn) throws Pegas06FMException {
        FMDataStringListener dataListener = new FMDataStringListener(this.charset);
        this.getCommand(deviceNumber, 153, dataListener, paragonSn);
        return dataListener.getData();
    }

    public String getJournalStructU(int deviceNumber, String paragonSn) throws Pegas06FMException {
        return this.getStructJournalU(deviceNumber, paragonSn);
    }

    public void printStructJournalD(int deviceNumber, char journalType, String dateFrom, String dateTo) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 87, "" + journalType, dateFrom, dateTo);
    }

    public void printJournalStructD(int deviceNumber, char journalType, String dateFrom, String dateTo) throws Pegas06FMException {
        this.printStructJournalD(deviceNumber, journalType, dateFrom, dateTo);
    }

    public void printStructJournalZ(int deviceNumber, int numberFrom, int numberTo) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 88, String.format("%1$4d", numberFrom).replace(' ', '0'), String.format("%1$4d", numberTo).replace(' ', '0'));
    }

    public void printJournalStructZ(int deviceNumber, int numberFrom, int numberTo) throws Pegas06FMException {
        this.printStructJournalZ(deviceNumber, numberFrom, numberTo);
    }

    public void printStructJournalU(int deviceNumber, String paragonSn) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 89, paragonSn);
    }

    public void printJournalStructU(int deviceNumber, String paragonSn) throws Pegas06FMException {
        this.printStructJournalU(deviceNumber, paragonSn);
    }

    public String getJournalStructD1(int deviceNumber, char journalType, String dateFrom, String dateTo) throws Pegas06FMException {
        FMDataStringListener dataListener = new FMDataStringListener(this.charset);
        this.getCommand(deviceNumber, 154, dataListener, "" + journalType, dateFrom, dateTo);
        return dataListener.getData();
    }

    public void printJournalStructD1(int deviceNumber, char journalType, String dateFrom, String dateTo) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 90, "" + journalType, dateFrom, dateTo);
    }

    public String getJournalStructZ1(int deviceNumber, char docId, int numberFrom, int numberTo) throws Pegas06FMException {
        FMDataStringListener dataListener = new FMDataStringListener(this.charset);
        this.getCommand(deviceNumber, 155, dataListener, "" + docId, "" + numberFrom, "" + numberTo);
        return dataListener.getData();
    }

    public void printJournalStructZ1(int deviceNumber, char docId, int numberFrom, int numberTo) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 91, "" + docId, "" + numberFrom, "" + numberTo);
    }

    public String getJournalFATD1(int deviceNumber, char journalType, String dateFrom, String dateTo) throws Pegas06FMException {
        FMDataStringListener dataListener = new FMDataStringListener(this.charset);
        this.getCommand(deviceNumber, 160, dataListener, "" + journalType, dateFrom, dateTo);
        return dataListener.getData();
    }

    public void initFP(int deviceNumber, String servicePassword) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 240, servicePassword);
    }

    public void initFM(int deviceNumber, String servicePassword) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 244, servicePassword);
    }

    public void initELJ(int deviceNumber) throws Pegas06FMException {
        this.initELJ(deviceNumber, "");
    }

    public void initELJ(int deviceNumber, String servicePassword) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 243, servicePassword);
    }

    public void defiscalizationFM(int deviceNumber, String servicePassword) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 241, servicePassword);
    }

    public void getIntervalFDAll(int deviceNumber, String journalFile) throws Pegas06FMException {
        try {
            FileOutputStream fos = new FileOutputStream(journalFile);
            FMDataFileListener dataListener = new FMDataFileListener(fos, this.charset);
            dataListener.setBinary(true);
            this.getCommand(deviceNumber, 84, dataListener, new String[0]);
            return;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10200);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10201);
        }
    }

    public void printIntervalFPD(int deviceNumber, int printType, String dateFrom, String dateTo) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 82, "" + printType, dateFrom, dateTo);
    }

    public void printIntervalFPC(int deviceNumber, int printType, int numberFrom, int numberTo) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 83, "" + printType, "" + numberFrom, "" + numberTo);
    }

    public String getIntervalFPD(int deviceNumber, int printType, String dateFrom, String dateTo) throws Pegas06FMException {
        FMDataStringListener dataListener = new FMDataStringListener(this.charset);
        this.getCommand(deviceNumber, 156, dataListener, "" + printType, dateFrom, dateTo);
        return dataListener.getData();
    }

    public String getIntervalFPC(int deviceNumber, int printType, int numberFrom, int numberTo) throws Pegas06FMException {
        FMDataStringListener dataListener = new FMDataStringListener(this.charset);
        this.getCommand(deviceNumber, 157, dataListener, "" + printType, "" + numberFrom, "" + numberTo);
        return dataListener.getData();
    }

    public void printJobCancel(int deviceNumber) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 224, new String[0]);
    }

    public void confirmNote(int deviceNumber) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 225, new String[0]);
    }

    public void verifyCRCElj(int deviceNumber, long closureNumber) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 245, "" + closureNumber);
    }

    public void inspectionEnabled(int deviceNumber, String servicePassword) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 246, servicePassword);
    }

    public void inspectionE(int deviceNumber, String servicePassword) throws Pegas06FMException {
        this.inspectionEnabled(deviceNumber, servicePassword);
    }

    public void closeELJcard(int deviceNumber) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 247, new String[0]);
    }

    public void inspectionE1(int deviceNumber, String password, int days) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 249, password, "" + days);
    }

    public void swReset(int deviceNumber, String password) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 119, password);
    }

    public void restoreBCKP(int deviceNumber, String password) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 120, password);
    }

    public String getBCKP(int deviceNumber, String password, int page) throws Pegas06FMException {
        FMDataStringListener dataListener = new FMDataStringListener(this.charset);
        this.getCommand(deviceNumber, 121, dataListener, password, "" + page);
        return dataListener.getData();
    }

    public void testPegasFM(int deviceNumber, String password, int device) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 122, password, "" + device);
    }

    public String getRAMMP(int deviceNumber, String password) throws Pegas06FMException {
        FMDataStringListener dataListener = new FMDataStringListener(this.charset);
        this.getCommand(deviceNumber, 123, dataListener, password);
        return dataListener.getData();
    }

    public void setPCHDU(int deviceNumber, int interfaceType, String name) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 205, "" + interfaceType, name);
    }

    public void setLocation(int deviceNumber, int inputType, String ... parameters) throws Pegas06FMException {
        String[] data = new String[parameters.length + 1];
        data[0] = "" + inputType;
        int i = 1;
        while (i < data.length) {
            data[i] = parameters[i - 1];
            ++i;
        }
        this.executionCommand(deviceNumber, 204, data);
    }

    public void setClientID(int deviceNumber, String number, int type) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 203, number, "" + type);
    }

    public void printIssuedParagon(int deviceNumber, long serialNumber, String date) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 202, "" + serialNumber, date);
    }

    public void setInvoiceNumber(int deviceNumber, String invoiceNumber) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 201, invoiceNumber);
    }

    public void vymenaPoukazu(int deviceNumber, String name, double amount, char vat, double price, String voucherNumber) throws Pegas06FMException {
        BigDecimal dAmount = new BigDecimal("" + amount);
        BigDecimal dPrice = new BigDecimal("" + price);
        dPrice = dPrice.setScale(2, 4);
        if (dAmount.scale() < 3) {
            dAmount = dAmount.setScale(3, 4);
        }
        if (dPrice.scale() < 2) {
            dPrice = dPrice.setScale(2, 4);
        }
        this.vymenaPoukazu_str(deviceNumber, name, dAmount.toString(), "" + vat, dPrice.toString(), voucherNumber);
    }

    public void vymenaPoukazu_str(int deviceNumber, String name, String amount, String vat, String price, String voucherNumber) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 192, name, amount, vat, price, voucherNumber);
    }

    public void vymenaPoukazu(int deviceNumber, String name, String amount, String vat, String price, String voucherNumber) throws Pegas06FMException {
        this.vymenaPoukazu_str(deviceNumber, this.autoTwoLineItem ? String.format("%1$-40s", name) : name, amount, vat, price, voucherNumber);
    }

    public void vymenaPoukazu(int deviceNumber, String name, long amount, char vat, long price, String voucherNumber) throws Pegas06FMException {
        BigDecimal dAmount = new BigDecimal("" + amount);
        dAmount = dAmount.divide(HUNDRED);
        dAmount = dAmount.setScale(2, 4);
        BigDecimal dPrice = new BigDecimal("" + price);
        dPrice = dPrice.divide(HUNDRED);
        dPrice = dPrice.setScale(2, 4);
        this.vymenaPoukazu_str(deviceNumber, this.autoTwoLineItem ? String.format("%1$-40s", name) : name, dAmount.toString(), "" + vat, dPrice.toString(), voucherNumber);
    }

    public void odpocitanaZaloha(int deviceNumber, String name, double amount, char vat, double price) throws Pegas06FMException {
        BigDecimal dAmount = new BigDecimal("" + amount);
        BigDecimal dPrice = new BigDecimal("" + price);
        dPrice = dPrice.setScale(2, 4);
        if (dAmount.scale() < 3) {
            dAmount = dAmount.setScale(3, 4);
        }
        if (dPrice.scale() < 2) {
            dPrice = dPrice.setScale(2, 4);
        }
        this.odpocitanaZaloha_str(deviceNumber, name, dAmount.toString(), vat, dPrice.toString());
    }

    public void odpocitanaZaloha_str(int deviceNumber, String name, String amount, char vat, String price) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 179, name, amount, "" + vat, price);
    }

    public void odpocitanaZaloha(int deviceNumber, String name, String amount, char vat, String price) throws Pegas06FMException {
        this.odpocitanaZaloha_str(deviceNumber, this.autoTwoLineItem ? String.format("%1$-40s", name) : name, amount, vat, price);
    }

    public void odpocitanaZaloha(int deviceNumber, String name, long amount, char vat, long price) throws Pegas06FMException {
        BigDecimal dAmount = new BigDecimal("" + amount);
        dAmount = dAmount.divide(HUNDRED);
        dAmount = dAmount.setScale(2, 4);
        BigDecimal dPrice = new BigDecimal("" + price);
        dPrice = dPrice.divide(HUNDRED);
        dPrice = dPrice.setScale(2, 4);
        this.odpocitanaZaloha_str(deviceNumber, this.autoTwoLineItem ? String.format("%1$-40s", name) : name, dAmount.toString(), vat, dPrice.toString());
    }

    public String getParagonIDs(int deviceNumber, int inputType, String input) throws Pegas06FMException {
        FMDataStringListener dataListener = new FMDataStringListener(this.charset);
        this.getCommand(deviceNumber, 175, dataListener, "" + inputType, input);
        return dataListener.getData();
    }

    public void setTransactionID(int deviceNumber, String internalCode) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 174, internalCode);
    }

    public void printUnsentSFSpackets(int deviceNumber) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 168, new String[0]);
    }

    public void setEmail(int deviceNumber, String email) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 167, email);
    }

    public void setSMTP(int deviceNumber, int type, String address, int port, String localDir) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 166, "" + type, address, "" + port, localDir);
    }

    public void sendUnsentSFSpackets(int deviceNumber) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 162, new String[0]);
    }

    public void setAutKey(int deviceNumber, String password, String filePath) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 163, password, filePath);
    }

    public void setSubjectIDData(int deviceNumber, String filePath) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 161, filePath);
    }

    public void popis0DPH(int deviceNumber, int type) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 158, "" + type);
    }

    public void setSellerID(int deviceNumber, String number, int type) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 150, number, "" + type);
    }

    public void opravaDokladu(int deviceNumber, String errorCode) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 149, errorCode);
    }

    public String getBin(int deviceNumber) throws Pegas06FMException {
        FMDataStringListener dataListener = new FMDataStringListener(this.charset);
        this.getCommand(deviceNumber, 165, dataListener, new String[0]);
        return dataListener.getData();
    }

    public void openDrawer(int deviceNumber, int index) throws Pegas06FMException {
        switch (index) {
            case 1: {
                this.setEscapeSequence(deviceNumber, "~1B~70~00~20~80");
                break;
            }
            case 2: {
                this.setEscapeSequence(deviceNumber, "~1B~70~01~20~80");
            }
        }
    }

    public void saveIntervalFPD(int deviceNumber, int printType, String dateFrom, String dateTo, String filename) throws Pegas06FMException {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            FMDataFileListener dataListener = new FMDataFileListener(fos, this.charset);
            dataListener.setBinary(false);
            this.getCommand(deviceNumber, 156, dataListener, "" + printType, dateFrom, dateTo);
            return;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10200);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10201);
        }
    }

    public void saveIntervalFPC(int deviceNumber, int printType, int numberFrom, int numberTo, String filename) throws Pegas06FMException {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            FMDataFileListener dataListener = new FMDataFileListener(fos, this.charset);
            dataListener.setBinary(false);
            this.getCommand(deviceNumber, 157, dataListener, "" + printType, "" + numberFrom, "" + numberTo);
            return;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10200);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10201);
        }
    }

    public void testELJ(int deviceNumber) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 248, new String[0]);
    }

    public void saveBCKP(int deviceNumber, String password, int page, String filename) throws Pegas06FMException {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            FMDataFileListener dataListener = new FMDataFileListener(fos, this.charset);
            dataListener.setBinary(false);
            this.getCommand(deviceNumber, 121, dataListener, password, "" + page);
            return;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10200);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10201);
        }
    }

    public String getLogAll(int deviceNumber) throws Pegas06FMException {
        FMDataStringListener dataListener = new FMDataStringListener(this.charset);
        this.getCommand(deviceNumber, 253, dataListener, new String[0]);
        return dataListener.getData();
    }

    public void printFlashSha1(int deviceNumber) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 254, new String[0]);
    }

    public void saveRAMMP(int deviceNumber, String password, String filename) throws Pegas06FMException {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            FMDataFileListener dataListener = new FMDataFileListener(fos, this.charset);
            dataListener.setBinary(false);
            this.getCommand(deviceNumber, 123, dataListener, password);
            return;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10200);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10201);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readBlockResponse(int deviceNumber) throws Pegas06FMException {
        ByteArrayOutputStream byteArrayOutputStream = this.byteArray;
        synchronized (byteArrayOutputStream) {
            this.byteArray.reset();
            this.byteArray.write(28);
            this.byteArray.write(deviceNumber);
            this.byteArray.write(239);
            this.byteArray.write(4);
            byte[] data = this.byteArray.toByteArray();
            return this.blockGet16(data).toString();
        }
    }

    public void setBlockTransfer(int deviceNumber, String[] commands) throws Pegas06FMException {
        this.setBlockTransfer(deviceNumber, commands, (byte)55, (byte)48);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlockTransfer(int deviceNumber, String[] commands, byte bufferSize, byte dataType) throws Pegas06FMException {
        ByteArrayOutputStream byteArrayOutputStream = this.byteArray;
        synchronized (byteArrayOutputStream) {
            this.byteArray.reset();
            this.byteArray.write(28);
            this.byteArray.write(deviceNumber);
            this.byteArray.write(238);
            this.byteArray.write(bufferSize);
            this.byteArray.write(0);
            this.byteArray.write(dataType);
            this.byteArray.write(0);
            this.byteArray.write(4);
            byte[] data = this.byteArray.toByteArray();
            this.dataOut(data);
            StringBuilder packet = new StringBuilder();
            int i = 0;
            while (i < commands.length) {
                if (packet.length() + commands.length > 256) {
                    this.blockOut16(this.charsetEncode(packet.toString()), false);
                    packet.setLength(0);
                }
                packet.append(commands[i]);
                ++i;
            }
            this.blockOut16(this.charsetEncode(packet.toString()), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getCommand(int deviceNumber, int command, FMDataListener dataListener, String ... params) throws Pegas06FMException {
        switch (command) {
            case 146: 
            case 147: {
                dataListener.setBinary(false);
            }
        }
        dataListener.setBinary(true);
        ByteArrayOutputStream byteArrayOutputStream = this.byteArray;
        synchronized (byteArrayOutputStream) {
            this.byteArray.reset();
            this.byteArray.write(28);
            this.byteArray.write(deviceNumber);
            this.byteArray.write(command);
            String[] stringArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                if (p != null) {
                    byte[] bytes = this.charsetEncode(p);
                    this.byteArray.write(bytes, 0, bytes.length);
                }
                this.byteArray.write(0);
                ++n2;
            }
            this.byteArray.write(4);
            byte[] data = this.byteArray.toByteArray();
            this.blockGet(data, dataListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executionCommand(int deviceNumber, int command, String ... params) throws Pegas06FMException {
        ByteArrayOutputStream byteArrayOutputStream = this.byteArray;
        synchronized (byteArrayOutputStream) {
            this.byteArray.reset();
            this.byteArray.write(28);
            this.byteArray.write(deviceNumber);
            this.byteArray.write(command);
            String[] stringArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                if (p != null) {
                    byte[] bytes = this.charsetEncode(p);
                    this.byteArray.write(bytes, 0, bytes.length);
                }
                this.byteArray.write(0);
                ++n2;
            }
            this.byteArray.write(4);
            byte[] data = this.byteArray.toByteArray();
            this.dataOut(data);
        }
    }

    public void prepareGraphicHeader(int imageIndex, byte[] imageData) throws Pegas06FMException {
        this.prepareGraphicHeader(imageIndex, imageData, false);
    }

    public void prepareGraphicHeader(int imageIndex, byte[] imageData, boolean inverse) throws Pegas06FMException {
        int i;
        StringBuilder b;
        int x;
        BMPLoader.BitmapHeader bh = new BMPLoader.BitmapHeader();
        int pos = bh.read(imageData);
        if (bh.nbitcount != 1) {
            throw new Pegas06FMException(-10104);
        }
        byte[][] data = BMPLoader.readMap1(imageData, bh, pos);
        ByteArrayOutputStream fullImageData = new ByteArrayOutputStream();
        fullImageData.write((bh.nwidth + 7) / 8);
        fullImageData.write(0);
        fullImageData.write(bh.nheight + 7);
        fullImageData.write(0);
        int y = 0;
        while (y < (bh.nheight + 7) / 8 * 8) {
            x = 0;
            while (x < bh.nwidth) {
                b = new StringBuilder();
                i = 0;
                while (i < 8) {
                    if (x + i < bh.nwidth && y < bh.nheight && data[y][x + i] == 0) {
                        if (inverse) {
                            b.append("0");
                        } else {
                            b.append("1");
                        }
                    } else if (inverse) {
                        b.append("1");
                    } else {
                        b.append("0");
                    }
                    ++i;
                }
                fullImageData.write(Integer.parseInt(b.toString(), 2));
                x += 8;
            }
            ++y;
        }
        this.graphicHeadersMMC.put(imageIndex, fullImageData.toByteArray());
        fullImageData = new ByteArrayOutputStream();
        fullImageData.write(bh.nwidth % 256);
        fullImageData.write(bh.nwidth / 256);
        fullImageData.write((bh.nheight + 7) / 8);
        fullImageData.write(0);
        y = 0;
        while (y < bh.nheight) {
            x = 0;
            while (x < bh.nwidth) {
                b = new StringBuilder();
                i = 0;
                while (i < 8) {
                    if (y + i < bh.nheight && x < bh.nwidth && data[y + i][x] == 0) {
                        if (inverse) {
                            b.append("0");
                        } else {
                            b.append("1");
                        }
                    } else if (inverse) {
                        b.append("1");
                    } else {
                        b.append("0");
                    }
                    ++i;
                }
                fullImageData.write(Integer.parseInt(b.toString(), 2));
                ++x;
            }
            y += 8;
        }
        this.graphicHeadersMMC1.put(imageIndex, fullImageData.toByteArray());
        fullImageData = new ByteArrayOutputStream();
        fullImageData.write((bh.nwidth + 7) / 8);
        fullImageData.write(0);
        fullImageData.write((bh.nheight + 7) / 8);
        fullImageData.write(0);
        int x2 = 0;
        while (x2 < (bh.nwidth + 7) / 8 * 8) {
            int y2 = 0;
            while (y2 < bh.nheight) {
                b = new StringBuilder();
                i = 0;
                while (i < 8) {
                    if (x2 < bh.nwidth && y2 + i < bh.nheight && data[y2 + i][x2] == 0) {
                        if (inverse) {
                            b.append("0");
                        } else {
                            b.append("1");
                        }
                    } else if (inverse) {
                        b.append("1");
                    } else {
                        b.append("0");
                    }
                    ++i;
                }
                fullImageData.write(Integer.parseInt(b.toString(), 2));
                y2 += 8;
            }
            ++x2;
        }
        this.graphicHeadersNV.put(imageIndex, fullImageData.toByteArray());
    }

    public void printJournal(int deviceNumber, char journalType, int journalNumber) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 81, "" + journalType, "" + journalNumber);
    }

    public void printYearlyClosure(int deviceNumber, String password) throws Pegas06FMException {
        this.executionCommand(deviceNumber, 82, password);
    }

    public void saveJournalStructD1(int deviceNumber, char journalType, String dateFrom, String dateTo, String filename) throws Pegas06FMException {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            FMDataFileListener dataListener = new FMDataFileListener(fos, this.charset);
            dataListener.setBinary(false);
            this.getCommand(deviceNumber, 154, dataListener, "" + journalType, dateFrom, dateTo);
            return;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10200);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10201);
        }
    }

    public void saveJournalFATD1(int deviceNumber, char journalType, String dateFrom, String dateTo, String filename) throws Pegas06FMException {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            FMDataFileListener dataListener = new FMDataFileListener(fos, this.charset);
            dataListener.setBinary(false);
            this.getCommand(deviceNumber, 160, dataListener, "" + journalType, dateFrom, dateTo);
            return;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10200);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10201);
        }
    }

    public void saveJournalStructZ1(int deviceNumber, char docId, int numberFrom, int numberTo, String filename) throws Pegas06FMException {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            FMDataFileListener dataListener = new FMDataFileListener(fos, this.charset);
            dataListener.setBinary(false);
            this.getCommand(deviceNumber, 155, dataListener, "" + docId, "" + numberFrom, "" + numberTo);
            return;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10200);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10201);
        }
    }

    public void saveJournalToFile(int deviceNumber, char journalType, int journalNumber, String journalFile) throws Pegas06FMException {
        try {
            FileOutputStream fos = new FileOutputStream(journalFile);
            FMDataFileListener dataListener = new FMDataFileListener(fos, this.charset);
            dataListener.setBinary(false);
            this.getCommand(deviceNumber, 159, dataListener, "" + journalType, "" + journalNumber);
            return;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10200);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10201);
        }
    }

    public void saveStructJournalD(int deviceNumber, char journalType, String dateFrom, String dateTo, String filename) throws Pegas06FMException {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            FMDataFileListener dataListener = new FMDataFileListener(fos, this.charset);
            dataListener.setBinary(false);
            this.getCommand(deviceNumber, 151, dataListener, "" + journalType, dateFrom, dateTo);
            return;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10200);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10201);
        }
    }

    public void saveJournalStructD(int deviceNumber, char journalType, String dateFrom, String dateTo, String journalFile) throws Pegas06FMException {
        this.saveStructJournalD(deviceNumber, journalType, dateFrom, dateTo, journalFile);
    }

    public void saveStructJournalN(int deviceNumber, int numberFrom, int numberTo, String filename) throws Pegas06FMException {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            FMDataFileListener dataListener = new FMDataFileListener(fos, this.charset);
            dataListener.setBinary(false);
            this.getCommand(deviceNumber, 152, dataListener, String.format("%1$4d", numberFrom), String.format("%1$4d", numberTo));
            return;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10200);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10201);
        }
    }

    public void saveJournalStructZ(int deviceNumber, int numberFrom, int numberTo, String filename) throws Pegas06FMException {
        this.saveStructJournalN(deviceNumber, numberFrom, numberTo, filename);
    }

    public void saveStructJournalSN(int deviceNumber, String paragonSn, String filename) throws Pegas06FMException {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            FMDataFileListener dataListener = new FMDataFileListener(fos, this.charset);
            dataListener.setBinary(false);
            this.getCommand(deviceNumber, 153, dataListener, paragonSn);
            return;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10200);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10201);
        }
    }

    public void saveJournalStructU(int deviceNumber, String paragonSn, String filename) throws Pegas06FMException {
        this.saveStructJournalSN(deviceNumber, paragonSn, filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendUnspecifiedData(byte[] data) throws Pegas06FMException {
        ByteArrayOutputStream byteArrayOutputStream = this.byteArray;
        synchronized (byteArrayOutputStream) {
            this.dataOut(data);
        }
    }

    public void addFMStateListener(FMStateListener listener) {
        this.fmStateListeners.add(listener);
    }

    public void removeFMStateListener(FMStateListener listener) {
        this.fmStateListeners.remove(listener);
    }

    public void removeAllFMStateListeners() {
        this.fmStateListeners.clear();
    }

    public boolean getFMSignal() {
        return this.fmSignal;
    }

    public int getFMState() {
        return this.fmState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeFmStateListener(int state) {
        if (this.fmState != state) {
            this.fmState = state;
            List<FMStateListener> list = this.fmStateListeners;
            synchronized (list) {
                FMStateEvent event = null;
                for (FMStateListener listener : this.fmStateListeners) {
                    if (event == null) {
                        event = new FMStateEvent(this, state);
                    }
                    listener.fmState(event);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeFMSignalListener(boolean signal) {
        if (this.fmSignal != signal) {
            this.fmSignal = signal;
            List<FMStateListener> list = this.fmStateListeners;
            synchronized (list) {
                FMSignalEvent event = null;
                for (FMStateListener listener : this.fmStateListeners) {
                    if (event == null) {
                        event = new FMSignalEvent(this, signal);
                    }
                    listener.fmSignal(event);
                }
            }
        }
    }

    protected byte generCRC(byte[] data) {
        byte xorByte = 0;
        int i = 0;
        while (i < data.length) {
            xorByte = (byte)(xorByte ^ data[i]);
            ++i;
        }
        return xorByte;
    }

    private byte generCRC(byte byte1, byte byte2, byte[] bytes, byte lastByte) {
        byte xorByte = 0;
        xorByte = this.generBCC(xorByte, byte1);
        xorByte = this.generBCC(xorByte, byte2);
        xorByte = this.generBCC(xorByte, bytes);
        xorByte = this.generBCC(xorByte, lastByte);
        return xorByte;
    }

    protected int generCRC16(byte[] b) {
        int crcpoc = 0;
        int i = 0;
        while (i < b.length) {
            crcpoc = this.generCRC16(crcpoc, b[i]);
            ++i;
        }
        return crcpoc;
    }

    private int generCRC16(int crcpoc, byte b) {
        short sB = (short)(b & 0xFF);
        int CRC_POLYNOM = 33800;
        crcpoc ^= sB;
        int j = 0;
        while (j < 8) {
            crcpoc = (crcpoc & 1) == 1 ? crcpoc >> 1 ^ CRC_POLYNOM : (crcpoc >>= 1);
            ++j;
        }
        return crcpoc;
    }

    protected byte generBCC(byte bcc, byte data) {
        return (byte)(bcc ^ data);
    }

    protected byte generBCC(byte bcc, byte[] data) {
        byte xorByte = bcc;
        int i = 0;
        while (i < data.length) {
            xorByte = this.generBCC(xorByte, data[i]);
            ++i;
        }
        return xorByte;
    }

    protected void dataOut(byte[] data) throws Pegas06FMException {
        if (this.testingMode) {
            return;
        }
        int i = 0;
        while (i < this.lowLevelCommunicationListeners.size()) {
            this.lowLevelCommunicationListeners.get(i).nextBlockWrited();
            ++i;
        }
        int error = 0;
        byte crc = this.generCRC(data);
        try {
            int tryCounter = 0;
            while (tryCounter < 1) {
                this.serial.clearInputBuffer();
                this.serial.send(data, this);
                this.serial.send(crc, this);
                byte answer = this.serial.read(this);
                while (answer == 17 || answer == 19) {
                    answer = this.serial.read(this);
                }
                if (answer == 6) {
                    return;
                }
                if (answer == 4) {
                    throw new Pegas06FMException(4);
                }
                error = this.serial.read(this);
                logger.debug("Answer: " + answer + "  Error: " + error);
                tryCounter = (short)(tryCounter + 1);
            }
        }
        catch (Pegas06FMException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10000);
        }
        throw new Pegas06FMException(error);
    }

    protected void blockOut(byte[] data, boolean endOfText) throws Pegas06FMException {
        if (this.testingMode) {
            return;
        }
        int i = 0;
        while (i < this.lowLevelCommunicationListeners.size()) {
            this.lowLevelCommunicationListeners.get(i).nextBlockWrited();
            ++i;
        }
        int error = 0;
        ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
        try {
            int startPos = 0;
            int endPos = 0;
            while (startPos < data.length) {
                endPos = startPos + 256;
                if (data.length < endPos) {
                    endPos = data.length;
                }
                int length = endPos - startPos;
                dataStream.reset();
                dataStream.write(58);
                dataStream.write(length - 1);
                int i2 = 0;
                while (i2 < length) {
                    dataStream.write(data[startPos + i2]);
                    ++i2;
                }
                if (endOfText && endPos == data.length) {
                    dataStream.write(3);
                } else {
                    dataStream.write(23);
                }
                byte[] sentenceData = dataStream.toByteArray();
                byte crc = this.generCRC(sentenceData);
                int tryCounter = 0;
                while (tryCounter < 1) {
                    this.serial.clearInputBuffer();
                    this.serial.send(sentenceData, this);
                    this.serial.send(crc, this);
                    byte state = this.serial.read(this);
                    while (state == 17 || state == 19) {
                        state = this.serial.read(this);
                    }
                    if (state == 6) break;
                    if (state == 3) {
                        return;
                    }
                    if (state == 4) {
                        return;
                    }
                    error = this.serial.read(this);
                    tryCounter = (short)(tryCounter + 1);
                }
                if (tryCounter >= 1) {
                    throw new Pegas06FMException(error);
                }
                startPos = endPos;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10000);
        }
    }

    protected void blockOut16(byte[] data, boolean endOfText) throws Pegas06FMException {
        if (this.testingMode) {
            return;
        }
        int i = 0;
        while (i < this.lowLevelCommunicationListeners.size()) {
            this.lowLevelCommunicationListeners.get(i).nextBlockWrited();
            ++i;
        }
        int error = 0;
        ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
        try {
            int startPos = 0;
            int endPos = 0;
            while (startPos < data.length) {
                endPos = startPos + 65536;
                if (data.length < endPos) {
                    endPos = data.length;
                }
                int length = endPos - startPos;
                dataStream.reset();
                dataStream.write(58);
                byte highByte = (byte)(length >> 8 & 0xFF);
                byte lowByte = (byte)(length & 0xFF);
                dataStream.write(lowByte);
                dataStream.write(highByte);
                int i2 = 0;
                while (i2 < length) {
                    dataStream.write(data[startPos + i2]);
                    ++i2;
                }
                if (endOfText && endPos == data.length) {
                    dataStream.write(3);
                } else {
                    dataStream.write(23);
                }
                byte[] sentenceData = dataStream.toByteArray();
                int crc = this.generCRC16(sentenceData);
                int tryCounter = 0;
                while (tryCounter < 1) {
                    this.serial.clearInputBuffer();
                    this.serial.send(sentenceData, this);
                    highByte = (byte)(crc >> 8 & 0xFF);
                    lowByte = (byte)(crc & 0xFF);
                    this.serial.send(lowByte, this);
                    this.serial.send(highByte, this);
                    byte state = this.serial.read(this);
                    while (state == 17 || state == 19) {
                        state = this.serial.read(this);
                    }
                    if (state == 6) break;
                    if (state == 3) {
                        return;
                    }
                    if (state == 4) {
                        return;
                    }
                    error = this.serial.read(this);
                    tryCounter = (short)(tryCounter + 1);
                }
                if (tryCounter >= 1) {
                    throw new Pegas06FMException(error);
                }
                startPos = endPos;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10000);
        }
    }

    protected void blockGet(byte[] data, FMDataListener dataListener) throws Pegas06FMException {
        if (this.testingMode) {
            return;
        }
        int i = 0;
        while (i < this.lowLevelCommunicationListeners.size()) {
            this.lowLevelCommunicationListeners.get(i).nextBlockReaded();
            ++i;
        }
        int error = 0;
        logger.debug(" ** BlockGet >> GenerCRC");
        byte crc = this.generCRC(data);
        try {
            dataListener.readStart();
            for (int tryCounter = 0; tryCounter < 1; tryCounter = (int)((short)(tryCounter + 1))) {
                logger.debug(" ** BlockGet >> ClearInputBuffer");
                this.serial.clearInputBuffer();
                logger.debug(" ** BlockGet >> SendData [" + tryCounter + "]");
                this.serial.send(data, this);
                logger.debug(" ** BlockGet >> SendCRC [" + tryCounter + "]");
                this.serial.send(crc, this);
                logger.debug(" ** BlockGet >> ReadAnswer");
                byte state = this.serial.read(this);
                while (state == 17 || state == 19) {
                    state = this.serial.read(this);
                }
                if (state == 58) {
                    long level = 0L;
                    while (this.blockGetRow(level, dataListener)) {
                        ++level;
                    }
                    dataListener.readEnd();
                    return;
                }
                if (state == 4) {
                    throw new Pegas06FMException(4);
                }
                if (state == 21) {
                    error = this.serial.read(this);
                    logger.debug(" ** BlockGet >> NACK");
                    continue;
                }
                logger.debug("Odpoved na potvrdenie prijatia bloku: " + state);
                this.serial.clearInputBuffer();
                this.serial.send((byte)4, this);
                this.serial.read(this);
                throw new Pegas06FMException(-10002);
            }
            throw new Pegas06FMException(error);
        }
        catch (Pegas06FMException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10000);
        }
    }

    protected StringBuilder blockGet16(byte[] data) throws Pegas06FMException {
        if (this.testingMode) {
            return new StringBuilder();
        }
        int i = 0;
        while (i < this.lowLevelCommunicationListeners.size()) {
            this.lowLevelCommunicationListeners.get(i).nextBlockReaded();
            ++i;
        }
        int error = 0;
        StringBuilder result = new StringBuilder();
        logger.debug(" ** BlockGet >> GenerCRC");
        byte crc = this.generCRC(data);
        short reinitPortCounter = 0;
        while (true) {
            result.setLength(0);
            try {
                for (int tryCounter = 0; tryCounter < 1; tryCounter = (int)((short)(tryCounter + 1))) {
                    logger.debug(" ** BlockGet >> ClearInputBuffer");
                    this.serial.clearInputBuffer();
                    logger.debug(" ** BlockGet >> SendData [" + tryCounter + "]");
                    this.serial.send(data, this);
                    logger.debug(" ** BlockGet >> SendCRC [" + tryCounter + "]");
                    this.serial.send(crc, this);
                    logger.debug(" ** BlockGet >> ReadAnswer");
                    byte state = this.serial.read(this);
                    while (state == 17 || state == 19) {
                        state = this.serial.read(this);
                    }
                    if (state == 58) {
                        long level = 0L;
                        while (this.blockGetRow16(result, level)) {
                            ++level;
                        }
                        return result;
                    }
                    if (state == 4) {
                        throw new Pegas06FMException(4);
                    }
                    if (state == 21) {
                        error = this.serial.read(this);
                        logger.debug(" ** BlockGet >> NACK");
                        continue;
                    }
                    logger.debug("Odpoved na potvrdenie prijatia bloku: " + state);
                    this.serial.clearInputBuffer();
                    this.serial.send((byte)4, this);
                    this.serial.read(this);
                    throw new Pegas06FMException(-10002);
                }
                throw new Pegas06FMException(error);
            }
            catch (Pegas06FMException e) {
                if (reinitPortCounter < this.maxReinitPortCounter) {
                    reinitPortCounter = (short)(reinitPortCounter + 1);
                    this.reinitPort();
                    continue;
                }
                throw e;
            }
            catch (Exception e) {
                if (reinitPortCounter < this.maxReinitPortCounter) {
                    reinitPortCounter = (short)(reinitPortCounter + 1);
                    this.reinitPort();
                    continue;
                }
                e.printStackTrace();
                throw new Pegas06FMException(-10000);
            }
            break;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean blockGetRow(long level, FMDataListener dataListener) throws Pegas06FMException {
        if (this.testingMode) {
            return true;
        }
        int i = 0;
        while (i < this.lowLevelCommunicationListeners.size()) {
            this.lowLevelCommunicationListeners.get(i).nextBlockReaded();
            ++i;
        }
        try {
            byte state;
            int tryCounter = 0;
            StringBuilder resultRow = new StringBuilder();
            while (true) {
                resultRow.setLength(0);
                byte dataLength = this.serial.read(this);
                byte[] block = new byte[(dataLength & 0xFF) + 1];
                int i2 = 0;
                while (i2 < block.length) {
                    block[i2] = this.serial.read(this);
                    ++i2;
                }
                byte endBlock = this.serial.read(this);
                byte crc = this.serial.read(this);
                if (this.generCRC((byte)58, dataLength, block, endBlock) == crc) {
                    resultRow.append(this.charsetDecode(block));
                    if (endBlock == 23) {
                        this.serial.clearInputBuffer();
                        this.serial.send((byte)6, this);
                        state = this.serial.read(this);
                        while (state == 17 || state == 19) {
                            state = this.serial.read(this);
                        }
                        if (state == 58) {
                            dataListener.dataReaded(block);
                            return true;
                        }
                        if (state == 4) {
                            throw new Pegas06FMException(4);
                        }
                        logger.debug("Odpoved na potvrdenie prijatia bloku: " + state);
                        this.serial.clearInputBuffer();
                        this.serial.send((byte)4, this);
                        this.serial.read(this);
                        throw new Pegas06FMException(-10002);
                    }
                    if (endBlock == 3) {
                        this.serial.clearInputBuffer();
                        this.serial.send((byte)3, this);
                        dataListener.dataReaded(block);
                        return false;
                    }
                    logger.debug("Odpoved na potvrdenie prijatia bloku: " + endBlock);
                    this.serial.clearInputBuffer();
                    this.serial.send((byte)4, this);
                    this.serial.read(this);
                    throw new Pegas06FMException(-10002);
                }
                logger.warn("Bad BCC from FM - Trying again ");
                this.serial.clearInputBuffer();
                this.serial.send((byte)21, this);
                state = this.serial.read(this);
                if (state != 58) break;
                tryCounter = (short)(tryCounter + 1);
            }
            if (state == 4) {
                throw new Pegas06FMException(4);
            }
            logger.debug("Odpoved na NACK po zlom BCC: " + state);
            this.serial.clearInputBuffer();
            this.serial.send((byte)4, this);
            this.serial.read(this);
            throw new Pegas06FMException(-10002);
        }
        catch (Pegas06FMException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10000);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean blockGetRow16(StringBuilder result, long level) throws Pegas06FMException {
        if (this.testingMode) {
            return true;
        }
        int i = 0;
        while (i < this.lowLevelCommunicationListeners.size()) {
            this.lowLevelCommunicationListeners.get(i).nextBlockReaded();
            ++i;
        }
        try {
            byte state;
            int tryCounter = 0;
            StringBuilder resultRow = new StringBuilder();
            while (true) {
                resultRow.setLength(0);
                byte dataLow = this.serial.read(this);
                byte dataHigh = this.serial.read(this);
                int dataLength = dataHigh << 8 & 0xFF00 | dataLow & 0xFF;
                int crcCalc = 0;
                crcCalc = this.generCRC16(crcCalc, (byte)58);
                crcCalc = this.generCRC16(crcCalc, dataLow);
                crcCalc = this.generCRC16(crcCalc, dataHigh);
                byte[] block = new byte[dataLength];
                int i2 = 0;
                while (i2 < block.length) {
                    block[i2] = this.serial.read(this);
                    ++i2;
                }
                byte endBlock = this.serial.read(this);
                dataLow = this.serial.read(this);
                dataHigh = this.serial.read(this);
                int crc = dataHigh << 8 & 0xFF00 | dataLow & 0xFF;
                int i3 = 0;
                while (i3 < block.length) {
                    crcCalc = this.generCRC16(crcCalc, block[i3]);
                    ++i3;
                }
                if ((crcCalc = this.generCRC16(crcCalc, endBlock)) == crc) {
                    resultRow.append(this.charsetDecode(block));
                    if (endBlock == 23) {
                        this.serial.clearInputBuffer();
                        this.serial.send((byte)6, this);
                        state = this.serial.read(this);
                        while (state == 17 || state == 19) {
                            state = this.serial.read(this);
                        }
                        if (state == 58) {
                            result.append((CharSequence)resultRow);
                            return true;
                        }
                        if (state == 4) {
                            throw new Pegas06FMException(4);
                        }
                        logger.debug("Odpoved na potvrdenie prijatia bloku: " + state);
                        this.serial.clearInputBuffer();
                        this.serial.send((byte)4, this);
                        this.serial.read(this);
                        throw new Pegas06FMException(-10002);
                    }
                    if (endBlock == 3) {
                        this.serial.clearInputBuffer();
                        this.serial.send((byte)3, this);
                        result.append((CharSequence)resultRow);
                        return false;
                    }
                    logger.debug("Odpoved na potvrdenie prijatia bloku: " + endBlock);
                    this.serial.clearInputBuffer();
                    this.serial.send((byte)4, this);
                    this.serial.read(this);
                    throw new Pegas06FMException(-10002);
                }
                logger.warn("Bad BCC from FM - Trying again ");
                this.serial.clearInputBuffer();
                this.serial.send((byte)21, this);
                state = this.serial.read(this);
                if (state != 58) break;
                tryCounter = (short)(tryCounter + 1);
            }
            if (state == 4) {
                throw new Pegas06FMException(4);
            }
            logger.debug("Odpoved na NACK po zlom BCC: " + state);
            this.serial.clearInputBuffer();
            this.serial.send((byte)4, this);
            this.serial.read(this);
            throw new Pegas06FMException(-10002);
        }
        catch (Pegas06FMException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10000);
        }
    }

    public boolean setCharset(Charset charset) {
        switch (charset) {
            case CP852: {
                try {
                    this.charset = java.nio.charset.Charset.forName("CP852");
                }
                catch (Exception e) {
                    this.charset = new Cp852Charset();
                }
                return true;
            }
            case CP1250: {
                try {
                    this.charset = java.nio.charset.Charset.forName("CP1250");
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        return false;
    }

    protected byte[] charsetEncode(String data) {
        return this.charset.encode(data).array();
    }

    protected String charsetDecode(byte[] data) {
        return this.charset.decode(ByteBuffer.wrap(data)).toString();
    }
}

