/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.eKasaSK.lib.communication;

import java.io.File;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import sk.singularisdev.eKasaSK.lib.communication.SerialCommunicationMirror;

public class FileSerialCommunicationMirror
implements SerialCommunicationMirror {
    private PrintStream ps = null;
    private boolean lastReaded = true;
    private StringBuilder data = new StringBuilder();
    private String filenamePrefix = "";
    private File dir;
    private static final SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss.SSS");

    public FileSerialCommunicationMirror() {
        this("");
    }

    public FileSerialCommunicationMirror(String filenamePrefix) {
        this(null, filenamePrefix);
    }

    public FileSerialCommunicationMirror(File dir, String filenamePrefix) {
        this.filenamePrefix = filenamePrefix;
        this.dir = dir;
    }

    @Override
    public void byteRead(byte b) {
        if (this.ps == null) {
            this.createStream();
        }
        if (!this.lastReaded) {
            this.ps.println();
            this.ps.print(this.data.toString());
            this.data.setLength(0);
            this.ps.println();
            this.ps.println();
            String t = sdf.format(new Date(System.currentTimeMillis()));
            this.ps.print(String.format("%1$-25s %2$-10s", "Data from device", "[" + t + "]"));
            this.ps.println();
            this.lastReaded = true;
        }
        String hex = "0" + Integer.toHexString(b);
        this.ps.print(hex.substring(hex.length() - 2));
        this.ps.print(" ");
        if (b == 13 || b == 10) {
            this.data.append("   ");
        } else {
            this.data.append(" ");
            this.data.append((char)b);
            this.data.append(" ");
        }
        this.ps.flush();
    }

    @Override
    public void byteWritten(byte b) {
        if (this.ps == null) {
            this.createStream();
        }
        if (this.lastReaded) {
            this.ps.println();
            this.ps.print(this.data.toString());
            this.data.setLength(0);
            this.ps.println();
            this.ps.println();
            String t = sdf.format(new Date(System.currentTimeMillis()));
            this.ps.print(String.format("%1$-25s %2$-10s", "Data to device", "[" + t + "]"));
            this.ps.println();
            this.lastReaded = false;
        }
        String hex = "0" + Integer.toHexString(b);
        this.ps.print(hex.substring(hex.length() - 2));
        this.ps.print(" ");
        if (b == 13 || b == 10) {
            this.data.append("   ");
        } else {
            this.data.append(" ");
            this.data.append((char)b);
            this.data.append(" ");
        }
        this.ps.flush();
    }

    @Override
    public void writeText(String text) {
        if (this.ps == null) {
            this.createStream();
        }
        this.ps.println();
        this.ps.println();
        this.ps.print(text);
        this.data.setLength(0);
        this.ps.println();
        this.ps.println();
        this.lastReaded = false;
        this.ps.flush();
    }

    protected void createStream() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String fileName = String.valueOf(this.filenamePrefix) + "serial_" + sdf.format(new Date(System.currentTimeMillis())) + "_" + System.currentTimeMillis() + ".log";
        try {
            File file = this.dir == null ? new File(fileName) : new File(this.dir, fileName);
            System.out.println(file.getAbsolutePath());
            this.ps = new PrintStream(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

