/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.eKasaSK.lib.communication;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import sk.singularisdev.eKasaSK.lib.LowLevelFMInterface;
import sk.singularisdev.eKasaSK.lib.Pegas06FMException;
import sk.singularisdev.eKasaSK.lib.communication.CommunicationDriver;
import sk.singularisdev.eKasaSK.lib.communication.SerialCommunicationMirror;
import sk.singularisdev.eKasaSK.lib.languages.NoneLanguageMap;
import sk.singularisdev.eKasaSK.lib.logger.Logger;

public class TcpDriverSwHandshake
implements CommunicationDriver {
    NoneLanguageMap noneTranslate = new NoneLanguageMap();
    protected static Logger logger;
    protected static final int RECV_TIMEOUT = 15000;
    protected static final int SEND_TIMEOUT = 15000;
    protected static final int BUFFER_SIZE = 16384;
    protected InputStream inStream;
    protected OutputStream outStream;
    private String ipAddress;
    private int port;
    protected boolean bufferEmpty = true;
    protected boolean init = false;
    protected List<SerialCommunicationMirror> mirrors = new ArrayList<SerialCommunicationMirror>();
    protected int recvTimeout = 15000;
    protected int sendTimeout = 15000;
    protected Socket clientSocket;

    public TcpDriverSwHandshake(String ipAddress, int port) {
        this.ipAddress = ipAddress;
        this.port = port;
        logger = Logger.createLogger(this.getClass().getName());
    }

    @Override
    public void openPort() throws Pegas06FMException {
        logger.debug(String.valueOf(this.getIpAddress()) + ":" + this.getIpPort() + " - connecting ...");
        try {
            this.clientSocket = new Socket(this.ipAddress, this.port);
            this.inStream = this.clientSocket.getInputStream();
            this.outStream = this.clientSocket.getOutputStream();
            this.clientSocket.setSendBufferSize(16384);
            this.clientSocket.setReceiveBufferSize(16384);
            this.clientSocket.setSoTimeout(this.recvTimeout);
            this.init = true;
        }
        catch (Exception e) {
            this.init = false;
            logger.error(e.getMessage(), e);
            e.printStackTrace();
            throw new Pegas06FMException(-10001, e);
        }
    }

    public void send(String s, String charsetName, LowLevelFMInterface fmInterface) throws Pegas06FMException {
        if (!this.init) {
            throw new Pegas06FMException(-10103);
        }
        if (charsetName.equals("none")) {
            s = this.noneTranslate.convert(s);
            charsetName = "US-ASCII";
        }
        try {
            byte[] b = s.getBytes(charsetName);
            int i = 0;
            while (i < b.length) {
                long time = System.currentTimeMillis();
                while (!this.bufferEmpty) {
                    if (System.currentTimeMillis() - time > (long)this.sendTimeout) {
                        throw new Pegas06FMException(-10006);
                    }
                    try {
                        Thread.sleep(5L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.outStream.write(b[i]);
                for (SerialCommunicationMirror mirror : this.mirrors) {
                    mirror.byteWritten(b[i]);
                }
                ++i;
            }
            this.outStream.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10003, e);
        }
    }

    @Override
    public void send(byte[] data, LowLevelFMInterface fmInterface) throws Pegas06FMException {
        if (!this.init) {
            throw new Pegas06FMException(-10103);
        }
        try {
            int i = 0;
            while (i < data.length) {
                logger.debug(" **** TcpSendData [bytes]:Waiting for empty buffer/ DSR");
                long time = System.currentTimeMillis();
                this.outStream.write(data[i]);
                logger.debug(" **** TcpSendData [bytes]: writing byte [" + data[i]);
                for (SerialCommunicationMirror mirror : this.mirrors) {
                    mirror.byteWritten(data[i]);
                }
                ++i;
            }
            logger.debug(" **** TcpSendData [bytes]: flush buffer *");
            this.outStream.flush();
            logger.debug(" **** TcpSendData [bytes]: buffer flushed");
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.debug("Error", e);
            throw new Pegas06FMException(-10003, e);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.debug("Error", e);
            throw new Pegas06FMException(-10003, e);
        }
    }

    @Override
    public void send(byte data, LowLevelFMInterface fmInterface) throws Pegas06FMException {
        if (!this.init) {
            throw new Pegas06FMException(-10103);
        }
        try {
            logger.debug(" **** TcpSendData [byte]:Waiting for empty buffer/ DSR");
            long time = System.currentTimeMillis();
            this.outStream.write(data);
            logger.debug(" **** TcpSendData [byte]: writing byte [" + data);
            for (SerialCommunicationMirror mirror : this.mirrors) {
                mirror.byteWritten(data);
            }
            logger.debug(" **** TcpSendData [byte]: flush buffer");
            this.outStream.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10003, e);
        }
    }

    @Override
    public byte read(LowLevelFMInterface fmInterface) throws Pegas06FMException {
        if (!this.init) {
            throw new Pegas06FMException(-10103);
        }
        try {
            byte returnByte;
            long time = System.currentTimeMillis();
            logger.debug(" **** TcpRead: waiting for available data ");
            int handshake = -1;
            while (this.inStream.available() == 0) {
                boolean longJob = false;
                fmInterface.invokeFMSignalListener(longJob);
                if (longJob) {
                    longJob = !longJob;
                    fmInterface.invokeFMSignalListener(longJob);
                }
                logger.debug(" **** TcpRead: CTS ON ");
                if (time + (long)this.recvTimeout >= System.currentTimeMillis()) continue;
                handshake = this.swHandshake(fmInterface);
                switch (handshake) {
                    case 19: {
                        handshake = -1;
                        time = System.currentTimeMillis();
                        break;
                    }
                    case -1: 
                    case 17: {
                        throw new Pegas06FMException(64);
                    }
                }
            }
            if (handshake == -1) {
                logger.debug(" **** TcpRead: read byte ");
                returnByte = (byte)this.inStream.read();
                for (SerialCommunicationMirror mirror : this.mirrors) {
                    mirror.byteRead(returnByte);
                }
                logger.debug(" **** TcpRead: byte readed [" + returnByte);
            } else {
                returnByte = (byte)handshake;
            }
            return returnByte;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10003, e);
        }
    }

    private int swHandshake(LowLevelFMInterface fmInterface) throws Pegas06FMException {
        try {
            logger.debug(" **** TcpHandshake");
            this.outStream.write(17);
            this.outStream.flush();
            logger.debug(" **** TcpHandshake: writing byte [17");
            for (SerialCommunicationMirror mirror : this.mirrors) {
                mirror.byteWritten((byte)17);
            }
            int returnValue = this.inStream.read();
            if (returnValue != -1) {
                for (SerialCommunicationMirror mirror : this.mirrors) {
                    mirror.byteRead((byte)returnValue);
                }
            }
            return returnValue;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10003, e);
        }
    }

    @Override
    public void setOldFMBehaviour(boolean old) {
    }

    public int getIpPort() {
        return this.port;
    }

    public void setIpPort(int port) {
        this.port = port;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    @Override
    public void closePort() {
        this.init = false;
        logger.debug(String.valueOf(this.getIpAddress()) + ":" + this.getIpPort() + " - disconnecting ...");
        try {
            logger.debug("Closing InputStream ...");
            this.inStream.close();
            logger.debug("Closing OutputStream ...");
            this.outStream.close();
            logger.debug("Closing SerialPort ...");
            this.clientSocket.close();
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
        }
    }

    public void send(byte[] data) throws IOException {
        try {
            this.outStream.write(data);
            this.outStream.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public boolean isAvailable() throws Pegas06FMException {
        if (!this.init) {
            throw new Pegas06FMException(-10103);
        }
        try {
            return this.inStream.available() > 0;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Pegas06FMException(-10003, e);
        }
    }

    @Override
    public void clearInputBuffer() throws Exception {
    }

    @Override
    public void addMirror(SerialCommunicationMirror mirror) {
        this.mirrors.add(mirror);
    }

    @Override
    public void removeMirror(SerialCommunicationMirror mirror) {
        this.mirrors.remove(mirror);
    }

    @Override
    public void removeAllMirrors() {
        this.mirrors.clear();
    }

    @Override
    public boolean isInitialized() {
        return this.init;
    }

    @Override
    @Deprecated
    public String getPort() {
        return null;
    }

    @Override
    @Deprecated
    public int getBaud() {
        return 0;
    }
}

