/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.eKasaSK.lib.communication.rxtx;

import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import sk.singularisdev.eKasaSK.lib.LowLevelFMInterface;
import sk.singularisdev.eKasaSK.lib.Pegas06FMException;
import sk.singularisdev.eKasaSK.lib.communication.CommunicationDriver;
import sk.singularisdev.eKasaSK.lib.communication.SerialCommunicationMirror;
import sk.singularisdev.eKasaSK.lib.languages.NoneLanguageMap;
import sk.singularisdev.eKasaSK.lib.logger.Logger;

public class SerialDriver
implements CommunicationDriver {
    NoneLanguageMap noneTranslate = new NoneLanguageMap();
    protected static Logger logger;
    public static final int STOPBITS_1 = 1;
    public static final int STOPBITS_2 = 2;
    public static final int STOPBITS_1_5 = 3;
    protected static final int RECV_TIMEOUT = 4000;
    protected static final int SEND_TIMEOUT = 4000;
    protected static final int BUFFER_SIZE = 16384;
    protected SerialPort serialPort;
    protected InputStream inStream;
    protected OutputStream outStream;
    private String port;
    private int baud;
    protected int stopBits = 1;
    protected boolean bufferEmpty = true;
    protected boolean init = false;
    protected List<SerialCommunicationMirror> mirrors = new ArrayList<SerialCommunicationMirror>();
    protected int recvTimeout = 4000;
    protected int sendTimeout = 4000;
    protected boolean xuseSignal = true;

    public SerialDriver(String port, int baud, int stopBits) {
        this(port, baud);
        this.stopBits = stopBits;
    }

    public SerialDriver(String port, int baud) {
        if (System.getProperty("gnu.io.log.mode") == null) {
            System.setProperty("gnu.io.log.mode", "FILE_MODE");
        }
        if (System.getProperty("gnu.io.log.filename") == null) {
            System.setProperty("gnu.io.log.filename", "rxtx_log.txt");
        }
        logger = Logger.createLogger(this.getClass().getName());
        this.init = false;
        this.port = port;
        this.baud = baud;
    }

    public SerialDriver(SerialPort serialPort) {
        logger = Logger.createLogger(this.getClass().getName());
        this.serialPort = serialPort;
        try {
            this.port = serialPort.getName();
            this.baud = serialPort.getBaudRate();
            this.inStream = this.serialPort.getInputStream();
            this.outStream = this.serialPort.getOutputStream();
            this.serialPort.setDTR(true);
            this.init = true;
        }
        catch (IOException e) {
            this.init = false;
            logger.error(e.getMessage(), e);
            this.init = false;
            logger.error(e.getMessage(), e);
        }
    }

    @Override
    public void setOldFMBehaviour(boolean old) {
        if (old) {
            this.recvTimeout = 30000;
            this.sendTimeout = 30000;
        } else {
            this.recvTimeout = 4000;
            this.sendTimeout = 4000;
        }
        try {
            this.serialPort.enableReceiveTimeout(this.recvTimeout);
        }
        catch (UnsupportedCommOperationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getBaud() {
        return this.baud;
    }

    public void setBaud(int baud) {
        this.baud = baud;
    }

    @Override
    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    @Override
    public void openPort() throws Pegas06FMException {
        SerialDriver.getAvailableCommPorts();
        logger.debug(String.valueOf(this.getPort()) + " - connecting ...");
        System.out.println(String.valueOf(this.getPort()) + " - connecting ...");
        try {
            CommPortIdentifier portId = CommPortIdentifier.getPortIdentifier((String)this.getPort());
            this.serialPort = (SerialPort)portId.open(this.getPort(), 2000);
            this.inStream = this.serialPort.getInputStream();
            this.outStream = this.serialPort.getOutputStream();
            this.serialPort.setFlowControlMode(3);
            this.serialPort.setSerialPortParams(this.getBaud(), 8, this.stopBits, 0);
            this.serialPort.setInputBufferSize(16384);
            this.serialPort.setOutputBufferSize(16384);
            this.serialPort.enableReceiveTimeout(this.recvTimeout);
            this.serialPort.setDTR(true);
            this.init = true;
        }
        catch (PortInUseException e) {
            this.init = false;
            logger.error(e.getMessage(), e);
            throw new Pegas06FMException(-10100, (Exception)((Object)e));
        }
        catch (NoSuchPortException e) {
            this.init = false;
            logger.error(e.getMessage(), e);
            throw new Pegas06FMException(-10101, (Exception)((Object)e));
        }
        catch (IOException e) {
            this.init = false;
            logger.error(e.getMessage(), e);
            throw new Pegas06FMException(-10003, e);
        }
        catch (UnsupportedCommOperationException e) {
            this.init = false;
            logger.error(e.getMessage(), e);
            throw new Pegas06FMException(-10102, (Exception)((Object)e));
        }
        catch (Exception e) {
            this.init = false;
            logger.error(e.getMessage(), e);
            throw new Pegas06FMException(-10001, e);
        }
    }

    @Override
    public void closePort() {
        this.init = false;
        logger.debug(String.valueOf(this.getPort()) + " - disconnecting ...");
        try {
            logger.debug("Closing InputStream ...");
            this.inStream.close();
            logger.debug("Closing OutputStream ...");
            this.outStream.close();
            logger.debug("Closing SerialPort ...");
            this.serialPort.close();
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
        }
    }

    public void send(String s, String charsetName, LowLevelFMInterface fmInterface) throws Pegas06FMException {
        if (!this.init) {
            throw new Pegas06FMException(-10103);
        }
        if (charsetName.equals("none")) {
            s = this.noneTranslate.convert(s);
            charsetName = "US-ASCII";
        }
        try {
            byte[] b = s.getBytes(charsetName);
            int i = 0;
            while (i < b.length) {
                long time = System.currentTimeMillis();
                while (!this.bufferEmpty || !this.serialPort.isDSR()) {
                    if (System.currentTimeMillis() - time > (long)this.sendTimeout) {
                        throw new Pegas06FMException(-10006);
                    }
                    try {
                        Thread.sleep(5L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.outStream.write(b[i]);
                for (SerialCommunicationMirror mirror : this.mirrors) {
                    mirror.byteWritten(b[i]);
                }
                ++i;
            }
        }
        catch (IOException e) {
            throw new Pegas06FMException(-10003, e);
        }
    }

    public void send(byte[] data) throws IOException {
        this.outStream.write(data);
    }

    @Override
    public void send(byte[] data, LowLevelFMInterface fmInterface) throws Pegas06FMException {
        if (!this.init) {
            throw new Pegas06FMException(-10103);
        }
        if (!this.serialPort.isCTS()) {
            throw new Pegas06FMException(-10103);
        }
        try {
            int i = 0;
            while (i < data.length) {
                logger.debug(" **** SerialSendData [bytes]:Waiting for empty buffer/ DSR");
                long time = System.currentTimeMillis();
                while (!this.bufferEmpty || !this.serialPort.isDSR()) {
                    logger.debug(" **** SerialSendData [bytes]:EmptyBuffer - " + this.bufferEmpty + "/ DSR:" + this.serialPort.isDSR());
                    if (System.currentTimeMillis() - time > (long)this.sendTimeout) {
                        throw new Pegas06FMException(-10006);
                    }
                    try {
                        Thread.sleep(5L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.outStream.write(data[i]);
                logger.debug(" **** SerialSendData [bytes]: writing byte [" + data[i]);
                for (SerialCommunicationMirror mirror : this.mirrors) {
                    mirror.byteWritten(data[i]);
                }
                ++i;
            }
            logger.debug(" **** SerialSendData [bytes]: flush buffer *");
            logger.debug(" **** SerialSendData [bytes]: buffer flushed");
        }
        catch (IOException e) {
            logger.debug("Error", e);
            throw new Pegas06FMException(-10003, e);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.debug("Error", e);
            throw new Pegas06FMException(-10003, e);
        }
    }

    @Override
    public void send(byte data, LowLevelFMInterface fmInterface) throws Pegas06FMException {
        if (!this.init) {
            throw new Pegas06FMException(-10103);
        }
        try {
            logger.debug(" **** SerialSendData [byte]:Waiting for empty buffer/ DSR");
            long time = System.currentTimeMillis();
            while (!this.bufferEmpty || !this.serialPort.isDSR()) {
                logger.debug(" **** SerialSendData [byte]:EmptyBuffer - " + this.bufferEmpty + "/ DSR:" + this.serialPort.isDSR());
                if (System.currentTimeMillis() - time > (long)this.sendTimeout) {
                    throw new Pegas06FMException(-10006);
                }
                try {
                    Thread.sleep(5L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.outStream.write(data);
            logger.debug(" **** SerialSendData [byte]: writing byte [" + data);
            for (SerialCommunicationMirror mirror : this.mirrors) {
                mirror.byteWritten(data);
            }
            logger.debug(" **** SerialSendData [byte]: flush buffer");
        }
        catch (IOException e) {
            throw new Pegas06FMException(-10003, e);
        }
    }

    public void zsend(char c) throws Pegas06FMException {
        if (!this.init) {
            throw new Pegas06FMException(-10103);
        }
        try {
            long time = System.currentTimeMillis();
            while (!this.bufferEmpty || !this.serialPort.isDSR()) {
                if (System.currentTimeMillis() - time > (long)this.sendTimeout) {
                    throw new Pegas06FMException(-10006);
                }
                try {
                    Thread.sleep(5L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.outStream.write((byte)c);
            for (SerialCommunicationMirror mirror : this.mirrors) {
                mirror.byteWritten((byte)c);
            }
        }
        catch (IOException e) {
            throw new Pegas06FMException(-10003, e);
        }
    }

    public boolean isAvailable() throws Pegas06FMException {
        if (!this.init) {
            throw new Pegas06FMException(-10103);
        }
        try {
            return this.inStream.available() > 0;
        }
        catch (IOException e) {
            throw new Pegas06FMException(-10003, e);
        }
    }

    @Override
    public byte read(LowLevelFMInterface fmInterface) throws Pegas06FMException {
        if (!this.init) {
            throw new Pegas06FMException(-10103);
        }
        try {
            long time = System.currentTimeMillis();
            logger.debug(" **** SerialRead: waiting for available data ");
            while (this.inStream.available() == 0) {
                Thread.sleep(5L);
                logger.debug(" **** SerialRead: waiting for CTS ");
                boolean longJob = false;
                fmInterface.invokeFMSignalListener(longJob);
                if (!this.serialPort.isCTS()) {
                    if (!longJob) {
                        longJob = !longJob;
                        fmInterface.invokeFMSignalListener(longJob);
                    }
                    time = System.currentTimeMillis();
                    continue;
                }
                if (longJob) {
                    longJob = !longJob;
                    fmInterface.invokeFMSignalListener(longJob);
                }
                logger.debug(" **** SerialRead: CTS ON ");
                if (time + (long)this.recvTimeout >= System.currentTimeMillis()) continue;
                throw new Pegas06FMException(64);
            }
            logger.debug(" **** SerialRead: read byte ");
            byte returnByte = (byte)this.inStream.read();
            for (SerialCommunicationMirror mirror : this.mirrors) {
                mirror.byteRead(returnByte);
            }
            logger.debug(" **** SerialRead: byte readed [" + returnByte);
            return returnByte;
        }
        catch (IOException e) {
            throw new Pegas06FMException(-10003, e);
        }
        catch (InterruptedException e) {
            throw new Pegas06FMException(-10004, e);
        }
    }

    @Override
    public void clearInputBuffer() throws Exception {
        this.inStream.skip(this.inStream.available());
    }

    public static String[] getAvailableCommPorts() {
        Vector<String> ports = new Vector<String>();
        Enumeration portList = CommPortIdentifier.getPortIdentifiers();
        System.out.println("getAvailableCommPorts:");
        while (portList.hasMoreElements()) {
            CommPortIdentifier portId = (CommPortIdentifier)portList.nextElement();
            System.out.println("Port: " + portId.getName() + " (" + portId.getPortType() + ")");
            if (portId.getPortType() != 1) continue;
            ports.add(portId.getName());
        }
        String[] portName = new String[ports.size()];
        int i = 0;
        Iterator iterator = ports.iterator();
        while (iterator.hasNext()) {
            String name;
            portName[i] = name = (String)iterator.next();
            ++i;
        }
        return portName;
    }

    @Override
    public void addMirror(SerialCommunicationMirror mirror) {
        this.mirrors.add(mirror);
    }

    @Override
    public void removeMirror(SerialCommunicationMirror mirror) {
        this.mirrors.remove(mirror);
    }

    @Override
    public void removeAllMirrors() {
        this.mirrors.clear();
    }

    @Override
    public boolean isInitialized() {
        return this.init;
    }
}

