/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message.token;

import java.security.Principal;
import java.security.PrivilegedAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.message.token.KerberosClientExceptionAction;
import org.apache.ws.security.message.token.KerberosContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KerberosClientAction
implements PrivilegedAction<byte[]> {
    private static Log LOG = LogFactory.getLog(KerberosClientAction.class);
    private Principal clientPrincipal;
    private String serviceName;
    private boolean isUsernameServiceNameForm;

    public KerberosClientAction(Principal clientPrincipal, String serviceName) {
        this(clientPrincipal, serviceName, false);
    }

    public KerberosClientAction(Principal clientPrincipal, String serviceName, boolean isUsernameServiceNameForm) {
        this.clientPrincipal = clientPrincipal;
        this.serviceName = serviceName;
        this.isUsernameServiceNameForm = isUsernameServiceNameForm;
    }

    @Override
    public byte[] run() {
        try {
            KerberosContext krbCtx = new KerberosClientExceptionAction(this.clientPrincipal, this.serviceName, this.isUsernameServiceNameForm, false).run();
            return krbCtx.getKerberosToken();
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Error in obtaining a Kerberos token", (Throwable)e);
            }
            return null;
        }
    }
}

