/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.JComponent;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthPainter;
import javax.swing.plaf.synth.SynthStyle;

public class SynthContext {
    private static final Queue<SynthContext> queue = new ConcurrentLinkedQueue<SynthContext>();
    private JComponent component;
    private Region region;
    private SynthStyle style;
    private int state;

    static SynthContext getContext(JComponent jComponent, SynthStyle synthStyle, int n) {
        return SynthContext.getContext(jComponent, SynthLookAndFeel.getRegion(jComponent), synthStyle, n);
    }

    static SynthContext getContext(JComponent jComponent, Region region, SynthStyle synthStyle, int n) {
        SynthContext synthContext = queue.poll();
        if (synthContext == null) {
            synthContext = new SynthContext();
        }
        synthContext.reset(jComponent, region, synthStyle, n);
        return synthContext;
    }

    static void releaseContext(SynthContext synthContext) {
        queue.offer(synthContext);
    }

    SynthContext() {
    }

    public SynthContext(JComponent jComponent, Region region, SynthStyle synthStyle, int n) {
        if (jComponent == null || region == null || synthStyle == null) {
            throw new NullPointerException("You must supply a non-null component, region and style");
        }
        this.reset(jComponent, region, synthStyle, n);
    }

    public JComponent getComponent() {
        return this.component;
    }

    public Region getRegion() {
        return this.region;
    }

    boolean isSubregion() {
        return this.getRegion().isSubregion();
    }

    void setStyle(SynthStyle synthStyle) {
        this.style = synthStyle;
    }

    public SynthStyle getStyle() {
        return this.style;
    }

    void setComponentState(int n) {
        this.state = n;
    }

    public int getComponentState() {
        return this.state;
    }

    void reset(JComponent jComponent, Region region, SynthStyle synthStyle, int n) {
        this.component = jComponent;
        this.region = region;
        this.style = synthStyle;
        this.state = n;
    }

    void dispose() {
        this.component = null;
        this.style = null;
        SynthContext.releaseContext(this);
    }

    SynthPainter getPainter() {
        SynthPainter synthPainter = this.getStyle().getPainter(this);
        if (synthPainter != null) {
            return synthPainter;
        }
        return SynthPainter.NULL_PAINTER;
    }
}

