/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.printer;

import java.lang.reflect.Method;
import java.nio.charset.Charset;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.enumeration.BARCODE_FONT_SIZE;
import sk.singularisdev.ekasask.enumeration.BARCODE_TEXT_POSITION;
import sk.singularisdev.ekasask.enumeration.BARCODE_TYPE;
import sk.singularisdev.ekasask.enumeration.PRINT_ALIGNMENT;
import sk.singularisdev.ekasask.enumeration.PRINT_SEQUENCE_TYPE;
import sk.singularisdev.ekasask.enumeration.QR_CODE_TYPE;
import sk.singularisdev.ekasask.localization.Localization;
import sk.singularisdev.ekasask.printer.Printer;
import sk.singularisdev.ekasask.printer.PrinterEsc;
import sk.singularisdev.ekasask.printer.PrinterStatus;
import sk.singularisdev.ekasask.printer.driver.BmpPrinter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class AbstractPrinter {
    private static Logger do = LoggerManager.getLogger(AbstractPrinter.class.getName());
    protected Charset charset;
    private String if;
    private String for;

    /*
     * WARNING - void declaration
     */
    public AbstractPrinter() {
        void var1_1;
        String emptyLine = String.format("%" + this.getCharPerRow() + "s", "");
        this.if = emptyLine.replace(" ", "-");
        this.for = var1_1.replace(" ", "=");
    }

    public String getSingleSeparator() {
        return this.if;
    }

    public String getDoubleSeparator() {
        return this.for;
    }

    public Charset getDefaultCharset() {
        return this.charset;
    }

    public abstract byte[] getAlignment(PRINT_ALIGNMENT var1);

    public abstract int getCharPerRow();

    public abstract boolean isQRsupport();

    public abstract int getDotsPerLine();

    public Charset getCharset() {
        return this.charset;
    }

    /*
     * WARNING - void declaration
     */
    public static AbstractPrinter getInstance(String printerType) {
        try {
            printerType = Class.forName((String)printerType);
            printerType = ((Class)printerType).getMethod("getInstance", null);
            return (AbstractPrinter)((Method)printerType).invoke(null, null);
        }
        catch (Exception e) {
            void var0_1;
            do.fatal("Printer driver initialization", (Throwable)var0_1);
            return null;
        }
    }

    public abstract byte[] printImage(int var1, int var2, byte[] var3) throws EKasaException;

    public abstract byte[] loadNvImage(int var1, byte[] var2) throws EKasaException;

    public abstract byte[] printNvImage(int var1) throws EKasaException;

    public abstract byte[] getEscSequence(PRINT_SEQUENCE_TYPE var1);

    public abstract byte[] getBarcode(String var1, BARCODE_TYPE var2, BARCODE_TEXT_POSITION var3, BARCODE_FONT_SIZE var4, int var5, int var6) throws EKasaException;

    public abstract PrinterEsc[] getPrinterStatusEsc();

    public abstract PrinterEsc getPrinterConnectionStatus();

    public abstract PrinterStatus parsePrinterStatus(PrinterEsc[] var1);

    public abstract byte[] getQrCode(String var1, QR_CODE_TYPE var2) throws EKasaException;

    public abstract String rewriteEscSequence(String var1, boolean var2, boolean var3);

    @Deprecated
    public abstract int[] getVatTableCols();

    /*
     * WARNING - void declaration
     */
    public String getVatTableTitle() throws EKasaException {
        void var2_2;
        int[] cols = this.getVatTableCols();
        StringBuilder sb = new StringBuilder();
        if (cols[0] > 0) {
            sb.append(String.format("%" + cols[0] + "s", ""));
        }
        sb.append(new String(Printer.alignText(this, Localization.getString("paragon.vat.rate"), PRINT_ALIGNMENT.RIGHT, cols[1], true, false), this.getCharset()));
        sb.append(new String(Printer.alignText(this, Localization.getString("paragon.vat.base"), PRINT_ALIGNMENT.RIGHT, cols[2]), this.getCharset()));
        sb.append(new String(Printer.alignText(this, Localization.getString("paragon.vat.vat"), PRINT_ALIGNMENT.RIGHT, cols[3]), this.getCharset()));
        sb.append(new String(Printer.alignText(this, Localization.getString("paragon.vat.total"), PRINT_ALIGNMENT.RIGHT, cols[4]), this.getCharset()));
        sb.append(" ");
        if (cols[5] > 0) {
            void var1_1;
            sb.append(String.format("%" + (int)var1_1[5] + "s", ""));
        }
        return var2_2.toString();
    }

    public String getVatTableTotalText() {
        return Localization.getString("paragon.vat.total_amount");
    }

    public int getParagonItemDiscountPriceSize() {
        return 12;
    }

    /*
     * WARNING - void declaration
     */
    public String getParagonItemSaleFormat(boolean platca) {
        int n;
        void var1_1;
        int unitPrice = this.getCharPerRow() - 11 - 3 - 12 - 4;
        if (var1_1 != false) {
            return "%1$-" + this.getCharPerRow() + "s%2$" + (unitPrice > 10 ? unitPrice : 10) + "s%3$" + 11 + "s%4$-" + 3 + "s%5$" + 12 + "s%6$3s" + "%7$1s";
        }
        return "%1$-" + this.getCharPerRow() + "s%2$" + (unitPrice > 10 ? n : 10) + "s%3$" + 11 + "s%4$-" + 3 + "s%5$" + 12 + "s%6$1s" + Localization.getString("paragon.no_vat");
    }

    /*
     * WARNING - void declaration
     */
    public String getParagonItemVoucherFormat(boolean platca) {
        void var2_2;
        void var1_1;
        int unitPrice = this.getCharPerRow() - 11 - 3 - 12 - 4;
        if (var1_1 != false) {
            return "%3$" + (unitPrice + 11) + "s%4$-" + 3 + "s%5$" + 12 + "s%6$3s" + "%7$1s";
        }
        return "%3$" + (int)(var2_2 + 11) + "s%4$-" + 3 + "s%5$" + 12 + "s%6$1s" + Localization.getString("paragon.no_vat");
    }

    /*
     * WARNING - void declaration
     */
    public String getVatTableFormat() {
        void var1_1;
        int[] cols = this.getVatTableCols();
        return "%1$" + (cols[0] + cols[1]) + "s%2$" + cols[2] + "s%3$" + cols[3] + "s%4$" + (int)var1_1[4] + "s%5$1s";
    }

    public boolean printEmptyVatTableRow() {
        return true;
    }

    public BmpPrinter getEmailPrinter() {
        return BmpPrinter.getInstance();
    }
}

