/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.printer.driver;

import com.google.zxing.WriterException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.enumeration.BARCODE_FONT_SIZE;
import sk.singularisdev.ekasask.enumeration.BARCODE_TEXT_POSITION;
import sk.singularisdev.ekasask.enumeration.BARCODE_TYPE;
import sk.singularisdev.ekasask.enumeration.PRINT_ALIGNMENT;
import sk.singularisdev.ekasask.enumeration.PRINT_SEQUENCE_TYPE;
import sk.singularisdev.ekasask.enumeration.QR_CODE_TYPE;
import sk.singularisdev.ekasask.printer.AbstractPrinter;
import sk.singularisdev.ekasask.printer.PrinterEsc;
import sk.singularisdev.ekasask.printer.PrinterStatus;
import sk.singularisdev.ekasask.printer.driver.BL112Rewriter;
import sk.singularisdev.ekasask.utils.QRCode;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BL112
extends AbstractPrinter {
    public static String CHARSET_NAME = "CP852";
    private static final byte[] do = new byte[0];
    private static final byte[] if = new byte[]{16, 4, 1};
    private static final byte[] for = new byte[]{16, 4, 2};
    private static final byte[] int = new byte[]{16, 4, 3};
    private static final byte[] new = new byte[]{16, 4, 4};
    private static final byte[] try = new byte[]{13};
    private static final byte[] byte = new byte[]{10};
    private static final byte[] case = new byte[]{13, 10};
    private static final byte[] char = new byte[]{13, 10, 13, 10, 13, 10, 13, 10};
    private static final byte[] else = new byte[0];
    private static final byte[] goto = new byte[]{27, 33, 1};
    private static final byte[] long;
    private static final byte[] this;
    private static final byte[] void;
    private static final byte[] break;
    private static final byte[] catch;
    private static final byte[] class;
    private static final byte[] const;
    private static final byte[] final;
    private static final byte[] float;
    private static final byte[] short;
    private static final byte[] super;
    private static final byte[] throw;
    private static final int while = 160;
    private static /* synthetic */ int[] double;
    private static /* synthetic */ int[] import;
    private static /* synthetic */ int[] public;
    private static /* synthetic */ int[] return;

    static {
        byte[] byArray = new byte[3];
        byArray[0] = 27;
        byArray[1] = 33;
        long = byArray;
        this = new byte[]{27, 51, 8};
        void = new byte[]{27, 50};
        break = new byte[]{27, 116, -1};
        catch = new byte[0];
        BL112.class = new byte[]{29, 33, 16};
        byte[] byArray2 = new byte[3];
        byArray2[0] = 29;
        byArray2[1] = 33;
        const = byArray2;
        byte[] byArray3 = new byte[29];
        byArray3[0] = 27;
        byArray3[1] = 97;
        byArray3[3] = 27;
        byArray3[4] = 32;
        byArray3[6] = 27;
        byArray3[7] = 45;
        byArray3[9] = 27;
        byArray3[10] = 50;
        byArray3[11] = 27;
        byArray3[12] = 69;
        byArray3[14] = 27;
        byArray3[15] = 71;
        byArray3[17] = 29;
        byArray3[18] = 33;
        byArray3[20] = 29;
        byArray3[21] = 80;
        byArray3[24] = 27;
        byArray3[25] = 37;
        byArray3[27] = 27;
        byArray3[28] = 50;
        final = byArray3;
        byte[] byArray4 = new byte[3];
        byArray4[0] = 27;
        byArray4[1] = 97;
        float = byArray4;
        short = new byte[]{27, 97, 1};
        super = new byte[]{27, 97, 2};
        throw = new byte[]{32};
    }

    private BL112() {
        this.charset = Charset.forName(CHARSET_NAME);
    }

    public static BL112 getInstance() {
        return new BL112();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] getEscSequence(PRINT_SEQUENCE_TYPE sequenceType) {
        void var1_1;
        switch (BL112.do()[var1_1.ordinal()]) {
            case 2: {
                return try;
            }
            case 3: {
                return byte;
            }
            case 4: {
                return case;
            }
            case 5: {
                return char;
            }
            case 1: {
                return do;
            }
            case 6: {
                return else;
            }
            case 7: {
                return goto;
            }
            case 8: {
                return long;
            }
            case 9: {
                return this;
            }
            case 10: {
                return void;
            }
            case 11: {
                return break;
            }
            case 12: {
                return catch;
            }
            case 13: {
                return BL112.class;
            }
            case 14: {
                return const;
            }
            case 15: {
                return final;
            }
            case 16: {
                return float;
            }
            case 17: {
                return short;
            }
            case 18: {
                return super;
            }
            case 19: {
                return throw;
            }
        }
        return new byte[0];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] getAlignment(PRINT_ALIGNMENT alignment) {
        void var1_1;
        switch (BL112.if()[var1_1.ordinal()]) {
            case 1: {
                return float;
            }
            case 2: {
                return short;
            }
            case 3: {
                return super;
            }
        }
        return new byte[0];
    }

    @Override
    public int getCharPerRow() {
        return 68;
    }

    @Override
    public boolean isQRsupport() {
        return false;
    }

    @Override
    public int getDotsPerLine() {
        return 360;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] getBarcode(String barcode, BARCODE_TYPE barcodeType, BARCODE_TEXT_POSITION textPosition, BARCODE_FONT_SIZE fontSize, int bcHeight, int bcWidth) throws EKasaException {
        try {
            void var1_1;
            void var2_2;
            void var3_3;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(new byte[]{29, 102});
            switch (fontSize) {
                case SMALL: {
                    baos.write(1);
                    break;
                }
                case LARGE: {
                    baos.write(0);
                }
            }
            baos.write(new byte[]{29, 104, (byte)bcHeight});
            baos.write(new byte[]{29, 119, (byte)bcWidth});
            baos.write(new byte[]{29, 72});
            switch (BL112.int()[var3_3.ordinal()]) {
                case 1: {
                    baos.write(0);
                    break;
                }
                case 2: {
                    baos.write(1);
                    break;
                }
                case 3: {
                    baos.write(2);
                    break;
                }
                case 4: {
                    baos.write(3);
                }
            }
            baos.write(new byte[]{29, 107});
            switch (BL112.new()[var2_2.ordinal()]) {
                case 1: {
                    baos.write(0);
                    break;
                }
                case 2: {
                    baos.write(1);
                    break;
                }
                case 3: {
                    baos.write(2);
                    break;
                }
                case 4: {
                    baos.write(3);
                    break;
                }
                case 5: {
                    baos.write(4);
                    break;
                }
                case 6: {
                    baos.write(5);
                    break;
                }
                case 7: {
                    baos.write(6);
                    break;
                }
                case 8: {
                    baos.write(65);
                    break;
                }
                case 9: {
                    baos.write(66);
                    break;
                }
                case 10: {
                    baos.write(67);
                    break;
                }
                case 11: {
                    baos.write(68);
                    break;
                }
                case 12: {
                    baos.write(69);
                    break;
                }
                case 13: {
                    baos.write(70);
                    break;
                }
                case 14: {
                    baos.write(71);
                    break;
                }
                case 15: {
                    baos.write(72);
                    break;
                }
                case 16: {
                    baos.write(73);
                }
            }
            baos.write(var1_1.getBytes(this.charset));
            baos.write(0);
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new EKasaException(13L, (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] loadNvImage(int count, byte[] data) throws EKasaException {
        try {
            void var2_2;
            void var1_1;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(28);
            baos.write(113);
            baos.write((byte)var1_1);
            baos.write((byte[])var2_2);
            return baos.toByteArray();
        }
        catch (IOException e) {
            void var3_4;
            throw new EKasaException(13L, (Throwable)var3_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] printNvImage(int index) throws EKasaException {
        void var2_2;
        void var1_1;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(28);
        baos.write(112);
        baos.write((byte)var1_1);
        baos.write(0);
        return var2_2.toByteArray();
    }

    @Override
    public byte[] printImage(int width, int height, byte[] bmp) throws EKasaException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int w = (width + 7) / 8 << 3;
        int h = (height + 7) / 8;
        int firstY = 0;
        while (firstY < h) {
            int lengthY = firstY + 10 < h ? 10 : h - firstY;
            baos.write(29);
            baos.write(42);
            baos.write((byte)((width + 7) / 8));
            baos.write((byte)lengthY);
            int x = 0;
            while (x < w) {
                int y = 0;
                while (y < lengthY) {
                    int p = (firstY + y) * w + x;
                    baos.write(bmp[p]);
                    ++y;
                }
                ++x;
            }
            baos.write(29);
            baos.write(47);
            baos.write(3);
            firstY += 10;
        }
        return baos.toByteArray();
    }

    @Override
    public PrinterEsc[] getPrinterStatusEsc() {
        PrinterEsc[] printerEscArray = new PrinterEsc[]{new PrinterEsc(if, 1), new PrinterEsc(for, 1), new PrinterEsc(int, 1), new PrinterEsc(new, 1)};
        return printerEscArray;
    }

    @Override
    public PrinterEsc getPrinterConnectionStatus() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PrinterStatus parsePrinterStatus(PrinterEsc[] esc) {
        void var2_3;
        PrinterStatus status = new PrinterStatus();
        try {
            PrinterEsc[] printerEscArray = esc;
            int n = esc.length;
            int n2 = 0;
            while (n2 < n) {
                PrinterEsc e = printerEscArray[n2];
                if (Arrays.equals(e.getEsc(), if)) {
                    if ((e.getResponse()[0] & 8) == 8) {
                        status.setOnline(false);
                    } else {
                        status.setOnline(true);
                    }
                } else if (Arrays.equals(e.getEsc(), for)) {
                    if ((e.getResponse()[0] & 4) == 4) {
                        status.setCoverOpen(true);
                    } else {
                        status.setCoverOpen(false);
                    }
                    if ((e.getResponse()[0] & 0x20) == 32) {
                        status.setEndOfPaper(true);
                    } else {
                        status.setEndOfPaper(false);
                    }
                } else if (Arrays.equals(e.getEsc(), int)) {
                    if ((e.getResponse()[0] & 8) == 8) {
                        status.setAutoCutterError(true);
                    } else {
                        status.setAutoCutterError(false);
                    }
                } else if (Arrays.equals(e.getEsc(), new)) {
                    if ((e.getResponse()[0] & 0xC) == 12) {
                        status.setPaperNearToEnd(true);
                    } else {
                        status.setPaperNearToEnd(false);
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            void var1_2;
            status.setPrinterResponseError(var1_2.getMessage());
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] getQrCode(String qrCode, QR_CODE_TYPE qrCodeType) throws EKasaException {
        try {
            void var1_1;
            void var2_2;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] bmp = QRCode.generateQRCodeImage(qrCode, 160, 160, (QR_CODE_TYPE)var2_2);
            baos.write(this.getAlignment(PRINT_ALIGNMENT.CENTER));
            baos.write(this.printImage(160, 160, (byte[])var1_1));
            baos.write(this.getAlignment(PRINT_ALIGNMENT.LEFT));
            return baos.toByteArray();
        }
        catch (EKasaException eKasaException) {
            EKasaException baos = eKasaException;
            throw eKasaException;
        }
        catch (IOException e) {
            throw new EKasaException(13L, (Throwable)e);
        }
        catch (WriterException e) {
            void var3_6;
            throw new EKasaException(13L, (Throwable)var3_6);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String rewriteEscSequence(String text, boolean printable, boolean announcement) {
        void var2_2;
        String string;
        text = BL112Rewriter.REWRITER_ALLOW_PANEL_BUTTON.rewrite(text, this.getCharset(), printable, this);
        text = BL112Rewriter.REWRITER_CR.rewrite(text, this.getCharset(), printable, this);
        text = BL112Rewriter.REWRITER_CUTTER.rewrite(text, this.getCharset(), printable, this);
        text = BL112Rewriter.REWRITER_DOUBLE_STRIKE.rewrite(text, this.getCharset(), printable, this);
        text = BL112Rewriter.REWRITER_DOUBLE_WIDTH.rewrite(text, this.getCharset(), printable, this);
        text = BL112Rewriter.REWRITER_EMPHASIZED.rewrite(text, this.getCharset(), printable, this);
        text = BL112Rewriter.REWRITER_LF.rewrite(text, this.getCharset(), printable, this);
        text = BL112Rewriter.REWRITER_REVERSE.rewrite(text, this.getCharset(), printable, this);
        text = BL112Rewriter.REWRITER_ROTATE.rewrite(text, this.getCharset(), printable, this);
        text = BL112Rewriter.REWRITER_LOGO.rewrite(text, this.getCharset(), printable, this);
        text = BL112Rewriter.REWRITER_SHUFFLE.rewrite(text, this.getCharset(), printable, this);
        text = BL112Rewriter.REWRITER_UNDERLINE.rewrite(text, this.getCharset(), printable, this);
        text = BL112Rewriter.REWRITER_UPSIDE_DOWN.rewrite(text, this.getCharset(), printable, this);
        string = BL112Rewriter.REWRITER_EURO.rewrite(string, this.getCharset(), (boolean)var2_2, this);
        return string;
    }

    @Override
    public int[] getVatTableCols() {
        return new int[]{5, 10, 16, 16, 16, 4};
    }

    private static /* synthetic */ int[] do() {
        if (double != null) {
            return double;
        }
        int[] nArray = new int[PRINT_SEQUENCE_TYPE.values().length];
        try {
            nArray[PRINT_SEQUENCE_TYPE.ALIGNMENT_CENTER.ordinal()] = 17;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[PRINT_SEQUENCE_TYPE.ALIGNMENT_LEFT.ordinal()] = 16;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[PRINT_SEQUENCE_TYPE.ALIGNMENT_RIGHT.ordinal()] = 18;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[PRINT_SEQUENCE_TYPE.CR.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[PRINT_SEQUENCE_TYPE.CRLF.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[PRINT_SEQUENCE_TYPE.DEFAULT.ordinal()] = 15;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[PRINT_SEQUENCE_TYPE.DOUBLE_CHAR_OFF.ordinal()] = 14;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[PRINT_SEQUENCE_TYPE.DOUBLE_CHAR_ON.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[PRINT_SEQUENCE_TYPE.EURO.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[PRINT_SEQUENCE_TYPE.FONT_CONDENSE_OFF.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[PRINT_SEQUENCE_TYPE.FONT_CONDENSE_ON.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[PRINT_SEQUENCE_TYPE.FONT_SLOVAK.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[PRINT_SEQUENCE_TYPE.INIT_PRN.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[PRINT_SEQUENCE_TYPE.LF.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[PRINT_SEQUENCE_TYPE.LINE_CONDENSE_OFF.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[PRINT_SEQUENCE_TYPE.LINE_CONDENSE_ON.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[PRINT_SEQUENCE_TYPE.LINE_PREFIX.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[PRINT_SEQUENCE_TYPE.OREZ.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[PRINT_SEQUENCE_TYPE.SPACE.ordinal()] = 19;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        double = nArray;
        return nArray;
    }

    private static /* synthetic */ int[] if() {
        if (import != null) {
            return import;
        }
        int[] nArray = new int[PRINT_ALIGNMENT.values().length];
        try {
            nArray[PRINT_ALIGNMENT.CENTER.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[PRINT_ALIGNMENT.LEFT.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[PRINT_ALIGNMENT.RIGHT.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        import = nArray;
        return nArray;
    }

    private static /* synthetic */ int[] int() {
        if (public != null) {
            return public;
        }
        int[] nArray = new int[BARCODE_TEXT_POSITION.values().length];
        try {
            nArray[BARCODE_TEXT_POSITION.ABOVE.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BARCODE_TEXT_POSITION.BELOW.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BARCODE_TEXT_POSITION.BOTH.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BARCODE_TEXT_POSITION.NONE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        public = nArray;
        return nArray;
    }

    private static /* synthetic */ int[] new() {
        if (return != null) {
            return return;
        }
        int[] nArray = new int[BARCODE_TYPE.values().length];
        try {
            nArray[BARCODE_TYPE.CODABAR.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BARCODE_TYPE.CODABARx.ordinal()] = 14;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BARCODE_TYPE.CODE128.ordinal()] = 16;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BARCODE_TYPE.CODE39.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BARCODE_TYPE.CODE39x.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BARCODE_TYPE.CODE93.ordinal()] = 15;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BARCODE_TYPE.EAN13.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BARCODE_TYPE.EAN13x.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BARCODE_TYPE.EAN8.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BARCODE_TYPE.EANS.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BARCODE_TYPE.ITF.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BARCODE_TYPE.ITFx.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BARCODE_TYPE.UPC_A.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BARCODE_TYPE.UPC_Ax.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BARCODE_TYPE.UPC_E.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BARCODE_TYPE.UPC_Ex.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        return = nArray;
        return nArray;
    }
}

