/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.eKasaSK.lib.LowLevelFMInterfaceNoControl;
import sk.singularisdev.eKasaSK.lib.communication.CommunicationDriver;
import sk.singularisdev.eKasaSK.lib.communication.TcpDriverSwHandshake;
import sk.singularisdev.ekasask.Configuration;
import sk.singularisdev.ekasask.ErrorListenerInterface;
import sk.singularisdev.ekasask.client.server.Server;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.common.Function;
import sk.singularisdev.ekasask.fm.communication.SuperserverDriverTcpIp;
import sk.singularisdev.ekasask.fm.config.Config;
import sk.singularisdev.ekasask.fm.interfaces.GUIThreadListener;
import sk.singularisdev.ekasask.fm.test.ConfigurationRunnable;

public class Daemon
implements GUIThreadListener {
    public static Logger logger = LoggerManager.getLogger((String)Daemon.class.getName());
    private static Daemon daemon = new Daemon();
    private Config config = new Config();
    private SuperserverDriverTcpIp superserverDriver;
    private Server clientServer;

    private Daemon() {
    }

    public static Daemon getInstance() {
        return daemon;
    }

    public SuperserverDriverTcpIp getServerDriver() {
        return this.superserverDriver;
    }

    public void fileConfiguration() throws Exception {
        if (this.config.getConfiguration() != null) {
            System.out.println("Prebieha konfigur\u00e1cia zo s\u00faboru. \u010cakajte pros\u00edm ...");
            TcpDriverSwHandshake driver = new TcpDriverSwHandshake("127.0.0.1", 30000);
            LowLevelFMInterfaceNoControl fmInterface = new LowLevelFMInterfaceNoControl((CommunicationDriver)driver);
            Thread thread = new Thread(new ConfigurationRunnable(fmInterface, this.config.getConfiguration(), this));
            thread.start();
        }
    }

    public void install(Config config) throws Exception {
        this.config = config.clone();
        if (config.getLogging() == Level.ALL) {
            FileHandler handler = new FileHandler("CommunicationLog.log");
            handler.setLevel(Level.ALL);
            LoggerManager.addHandler((String)"", (Handler)handler);
            LoggerManager.setLevel((String)"", (Level)Level.ALL);
        } else if (config.getLogging() == Level.INFO) {
            ConsoleHandler handler = new ConsoleHandler();
            handler.setLevel(Level.INFO);
            LoggerManager.addHandler((String)"", (Handler)handler);
            LoggerManager.setLevel((String)"", (Level)Level.INFO);
        }
        this.superserverDriver = new SuperserverDriverTcpIp(this.config.getSuperserverPort());
        this.superserverDriver.startDriver();
        try {
            this.clientServer = new Server(0);
            this.clientServer.startDriver();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    public void uninstall() {
        EKasa.uninstallAll();
        if (this.superserverDriver != null) {
            this.superserverDriver.stopDriver(false);
        }
        try {
            this.clientServer.stopDriver();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    public synchronized EKasa getEKasa(long deviceNumber) {
        return EKasa.install(deviceNumber);
    }

    public static void main(String[] args) {
        List<String> ppekkInis;
        System.out.println("JAVA VERSION: " + System.getProperty("java.version"));
        if (Function.getFilesList(System.getProperty("user.dir"), "ppekk_").size() == 0 && (ppekkInis = Function.getFilesList(System.getProperty("user.dir"), "ppekk.ini")).size() == 1) {
            try {
                Path fileToMovePath = Paths.get(String.valueOf(System.getProperty("user.dir")) + "/ppekk.ini", new String[0]);
                Path targetPath = Paths.get(System.getProperty("user.dir"), new String[0]);
                Files.move(fileToMovePath, targetPath.resolve("ppekk_1.ini"), new CopyOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Configuration.setErrorListener((ErrorListenerInterface)new ErrorListenerInterface(){

            public void errorException(Exception e) {
                block13: {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss_SSS");
                    FileOutputStream fos = null;
                    try {
                        try {
                            File dir = new File("exception_error_log");
                            if (!dir.exists()) {
                                dir.mkdirs();
                            }
                            File file = new File(dir, "exception_error_" + sdf.format(new Date()) + "_" + (int)(Math.random() * 100000.0) + ".log");
                            file.createNewFile();
                            fos = new FileOutputStream(file);
                            fos.write(e.getMessage().getBytes("UTF-8"));
                            fos.flush();
                        }
                        catch (Exception ex) {
                            logger.fatal("Error save log", (Throwable)e);
                            if (fos == null) break block13;
                            try {
                                fos.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    finally {
                        if (fos != null) {
                            try {
                                fos.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
            }

            public void httpErrorListener(String response) {
                block13: {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss_SSS");
                    FileOutputStream fos = null;
                    try {
                        try {
                            File dir = new File("http_error_log");
                            if (!dir.exists()) {
                                dir.mkdirs();
                            }
                            File file = new File(dir, "http_error_" + sdf.format(new Date()) + "_" + (int)(Math.random() * 100000.0) + ".log");
                            file.createNewFile();
                            fos = new FileOutputStream(file);
                            fos.write(response.getBytes("UTF-8"));
                            fos.flush();
                        }
                        catch (Exception e) {
                            logger.fatal("Error save log", (Throwable)e);
                            if (fos == null) break block13;
                            try {
                                fos.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    finally {
                        if (fos != null) {
                            try {
                                fos.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
            }
        });
        Config config = new Config();
        if (args != null) {
            String[] stringArray = args;
            int n = args.length;
            int targetPath = 0;
            while (targetPath < n) {
                String arg = stringArray[targetPath];
                if (arg.contains("-port:")) {
                    try {
                        config.setSuperserver(Integer.parseInt(arg.split(":")[1]));
                    }
                    catch (Exception e) {
                        config.setSuperserver(30000);
                    }
                } else if (arg.contains("-log:")) {
                    switch (arg.split(":")[1].charAt(0)) {
                        case 'A': {
                            config.setLogging(Level.ALL);
                            break;
                        }
                        case 'I': {
                            config.setLogging(Level.INFO);
                        }
                    }
                } else if (arg.contains("-folder:")) {
                    try {
                        config.setPath(arg.split(":")[1]);
                    }
                    catch (Exception e) {
                        config.setPath("");
                    }
                } else if (arg.contains("-url:")) {
                    Configuration.setSfsUrl((String)arg.split(":", 2)[1]);
                } else if (arg.contains("-proxy:")) {
                    String[] proxy = arg.split(":");
                    Configuration.setProxyHost((String)proxy[1]);
                    Configuration.setProxyPort((int)Integer.parseInt(proxy[2]));
                }
                ++targetPath;
            }
        } else {
            config.setSuperserver(30000);
        }
        try {
            config.setConfiguration(Function.loadConfigurationFile());
        }
        catch (Exception e) {
            config.setConfiguration(null);
        }
        FileInputStream in = null;
        RandomAccessFile raf = null;
        try {
            String filename = "fm.pid";
            File f = new File(filename);
            f.delete();
            f.createNewFile();
            in = new FileInputStream(f);
            raf = new RandomAccessFile(f, "rw");
            FileLock lock = raf.getChannel().tryLock();
            if (lock == null) {
                System.out.println("Be\u017e\u00ed in\u00e1 in\u0161tancia.");
                return;
            }
            try {
                Daemon.getInstance().install(config);
                Daemon.getInstance().fileConfiguration();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                    raf.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void processFinished(boolean success) {
        if (success) {
            System.out.println("Konfigur\u00e1cia zo s\u00faboru ukon\u010den\u00e1!");
            try {
                new File("Configuration.config").delete();
            }
            catch (Exception exception) {}
        } else {
            System.out.println("Konfigur\u00e1cia zo s\u00faboru zlyhala!");
        }
    }
}

