/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import java.math.BigDecimal;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.fm.Checkers;
import sk.singularisdev.ekasask.fm.EKasa;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.common.Function;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.data.ItemModel;
import sk.singularisdev.ekasask.fm.util.Hex;
import sk.singularisdev.ekasask.printer.AbstractPrinter;
import sk.singularisdev.ekasask.printer.Printer;

public class DepositeInDrawer
extends FmCommand {
    private static final Logger logger = LoggerManager.getLogger((String)DepositeInDrawer.class.getName());
    private int row;
    private int operationType;
    private int paymentId;
    private String description;
    private BigDecimal totalPrice;

    public DepositeInDrawer(EKasa eKasa, AppCommunicationDriver driver, byte[] binary, String[] params) {
        super(eKasa, driver, binary, params);
        logger.info("[FMCOMMAND] Binary: " + Hex.toHexString(binary) + " Params: " + Formatter.get().StringArrayToString(params));
    }

    @Override
    public byte doCommand(PPEKK ppekk, FmFiscalMemory fm) {
        if (ppekk == null) {
            return -3;
        }
        try {
            if (fm.isDbOk()) {
                byte status = this.parseParams();
                if (status == 0) {
                    fm.beginTransaction();
                    switch (this.operationType) {
                        case 0: {
                            fm.getPaymentMethod(this.paymentId).appendLocalDeposite(this.totalPrice);
                            fm.getPaymentMethod(this.paymentId).incLocalDepositeCounter();
                            fm.appendReceiptTotal(this.totalPrice);
                            break;
                        }
                        case 1: {
                            fm.getPaymentMethod(this.paymentId).appendLocalWithdraw(this.totalPrice);
                            fm.getPaymentMethod(this.paymentId).incLocalWithdrawCounter();
                            fm.appendReceiptTotal(this.totalPrice.negate());
                        }
                    }
                    fm.getParagon().addItem(new ItemModel.Builder().setRow(this.row).setDescription(this.description).setPaymentFlag(this.paymentId).setTotalPrice(this.totalPrice.toString()).setItemType(this.operationType == 0 ? ItemModel.ItemType.deposite : ItemModel.ItemType.withdraw).build());
                    fm.getParagon().appendBinaryData(this.binary);
                    fm.setPreline(null);
                    fm.setPostline(null);
                    fm.saveDbParagon();
                    fm.setTransactionSuccesfull();
                    fm.endTransaction();
                }
                return status;
            }
            return -2;
        }
        catch (FmStoreToDbException e) {
            fm.endTransaction();
            logger.fatal("Database error", (Throwable)e);
            Function.initFMDB(fm);
            return -2;
        }
    }

    @Override
    protected byte parseParams() {
        block16: {
            block15: {
                block14: {
                    block13: {
                        PPEKK ppekk;
                        block12: {
                            FmFiscalMemory fm;
                            block11: {
                                fm = this.eKasa.getFm();
                                ppekk = this.eKasa.getPPEKK();
                                if (fm.getFmState() != 20) {
                                    return 52;
                                }
                                if (this.params.length != 5) {
                                    return 32;
                                }
                                try {
                                    this.row = Integer.parseInt(this.params[0]);
                                    if (this.row >= 0 && this.row <= 9) break block11;
                                    return 96;
                                }
                                catch (NumberFormatException e) {
                                    return 96;
                                }
                            }
                            if (!fm.isSafeMode() || fm.getActualRow() == this.row - 1) break block12;
                            return 67;
                        }
                        this.description = this.params[1];
                        if (Printer.getPrintableLength((AbstractPrinter)ppekk.getPrinter(), (String)this.description, (boolean)true) <= 20) break block13;
                        return 33;
                    }
                    this.operationType = Integer.parseInt(this.params[2]);
                    if (this.operationType >= 0 && this.operationType <= 1) break block14;
                    return 96;
                }
                if (Checkers.get().checkValueFormat(this.params[3], 7, 2)) break block15;
                return 33;
            }
            if (!this.params[3].contains("-")) break block16;
            return 96;
        }
        this.totalPrice = new BigDecimal(this.params[3]);
        this.paymentId = Integer.parseInt(this.params[4]);
        if (this.paymentId < 1 || this.paymentId > 8 && this.paymentId != 16) {
            return 96;
        }
        return 0;
    }
}

