/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import sk.singularisdev.common.image.Image;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.Configuration;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.PPEKKListener;
import sk.singularisdev.ekasask.enumeration.AUTHENTICATION_ALERT_TYPE;
import sk.singularisdev.ekasask.enumeration.EVENT_TYPE;
import sk.singularisdev.ekasask.fm.ClearDisplay;
import sk.singularisdev.ekasask.fm.DepositeInDrawer;
import sk.singularisdev.ekasask.fm.DestroyParagon;
import sk.singularisdev.ekasask.fm.Fiscalization;
import sk.singularisdev.ekasask.fm.FmCommand;
import sk.singularisdev.ekasask.fm.FmFiscalMemory;
import sk.singularisdev.ekasask.fm.FreeId;
import sk.singularisdev.ekasask.fm.GetEscapeSequence;
import sk.singularisdev.ekasask.fm.GetJournal;
import sk.singularisdev.ekasask.fm.GetJournalStructD;
import sk.singularisdev.ekasask.fm.GetJournalStructU;
import sk.singularisdev.ekasask.fm.GetLastParagon;
import sk.singularisdev.ekasask.fm.GetParagonIDs;
import sk.singularisdev.ekasask.fm.GetVariable;
import sk.singularisdev.ekasask.fm.InternalCommand;
import sk.singularisdev.ekasask.fm.ItemDiscount;
import sk.singularisdev.ekasask.fm.ItemDiscount2;
import sk.singularisdev.ekasask.fm.ItemNegative;
import sk.singularisdev.ekasask.fm.ItemReturn;
import sk.singularisdev.ekasask.fm.ItemSale;
import sk.singularisdev.ekasask.fm.ItemVoid;
import sk.singularisdev.ekasask.fm.LoadGHNV;
import sk.singularisdev.ekasask.fm.OdpocitanaZaloha;
import sk.singularisdev.ekasask.fm.OpravaDokladu;
import sk.singularisdev.ekasask.fm.ParagonBegin;
import sk.singularisdev.ekasask.fm.ParagonEnd;
import sk.singularisdev.ekasask.fm.Payment;
import sk.singularisdev.ekasask.fm.Payment2;
import sk.singularisdev.ekasask.fm.Popis0DPH;
import sk.singularisdev.ekasask.fm.PrintAnnouncement;
import sk.singularisdev.ekasask.fm.PrintAnnouncementNF;
import sk.singularisdev.ekasask.fm.PrintBC;
import sk.singularisdev.ekasask.fm.PrintDisplay;
import sk.singularisdev.ekasask.fm.PrintDisplay2;
import sk.singularisdev.ekasask.fm.PrintIssuedParagon;
import sk.singularisdev.ekasask.fm.PrintJournalStructD;
import sk.singularisdev.ekasask.fm.PrintJournalStructU;
import sk.singularisdev.ekasask.fm.PrintQRCode;
import sk.singularisdev.ekasask.fm.PrintReport;
import sk.singularisdev.ekasask.fm.PrintUnsentSFSPackets;
import sk.singularisdev.ekasask.fm.RepeatParagon;
import sk.singularisdev.ekasask.fm.ResetStates;
import sk.singularisdev.ekasask.fm.SellingDayBegin;
import sk.singularisdev.ekasask.fm.SendUnsentSFSPackets;
import sk.singularisdev.ekasask.fm.SetAdditionalFooter;
import sk.singularisdev.ekasask.fm.SetAdditionalHeader;
import sk.singularisdev.ekasask.fm.SetAutKey;
import sk.singularisdev.ekasask.fm.SetBCParm;
import sk.singularisdev.ekasask.fm.SetClientID;
import sk.singularisdev.ekasask.fm.SetDIC;
import sk.singularisdev.ekasask.fm.SetDKP;
import sk.singularisdev.ekasask.fm.SetDeltaSI;
import sk.singularisdev.ekasask.fm.SetDispF;
import sk.singularisdev.ekasask.fm.SetEmail;
import sk.singularisdev.ekasask.fm.SetEscapeSequence;
import sk.singularisdev.ekasask.fm.SetEuroExchangeRate;
import sk.singularisdev.ekasask.fm.SetHeader;
import sk.singularisdev.ekasask.fm.SetICO;
import sk.singularisdev.ekasask.fm.SetInvoiceNumber;
import sk.singularisdev.ekasask.fm.SetLocation;
import sk.singularisdev.ekasask.fm.SetPCHDU;
import sk.singularisdev.ekasask.fm.SetPParameter;
import sk.singularisdev.ekasask.fm.SetPRNBd;
import sk.singularisdev.ekasask.fm.SetPRNColumns;
import sk.singularisdev.ekasask.fm.SetParameter;
import sk.singularisdev.ekasask.fm.SetPassword;
import sk.singularisdev.ekasask.fm.SetPaymentType;
import sk.singularisdev.ekasask.fm.SetPaymentType2;
import sk.singularisdev.ekasask.fm.SetPostline;
import sk.singularisdev.ekasask.fm.SetPreline;
import sk.singularisdev.ekasask.fm.SetPrinterType;
import sk.singularisdev.ekasask.fm.SetQRParm;
import sk.singularisdev.ekasask.fm.SetSMTP;
import sk.singularisdev.ekasask.fm.SetSellerID;
import sk.singularisdev.ekasask.fm.SetSubjectIDData;
import sk.singularisdev.ekasask.fm.SetTransactionID;
import sk.singularisdev.ekasask.fm.SetV48;
import sk.singularisdev.ekasask.fm.SetVAT;
import sk.singularisdev.ekasask.fm.SubTotal;
import sk.singularisdev.ekasask.fm.SubTotalDiscount;
import sk.singularisdev.ekasask.fm.SubTotalDiscount2;
import sk.singularisdev.ekasask.fm.VymenaPoukazu;
import sk.singularisdev.ekasask.fm.common.Function;
import sk.singularisdev.ekasask.fm.communication.AppCommunicationDriver;
import sk.singularisdev.ekasask.fm.communication.MailLoader;
import sk.singularisdev.ekasask.xmlparser.IdentityData;

public class EKasa
implements PPEKKListener {
    private static final Logger logger = LoggerManager.getLogger((String)EKasa.class.getName());
    private static final Map<Long, EKasa> eKasa = new HashMap<Long, EKasa>();
    private PPEKK ppekk;
    private long fmId;
    private FmFiscalMemory fiscalMemory;

    private EKasa(long fmId) {
        this.fmId = fmId;
        this.fiscalMemory = FmFiscalMemory.install(fmId);
        try {
            this.ppekk = PPEKK.install((long)fmId, (String)"AA1", (PPEKKListener)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static synchronized EKasa install(long fmId) {
        if (eKasa.containsKey(fmId)) {
            return eKasa.get(fmId);
        }
        EKasa ekasa = new EKasa(fmId);
        eKasa.put(fmId, ekasa);
        try {
            Configuration.setHeaderTemplate((long)fmId, (String)Function.loadTemplateFile(fmId));
        }
        catch (Exception e) {
            logger.info("Template not specified!");
        }
        return ekasa;
    }

    public static synchronized void uninstall(long fmId) {
        if (eKasa.containsKey(fmId)) {
            EKasa ekasa = eKasa.remove(fmId);
            ekasa.close();
        }
    }

    public static synchronized void uninstallAll() {
        for (long fmId : eKasa.keySet()) {
            EKasa.uninstall(fmId);
        }
    }

    public FmCommand getCommand(AppCommunicationDriver driver, byte command, byte[] binary, String[] params) {
        switch (command) {
            case -78: {
                return new SetEuroExchangeRate(this, driver, binary, params);
            }
            case -73: {
                return new SetPassword(this, driver, binary, params);
            }
            case -72: {
                return new SetPaymentType2(this, driver, binary, params);
            }
            case -71: {
                return new SetDIC(this, driver, binary, params);
            }
            case -70: {
                return new SetICO(this, driver, binary, params);
            }
            case -69: {
                return new SetPaymentType(this, driver, binary, params);
            }
            case -56: {
                return new PrintDisplay2(this, driver, binary, params);
            }
            case -45: {
                return new SetDKP(this, driver, binary, params);
            }
            case -40: {
                return new SetPRNColumns(this, driver, binary, params);
            }
            case -38: {
                return new SetDeltaSI(this, driver, binary, params);
            }
            case -37: {
                return new SetDispF(this, driver, binary, params);
            }
            case 41: {
                return new SellingDayBegin(this, driver, binary, params);
            }
            case 32: {
                return new ParagonBegin(this, driver, binary, params);
            }
            case 36: {
                return new ItemSale(this, driver, binary, params);
            }
            case 40: {
                return new ItemReturn(this, driver, binary, params);
            }
            case 37: {
                return new ItemVoid(this, driver, binary, params);
            }
            case 45: {
                return new ItemNegative(this, driver, binary, params);
            }
            case 48: {
                return new Payment(this, driver, binary, params);
            }
            case 54: {
                return new Payment2(this, driver, binary, params);
            }
            case 38: {
                return new ItemDiscount(this, driver, binary, params);
            }
            case 52: {
                return new ItemDiscount2(this, driver, binary, params);
            }
            case 44: {
                return new SubTotalDiscount(this, driver, binary, params);
            }
            case 53: {
                return new SubTotalDiscount2(this, driver, binary, params);
            }
            case 39: {
                return new SubTotal(this, driver, binary, params);
            }
            case -68: {
                return new SetHeader(this, driver, binary, params);
            }
            case -110: {
                return new GetVariable(this, driver, binary, params);
            }
            case 80: {
                return new PrintReport(this, driver, binary, params);
            }
            case 43: {
                return new DestroyParagon(this, driver, binary, params);
            }
            case 42: {
                return new RepeatParagon(this, driver, binary, params);
            }
            case -109: {
                return new GetLastParagon(this, driver, binary, params);
            }
            case 46: {
                return new DepositeInDrawer(this, driver, binary, params);
            }
            case 49: {
                return new PrintAnnouncement(this, driver, binary, params);
            }
            case 50: {
                return new PrintAnnouncementNF(this, driver, binary, params);
            }
            case -61: {
                return new SetPreline(this, driver, binary, params);
            }
            case -60: {
                return new SetPostline(this, driver, binary, params);
            }
            case 34: {
                return new ParagonEnd(this, driver, binary, params);
            }
            case 56: {
                return new FreeId(this, driver, binary, params);
            }
            case -43: {
                return new SetBCParm(this, driver, binary, params);
            }
            case 55: {
                return new PrintBC(this, driver, binary, params);
            }
            case -20: {
                return new SetQRParm(this, driver, binary, params);
            }
            case -19: {
                return new PrintQRCode(this, driver, binary, params);
            }
            case -52: {
                return new SetLocation(this, driver, binary, params);
            }
            case -53: {
                return new SetClientID(this, driver, binary, params);
            }
            case -54: {
                return new PrintIssuedParagon(this, driver, binary, params);
            }
            case -80: {
                return new Fiscalization(this, driver, binary, params);
            }
            case -95: {
                return new SetSubjectIDData(this, driver, binary, params);
            }
            case -63: {
                return new SetAdditionalHeader(this, driver, binary, params);
            }
            case -62: {
                return new SetAdditionalFooter(this, driver, binary, params);
            }
            case -74: {
                return new SetPrinterType(this, driver, binary, params);
            }
            case -76: {
                return new SetPRNBd(this, driver, binary, params);
            }
            case -67: {
                return new SetParameter(this, driver, binary, params);
            }
            case -42: {
                return new SetPParameter(this, driver, binary, params);
            }
            case -92: {
                return new SetV48(this, driver, binary, params);
            }
            case -55: {
                return new SetInvoiceNumber(this, driver, binary, params);
            }
            case -51: {
                return new SetPCHDU(this, driver, binary, params);
            }
            case -64: {
                return new VymenaPoukazu(this, driver, binary, params);
            }
            case -77: {
                return new OdpocitanaZaloha(this, driver, binary, params);
            }
            case -81: {
                return new GetParagonIDs(this, driver, binary, params);
            }
            case -82: {
                return new SetTransactionID(this, driver, binary, params);
            }
            case -88: {
                return new PrintUnsentSFSPackets(this, driver, binary, params);
            }
            case -89: {
                return new SetEmail(this, driver, binary, params);
            }
            case -90: {
                return new SetSMTP(this, driver, binary, params);
            }
            case -94: {
                return new SendUnsentSFSPackets(this, driver, binary, params);
            }
            case -93: {
                return new SetAutKey(this, driver, binary, params);
            }
            case -98: {
                return new Popis0DPH(this, driver, binary, params);
            }
            case -106: {
                return new SetSellerID(this, driver, binary, params);
            }
            case -66: {
                return new SetVAT(this, driver, binary, params);
            }
            case -108: {
                return new InternalCommand(this, driver, binary, params);
            }
            case -59: {
                return new PrintDisplay(this, driver, binary, params);
            }
            case -58: {
                return new ClearDisplay(this, driver, binary, params);
            }
            case -57: {
                return new SetEscapeSequence(this, driver, binary, params);
            }
            case -47: {
                return new LoadGHNV(this, driver, binary, params);
            }
            case -107: {
                return new OpravaDokladu(this, driver, binary, params);
            }
            case -3: {
                return new ResetStates(this, driver, binary, params);
            }
            case 89: {
                return new PrintJournalStructU(this, driver, binary, params);
            }
            case -103: {
                return new GetJournalStructU(this, driver, binary, params);
            }
            case 87: {
                return new PrintJournalStructD(this, driver, binary, params);
            }
            case -105: {
                return new GetJournalStructD(this, driver, binary, params);
            }
            case -97: {
                return new GetJournal(this, driver, binary, params);
            }
            case -111: {
                return new GetEscapeSequence(this, driver, binary, params);
            }
        }
        return null;
    }

    public long getFmId() {
        return this.fmId;
    }

    public FmFiscalMemory getFm() {
        return this.fiscalMemory;
    }

    public PPEKK getPPEKK() {
        return this.ppekk;
    }

    private void close() {
        FmFiscalMemory.uninstall(this.fmId);
        if (this.ppekk != null) {
            this.ppekk.removeListener((PPEKKListener)this);
            PPEKK.uninstall((long)this.ppekk.getId());
        }
    }

    public void resendError(PPEKK ppekk, EKasaException e, Date when) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        System.out.println("resendError: " + sdf.format(when));
        e.printStackTrace();
    }

    public void synchronizeChdu2Ppekk(PPEKK ppekk, String transactionId, String lastTransactionId, EVENT_TYPE eventType, Date when) {
    }

    public void chduAuthenticationAlert(PPEKK ppekk, AUTHENTICATION_ALERT_TYPE alertType, Date when) {
    }

    public void mail(PPEKK ppekk, UUID messageUuid, String transactionId, String email, Image receipt, PPEKKListener.ReceiptInfo receiptInfo, Date when) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        System.out.println("Document emailed: " + sdf.format(when) + "    transactionID: " + transactionId);
        BufferedImage bufferedImage = new BufferedImage(receipt.getWidth(), receipt.getHeight(), 1);
        int[] underlyingBuffer = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        System.arraycopy(receipt.getBuffer(), 0, underlyingBuffer, 0, receipt.getBuffer().length);
        new Thread(new MailLoader(this.fiscalMemory.getEmailDirectory(), email, bufferedImage)).start();
    }

    public void mail(PPEKK ppekk, UUID messageUuid, String transactionId, String email, BufferedImage receipt, PPEKKListener.ReceiptInfo receiptInfo, Date when) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        System.out.println("Document emailed: " + sdf.format(when) + "    transactionID: " + transactionId);
        new Thread(new MailLoader(this.fiscalMemory.getEmailDirectory(), email, receipt)).start();
    }

    public void documentPrint(PPEKK ppekk, EVENT_TYPE eventType, UUID commandUuid, String transactionId, String originTransactionId, byte[] printDocument, byte[] copyDocument, PPEKKListener.ReceiptInfo receiptInfo, Date when) {
        block5: {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            System.out.println("Document print: " + sdf.format(when) + "    " + (eventType == EVENT_TYPE.START ? "start" : "end") + "    transactionID: " + transactionId);
            if ((eventType == EVENT_TYPE.END || eventType == EVENT_TYPE.ERROR) && receiptInfo == null) {
                try {
                    char receiptType = this.fiscalMemory.getParagonType(commandUuid);
                    this.fiscalMemory.saveJournal(commandUuid, 0, 0, 0, 0, "", "", "", "", printDocument, receiptType == 'I' ? this.fiscalMemory.getReceiptNumber() + 1 : 0, this.fiscalMemory.getReportNumber(), transactionId);
                    if (receiptType == 'I') {
                        this.fiscalMemory.incReceiptNumer();
                    } else {
                        this.fiscalMemory.setReceiptNumer(0);
                        this.fiscalMemory.incReportNumber();
                    }
                }
                catch (Exception e) {
                    if (e.getMessage().equals("No data")) break block5;
                    logger.fatal("SAVE JOURNAL", (Throwable)e);
                }
            }
        }
    }

    public void documentSend(PPEKK ppekk, EVENT_TYPE eventType, UUID commandUuid, String transactionId, String originTransactionId, int status, byte[] copyDocument, PPEKKListener.ReceiptInfo receiptInfo, boolean resend, Date when) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        System.out.println("Document send: " + sdf.format(when) + "   Status: " + status + "    " + (eventType == EVENT_TYPE.START ? "start" : "end") + "   Resend:" + resend + "    transactionID: " + transactionId);
        if (eventType == EVENT_TYPE.END || eventType == EVENT_TYPE.ERROR) {
            try {
                if (resend) {
                    this.fiscalMemory.saveJournal(commandUuid, status, Integer.parseInt(receiptInfo.getReceiptMonth().substring(4)), Integer.parseInt(receiptInfo.getReceiptMonth().substring(0, 4)), Integer.parseInt(receiptInfo.getReceiptNumber()), receiptInfo.getUid(), transactionId);
                    if (status != 0) {
                        this.fiscalMemory.setLastSFSError(status);
                    }
                } else {
                    this.fiscalMemory.saveJournal(commandUuid, status, Integer.parseInt(receiptInfo.getReceiptMonth().substring(4)), Integer.parseInt(receiptInfo.getReceiptMonth().substring(0, 4)), Integer.parseInt(receiptInfo.getReceiptNumber()), receiptInfo.getUid(), receiptInfo.getOkp(), receiptInfo.getPkp(), receiptInfo.getQrCode(), copyDocument, this.fiscalMemory.getReceiptNumber() + 1, this.fiscalMemory.getReportNumber(), transactionId);
                    if (status != 0) {
                        this.fiscalMemory.setLastSFSError(status);
                    }
                    this.fiscalMemory.setOKP(receiptInfo.getOkp());
                    this.fiscalMemory.setUID(receiptInfo.getUid());
                    this.fiscalMemory.setPKP(receiptInfo.getPkp());
                    this.fiscalMemory.setQR(receiptInfo.getQrCode());
                    this.fiscalMemory.setTransactionId(transactionId);
                    this.fiscalMemory.setSFSReceiptNumber(String.valueOf(receiptInfo.getReceiptMonth()) + String.format("%5s", receiptInfo.getReceiptNumber()).replaceAll(" ", "0"));
                    this.fiscalMemory.incReceiptNumer();
                }
            }
            catch (Exception e) {
                logger.fatal("SAVE JOURNAL", (Throwable)e);
            }
        }
    }

    public void synchronizeChdu2PpekkProcess(PPEKK arg0, EVENT_TYPE arg1, Date arg2) {
    }

    public void chduLoadConfig(PPEKK ppekk, String chduCfg, IdentityData chduIdent, Date when) {
    }
}

