/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.fm;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.enumeration.BARCODE_FONT_SIZE;
import sk.singularisdev.ekasask.enumeration.BARCODE_TEXT_POSITION;
import sk.singularisdev.ekasask.fm.SVKFiscal;
import sk.singularisdev.ekasask.fm.common.FmStoreToDbException;
import sk.singularisdev.ekasask.fm.common.Formatter;
import sk.singularisdev.ekasask.fm.data.DiscountTurnover;
import sk.singularisdev.ekasask.fm.data.NegativeTurnover;
import sk.singularisdev.ekasask.fm.data.ParagonModel;
import sk.singularisdev.ekasask.fm.data.PaymentMethod;
import sk.singularisdev.ekasask.fm.data.Turnover;
import sk.singularisdev.ekasask.fm.db.FiscalDataStorage;
import sk.singularisdev.ekasask.fm.db.enums.DB;
import sk.singularisdev.ekasask.fm.db.enums.RowPrefix;
import sk.singularisdev.ekasask.fm.db.enums.Rows;
import sk.singularisdev.ekasask.fm.db.enums.Tables;
import sk.singularisdev.ekasask.fm.db.helpers.ContentValues;
import sk.singularisdev.ekasask.fm.db.holder.DbFmData;
import sk.singularisdev.ekasask.fm.db.holder.DbFmState;
import sk.singularisdev.ekasask.fm.enums.ParagonType;
import sk.singularisdev.ekasask.fm.enums.VariableCodes;
import sk.singularisdev.ekasask.fm.interfaces.FiscalLocalize;
import sk.singularisdev.ekasask.fm.util.SerializationUtility;

public class FmFiscalMemory {
    private static final Logger logger = LoggerManager.getLogger((String)FmFiscalMemory.class.getName());
    private static final Map<Long, FmFiscalMemory> fmFiscalMemory = new HashMap<Long, FmFiscalMemory>();
    private FiscalDataStorage dbSource = null;
    private DbFmState fmState;
    private DbFmData fmData;
    private ParagonModel paragon;
    private DiscountTurnover dcsrLocalValueCounter;
    private DiscountTurnover dcsrLocalPercentageCounter;
    private NegativeTurnover negativeLocalCounter;
    private DiscountTurnover dcsrGlobalValueCounter;
    private DiscountTurnover dcsrGlobalPercentageCounter;
    private NegativeTurnover negativeGlobalCounter;
    private Map<Character, Turnover> vats = new HashMap<Character, Turnover>();
    private Map<Integer, PaymentMethod> paymentMethods = new HashMap<Integer, PaymentMethod>();
    private FiscalLocalize flocal = new SVKFiscal();

    private FmFiscalMemory(long fmId) {
        this.dbSource = new FiscalDataStorage((int)fmId);
        this.dbSource.open();
        try {
            this.reloadData();
        }
        catch (FmStoreToDbException e) {
            logger.fatal("Database error", (Throwable)e);
        }
    }

    public void resetAllGlobals() throws FmStoreToDbException {
        this.resetLocalPayments(false);
        this.resetLocalVats(false);
        this.resetGlobalsPayments();
        this.resetGlobalVats();
        this.setNegativeLocalCounter(new NegativeTurnover.Builder(this, true).build());
        this.setNegativeGlobalCounter(new NegativeTurnover.Builder(this, true).build());
        this.setDcsrLocalPercentageCounter(new DiscountTurnover.Builder(this, false, true).build());
        this.setDcsrGlobalPercentageCounter(new DiscountTurnover.Builder(this, true, true).build());
        this.setDcsrLocalValueCounter(new DiscountTurnover.Builder(this, false, false).build());
        this.setDcsrGlobalValueCounter(new DiscountTurnover.Builder(this, true, false).build());
        this.resetDepositeWithdrawCount();
        this.resetInvalidReceipt();
        this.resetInvoiceCounter();
        this.resetInvoiceTurnover();
        this.resetLocalInvoiceTurnover();
        this.resetReceiptTotal();
    }

    public int getFmState() {
        return this.fmState.getFmState();
    }

    public void setFmState(int fmState) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.fmState.row(), fmState);
            this.dbSource.saveData(Tables.fmStates.table(), values);
            this.fmState.setFmState(fmState);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public boolean isSafeMode() {
        return this.fmState.isFmGPSafeMode();
    }

    public void setSafeMode(boolean safeMode) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.fmGPSafeMode.row(), safeMode ? 1 : 0);
            this.dbSource.saveData(Tables.fmStates.table(), values);
            this.fmState.setFmGPSafeMode(safeMode);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public void setEmailDirectory(String path) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.fmEmailDirectory.row(), path);
            this.dbSource.saveData(Tables.fmData.table(), values);
            this.fmData.setEmailDirectory(path);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public void setJournalZFlag(String date) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.fmJournalZFlag.row(), date);
            this.dbSource.saveData(Tables.fmData.table(), values);
            this.fmData.setJournalZFlag(date);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public String getJournalZFlag() {
        return this.fmData.getJournalZFlag();
    }

    public String getEmailDirectory() {
        return this.fmData.getEmailDirectory();
    }

    public int getCharCount() {
        return this.fmData.getCharCount();
    }

    public void setCharCount(int charCount) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.fmCharsPerRow.row(), charCount);
            this.dbSource.saveData(Tables.fmData.table(), values);
            this.fmData.setCharCount(charCount);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public long getLastDbError() {
        return this.fmData.getLastDbError();
    }

    public void setLastDbError(long lastDbError) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.fmLastDBError.row(), (int)lastDbError);
            this.dbSource.saveData(Tables.fmData.table(), values);
            this.fmData.setLastDbError(lastDbError);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public long getLastPPEKKError() {
        return this.fmData.getLastPPEKKError();
    }

    public void setLastPPEKKError(long lastPPEKKError) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.fmLastPPEKKError.row(), (int)lastPPEKKError);
            this.dbSource.saveData(Tables.fmData.table(), values);
            this.fmData.setLastPPEKKError(lastPPEKKError);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public long getLastSFSError() {
        return this.fmData.getLastSFSError();
    }

    public void setLastSFSError(long lastSFSError) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.fmLastSFSError.row(), (int)lastSFSError);
            this.dbSource.saveData(Tables.fmData.table(), values);
            this.fmData.setLastSFSError(lastSFSError);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public String getUID() {
        return this.fmData.getUID();
    }

    public String getOKP() {
        return this.fmData.getOKP();
    }

    public String getQR() {
        return this.fmData.getQR();
    }

    public String getPKP() {
        return this.fmData.getPKP();
    }

    public String getTransactionId() {
        return this.fmData.getTransactionID();
    }

    public void setPKP(String pkp) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.fmLastPKP.row(), pkp);
            this.dbSource.saveData(Tables.fmData.table(), values);
            this.fmData.setPKP(pkp);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public void setUID(String uID) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.fmLastUID.row(), uID);
            this.dbSource.saveData(Tables.fmData.table(), values);
            this.fmData.setUID(uID);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public void setOKP(String oKP) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.fmLastOKP.row(), oKP);
            this.dbSource.saveData(Tables.fmData.table(), values);
            this.fmData.setOKP(oKP);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public void setQR(String qr) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.fmLastQR.row(), qr);
            this.dbSource.saveData(Tables.fmData.table(), values);
            this.fmData.setQR(qr);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public void setTransactionId(String transactionId) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.transactionId.row(), transactionId);
            this.dbSource.saveData(Tables.fmData.table(), values);
            this.fmData.setTransactionID(transactionId);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public int getReceiptNumber() {
        return this.fmData.getReceiptNumber();
    }

    public void setReceiptNumer(int receiptNumber) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.fmReceiptNumber.row(), receiptNumber);
            this.dbSource.saveData(Tables.fmData.table(), values);
            this.fmData.setReceiptNumber(receiptNumber);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public void incReceiptNumer() throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.fmReceiptNumber.row(), this.fmData.getReceiptNumber() + 1);
            this.dbSource.saveData(Tables.fmData.table(), values);
            this.fmData.incReceiptNumber();
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public int getReportNumber() {
        return this.fmData.getReportNumber();
    }

    public void incReportNumber() throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.fmReportNumber.row(), this.fmData.getReportNumber() + 1);
            this.dbSource.saveData(Tables.fmData.table(), values);
            this.fmData.incReportNumber();
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public String getReceiptNumberSFS() {
        return this.fmData.getReceiptNumberSFS();
    }

    public void setSFSReceiptNumber(String receiptNumberSFS) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.fmLastReceiptId.row(), receiptNumberSFS);
            this.dbSource.saveData(Tables.fmData.table(), values);
            this.fmData.setReceiptNumberSFS(receiptNumberSFS);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public boolean isVynimka48hodin() {
        return this.fmState.isFmException48();
    }

    public void setVynimka48hodin(boolean exception48) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.fmException48.row(), exception48 ? 1 : 0);
            this.dbSource.saveData(Tables.fmStates.table(), values);
            this.fmState.setFmException48(exception48);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public int getPrinterType() {
        return this.fmData.getPrinterType();
    }

    public int getPrinterBaud() {
        return this.fmData.getPrinterBaud();
    }

    public void setPrinterType(int printerType) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.fmPrinterType.row(), printerType);
            this.dbSource.saveData(Tables.fmData.table(), values);
            this.fmData.setPrinterType(printerType);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public void setPrinterBaud(int printerBaud) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.fmPrinterBaud.row(), printerBaud);
            this.dbSource.saveData(Tables.fmData.table(), values);
            this.fmData.setPrinterBaud(printerBaud);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public String getPassword() {
        return this.fmData.getPassword();
    }

    public void setPassword(String password) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.fmPassword.row(), Formatter.get().getMD5Format(password));
            this.dbSource.saveData(Tables.fmData.table(), values);
            this.fmData.setPassword(Formatter.get().getMD5Format(password));
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public Date getLastReportDate() {
        return this.fmData.getLastReportDate();
    }

    public Date getLastShiftDate() {
        return this.fmData.getLastShiftDate();
    }

    public void setLastReportDate(Date lastReportDate) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            values.put(Rows.fmLastReportDate.row(), sdf.format(lastReportDate));
            this.dbSource.saveData(Tables.fmData.table(), values);
            this.fmData.setLastReportDate(lastReportDate);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public void setLastShiftDate(Date lastShiftDate) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            values.put(Rows.fmLastShiftDate.row(), sdf.format(lastShiftDate));
            this.dbSource.saveData(Tables.fmData.table(), values);
            this.fmData.setLastShiftDate(lastShiftDate);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public BigDecimal getLocalDiscountTotal() {
        return this.dcsrLocalValueCounter.getDiscountTotal().add(this.dcsrLocalPercentageCounter.getDiscountTotal());
    }

    public int getLocalDiscountTotalCount() {
        return this.dcsrLocalPercentageCounter.getDiscountTotalCount() + this.dcsrLocalValueCounter.getDiscountTotalCount();
    }

    public BigDecimal getGlobalDiscountTotal() {
        return this.dcsrGlobalValueCounter.getDiscountTotal().add(this.dcsrGlobalPercentageCounter.getDiscountTotal());
    }

    public int getGlobalDiscountTotalCount() {
        return this.dcsrGlobalPercentageCounter.getDiscountTotalCount() + this.dcsrGlobalValueCounter.getDiscountTotalCount();
    }

    public void appendInvalidReceipt(BigDecimal appendedValue) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.Total.fullPrefixRow(RowPrefix.invalidReceipt), this.fmData.getInvalidReceiptTotal().add(appendedValue).toString());
            this.dbSource.saveData(Tables.fmGlobals.table(), values);
            this.fmData.setInvalidReceiptTotal(this.fmData.getInvalidReceiptTotal().add(appendedValue));
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public BigDecimal getInvalidReceiptTotal() {
        return this.fmData.getInvalidReceiptTotal();
    }

    public void resetInvalidReceipt() throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.invalidReceipt), 0);
            values.put(Rows.Total.fullPrefixRow(RowPrefix.invalidReceipt), "0.00");
            this.dbSource.saveData(Tables.fmGlobals.table(), values);
            this.fmData.setInvalidReceiptTotal(BigDecimal.ZERO);
            this.fmData.setInvalidReceiptCount(0);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public void incInvalidReceiptCount() throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.invalidReceipt), this.fmData.getInvalidReceiptCount() + 1);
            this.dbSource.saveData(Tables.fmGlobals.table(), values);
            this.fmData.incInvalidReceiptCount();
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public int getInvalidReceiptCount() {
        return this.fmData.getInvalidReceiptCount();
    }

    public void resetDepositeWithdrawCount() throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.deposite, RowPrefix.withdraw), 0);
            this.dbSource.saveData(Tables.fmGlobals.table(), values);
            this.fmData.setDepositeWithdrawCount(0);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public void incDepositeWithdrawCount() throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.deposite, RowPrefix.withdraw), this.fmData.getDepositeWithdrawCount() + 1);
            this.dbSource.saveData(Tables.fmGlobals.table(), values);
            this.fmData.incDepositeWithdrawCount();
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public int getDespositeWithdrawCount() {
        return this.fmData.getDepositeWithdrawCount();
    }

    public NegativeTurnover getNegativeLocalCounter() {
        return this.negativeLocalCounter;
    }

    public NegativeTurnover getNegativeGlobalCounter() {
        return this.negativeGlobalCounter;
    }

    public void setNegativeLocalCounter(NegativeTurnover negativeLocalCounter) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.Total.fullPrefixRow(RowPrefix.itemVoid, RowPrefix.local), negativeLocalCounter.getVoidValue().toString());
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.itemVoid, RowPrefix.local), negativeLocalCounter.getVoidCount());
            values.put(Rows.Total.fullPrefixRow(RowPrefix.itemReturn, RowPrefix.local), negativeLocalCounter.getReturnValue().toString());
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.itemReturn, RowPrefix.local), negativeLocalCounter.getReturnCount());
            values.put(Rows.Total.fullPrefixRow(RowPrefix.itemNegative, RowPrefix.local), negativeLocalCounter.getNegativeValue().toString());
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.itemNegative, RowPrefix.local), negativeLocalCounter.getNegativeCount());
            values.put(Rows.Total.fullPrefixRow(RowPrefix.itemDestroy, RowPrefix.local), negativeLocalCounter.getDestroyedValue().toString());
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.itemDestroy, RowPrefix.local), negativeLocalCounter.getDestroyedCount());
            values.put(Rows.Total.fullPrefixRow(RowPrefix.round, RowPrefix.local), negativeLocalCounter.getRoundValue().toString());
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.round, RowPrefix.local), negativeLocalCounter.getReturnCount());
            this.dbSource.saveData(Tables.fmGlobals.table(), values);
            this.negativeLocalCounter = negativeLocalCounter;
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public void setNegativeGlobalCounter(NegativeTurnover negativeGlobalCounter) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.Total.fullPrefixRow(RowPrefix.itemVoid, RowPrefix.global), negativeGlobalCounter.getVoidValue().toString());
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.itemVoid, RowPrefix.global), negativeGlobalCounter.getVoidCount());
            values.put(Rows.Total.fullPrefixRow(RowPrefix.itemReturn, RowPrefix.global), negativeGlobalCounter.getReturnValue().toString());
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.itemReturn, RowPrefix.global), negativeGlobalCounter.getReturnCount());
            values.put(Rows.Total.fullPrefixRow(RowPrefix.itemNegative, RowPrefix.global), negativeGlobalCounter.getNegativeValue().toString());
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.itemNegative, RowPrefix.global), negativeGlobalCounter.getNegativeCount());
            values.put(Rows.Total.fullPrefixRow(RowPrefix.itemDestroy, RowPrefix.global), negativeGlobalCounter.getDestroyedValue().toString());
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.itemDestroy, RowPrefix.global), negativeGlobalCounter.getDestroyedCount());
            values.put(Rows.Total.fullPrefixRow(RowPrefix.round, RowPrefix.global), negativeGlobalCounter.getRoundValue().toString());
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.round, RowPrefix.global), negativeGlobalCounter.getReturnCount());
            this.dbSource.saveData(Tables.fmGlobals.table(), values);
            this.negativeGlobalCounter = negativeGlobalCounter;
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public DiscountTurnover getDcsrLocalValueCounter() {
        return this.dcsrLocalValueCounter;
    }

    public DiscountTurnover getDcsrLocalPercentageCounter() {
        return this.dcsrLocalPercentageCounter;
    }

    public DiscountTurnover getDcsrGlobalValueCounter() {
        return this.dcsrGlobalValueCounter;
    }

    public DiscountTurnover getDcsrGlobalPercentageCounter() {
        return this.dcsrGlobalPercentageCounter;
    }

    public void setDcsrLocalValueCounter(DiscountTurnover dcsrLocalValueCounter) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.Total.fullPrefixRow(RowPrefix.discount, RowPrefix.value, RowPrefix.local), dcsrLocalValueCounter.getDiscountItem().toString());
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.discount, RowPrefix.value, RowPrefix.local), dcsrLocalValueCounter.getDiscountItemCounter());
            values.put(Rows.Total.fullPrefixRow(RowPrefix.surcharge, RowPrefix.value, RowPrefix.local), dcsrLocalValueCounter.getSurchargeItem().toString());
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.surcharge, RowPrefix.value, RowPrefix.local), dcsrLocalValueCounter.getSurchargeItemCounter());
            values.put(Rows.Total.fullPrefixRow(RowPrefix.subtotalDiscount, RowPrefix.value, RowPrefix.local), dcsrLocalValueCounter.getDiscountSubtotal().toString());
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.subtotalDiscount, RowPrefix.value, RowPrefix.local), dcsrLocalValueCounter.getDiscountSubtotalCounter());
            values.put(Rows.Total.fullPrefixRow(RowPrefix.subtotalSurcharge, RowPrefix.value, RowPrefix.local), dcsrLocalValueCounter.getSurchargeSubtotal().toString());
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.subtotalSurcharge, RowPrefix.value, RowPrefix.local), dcsrLocalValueCounter.getSurchargeSubtotalCounter());
            this.dbSource.saveData(Tables.fmGlobals.table(), values);
            this.dcsrLocalValueCounter = dcsrLocalValueCounter;
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public void setDcsrLocalPercentageCounter(DiscountTurnover dcsrLocalPercentageCounter) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.Total.fullPrefixRow(RowPrefix.discount, RowPrefix.percent, RowPrefix.local), dcsrLocalPercentageCounter.getDiscountItem().toString());
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.discount, RowPrefix.percent, RowPrefix.local), dcsrLocalPercentageCounter.getDiscountItemCounter());
            values.put(Rows.Total.fullPrefixRow(RowPrefix.surcharge, RowPrefix.percent, RowPrefix.local), dcsrLocalPercentageCounter.getSurchargeItem().toString());
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.surcharge, RowPrefix.percent, RowPrefix.local), dcsrLocalPercentageCounter.getSurchargeItemCounter());
            values.put(Rows.Total.fullPrefixRow(RowPrefix.subtotalDiscount, RowPrefix.percent, RowPrefix.local), dcsrLocalPercentageCounter.getDiscountSubtotal().toString());
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.subtotalDiscount, RowPrefix.percent, RowPrefix.local), dcsrLocalPercentageCounter.getDiscountSubtotalCounter());
            values.put(Rows.Total.fullPrefixRow(RowPrefix.subtotalSurcharge, RowPrefix.percent, RowPrefix.local), dcsrLocalPercentageCounter.getSurchargeSubtotal().toString());
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.subtotalSurcharge, RowPrefix.percent, RowPrefix.local), dcsrLocalPercentageCounter.getSurchargeSubtotalCounter());
            this.dbSource.saveData(Tables.fmGlobals.table(), values);
            this.dcsrLocalPercentageCounter = dcsrLocalPercentageCounter;
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public void setDcsrGlobalValueCounter(DiscountTurnover dcsrGlobalValueCounter) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.Total.fullPrefixRow(RowPrefix.discount, RowPrefix.value, RowPrefix.global), dcsrGlobalValueCounter.getDiscountItem().toString());
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.discount, RowPrefix.value, RowPrefix.global), dcsrGlobalValueCounter.getDiscountItemCounter());
            values.put(Rows.Total.fullPrefixRow(RowPrefix.surcharge, RowPrefix.value, RowPrefix.global), dcsrGlobalValueCounter.getSurchargeItem().toString());
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.surcharge, RowPrefix.value, RowPrefix.global), dcsrGlobalValueCounter.getSurchargeItemCounter());
            values.put(Rows.Total.fullPrefixRow(RowPrefix.subtotalDiscount, RowPrefix.value, RowPrefix.global), dcsrGlobalValueCounter.getDiscountSubtotal().toString());
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.subtotalDiscount, RowPrefix.value, RowPrefix.global), dcsrGlobalValueCounter.getDiscountSubtotalCounter());
            values.put(Rows.Total.fullPrefixRow(RowPrefix.subtotalSurcharge, RowPrefix.value, RowPrefix.global), dcsrGlobalValueCounter.getSurchargeSubtotal().toString());
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.subtotalSurcharge, RowPrefix.value, RowPrefix.global), dcsrGlobalValueCounter.getSurchargeSubtotalCounter());
            this.dbSource.saveData(Tables.fmGlobals.table(), values);
            this.dcsrGlobalValueCounter = dcsrGlobalValueCounter;
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public void setDcsrGlobalPercentageCounter(DiscountTurnover dcsrGlobalPercentageCounter) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.Total.fullPrefixRow(RowPrefix.discount, RowPrefix.percent, RowPrefix.global), dcsrGlobalPercentageCounter.getDiscountItem().toString());
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.discount, RowPrefix.percent, RowPrefix.global), dcsrGlobalPercentageCounter.getDiscountItemCounter());
            values.put(Rows.Total.fullPrefixRow(RowPrefix.surcharge, RowPrefix.percent, RowPrefix.global), dcsrGlobalPercentageCounter.getSurchargeItem().toString());
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.surcharge, RowPrefix.percent, RowPrefix.global), dcsrGlobalPercentageCounter.getSurchargeItemCounter());
            values.put(Rows.Total.fullPrefixRow(RowPrefix.subtotalDiscount, RowPrefix.percent, RowPrefix.global), dcsrGlobalPercentageCounter.getDiscountSubtotal().toString());
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.subtotalDiscount, RowPrefix.percent, RowPrefix.global), dcsrGlobalPercentageCounter.getDiscountSubtotalCounter());
            values.put(Rows.Total.fullPrefixRow(RowPrefix.subtotalSurcharge, RowPrefix.percent, RowPrefix.global), dcsrGlobalPercentageCounter.getSurchargeSubtotal().toString());
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.subtotalSurcharge, RowPrefix.percent, RowPrefix.global), dcsrGlobalPercentageCounter.getSurchargeSubtotalCounter());
            this.dbSource.saveData(Tables.fmGlobals.table(), values);
            this.dcsrGlobalPercentageCounter = dcsrGlobalPercentageCounter;
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public void appendInvoiceTurnover(BigDecimal value) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.Total.fullPrefixRow(RowPrefix.invoice), this.fmData.getInvoiceTurnover().add(value).toString());
            this.dbSource.saveData(Tables.fmGlobals.table(), values);
            this.fmData.setInvoiceTurnover(this.fmData.getInvoiceTurnover().add(value));
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public void appendLocalInvoiceTurnover(BigDecimal value) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.Total.fullPrefixRow(RowPrefix.invoice, RowPrefix.local), this.fmData.getLocalInvoiceTurnover().add(value).toString());
            this.dbSource.saveData(Tables.fmGlobals.table(), values);
            this.fmData.setLocalInvoiceTurnover(this.fmData.getLocalInvoiceTurnover().add(value));
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public void resetInvoiceTurnover() throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.Total.fullPrefixRow(RowPrefix.invoice), "0.00");
            this.dbSource.saveData(Tables.fmGlobals.table(), values);
            this.fmData.setInvoiceTurnover(BigDecimal.ZERO);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public void resetLocalInvoiceTurnover() throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.Total.fullPrefixRow(RowPrefix.invoice, RowPrefix.local), "0.00");
            this.dbSource.saveData(Tables.fmGlobals.table(), values);
            this.fmData.setLocalInvoiceTurnover(BigDecimal.ZERO);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public BigDecimal getLocalInvoiceTurnover() {
        return this.fmData.getLocalInvoiceTurnover();
    }

    public BigDecimal getInvoiceTurnover() {
        return this.fmData.getInvoiceTurnover();
    }

    public void incInvoiceCounter() throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.invoice), this.fmData.getInvoiceCounter() + 1);
            this.dbSource.saveData(Tables.fmGlobals.table(), values);
            this.fmData.incInvoiceCounter();
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public void resetInvoiceCounter() throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.Counter.fullPrefixRow(RowPrefix.invoice), 0);
            this.dbSource.saveData(Tables.fmGlobals.table(), values);
            this.fmData.setInvoiceCounter(0);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public int getinvoiceCounter() {
        return this.fmData.getInvoiceCounter();
    }

    public BigDecimal getGT() {
        return this.fmData.getGT();
    }

    public void appendGT(BigDecimal gT) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.fmGT.row(), this.fmData.getGT().add(gT).toString());
            this.dbSource.saveData(Tables.fmData.table(), values);
            this.fmData.setGT(this.fmData.getGT().add(gT));
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public String getAdditionalHeader() {
        return this.fmData.getAdditionalHeader();
    }

    public String getAdditionalFooter() {
        return this.fmData.getAdditionalFooter();
    }

    public void setAdditionalHeader(String additionalHeader) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.fmAdditionalHeader.row(), additionalHeader);
            this.dbSource.saveData(Tables.fmData.table(), values);
            this.fmData.setAdditionalHeader(additionalHeader);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public void setAdditionalFooter(String additionalFooter) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.fmAdditionalFooter.row(), additionalFooter);
            this.dbSource.saveData(Tables.fmData.table(), values);
            this.fmData.setAdditionalFooter(additionalFooter);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public int getModel() {
        return this.fmData.getModel();
    }

    public int getModuleWidth() {
        return this.fmData.getModuleWidth();
    }

    public int getErrorCorrectionLevel() {
        return this.fmData.getErrorCorrectionLevel();
    }

    public int getLeftMargin() {
        return this.fmData.getLeftMargin();
    }

    public int getViewMode() {
        return this.fmData.getViewMode();
    }

    public void setModel(int model) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.fmQRModel.row(), model);
            this.dbSource.saveData(Tables.fmData.table(), values);
            this.fmData.setModel(model);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public void setModuleWidth(int moduleWidth) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.fmQRModuleWidth.row(), moduleWidth);
            this.dbSource.saveData(Tables.fmData.table(), values);
            this.fmData.setModuleWidth(moduleWidth);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public void setErrorCorrectionLevel(int errorCorrectionLevel) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.fmQRErrorCorrectionLevel.row(), errorCorrectionLevel);
            this.dbSource.saveData(Tables.fmData.table(), values);
            this.fmData.setErrorCorrectionLevel(errorCorrectionLevel);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public void setLeftMargin(int leftMargin) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.fmQRLeftMargin.row(), leftMargin);
            this.dbSource.saveData(Tables.fmData.table(), values);
            this.fmData.setLeftMargin(leftMargin);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public void setViewMode(int viewMode) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.fmQRViewMode.row(), viewMode);
            this.dbSource.saveData(Tables.fmData.table(), values);
            this.fmData.setViewMode(viewMode);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public BARCODE_TEXT_POSITION getTextPos() {
        return this.fmData.getTextPos();
    }

    public BARCODE_FONT_SIZE getTextFont() {
        return this.fmData.getTextFont();
    }

    public int getBarcodeH() {
        return this.fmData.getBarcodeH();
    }

    public int getBarcodeW() {
        return this.fmData.getBarcodeW();
    }

    public void setTextPos(BARCODE_TEXT_POSITION textPos) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.fmBarcodeTextPos.row(), textPos.name());
            this.dbSource.saveData(Tables.fmData.table(), values);
            this.fmData.setTextPos(textPos);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public void setTextFont(BARCODE_FONT_SIZE textFont) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.fmBarcodeTextFont.row(), textFont.name());
            this.dbSource.saveData(Tables.fmData.table(), values);
            this.fmData.setTextFont(textFont);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public void setBarcodeH(int barcodeH) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.fmBarcodeH.row(), barcodeH);
            this.dbSource.saveData(Tables.fmData.table(), values);
            this.fmData.setBarcodeH(barcodeH);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public void setBarcodeW(int barcodeW) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.fmBarcodeW.row(), barcodeW);
            this.dbSource.saveData(Tables.fmData.table(), values);
            this.fmData.setBarcodeW(barcodeW);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public String getPreline() {
        return this.fmData.getPreline();
    }

    public void setPreline(String preline) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.fmPreline.row(), preline);
            this.dbSource.saveData(Tables.fmData.table(), values);
            this.fmData.setPreline(preline);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public String getPostline() {
        return this.fmData.getPostline();
    }

    public void setPostline(String postline) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.fmPostline.row(), postline);
            this.dbSource.saveData(Tables.fmData.table(), values);
            this.fmData.setPostline(postline);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public FiscalLocalize getFiscalLocalization() {
        return this.flocal;
    }

    public PaymentMethod getPaymentMethod(int ID) {
        return this.paymentMethods.get(ID);
    }

    public Map<Integer, PaymentMethod> getPaymentMethods() {
        return this.paymentMethods;
    }

    public boolean isVatPayer() {
        return this.fmState.isFmGPVatPayer();
    }

    public void setVatPayer(boolean vatPayer) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.fmGPVatPayer.row(), vatPayer ? 0 : 1);
            this.dbSource.saveData(Tables.fmStates.table(), values);
            this.fmState.setFmGPVatPayer(vatPayer);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public boolean validateVat(char vat) {
        try {
            return this.vats.get(Character.valueOf(vat)).getVat() != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void resetReceiptTotal() throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.fmReceiptTotal.row(), "0.00");
            this.dbSource.saveData(Tables.fmData.table(), values);
            this.fmData.setReceiptTotal(BigDecimal.ZERO);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public BigDecimal getReceiptTotal() {
        return this.fmData.getReceiptTotal();
    }

    public BigDecimal getReceiptTotalWithVat() throws FmStoreToDbException {
        BigDecimal total = BigDecimal.ZERO;
        for (Map.Entry<Character, Turnover> vat : this.vats.entrySet()) {
            if (vat.getValue().getLocalTotal().compareTo(BigDecimal.ZERO) == 0) continue;
            Turnover turnover = new Turnover.Builder(this, 'Z').setVat(vat.getValue().getVat()).setLocals(vat.getValue().getLocalTotal(), vat.getValue().getLocalVat(), vat.getValue().getLocalBase()).build();
            if (this.paragon.getSaleType() != ParagonType.velkoobchod) {
                this.getFiscalLocalization().getMaloobchod(turnover);
            } else {
                this.getFiscalLocalization().getVelkoobchod(turnover);
            }
            total = total.add(turnover.getLocalTotal());
        }
        return total;
    }

    public BigDecimal getReceiptTotalNoVat() throws FmStoreToDbException {
        BigDecimal noVat = BigDecimal.ZERO;
        for (Map.Entry<Character, Turnover> vat : this.vats.entrySet()) {
            if (vat.getValue().getLocalTotal().compareTo(BigDecimal.ZERO) == 0) continue;
            Turnover turnover = new Turnover.Builder(this, 'Z').setVat(vat.getValue().getVat()).setLocals(vat.getValue().getLocalTotal(), vat.getValue().getLocalVat(), vat.getValue().getLocalBase()).build();
            if (this.paragon.getSaleType() != ParagonType.velkoobchod) {
                this.getFiscalLocalization().getMaloobchod(turnover);
            } else {
                this.getFiscalLocalization().getVelkoobchod(turnover);
            }
            noVat = noVat.add(turnover.getLocalBase());
        }
        return noVat;
    }

    public void setReceiptTotal(BigDecimal receiptTotal) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.fmReceiptTotal.row(), receiptTotal.toString());
            this.dbSource.saveData(Tables.fmData.table(), values);
            this.fmData.setReceiptTotal(receiptTotal);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public void appendReceiptTotal(BigDecimal receiptTotal) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.fmReceiptTotal.row(), this.fmData.getReceiptTotal().add(receiptTotal).toString());
            this.dbSource.saveData(Tables.fmData.table(), values);
            this.fmData.setReceiptTotal(this.fmData.getReceiptTotal().add(receiptTotal));
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public void initParagon(ParagonModel paragon) {
        this.paragon = paragon;
    }

    public void saveDbParagon() throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            if (this.paragon == null) {
                values.put(Rows.fmParagon.row(), (String)null);
            } else {
                values.put(Rows.fmParagon.row(), SerializationUtility.toString(this.paragon));
            }
            this.dbSource.saveData(Tables.fmData.table(), values);
        }
        catch (IOException e) {
            throw new FmStoreToDbException(e);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public ParagonModel getParagon() {
        return this.paragon;
    }

    public int getActualRow() {
        return this.fmData.getActualRow();
    }

    public void setActualRow(int actualRow) throws FmStoreToDbException {
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.fmRow.row(), actualRow);
            this.dbSource.saveData(Tables.fmData.table(), values);
            this.fmData.setActualRow(actualRow);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public static synchronized FmFiscalMemory install(long fmId) {
        if (fmFiscalMemory.containsKey(fmId)) {
            return fmFiscalMemory.get(fmId);
        }
        FmFiscalMemory fiscalMemory = new FmFiscalMemory(fmId);
        fmFiscalMemory.put(fmId, fiscalMemory);
        return fiscalMemory;
    }

    public static synchronized void uninstall(long fmId) {
        if (fmFiscalMemory.containsKey(fmId)) {
            FmFiscalMemory fiscalMemory = fmFiscalMemory.remove(fmId);
            fiscalMemory.close();
        }
    }

    public static synchronized void uninstall(FmFiscalMemory fiscalMemory) {
        for (long fmId : fmFiscalMemory.keySet()) {
            if (fmFiscalMemory.get(fmId) != fiscalMemory) continue;
            fmFiscalMemory.remove(fmId);
        }
        fiscalMemory.close();
    }

    public static synchronized void uninstallAll() {
        for (long fmId : fmFiscalMemory.keySet()) {
            FmFiscalMemory.uninstall(fmId);
        }
    }

    public String[] getHeader() {
        return this.fmData.getHeader();
    }

    public String getHeader(VariableCodes code) {
        switch (code) {
            case V_F31: {
                return this.fmData.getHeader()[0];
            }
            case V_F32: {
                return this.fmData.getHeader()[1];
            }
            case V_F33: {
                return this.fmData.getHeader()[2];
            }
            case V_F34: {
                return this.fmData.getHeader()[3];
            }
            case V_F35: {
                return this.fmData.getHeader()[4];
            }
            case V_F36: {
                return this.fmData.getHeader()[5];
            }
        }
        return this.fmData.getHeader()[0];
    }

    public void setHeader(String[] header) throws FmStoreToDbException {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = header;
        int n = header.length;
        int n2 = 0;
        while (n2 < n) {
            String h = stringArray[n2];
            sb.append(h);
            sb.append("\n");
            ++n2;
        }
        try {
            ContentValues values = new ContentValues();
            values.put(Rows.fmHeader.row(), sb.toString());
            this.dbSource.saveData(Tables.fmData.table(), values);
            this.fmData.setHeader(header);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public Turnover getVat(char vat) {
        return this.vats.get(Character.valueOf(vat));
    }

    public Turnover getVat(VariableCodes code) {
        switch (code) {
            case V_121: 
            case V_131: {
                return this.vats.get(Character.valueOf('A'));
            }
            case V_122: 
            case V_132: {
                return this.vats.get(Character.valueOf('B'));
            }
            case V_123: 
            case V_133: {
                return this.vats.get(Character.valueOf('C'));
            }
            case V_124: 
            case V_134: {
                return this.vats.get(Character.valueOf('D'));
            }
            case V_125: 
            case V_135: {
                return this.vats.get(Character.valueOf('E'));
            }
        }
        return this.vats.get(Character.valueOf('A'));
    }

    public PaymentMethod getPaymentMethod(VariableCodes code) {
        switch (code) {
            case V_1C1: 
            case V_E71: {
                return this.paymentMethods.get(1);
            }
            case V_1C2: 
            case V_E72: {
                return this.paymentMethods.get(2);
            }
            case V_1C3: 
            case V_E73: {
                return this.paymentMethods.get(3);
            }
            case V_1C4: 
            case V_E74: {
                return this.paymentMethods.get(4);
            }
            case V_1C5: 
            case V_E75: {
                return this.paymentMethods.get(5);
            }
            case V_1C6: 
            case V_E76: {
                return this.paymentMethods.get(6);
            }
            case V_1C7: 
            case V_E77: {
                return this.paymentMethods.get(7);
            }
            case V_1C8: 
            case V_E78: {
                return this.paymentMethods.get(8);
            }
            case V_1CG: 
            case V_E7G: {
                return this.paymentMethods.get(16);
            }
        }
        return this.paymentMethods.get(16);
    }

    public String getStringVats() {
        StringBuilder builder = new StringBuilder();
        builder.append("*** A ").append(this.vats.get(Character.valueOf('A')).getVat()).append(" ***").append("\n").append(this.vats.get(Character.valueOf('A')).toString()).append("\n");
        builder.append("*** B ").append(this.vats.get(Character.valueOf('B')).getVat()).append(" ***").append("\n").append(this.vats.get(Character.valueOf('B')).toString()).append("\n");
        builder.append("*** C ").append(this.vats.get(Character.valueOf('C')).getVat()).append(" ***").append("\n").append(this.vats.get(Character.valueOf('C')).toString()).append("\n");
        builder.append("*** D ").append(this.vats.get(Character.valueOf('D')).getVat()).append(" ***").append("\n").append(this.vats.get(Character.valueOf('D')).toString()).append("\n");
        builder.append("*** E ").append(this.vats.get(Character.valueOf('E')).getVat()).append(" ***").append("\n").append(this.vats.get(Character.valueOf('E')).toString()).append("\n");
        return builder.toString();
    }

    public Map<Character, Turnover> getVats() {
        return this.vats;
    }

    public void resetLocalVats(boolean tilt) throws FmStoreToDbException {
        for (Map.Entry<Character, Turnover> vat : this.vats.entrySet()) {
            if (tilt) {
                vat.getValue().tiltLocalToGlobal();
            }
            vat.getValue().resetLocals();
        }
    }

    public void resetGlobalVats() throws FmStoreToDbException {
        for (Map.Entry<Character, Turnover> vat : this.vats.entrySet()) {
            vat.getValue().resetGlobals();
        }
    }

    public void resetLocalPayments(boolean tilt) throws FmStoreToDbException {
        for (Map.Entry<Integer, PaymentMethod> payment : this.paymentMethods.entrySet()) {
            if (tilt) {
                payment.getValue().tiltLocalToGlobal();
            }
            payment.getValue().resetLocals();
        }
    }

    public void resetGlobalsPayments() throws FmStoreToDbException {
        for (Map.Entry<Integer, PaymentMethod> payment : this.paymentMethods.entrySet()) {
            payment.getValue().resetGlobals();
        }
    }

    public boolean isDbOk() {
        if (this.dbSource == null) {
            return false;
        }
        return this.dbSource.isDbOK();
    }

    public FiscalDataStorage getDbSource() {
        return this.dbSource;
    }

    private void close() {
        this.dbSource.close();
    }

    public void reloadData() throws FmStoreToDbException {
        if (this.dbSource.isDbOK()) {
            this.fmState = this.dbSource.loadFmState();
            int id = 1;
            while (id < 9) {
                this.paymentMethods.put(id, this.dbSource.getPaymentMethod(this, id));
                ++id;
            }
            this.paymentMethods.put(16, this.dbSource.getPaymentMethod(this, 16));
            this.paragon = this.dbSource.loadParagon();
            this.fmData = this.dbSource.loadData();
            this.dcsrLocalValueCounter = this.dbSource.loadDiscountTurnover(this, false, false);
            this.dcsrLocalPercentageCounter = this.dbSource.loadDiscountTurnover(this, false, true);
            this.negativeLocalCounter = this.dbSource.loadNegativeTurnover(this, false);
            this.dcsrGlobalValueCounter = this.dbSource.loadDiscountTurnover(this, true, false);
            this.dcsrGlobalPercentageCounter = this.dbSource.loadDiscountTurnover(this, true, true);
            this.negativeGlobalCounter = this.dbSource.loadNegativeTurnover(this, true);
            this.vats.clear();
            this.vats.put(Character.valueOf('A'), this.dbSource.loadVatTurnover(this, 'A'));
            this.vats.put(Character.valueOf('B'), this.dbSource.loadVatTurnover(this, 'B'));
            this.vats.put(Character.valueOf('C'), this.dbSource.loadVatTurnover(this, 'C'));
            this.vats.put(Character.valueOf('D'), this.dbSource.loadVatTurnover(this, 'D'));
            this.vats.put(Character.valueOf('E'), this.dbSource.loadVatTurnover(this, 'E'));
            System.out.println("====================================" + new Date());
        }
    }

    public void beginTransaction() {
        this.dbSource.beginTransaction();
    }

    public void setTransactionSuccesfull() {
        this.dbSource.succes();
    }

    public void endTransaction() {
        if (this.dbSource.isTransactionActive()) {
            this.dbSource.endTransaction();
        }
    }

    public void destroyJournal() throws FmStoreToDbException {
        if (this.paragon != null) {
            this.negativeLocalCounter.reset();
            this.negativeGlobalCounter.appendDestroyedValue(this.fmData.getReceiptTotal());
            this.resetLocalInvoiceTurnover();
            this.resetReceiptTotal();
            this.resetLocalVats(false);
            this.resetLocalPayments(false);
            this.paragon = null;
            this.saveDbParagon();
            this.setFmState(1);
        }
    }

    public Date createJournalReport(Date createDate, byte[] binary, UUID uuid, ParagonType type) throws FmStoreToDbException {
        try {
            this.dbSource.createJournalEntry(uuid, createDate, binary, type.getType(), "");
            this.resetAllGlobals();
            this.setFmState(0);
            return createDate;
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public void createJournal(Date createDate, UUID uuid) throws FmStoreToDbException {
        try {
            if (this.paragon != null) {
                boolean tiltLocals = true;
                this.dbSource.createJournalEntry(uuid, createDate, this.paragon.getBinaryData(), this.paragon.getSaleType().getType(), this.paragon.getTransactionID());
                switch (this.paragon.getSaleType()) {
                    case maloobchod: {
                        this.appendGT(this.getReceiptTotalWithVat());
                        break;
                    }
                    case velkoobchod: {
                        this.appendGT(this.getReceiptTotalNoVat());
                        break;
                    }
                    case vkladVyber: {
                        this.incDepositeWithdrawCount();
                        this.appendGT(this.getReceiptTotalWithVat());
                        break;
                    }
                    case faktura: {
                        this.appendInvoiceTurnover(this.getLocalInvoiceTurnover());
                        this.appendGT(this.getLocalInvoiceTurnover());
                        this.incInvoiceCounter();
                        this.resetLocalInvoiceTurnover();
                        break;
                    }
                    case neplatny: {
                        tiltLocals = false;
                        this.appendInvalidReceipt(this.getReceiptTotalWithVat());
                        this.incInvalidReceiptCount();
                    }
                }
                this.resetReceiptTotal();
                this.resetLocalVats(tiltLocals);
                this.resetLocalPayments(tiltLocals);
                this.dcsrGlobalValueCounter.tilt(this.dcsrLocalValueCounter);
                this.dcsrGlobalPercentageCounter.tilt(this.dcsrLocalPercentageCounter);
                this.dcsrLocalValueCounter.reset();
                this.dcsrLocalPercentageCounter.reset();
                this.negativeGlobalCounter.tilt(this.negativeLocalCounter);
                this.negativeLocalCounter.reset();
                this.paragon = null;
                this.saveDbParagon();
                this.setFmState(1);
            }
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public void confirmJournal(UUID uuid) throws FmStoreToDbException {
        try {
            this.dbSource.confirmJournalEntry(uuid);
            ContentValues values = new ContentValues();
            values.put(Rows.fmLastReceiptUUID.row(), uuid.toString());
            this.dbSource.saveData(Tables.fmData.table(), values);
            this.fmData.setLastReceiptUUID(uuid);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public long saveJournal(UUID uuid, int status, Integer month, Integer year, Integer pcd, String uid, String transactionId) throws FmStoreToDbException {
        try {
            long rsp = this.dbSource.saveJournalEntry(uuid, status, month, year, pcd, uid, transactionId);
            return rsp;
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public long saveJournal(UUID uuid, int status, Integer month, Integer year, Integer pcd, String uid, String okp, String pkp, String qrCode, byte[] copyData, int receiptNumber, int reportNumber, String transactionId) throws FmStoreToDbException {
        try {
            long rsp = this.dbSource.saveJournalEntry(uuid, status, month, year, pcd, uid, okp, pkp, qrCode, copyData, receiptNumber, reportNumber, transactionId);
            return rsp;
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public byte[] getLastParagon(long deviceId) throws FmStoreToDbException {
        try {
            if (this.fmData.getLastReceiptUUID() == null) {
                throw new SQLException("No data");
            }
            return this.dbSource.exportJournal(DB.uuid, this.fmData.getLastReceiptUUID().toString(), "journal/" + deviceId, "LastParagon");
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
        catch (IOException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public char getParagonType(UUID uuid) throws FmStoreToDbException {
        return this.dbSource.getParagonType(uuid);
    }

    public byte[] getJournalParagon(DB type, String receiptId, String path, String fileName) throws FmStoreToDbException {
        try {
            return this.dbSource.exportJournal(type, receiptId, path, fileName);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
        catch (IOException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public byte[] getJournal(ParagonType type, String dateFrom, String dateTo, String path, String fileName) throws FmStoreToDbException {
        try {
            return this.dbSource.exportJournal(type, dateFrom, dateTo, path, fileName);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
        catch (IOException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public String getJournalZ(String flagDate, String path, String fileName) throws FmStoreToDbException {
        try {
            return this.dbSource.exportJournalZ(flagDate, path, fileName);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
        catch (IOException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public String getParagonIDs(int type, String whereParam) throws FmStoreToDbException {
        try {
            return this.dbSource.exportParagonIDs(type, whereParam);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }

    public boolean isTransactionInUse(String transactionId) throws FmStoreToDbException {
        try {
            return this.dbSource.isTransactionInUse(transactionId);
        }
        catch (SQLException e) {
            throw new FmStoreToDbException(e);
        }
    }
}

